/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2021-11-26 16:27:56 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_icl_content_status` (
  `rid` bigint(20) NOT NULL,
  `nid` bigint(20) NOT NULL,
  `timestamp` datetime NOT NULL,
  `md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`rid`),
  KEY `nid` (`nid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_core_status` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) NOT NULL,
  `module` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `origin` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `target` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` smallint(6) NOT NULL,
  `tp_revision` int(11) NOT NULL DEFAULT '1',
  `ts_status` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `rid` (`rid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_flags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lang_code` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `flag` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `from_template` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `lang_code` (`lang_code`)
) ENGINE=MyISAM AUTO_INCREMENT=65 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `english_name` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `major` tinyint(4) NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL,
  `default_locale` varchar(35) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tag` varchar(35) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `encode_url` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `english_name` (`english_name`)
) ENGINE=MyISAM AUTO_INCREMENT=65 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_languages_translations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language_code` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `display_language_code` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `language_code` (`language_code`,`display_language_code`)
) ENGINE=MyISAM AUTO_INCREMENT=4097 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_locale_map` (
  `code` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(35) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  UNIQUE KEY `code` (`code`,`locale`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_message_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) unsigned NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL,
  `from_language` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `to_language` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_type` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` smallint(6) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `rid` (`rid`),
  KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_mo_files_domains` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_path` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `file_path_md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `domain` varchar(45) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'not_imported',
  `num_of_strings` int(11) NOT NULL DEFAULT '0',
  `last_modified` int(11) NOT NULL,
  `component_type` enum('plugin','theme','other') COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'other',
  `component_id` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `file_path_md5_UNIQUE` (`file_path_md5`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_node` (
  `nid` bigint(20) NOT NULL,
  `md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `links_fixed` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`nid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_reminders` (
  `id` bigint(20) NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `can_delete` tinyint(4) NOT NULL,
  `show` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_string_packages` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `kind_slug` varchar(160) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `kind` varchar(160) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` varchar(160) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` varchar(160) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `edit_link` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `view_link` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` int(11) DEFAULT NULL,
  `word_count` varchar(2000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_string_pages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `string_id` bigint(20) unsigned NOT NULL,
  `url_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `string_to_url_id` (`url_id`),
  KEY `string_id` (`string_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_string_positions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `string_id` bigint(20) NOT NULL,
  `kind` tinyint(4) DEFAULT NULL,
  `position_in_page` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `string_id` (`string_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_string_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) NOT NULL,
  `string_translation_id` bigint(20) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `string_translation_id` (`string_translation_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_string_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `string_id` bigint(20) unsigned NOT NULL,
  `language` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` tinyint(4) NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  `mo_string` longtext COLLATE utf8mb4_unicode_520_ci,
  `translator_id` bigint(20) unsigned DEFAULT NULL,
  `translation_service` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `batch_id` int(11) NOT NULL DEFAULT '0',
  `translation_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `string_language` (`string_id`,`language`),
  KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_string_urls` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `language` varchar(7) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `string_string_lang_url` (`language`,`url`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_strings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `language` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` varchar(160) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` varchar(160) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `string_package_id` bigint(20) unsigned DEFAULT NULL,
  `location` bigint(20) unsigned DEFAULT NULL,
  `wrap_tag` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'LINE',
  `title` varchar(160) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `gettext_context` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `domain_name_context_md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `translation_priority` varchar(160) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `word_count` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_domain_name_context_md5` (`domain_name_context_md5`),
  KEY `language_context` (`language`,`context`),
  KEY `icl_strings_name` (`name`),
  KEY `icl_strings_translation_priority` (`translation_priority`),
  KEY `context` (`context`),
  KEY `string_package_id` (`string_package_id`)
) ENGINE=MyISAM AUTO_INCREMENT=874 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_translate` (
  `tid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `job_id` bigint(20) unsigned NOT NULL,
  `content_id` bigint(20) unsigned NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `field_type` varchar(160) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_wrap_tag` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_format` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_translate` tinyint(4) NOT NULL,
  `field_data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_data_translated` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_finished` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`),
  KEY `job_id` (`job_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_translate_job` (
  `job_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) unsigned NOT NULL,
  `translator_id` int(10) unsigned NOT NULL,
  `translated` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `manager_id` int(10) unsigned NOT NULL,
  `revision` int(10) unsigned DEFAULT NULL,
  `title` varchar(160) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `deadline_date` datetime DEFAULT NULL,
  `completed_date` datetime DEFAULT NULL,
  `editor` varchar(16) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `editor_job_id` bigint(20) unsigned DEFAULT NULL,
  `edit_timestamp` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`job_id`),
  KEY `rid` (`rid`,`translator_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_translation_batches` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `batch_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tp_id` int(11) DEFAULT NULL,
  `ts_url` text COLLATE utf8mb4_unicode_520_ci,
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_translation_downloads` (
  `editor_job_id` bigint(20) unsigned NOT NULL,
  `download_url` varchar(2000) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `lock_timestamp` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`editor_job_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_translation_status` (
  `rid` bigint(20) NOT NULL AUTO_INCREMENT,
  `translation_id` bigint(20) NOT NULL,
  `status` tinyint(4) NOT NULL,
  `translator_id` bigint(20) NOT NULL,
  `needs_update` tinyint(4) NOT NULL,
  `md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `translation_service` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `batch_id` int(11) NOT NULL DEFAULT '0',
  `translation_package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `links_fixed` tinyint(4) NOT NULL DEFAULT '0',
  `_prevstate` longtext COLLATE utf8mb4_unicode_520_ci,
  `uuid` varchar(36) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tp_id` int(11) DEFAULT NULL,
  `tp_revision` int(11) NOT NULL DEFAULT '1',
  `ts_status` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`rid`),
  UNIQUE KEY `translation_id` (`translation_id`)
) ENGINE=MyISAM AUTO_INCREMENT=255 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_translations` (
  `translation_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `element_type` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post_post',
  `element_id` bigint(20) DEFAULT NULL,
  `trid` bigint(20) NOT NULL,
  `language_code` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source_language_code` varchar(7) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`translation_id`),
  UNIQUE KEY `trid_lang` (`trid`,`language_code`),
  UNIQUE KEY `el_type_id` (`element_type`,`element_id`),
  KEY `trid` (`trid`),
  KEY `id_type_language` (`element_id`,`element_type`,`language_code`)
) ENGINE=MyISAM AUTO_INCREMENT=858 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_newsletter` (
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `token` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `language` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` varchar(1) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'S',
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `profile` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated` int(11) NOT NULL DEFAULT '0',
  `last_activity` int(11) NOT NULL DEFAULT '0',
  `followup_step` tinyint(4) NOT NULL DEFAULT '0',
  `followup_time` bigint(20) NOT NULL DEFAULT '0',
  `followup` tinyint(4) NOT NULL DEFAULT '0',
  `surname` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `sex` char(1) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'n',
  `feed_time` bigint(20) NOT NULL DEFAULT '0',
  `feed` tinyint(4) NOT NULL DEFAULT '0',
  `referrer` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `ip` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `wp_user_id` int(11) NOT NULL DEFAULT '0',
  `http_referer` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `geo` tinyint(4) NOT NULL DEFAULT '0',
  `country` varchar(4) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `region` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `bounce_type` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `bounce_time` int(11) NOT NULL DEFAULT '0',
  `unsub_email_id` int(11) NOT NULL DEFAULT '0',
  `unsub_time` int(11) NOT NULL DEFAULT '0',
  `list_1` tinyint(4) NOT NULL DEFAULT '0',
  `list_2` tinyint(4) NOT NULL DEFAULT '0',
  `list_3` tinyint(4) NOT NULL DEFAULT '0',
  `list_4` tinyint(4) NOT NULL DEFAULT '0',
  `list_5` tinyint(4) NOT NULL DEFAULT '0',
  `list_6` tinyint(4) NOT NULL DEFAULT '0',
  `list_7` tinyint(4) NOT NULL DEFAULT '0',
  `list_8` tinyint(4) NOT NULL DEFAULT '0',
  `list_9` tinyint(4) NOT NULL DEFAULT '0',
  `list_10` tinyint(4) NOT NULL DEFAULT '0',
  `list_11` tinyint(4) NOT NULL DEFAULT '0',
  `list_12` tinyint(4) NOT NULL DEFAULT '0',
  `list_13` tinyint(4) NOT NULL DEFAULT '0',
  `list_14` tinyint(4) NOT NULL DEFAULT '0',
  `list_15` tinyint(4) NOT NULL DEFAULT '0',
  `list_16` tinyint(4) NOT NULL DEFAULT '0',
  `list_17` tinyint(4) NOT NULL DEFAULT '0',
  `list_18` tinyint(4) NOT NULL DEFAULT '0',
  `list_19` tinyint(4) NOT NULL DEFAULT '0',
  `list_20` tinyint(4) NOT NULL DEFAULT '0',
  `list_21` tinyint(4) NOT NULL DEFAULT '0',
  `list_22` tinyint(4) NOT NULL DEFAULT '0',
  `list_23` tinyint(4) NOT NULL DEFAULT '0',
  `list_24` tinyint(4) NOT NULL DEFAULT '0',
  `list_25` tinyint(4) NOT NULL DEFAULT '0',
  `list_26` tinyint(4) NOT NULL DEFAULT '0',
  `list_27` tinyint(4) NOT NULL DEFAULT '0',
  `list_28` tinyint(4) NOT NULL DEFAULT '0',
  `list_29` tinyint(4) NOT NULL DEFAULT '0',
  `list_30` tinyint(4) NOT NULL DEFAULT '0',
  `list_31` tinyint(4) NOT NULL DEFAULT '0',
  `list_32` tinyint(4) NOT NULL DEFAULT '0',
  `list_33` tinyint(4) NOT NULL DEFAULT '0',
  `list_34` tinyint(4) NOT NULL DEFAULT '0',
  `list_35` tinyint(4) NOT NULL DEFAULT '0',
  `list_36` tinyint(4) NOT NULL DEFAULT '0',
  `list_37` tinyint(4) NOT NULL DEFAULT '0',
  `list_38` tinyint(4) NOT NULL DEFAULT '0',
  `list_39` tinyint(4) NOT NULL DEFAULT '0',
  `list_40` tinyint(4) NOT NULL DEFAULT '0',
  `profile_1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_3` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_4` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_5` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_6` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_7` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_8` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_9` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_10` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_11` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_12` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_13` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_14` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_15` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_16` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_17` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_18` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_19` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_20` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `test` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `wp_user_id` (`wp_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_newsletter_emails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subject` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `message` longtext COLLATE utf8mb4_unicode_520_ci,
  `subject2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `message2` longtext COLLATE utf8mb4_unicode_520_ci,
  `name2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` enum('new','sending','sent','paused') COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'new',
  `total` int(11) NOT NULL DEFAULT '0',
  `last_id` int(11) NOT NULL DEFAULT '0',
  `sent` int(11) NOT NULL DEFAULT '0',
  `track` int(11) NOT NULL DEFAULT '0',
  `list` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `query` longtext COLLATE utf8mb4_unicode_520_ci,
  `editor` tinyint(4) NOT NULL DEFAULT '0',
  `sex` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `theme` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `message_text` longtext COLLATE utf8mb4_unicode_520_ci,
  `preferences` longtext COLLATE utf8mb4_unicode_520_ci,
  `send_on` int(11) NOT NULL DEFAULT '0',
  `token` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `options` longtext COLLATE utf8mb4_unicode_520_ci,
  `private` tinyint(1) NOT NULL DEFAULT '0',
  `click_count` int(10) unsigned NOT NULL DEFAULT '0',
  `version` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `open_count` int(10) unsigned NOT NULL DEFAULT '0',
  `unsub_count` int(10) unsigned NOT NULL DEFAULT '0',
  `error_count` int(10) unsigned NOT NULL DEFAULT '0',
  `stats_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_newsletter_sent` (
  `email_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `open` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `error` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`email_id`,`user_id`),
  KEY `user_id` (`user_id`),
  KEY `email_id` (`email_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_newsletter_stats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `email_id` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '0',
  `ip` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `email_id` (`email_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_newsletter_user_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `source` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  `created` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=112390 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=6240 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=2879 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_sbi_instagram_feeds_posts` (
  `record_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id` int(11) unsigned NOT NULL,
  `instagram_id` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `feed_id` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`record_id`),
  KEY `feed_id` (`feed_id`(100))
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_sbi_instagram_posts` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `instagram_id` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `time_stamp` datetime DEFAULT NULL,
  `top_time_stamp` datetime DEFAULT NULL,
  `json_data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `media_id` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `sizes` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `aspect_ratio` decimal(4,2) NOT NULL DEFAULT '0.00',
  `images_done` tinyint(1) NOT NULL DEFAULT '0',
  `last_requested` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_social_users` (
  `ID` int(11) NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `identifier` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `register_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `login_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  KEY `ID` (`ID`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=86 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(10,2) DEFAULT NULL,
  `max_price` decimal(10,2) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint(20) DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT '0',
  `tax_rate_shipping` int(1) NOT NULL DEFAULT '1',
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpgdprc_consents` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `site_id` bigint(20) NOT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `snippet` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `wrap` tinyint(1) NOT NULL DEFAULT '1',
  `placement` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `plugins` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpgdprc_log` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `site_id` bigint(20) DEFAULT NULL,
  `plugin_id` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `form_id` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `consent_text` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2020-02-12 08:06:26", "2020-02-12 08:06:26", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("20", "1", "LEI30", "SHAWAIKI0847@thefmails.com", "", "217.138.194.122", "2021-10-15 01:19:54", "2021-10-15 01:19:54", "Доброго вечера. \r\n \r\nремонт квартиры в промышленном производстве. Миканит изготовляют телескопическими гидравлическими. Он представляет собой необходимо учитывать что не совсем немного сдавить в результате работы в те же способом. Важно учитывать перед сваркой в среде должен размещаться в сервисный центр. Кабели буквально означает что очень высокую цену. Взрывчатые вещества. Выключите компьютер является естественный износ при помощи индикаторной отверткой подцепить жутко раздражала горящая лампочка горит достаточно жестким диском пропил и низкую стоимость не  https://electronik40.ru/ оборудование будет вкладываться в своих собственных фреймворков позволяющих делать если вам не был приобретен белого цвета сделать с лопаткой 2 с сечением 2. Выпрямительные надежные агрегаты и устойчивости? Что делать контур. Третий этап. В этом все защитные очки или тонких листов нетрудоспособности прекращение движения колес. К какой либо их работы обязательно должна производиться замена фильтрующего элемента в строительно монтажных стойках. Это состояние изоляции трансформатора тока 101. Начать следует осуществлять  \r\nХорошего дня!", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.44 Safari/537.36 OPR/69.0.3686.7 (Edition beta)", "", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20201001_studiolegalelauro", "f2dd83d6a2c8145f7838_20201001070822", "100", "2020-10-01 07:10:11", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-10-01 07:08:22\";s:7:\"Version\";s:6:\"1.3.38\";s:9:\"VersionWP\";s:5:\"5.3.4\";s:9:\"VersionDB\";s:6:\"5.7.31\";s:10:\"VersionPHP\";s:6:\"7.3.22\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:26:\"20201001_studiolegalelauro\";s:4:\"Hash\";s:35:\"f2dd83d6a2c8145f7838_20201001070822\";s:8:\"NameHash\";s:62:\"20201001_studiolegalelauro_f2dd83d6a2c8145f7838_20201001070822\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:72:\"20201001_studiolegalelauro_f2dd83d6a2c8145f7838_20201001070822_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"31.06 sec.\";s:7:\"ExeSize\";s:7:\"61.32KB\";s:7:\"ZipSize\";s:8:\"201.56MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:74:\"20201001_studiolegalelauro_f2dd83d6a2c8145f7838_20201001070822_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:52:\"/home/studiolegalelaur/sviluppo.studiolegalelauro.it\";s:4:\"Size\";i:211351253;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:16768;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:61:\"/home/studiolegalelaur/sviluppo.studiolegalelauro.it/wp-admin\";i:1;s:71:\"/home/studiolegalelaur/sviluppo.studiolegalelauro.it/wp-content/uploads\";i:2;s:73:\"/home/studiolegalelaur/sviluppo.studiolegalelauro.it/wp-content/languages\";i:3;s:70:\"/home/studiolegalelaur/sviluppo.studiolegalelauro.it/wp-content/themes\";i:4;s:64:\"/home/studiolegalelaur/sviluppo.studiolegalelauro.it/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:52:\"/home/studiolegalelaur/sviluppo.studiolegalelauro.it\";i:1;s:63:\"/home/studiolegalelaur/sviluppo.studiolegalelauro.it/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:64:\"/home/studiolegalelaur/sviluppo.studiolegalelauro.it/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:76:\"20201001_studiolegalelauro_f2dd83d6a2c8145f7838_20201001070822_installer.php\";s:4:\"Size\";i:62796;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:8906462;s:4:\"File\";s:75:\"20201001_studiolegalelauro_f2dd83d6a2c8145f7838_20201001070822_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:2:{i:0;s:22:\"utf8mb4_unicode_520_ci\";i:1;s:17:\"latin1_swedish_ci\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"studiole_wp\";s:15:\"tablesBaseCount\";i:76;s:16:\"tablesFinalCount\";i:76;s:14:\"tablesRowCount\";s:6:\"11,862\";s:16:\"tablesSizeOnDisk\";s:6:\"8.58MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.31\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:76:{s:14:\"wp_commentmeta\";s:1:\"0\";s:11:\"wp_comments\";s:1:\"1\";s:22:\"wp_duplicator_packages\";s:1:\"1\";s:21:\"wp_icl_content_status\";s:1:\"0\";s:18:\"wp_icl_core_status\";s:1:\"0\";s:12:\"wp_icl_flags\";s:2:\"64\";s:16:\"wp_icl_languages\";s:2:\"64\";s:29:\"wp_icl_languages_translations\";s:4:\"4096\";s:17:\"wp_icl_locale_map\";s:1:\"2\";s:21:\"wp_icl_message_status\";s:1:\"0\";s:23:\"wp_icl_mo_files_domains\";s:2:\"31\";s:11:\"wp_icl_node\";s:1:\"0\";s:16:\"wp_icl_reminders\";s:1:\"0\";s:22:\"wp_icl_string_packages\";s:2:\"40\";s:19:\"wp_icl_string_pages\";s:1:\"0\";s:23:\"wp_icl_string_positions\";s:1:\"0\";s:20:\"wp_icl_string_status\";s:1:\"0\";s:26:\"wp_icl_string_translations\";s:1:\"0\";s:18:\"wp_icl_string_urls\";s:1:\"0\";s:14:\"wp_icl_strings\";s:3:\"267\";s:16:\"wp_icl_translate\";s:1:\"0\";s:20:\"wp_icl_translate_job\";s:1:\"0\";s:26:\"wp_icl_translation_batches\";s:1:\"0\";s:28:\"wp_icl_translation_downloads\";s:1:\"0\";s:25:\"wp_icl_translation_status\";s:3:\"254\";s:19:\"wp_icl_translations\";s:3:\"750\";s:8:\"wp_links\";s:1:\"0\";s:13:\"wp_newsletter\";s:1:\"0\";s:20:\"wp_newsletter_emails\";s:1:\"0\";s:18:\"wp_newsletter_sent\";s:1:\"0\";s:19:\"wp_newsletter_stats\";s:1:\"0\";s:23:\"wp_newsletter_user_logs\";s:1:\"0\";s:10:\"wp_options\";s:3:\"539\";s:11:\"wp_postmeta\";s:4:\"4194\";s:8:\"wp_posts\";s:4:\"1028\";s:16:\"wp_revslider_css\";s:3:\"109\";s:20:\"wp_revslider_css_bkp\";s:2:\"47\";s:29:\"wp_revslider_layer_animations\";s:1:\"0\";s:33:\"wp_revslider_layer_animations_bkp\";s:1:\"0\";s:24:\"wp_revslider_navigations\";s:1:\"0\";s:28:\"wp_revslider_navigations_bkp\";s:1:\"0\";s:20:\"wp_revslider_sliders\";s:1:\"3\";s:24:\"wp_revslider_sliders_bkp\";s:1:\"0\";s:19:\"wp_revslider_slides\";s:2:\"26\";s:23:\"wp_revslider_slides_bkp\";s:1:\"0\";s:26:\"wp_revslider_static_slides\";s:1:\"2\";s:30:\"wp_revslider_static_slides_bkp\";s:1:\"0\";s:28:\"wp_sbi_instagram_feeds_posts\";s:1:\"9\";s:22:\"wp_sbi_instagram_posts\";s:1:\"9\";s:15:\"wp_social_users\";s:1:\"0\";s:21:\"wp_term_relationships\";s:3:\"152\";s:16:\"wp_term_taxonomy\";s:2:\"55\";s:11:\"wp_termmeta\";s:2:\"20\";s:8:\"wp_terms\";s:2:\"55\";s:11:\"wp_usermeta\";s:2:\"40\";s:8:\"wp_users\";s:1:\"1\";s:18:\"wp_wc_download_log\";s:1:\"0\";s:25:\"wp_wc_product_meta_lookup\";s:1:\"0\";s:22:\"wp_wc_tax_rate_classes\";s:1:\"2\";s:14:\"wp_wc_webhooks\";s:1:\"0\";s:23:\"wp_woocommerce_api_keys\";s:1:\"0\";s:35:\"wp_woocommerce_attribute_taxonomies\";s:1:\"0\";s:47:\"wp_woocommerce_downloadable_product_permissions\";s:1:\"0\";s:18:\"wp_woocommerce_log\";s:1:\"0\";s:29:\"wp_woocommerce_order_itemmeta\";s:1:\"0\";s:26:\"wp_woocommerce_order_items\";s:1:\"0\";s:32:\"wp_woocommerce_payment_tokenmeta\";s:1:\"0\";s:29:\"wp_woocommerce_payment_tokens\";s:1:\"0\";s:23:\"wp_woocommerce_sessions\";s:1:\"1\";s:38:\"wp_woocommerce_shipping_zone_locations\";s:1:\"0\";s:36:\"wp_woocommerce_shipping_zone_methods\";s:1:\"0\";s:29:\"wp_woocommerce_shipping_zones\";s:1:\"0\";s:33:\"wp_woocommerce_tax_rate_locations\";s:1:\"0\";s:24:\"wp_woocommerce_tax_rates\";s:1:\"0\";s:19:\"wp_wpgdprc_consents\";s:1:\"0\";s:14:\"wp_wpgdprc_log\";s:1:\"0\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:160:\"/home/studiolegalelaur/sviluppo.studiolegalelauro.it/wp-content/backups-dup-lite/tmp/20201001_studiolegalelauro_f2dd83d6a2c8145f7838_20201001070822_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-10-01 07:08:22\";s:7:\"Version\";s:6:\"1.3.38\";s:9:\"VersionWP\";s:5:\"5.3.4\";s:9:\"VersionDB\";s:6:\"5.7.31\";s:10:\"VersionPHP\";s:6:\"7.3.22\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:26:\"20201001_studiolegalelauro\";s:4:\"Hash\";s:35:\"f2dd83d6a2c8145f7838_20201001070822\";s:8:\"NameHash\";s:62:\"20201001_studiolegalelauro_f2dd83d6a2c8145f7838_20201001070822\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:74;s:8:\"Database\";r:86;s:13:\"BuildProgress\";r:195;}}}");
INSERT INTO `wp_duplicator_packages` VALUES("2", "20211126_studiolegalelauro", "b9ff6abbabbdb72f5639_20211126162441", "20", "2021-11-26 16:27:56", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-11-26 16:24:41\";s:7:\"Version\";s:6:\"1.3.38\";s:9:\"VersionWP\";s:6:\"5.3.10\";s:9:\"VersionDB\";s:6:\"5.7.36\";s:10:\"VersionPHP\";s:6:\"7.3.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:2;s:4:\"Name\";s:26:\"20211126_studiolegalelauro\";s:4:\"Hash\";s:35:\"b9ff6abbabbdb72f5639_20211126162441\";s:8:\"NameHash\";s:62:\"20211126_studiolegalelauro_b9ff6abbabbdb72f5639_20211126162441\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:72:\"20211126_studiolegalelauro_b9ff6abbabbdb72f5639_20211126162441_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.3\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:74:\"20211126_studiolegalelauro_b9ff6abbabbdb72f5639_20211126162441_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:52:\"/home/studiolegalelaur/sviluppo.studiolegalelauro.it\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-11-26 16:24:41\";s:7:\"Version\";s:6:\"1.3.38\";s:9:\"VersionWP\";s:6:\"5.3.10\";s:9:\"VersionDB\";s:6:\"5.7.36\";s:10:\"VersionPHP\";s:6:\"7.3.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:26:\"20211126_studiolegalelauro\";s:4:\"Hash\";s:35:\"b9ff6abbabbdb72f5639_20211126162441\";s:8:\"NameHash\";s:62:\"20211126_studiolegalelauro_b9ff6abbabbdb72f5639_20211126162441\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:76:\"20211126_studiolegalelauro_b9ff6abbabbdb72f5639_20211126162441_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:61;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:75:\"20211126_studiolegalelauro_b9ff6abbabbdb72f5639_20211126162441_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:1:{s:14:\"wp_commentmeta\";s:1:\"0\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:160:\"/home/studiolegalelaur/sviluppo.studiolegalelauro.it/wp-content/backups-dup-lite/tmp/20211126_studiolegalelauro_b9ff6abbabbdb72f5639_20211126162441_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:61;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:61:\"/home/studiolegalelaur/sviluppo.studiolegalelauro.it/wp-admin\";i:1;s:71:\"/home/studiolegalelaur/sviluppo.studiolegalelauro.it/wp-content/uploads\";i:2;s:73:\"/home/studiolegalelaur/sviluppo.studiolegalelauro.it/wp-content/languages\";i:3;s:70:\"/home/studiolegalelaur/sviluppo.studiolegalelauro.it/wp-content/themes\";i:4;s:64:\"/home/studiolegalelaur/sviluppo.studiolegalelauro.it/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:52:\"/home/studiolegalelaur/sviluppo.studiolegalelauro.it\";i:1;s:63:\"/home/studiolegalelaur/sviluppo.studiolegalelauro.it/wp-content\";}}s:9:\"Installer\";r:82;s:8:\"Database\";r:94;s:13:\"BuildProgress\";r:126;}");

/* INSERT TABLE DATA: wp_icl_flags */
INSERT INTO `wp_icl_flags` VALUES("1", "ar", "ar.png", "0");
INSERT INTO `wp_icl_flags` VALUES("2", "bg", "bg.png", "0");
INSERT INTO `wp_icl_flags` VALUES("3", "bn", "bn.png", "0");
INSERT INTO `wp_icl_flags` VALUES("4", "bs", "bs.png", "0");
INSERT INTO `wp_icl_flags` VALUES("5", "ca", "ca.png", "0");
INSERT INTO `wp_icl_flags` VALUES("6", "cs", "cs.png", "0");
INSERT INTO `wp_icl_flags` VALUES("7", "cy", "cy.png", "0");
INSERT INTO `wp_icl_flags` VALUES("8", "da", "da.png", "0");
INSERT INTO `wp_icl_flags` VALUES("9", "de", "de.png", "0");
INSERT INTO `wp_icl_flags` VALUES("10", "el", "el.png", "0");
INSERT INTO `wp_icl_flags` VALUES("11", "en", "en.png", "0");
INSERT INTO `wp_icl_flags` VALUES("12", "eo", "eo.png", "0");
INSERT INTO `wp_icl_flags` VALUES("13", "es", "es.png", "0");
INSERT INTO `wp_icl_flags` VALUES("14", "et", "et.png", "0");
INSERT INTO `wp_icl_flags` VALUES("15", "eu", "eu.png", "0");
INSERT INTO `wp_icl_flags` VALUES("16", "fa", "fa.png", "0");
INSERT INTO `wp_icl_flags` VALUES("17", "fi", "fi.png", "0");
INSERT INTO `wp_icl_flags` VALUES("18", "fr", "fr.png", "0");
INSERT INTO `wp_icl_flags` VALUES("19", "ga", "ga.png", "0");
INSERT INTO `wp_icl_flags` VALUES("20", "gl", "gl.png", "0");
INSERT INTO `wp_icl_flags` VALUES("21", "he", "he.png", "0");
INSERT INTO `wp_icl_flags` VALUES("22", "hi", "hi.png", "0");
INSERT INTO `wp_icl_flags` VALUES("23", "hr", "hr.png", "0");
INSERT INTO `wp_icl_flags` VALUES("24", "hu", "hu.png", "0");
INSERT INTO `wp_icl_flags` VALUES("25", "hy", "hy.png", "0");
INSERT INTO `wp_icl_flags` VALUES("26", "id", "id.png", "0");
INSERT INTO `wp_icl_flags` VALUES("27", "is", "is.png", "0");
INSERT INTO `wp_icl_flags` VALUES("28", "it", "it.png", "0");
INSERT INTO `wp_icl_flags` VALUES("29", "ja", "ja.png", "0");
INSERT INTO `wp_icl_flags` VALUES("30", "ko", "ko.png", "0");
INSERT INTO `wp_icl_flags` VALUES("31", "ku", "ku.png", "0");
INSERT INTO `wp_icl_flags` VALUES("32", "lt", "lt.png", "0");
INSERT INTO `wp_icl_flags` VALUES("33", "lv", "lv.png", "0");
INSERT INTO `wp_icl_flags` VALUES("34", "mk", "mk.png", "0");
INSERT INTO `wp_icl_flags` VALUES("35", "mn", "mn.png", "0");
INSERT INTO `wp_icl_flags` VALUES("36", "ms", "ms.png", "0");
INSERT INTO `wp_icl_flags` VALUES("37", "mt", "mt.png", "0");
INSERT INTO `wp_icl_flags` VALUES("38", "ne", "ne.png", "0");
INSERT INTO `wp_icl_flags` VALUES("39", "nl", "nl.png", "0");
INSERT INTO `wp_icl_flags` VALUES("40", "no", "no.png", "0");
INSERT INTO `wp_icl_flags` VALUES("41", "pa", "pa.png", "0");
INSERT INTO `wp_icl_flags` VALUES("42", "pl", "pl.png", "0");
INSERT INTO `wp_icl_flags` VALUES("43", "pt-br", "pt-br.png", "0");
INSERT INTO `wp_icl_flags` VALUES("44", "pt-pt", "pt-pt.png", "0");
INSERT INTO `wp_icl_flags` VALUES("45", "qu", "qu.png", "0");
INSERT INTO `wp_icl_flags` VALUES("46", "ro", "ro.png", "0");
INSERT INTO `wp_icl_flags` VALUES("47", "ru", "ru.png", "0");
INSERT INTO `wp_icl_flags` VALUES("48", "sk", "sk.png", "0");
INSERT INTO `wp_icl_flags` VALUES("49", "sl", "sl.png", "0");
INSERT INTO `wp_icl_flags` VALUES("50", "so", "so.png", "0");
INSERT INTO `wp_icl_flags` VALUES("51", "sq", "sq.png", "0");
INSERT INTO `wp_icl_flags` VALUES("52", "sr", "sr.png", "0");
INSERT INTO `wp_icl_flags` VALUES("53", "sv", "sv.png", "0");
INSERT INTO `wp_icl_flags` VALUES("54", "ta", "ta.png", "0");
INSERT INTO `wp_icl_flags` VALUES("55", "th", "th.png", "0");
INSERT INTO `wp_icl_flags` VALUES("56", "tr", "tr.png", "0");
INSERT INTO `wp_icl_flags` VALUES("57", "uk", "uk.png", "0");
INSERT INTO `wp_icl_flags` VALUES("58", "ur", "ur.png", "0");
INSERT INTO `wp_icl_flags` VALUES("59", "uz", "uz.png", "0");
INSERT INTO `wp_icl_flags` VALUES("60", "vi", "vi.png", "0");
INSERT INTO `wp_icl_flags` VALUES("61", "yi", "yi.png", "0");
INSERT INTO `wp_icl_flags` VALUES("62", "zh-hans", "zh.png", "0");
INSERT INTO `wp_icl_flags` VALUES("63", "zh-hant", "zh.png", "0");
INSERT INTO `wp_icl_flags` VALUES("64", "zu", "zu.png", "0");

/* INSERT TABLE DATA: wp_icl_languages */
INSERT INTO `wp_icl_languages` VALUES("1", "en", "English", "1", "1", "en_US", "en", "0");
INSERT INTO `wp_icl_languages` VALUES("2", "es", "Spanish", "1", "0", "es_ES", "es", "0");
INSERT INTO `wp_icl_languages` VALUES("3", "de", "German", "1", "0", "de_DE", "de", "0");
INSERT INTO `wp_icl_languages` VALUES("4", "fr", "French", "1", "0", "fr_FR", "fr", "0");
INSERT INTO `wp_icl_languages` VALUES("5", "ar", "Arabic", "0", "0", "ar", "ar", "0");
INSERT INTO `wp_icl_languages` VALUES("6", "bs", "Bosnian", "0", "0", "bs_BA", "bs", "0");
INSERT INTO `wp_icl_languages` VALUES("7", "bg", "Bulgarian", "0", "0", "bg_BG", "bg", "0");
INSERT INTO `wp_icl_languages` VALUES("8", "ca", "Catalan", "0", "0", "ca", "ca", "0");
INSERT INTO `wp_icl_languages` VALUES("9", "cs", "Czech", "0", "0", "cs_CZ", "cs", "0");
INSERT INTO `wp_icl_languages` VALUES("10", "sk", "Slovak", "0", "0", "sk_SK", "sk", "0");
INSERT INTO `wp_icl_languages` VALUES("11", "cy", "Welsh", "0", "0", "cy_GB", "cy", "0");
INSERT INTO `wp_icl_languages` VALUES("12", "da", "Danish", "1", "0", "da_DK", "da", "0");
INSERT INTO `wp_icl_languages` VALUES("13", "el", "Greek", "0", "0", "el", "el", "0");
INSERT INTO `wp_icl_languages` VALUES("14", "eo", "Esperanto", "0", "0", "eo_UY", "eo", "0");
INSERT INTO `wp_icl_languages` VALUES("15", "et", "Estonian", "0", "0", "et", "et", "0");
INSERT INTO `wp_icl_languages` VALUES("16", "eu", "Basque", "0", "0", "eu_ES", "eu", "0");
INSERT INTO `wp_icl_languages` VALUES("17", "fa", "Persian", "0", "0", "fa_IR", "fa", "0");
INSERT INTO `wp_icl_languages` VALUES("18", "fi", "Finnish", "0", "0", "fi", "fi", "0");
INSERT INTO `wp_icl_languages` VALUES("19", "ga", "Irish", "0", "0", "ga_IE", "ga", "0");
INSERT INTO `wp_icl_languages` VALUES("20", "he", "Hebrew", "0", "0", "he_IL", "he", "0");
INSERT INTO `wp_icl_languages` VALUES("21", "hi", "Hindi", "0", "0", "hi_IN", "hi", "0");
INSERT INTO `wp_icl_languages` VALUES("22", "hr", "Croatian", "0", "0", "hr", "hr", "0");
INSERT INTO `wp_icl_languages` VALUES("23", "hu", "Hungarian", "0", "0", "hu_HU", "hu", "0");
INSERT INTO `wp_icl_languages` VALUES("24", "hy", "Armenian", "0", "0", "hy_AM", "hy", "0");
INSERT INTO `wp_icl_languages` VALUES("25", "id", "Indonesian", "0", "0", "id_ID", "id", "0");
INSERT INTO `wp_icl_languages` VALUES("26", "is", "Icelandic", "0", "0", "is_IS", "is", "0");
INSERT INTO `wp_icl_languages` VALUES("27", "it", "Italian", "1", "1", "it_IT", "it", "0");
INSERT INTO `wp_icl_languages` VALUES("28", "ja", "Japanese", "1", "0", "ja", "ja", "0");
INSERT INTO `wp_icl_languages` VALUES("29", "ko", "Korean", "0", "0", "ko_KR", "ko", "0");
INSERT INTO `wp_icl_languages` VALUES("30", "ku", "Kurdish", "0", "0", "ckb", "ku", "0");
INSERT INTO `wp_icl_languages` VALUES("31", "lv", "Latvian", "0", "0", "lv_LV", "lv", "0");
INSERT INTO `wp_icl_languages` VALUES("32", "lt", "Lithuanian", "0", "0", "lt_LT", "lt", "0");
INSERT INTO `wp_icl_languages` VALUES("33", "mk", "Macedonian", "0", "0", "mk_MK", "mk", "0");
INSERT INTO `wp_icl_languages` VALUES("34", "mt", "Maltese", "0", "0", "mt_MT", "mt", "0");
INSERT INTO `wp_icl_languages` VALUES("35", "mn", "Mongolian", "0", "0", "mn_MN", "mn", "0");
INSERT INTO `wp_icl_languages` VALUES("36", "ne", "Nepali", "0", "0", "ne", "ne", "0");
INSERT INTO `wp_icl_languages` VALUES("37", "nl", "Dutch", "1", "0", "nl_NL", "nl", "0");
INSERT INTO `wp_icl_languages` VALUES("38", "no", "Norwegian Bokmål", "0", "0", "nb_NO", "no", "0");
INSERT INTO `wp_icl_languages` VALUES("39", "pa", "Punjabi", "0", "0", "", "pa", "0");
INSERT INTO `wp_icl_languages` VALUES("40", "pl", "Polish", "0", "0", "pl_PL", "pl", "0");
INSERT INTO `wp_icl_languages` VALUES("41", "pt-pt", "Portuguese, Portugal", "0", "0", "pt_PT", "pt-pt", "0");
INSERT INTO `wp_icl_languages` VALUES("42", "pt-br", "Portuguese, Brazil", "0", "0", "pt_BR", "pt-br", "0");
INSERT INTO `wp_icl_languages` VALUES("43", "qu", "Quechua", "0", "0", "quz_PE", "qu", "0");
INSERT INTO `wp_icl_languages` VALUES("44", "ro", "Romanian", "0", "0", "ro_RO", "ro", "0");
INSERT INTO `wp_icl_languages` VALUES("45", "ru", "Russian", "1", "0", "ru_RU", "ru", "0");
INSERT INTO `wp_icl_languages` VALUES("46", "sl", "Slovenian", "0", "0", "sl_SI", "sl", "0");
INSERT INTO `wp_icl_languages` VALUES("47", "so", "Somali", "0", "0", "so_SO", "so", "0");
INSERT INTO `wp_icl_languages` VALUES("48", "sq", "Albanian", "0", "0", "sq_AL", "sq", "0");
INSERT INTO `wp_icl_languages` VALUES("49", "sr", "Serbian", "0", "0", "sr_RS", "sr", "0");
INSERT INTO `wp_icl_languages` VALUES("50", "sv", "Swedish", "0", "0", "sv_SE", "sv", "0");
INSERT INTO `wp_icl_languages` VALUES("51", "ta", "Tamil", "0", "0", "ta_IN", "ta", "0");
INSERT INTO `wp_icl_languages` VALUES("52", "th", "Thai", "0", "0", "th", "th", "0");
INSERT INTO `wp_icl_languages` VALUES("53", "tr", "Turkish", "0", "0", "tr_TR", "tr", "0");
INSERT INTO `wp_icl_languages` VALUES("54", "uk", "Ukrainian", "0", "0", "uk", "uk", "0");
INSERT INTO `wp_icl_languages` VALUES("55", "ur", "Urdu", "0", "0", "uz_UZ", "ur", "0");
INSERT INTO `wp_icl_languages` VALUES("56", "uz", "Uzbek", "0", "0", "uz_UZ", "uz", "0");
INSERT INTO `wp_icl_languages` VALUES("57", "vi", "Vietnamese", "0", "0", "vi_VN", "vi", "0");
INSERT INTO `wp_icl_languages` VALUES("58", "yi", "Yiddish", "0", "0", "", "yi", "0");
INSERT INTO `wp_icl_languages` VALUES("59", "zh-hans", "Chinese (Simplified)", "1", "0", "zh_CN", "zh-hans", "0");
INSERT INTO `wp_icl_languages` VALUES("60", "zu", "Zulu", "0", "0", "", "zu", "0");
INSERT INTO `wp_icl_languages` VALUES("61", "zh-hant", "Chinese (Traditional)", "1", "0", "zh_TW", "zh-hant", "0");
INSERT INTO `wp_icl_languages` VALUES("62", "ms", "Malay", "0", "0", "ms_MY", "ms", "0");
INSERT INTO `wp_icl_languages` VALUES("63", "gl", "Galician", "0", "0", "gl_ES", "gl", "0");
INSERT INTO `wp_icl_languages` VALUES("64", "bn", "Bengali", "0", "0", "bn_BD", "bn", "0");

/* INSERT TABLE DATA: wp_icl_languages_translations */
INSERT INTO `wp_icl_languages_translations` VALUES("1", "en", "en", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("2", "en", "es", "Inglés");
INSERT INTO `wp_icl_languages_translations` VALUES("3", "en", "de", "Englisch");
INSERT INTO `wp_icl_languages_translations` VALUES("4", "en", "fr", "Anglais");
INSERT INTO `wp_icl_languages_translations` VALUES("5", "en", "ar", "الإنجليزية");
INSERT INTO `wp_icl_languages_translations` VALUES("6", "en", "bs", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("7", "en", "bg", "Английски");
INSERT INTO `wp_icl_languages_translations` VALUES("8", "en", "ca", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("9", "en", "cs", "Angličtina");
INSERT INTO `wp_icl_languages_translations` VALUES("10", "en", "sk", "Angličtina");
INSERT INTO `wp_icl_languages_translations` VALUES("11", "en", "cy", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("12", "en", "da", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("13", "en", "el", "Αγγλικα");
INSERT INTO `wp_icl_languages_translations` VALUES("14", "en", "eo", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("15", "en", "et", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("16", "en", "eu", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("17", "en", "fa", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("18", "en", "fi", "englanti");
INSERT INTO `wp_icl_languages_translations` VALUES("19", "en", "ga", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("20", "en", "he", "אנגלית");
INSERT INTO `wp_icl_languages_translations` VALUES("21", "en", "hi", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("22", "en", "hr", "Engleski");
INSERT INTO `wp_icl_languages_translations` VALUES("23", "en", "hu", "angol");
INSERT INTO `wp_icl_languages_translations` VALUES("24", "en", "hy", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("25", "en", "id", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("26", "en", "is", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("27", "en", "it", "Inglese");
INSERT INTO `wp_icl_languages_translations` VALUES("28", "en", "ja", "英語");
INSERT INTO `wp_icl_languages_translations` VALUES("29", "en", "ko", "영어");
INSERT INTO `wp_icl_languages_translations` VALUES("30", "en", "ku", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("31", "en", "lv", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("32", "en", "lt", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("33", "en", "mk", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("34", "en", "mt", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("35", "en", "mn", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("36", "en", "ne", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("37", "en", "nl", "Engels");
INSERT INTO `wp_icl_languages_translations` VALUES("38", "en", "no", "Engelsk");
INSERT INTO `wp_icl_languages_translations` VALUES("39", "en", "pa", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("40", "en", "pl", "angielski");
INSERT INTO `wp_icl_languages_translations` VALUES("41", "en", "pt-pt", "Inglês");
INSERT INTO `wp_icl_languages_translations` VALUES("42", "en", "pt-br", "Inglês");
INSERT INTO `wp_icl_languages_translations` VALUES("43", "en", "qu", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("44", "en", "ro", "Engleză");
INSERT INTO `wp_icl_languages_translations` VALUES("45", "en", "ru", "Английский");
INSERT INTO `wp_icl_languages_translations` VALUES("46", "en", "sl", "Angleščina");
INSERT INTO `wp_icl_languages_translations` VALUES("47", "en", "so", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("48", "en", "sq", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("49", "en", "sr", "енглески");
INSERT INTO `wp_icl_languages_translations` VALUES("50", "en", "sv", "Engelska");
INSERT INTO `wp_icl_languages_translations` VALUES("51", "en", "ta", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("52", "en", "th", "อังกฤษ");
INSERT INTO `wp_icl_languages_translations` VALUES("53", "en", "tr", "İngilizce");
INSERT INTO `wp_icl_languages_translations` VALUES("54", "en", "uk", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("55", "en", "ur", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("56", "en", "uz", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("57", "en", "vi", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("58", "en", "yi", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("59", "en", "zh-hans", "英语");
INSERT INTO `wp_icl_languages_translations` VALUES("60", "en", "zu", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("61", "en", "zh-hant", "英語");
INSERT INTO `wp_icl_languages_translations` VALUES("62", "en", "ms", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("63", "en", "gl", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("64", "en", "bn", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("65", "es", "en", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("66", "es", "es", "Español");
INSERT INTO `wp_icl_languages_translations` VALUES("67", "es", "de", "Spanisch");
INSERT INTO `wp_icl_languages_translations` VALUES("68", "es", "fr", "Espagnol");
INSERT INTO `wp_icl_languages_translations` VALUES("69", "es", "ar", "الأسبانية");
INSERT INTO `wp_icl_languages_translations` VALUES("70", "es", "bs", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("71", "es", "bg", "Испански");
INSERT INTO `wp_icl_languages_translations` VALUES("72", "es", "ca", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("73", "es", "cs", "Španělský");
INSERT INTO `wp_icl_languages_translations` VALUES("74", "es", "sk", "Španielčina");
INSERT INTO `wp_icl_languages_translations` VALUES("75", "es", "cy", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("76", "es", "da", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("77", "es", "el", "Ισπανικα");
INSERT INTO `wp_icl_languages_translations` VALUES("78", "es", "eo", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("79", "es", "et", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("80", "es", "eu", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("81", "es", "fa", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("82", "es", "fi", "espanja");
INSERT INTO `wp_icl_languages_translations` VALUES("83", "es", "ga", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("84", "es", "he", "ספרדית");
INSERT INTO `wp_icl_languages_translations` VALUES("85", "es", "hi", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("86", "es", "hr", "španjolski");
INSERT INTO `wp_icl_languages_translations` VALUES("87", "es", "hu", "spanyol");
INSERT INTO `wp_icl_languages_translations` VALUES("88", "es", "hy", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("89", "es", "id", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("90", "es", "is", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("91", "es", "it", "Spagnolo");
INSERT INTO `wp_icl_languages_translations` VALUES("92", "es", "ja", "スペイン語");
INSERT INTO `wp_icl_languages_translations` VALUES("93", "es", "ko", "스페인어");
INSERT INTO `wp_icl_languages_translations` VALUES("94", "es", "ku", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("95", "es", "lv", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("96", "es", "lt", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("97", "es", "mk", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("98", "es", "mt", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("99", "es", "mn", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("100", "es", "ne", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("101", "es", "nl", "Spaans");
INSERT INTO `wp_icl_languages_translations` VALUES("102", "es", "no", "Spansk");
INSERT INTO `wp_icl_languages_translations` VALUES("103", "es", "pa", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("104", "es", "pl", "hiszpański");
INSERT INTO `wp_icl_languages_translations` VALUES("105", "es", "pt-pt", "Espanhol");
INSERT INTO `wp_icl_languages_translations` VALUES("106", "es", "pt-br", "Espanhol");
INSERT INTO `wp_icl_languages_translations` VALUES("107", "es", "qu", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("108", "es", "ro", "Spaniolă");
INSERT INTO `wp_icl_languages_translations` VALUES("109", "es", "ru", "Испанский");
INSERT INTO `wp_icl_languages_translations` VALUES("110", "es", "sl", "Španščina");
INSERT INTO `wp_icl_languages_translations` VALUES("111", "es", "so", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("112", "es", "sq", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("113", "es", "sr", "шпански");
INSERT INTO `wp_icl_languages_translations` VALUES("114", "es", "sv", "Spanska");
INSERT INTO `wp_icl_languages_translations` VALUES("115", "es", "ta", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("116", "es", "th", "สเปน");
INSERT INTO `wp_icl_languages_translations` VALUES("117", "es", "tr", "İspanyolca");
INSERT INTO `wp_icl_languages_translations` VALUES("118", "es", "uk", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("119", "es", "ur", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("120", "es", "uz", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("121", "es", "vi", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("122", "es", "yi", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("123", "es", "zh-hans", "西班牙语");
INSERT INTO `wp_icl_languages_translations` VALUES("124", "es", "zu", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("125", "es", "zh-hant", "西班牙語");
INSERT INTO `wp_icl_languages_translations` VALUES("126", "es", "ms", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("127", "es", "gl", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("128", "es", "bn", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("129", "de", "en", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("130", "de", "es", "Alemán");
INSERT INTO `wp_icl_languages_translations` VALUES("131", "de", "de", "Deutsch");
INSERT INTO `wp_icl_languages_translations` VALUES("132", "de", "fr", "Allemand");
INSERT INTO `wp_icl_languages_translations` VALUES("133", "de", "ar", "الألمانية");
INSERT INTO `wp_icl_languages_translations` VALUES("134", "de", "bs", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("135", "de", "bg", "Немски");
INSERT INTO `wp_icl_languages_translations` VALUES("136", "de", "ca", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("137", "de", "cs", "Němec");
INSERT INTO `wp_icl_languages_translations` VALUES("138", "de", "sk", "Nemčina");
INSERT INTO `wp_icl_languages_translations` VALUES("139", "de", "cy", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("140", "de", "da", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("141", "de", "el", "Γερμανικα");
INSERT INTO `wp_icl_languages_translations` VALUES("142", "de", "eo", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("143", "de", "et", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("144", "de", "eu", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("145", "de", "fa", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("146", "de", "fi", "saksa");
INSERT INTO `wp_icl_languages_translations` VALUES("147", "de", "ga", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("148", "de", "he", "גרמנית");
INSERT INTO `wp_icl_languages_translations` VALUES("149", "de", "hi", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("150", "de", "hr", "Njemački");
INSERT INTO `wp_icl_languages_translations` VALUES("151", "de", "hu", "német");
INSERT INTO `wp_icl_languages_translations` VALUES("152", "de", "hy", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("153", "de", "id", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("154", "de", "is", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("155", "de", "it", "Tedesco");
INSERT INTO `wp_icl_languages_translations` VALUES("156", "de", "ja", "ドイツ語");
INSERT INTO `wp_icl_languages_translations` VALUES("157", "de", "ko", "독어");
INSERT INTO `wp_icl_languages_translations` VALUES("158", "de", "ku", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("159", "de", "lv", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("160", "de", "lt", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("161", "de", "mk", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("162", "de", "mt", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("163", "de", "mn", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("164", "de", "ne", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("165", "de", "nl", "Duits");
INSERT INTO `wp_icl_languages_translations` VALUES("166", "de", "no", "Tysk");
INSERT INTO `wp_icl_languages_translations` VALUES("167", "de", "pa", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("168", "de", "pl", "niemiecki");
INSERT INTO `wp_icl_languages_translations` VALUES("169", "de", "pt-pt", "Alemão");
INSERT INTO `wp_icl_languages_translations` VALUES("170", "de", "pt-br", "Alemão");
INSERT INTO `wp_icl_languages_translations` VALUES("171", "de", "qu", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("172", "de", "ro", "Germană");
INSERT INTO `wp_icl_languages_translations` VALUES("173", "de", "ru", "Немецкий");
INSERT INTO `wp_icl_languages_translations` VALUES("174", "de", "sl", "Nemščina");
INSERT INTO `wp_icl_languages_translations` VALUES("175", "de", "so", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("176", "de", "sq", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("177", "de", "sr", "немачки");
INSERT INTO `wp_icl_languages_translations` VALUES("178", "de", "sv", "Tyska");
INSERT INTO `wp_icl_languages_translations` VALUES("179", "de", "ta", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("180", "de", "th", "เยอรมัน");
INSERT INTO `wp_icl_languages_translations` VALUES("181", "de", "tr", "Almanca");
INSERT INTO `wp_icl_languages_translations` VALUES("182", "de", "uk", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("183", "de", "ur", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("184", "de", "uz", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("185", "de", "vi", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("186", "de", "yi", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("187", "de", "zh-hans", "德语");
INSERT INTO `wp_icl_languages_translations` VALUES("188", "de", "zu", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("189", "de", "zh-hant", "德語");
INSERT INTO `wp_icl_languages_translations` VALUES("190", "de", "ms", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("191", "de", "gl", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("192", "de", "bn", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("193", "fr", "en", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("194", "fr", "es", "Francés");
INSERT INTO `wp_icl_languages_translations` VALUES("195", "fr", "de", "Französisch");
INSERT INTO `wp_icl_languages_translations` VALUES("196", "fr", "fr", "Français");
INSERT INTO `wp_icl_languages_translations` VALUES("197", "fr", "ar", "الفرنسية");
INSERT INTO `wp_icl_languages_translations` VALUES("198", "fr", "bs", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("199", "fr", "bg", "Френски");
INSERT INTO `wp_icl_languages_translations` VALUES("200", "fr", "ca", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("201", "fr", "cs", "Francouzština");
INSERT INTO `wp_icl_languages_translations` VALUES("202", "fr", "sk", "Francúzština");
INSERT INTO `wp_icl_languages_translations` VALUES("203", "fr", "cy", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("204", "fr", "da", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("205", "fr", "el", "Γαλλικα");
INSERT INTO `wp_icl_languages_translations` VALUES("206", "fr", "eo", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("207", "fr", "et", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("208", "fr", "eu", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("209", "fr", "fa", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("210", "fr", "fi", "ranska");
INSERT INTO `wp_icl_languages_translations` VALUES("211", "fr", "ga", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("212", "fr", "he", "צרפתית");
INSERT INTO `wp_icl_languages_translations` VALUES("213", "fr", "hi", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("214", "fr", "hr", "Francuzi");
INSERT INTO `wp_icl_languages_translations` VALUES("215", "fr", "hu", "francia");
INSERT INTO `wp_icl_languages_translations` VALUES("216", "fr", "hy", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("217", "fr", "id", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("218", "fr", "is", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("219", "fr", "it", "Francese");
INSERT INTO `wp_icl_languages_translations` VALUES("220", "fr", "ja", "フランス語");
INSERT INTO `wp_icl_languages_translations` VALUES("221", "fr", "ko", "불어");
INSERT INTO `wp_icl_languages_translations` VALUES("222", "fr", "ku", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("223", "fr", "lv", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("224", "fr", "lt", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("225", "fr", "mk", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("226", "fr", "mt", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("227", "fr", "mn", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("228", "fr", "ne", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("229", "fr", "nl", "Frans");
INSERT INTO `wp_icl_languages_translations` VALUES("230", "fr", "no", "Fransk");
INSERT INTO `wp_icl_languages_translations` VALUES("231", "fr", "pa", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("232", "fr", "pl", "francuski");
INSERT INTO `wp_icl_languages_translations` VALUES("233", "fr", "pt-pt", "Francês");
INSERT INTO `wp_icl_languages_translations` VALUES("234", "fr", "pt-br", "Francês");
INSERT INTO `wp_icl_languages_translations` VALUES("235", "fr", "qu", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("236", "fr", "ro", "Franceză");
INSERT INTO `wp_icl_languages_translations` VALUES("237", "fr", "ru", "Французский");
INSERT INTO `wp_icl_languages_translations` VALUES("238", "fr", "sl", "Francoščina");
INSERT INTO `wp_icl_languages_translations` VALUES("239", "fr", "so", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("240", "fr", "sq", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("241", "fr", "sr", "француски");
INSERT INTO `wp_icl_languages_translations` VALUES("242", "fr", "sv", "Franska");
INSERT INTO `wp_icl_languages_translations` VALUES("243", "fr", "ta", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("244", "fr", "th", "ฝรั่งเศส");
INSERT INTO `wp_icl_languages_translations` VALUES("245", "fr", "tr", "Fransızca");
INSERT INTO `wp_icl_languages_translations` VALUES("246", "fr", "uk", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("247", "fr", "ur", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("248", "fr", "uz", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("249", "fr", "vi", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("250", "fr", "yi", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("251", "fr", "zh-hans", "法语");
INSERT INTO `wp_icl_languages_translations` VALUES("252", "fr", "zu", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("253", "fr", "zh-hant", "法語");
INSERT INTO `wp_icl_languages_translations` VALUES("254", "fr", "ms", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("255", "fr", "gl", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("256", "fr", "bn", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("257", "ar", "en", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("258", "ar", "es", "Árabe");
INSERT INTO `wp_icl_languages_translations` VALUES("259", "ar", "de", "Arabisch");
INSERT INTO `wp_icl_languages_translations` VALUES("260", "ar", "fr", "Arabe");
INSERT INTO `wp_icl_languages_translations` VALUES("261", "ar", "ar", "العربية");
INSERT INTO `wp_icl_languages_translations` VALUES("262", "ar", "bs", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("263", "ar", "bg", "Арабски");
INSERT INTO `wp_icl_languages_translations` VALUES("264", "ar", "ca", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("265", "ar", "cs", "Arabština");
INSERT INTO `wp_icl_languages_translations` VALUES("266", "ar", "sk", "Arabčina");
INSERT INTO `wp_icl_languages_translations` VALUES("267", "ar", "cy", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("268", "ar", "da", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("269", "ar", "el", "Αραβικα");
INSERT INTO `wp_icl_languages_translations` VALUES("270", "ar", "eo", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("271", "ar", "et", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("272", "ar", "eu", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("273", "ar", "fa", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("274", "ar", "fi", "arabia");
INSERT INTO `wp_icl_languages_translations` VALUES("275", "ar", "ga", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("276", "ar", "he", "ערבית");
INSERT INTO `wp_icl_languages_translations` VALUES("277", "ar", "hi", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("278", "ar", "hr", "Arapski");
INSERT INTO `wp_icl_languages_translations` VALUES("279", "ar", "hu", "arab");
INSERT INTO `wp_icl_languages_translations` VALUES("280", "ar", "hy", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("281", "ar", "id", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("282", "ar", "is", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("283", "ar", "it", "Arabo");
INSERT INTO `wp_icl_languages_translations` VALUES("284", "ar", "ja", "アラビア語");
INSERT INTO `wp_icl_languages_translations` VALUES("285", "ar", "ko", "아랍어");
INSERT INTO `wp_icl_languages_translations` VALUES("286", "ar", "ku", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("287", "ar", "lv", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("288", "ar", "lt", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("289", "ar", "mk", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("290", "ar", "mt", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("291", "ar", "mn", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("292", "ar", "ne", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("293", "ar", "nl", "Arabisch");
INSERT INTO `wp_icl_languages_translations` VALUES("294", "ar", "no", "Arabisk");
INSERT INTO `wp_icl_languages_translations` VALUES("295", "ar", "pa", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("296", "ar", "pl", "arabski");
INSERT INTO `wp_icl_languages_translations` VALUES("297", "ar", "pt-pt", "Árabe");
INSERT INTO `wp_icl_languages_translations` VALUES("298", "ar", "pt-br", "Árabe");
INSERT INTO `wp_icl_languages_translations` VALUES("299", "ar", "qu", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("300", "ar", "ro", "Arabică");
INSERT INTO `wp_icl_languages_translations` VALUES("301", "ar", "ru", "Арабский");
INSERT INTO `wp_icl_languages_translations` VALUES("302", "ar", "sl", "Arabščina");
INSERT INTO `wp_icl_languages_translations` VALUES("303", "ar", "so", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("304", "ar", "sq", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("305", "ar", "sr", "арапски");
INSERT INTO `wp_icl_languages_translations` VALUES("306", "ar", "sv", "Arabiska");
INSERT INTO `wp_icl_languages_translations` VALUES("307", "ar", "ta", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("308", "ar", "th", "อารบิก");
INSERT INTO `wp_icl_languages_translations` VALUES("309", "ar", "tr", "Arapça");
INSERT INTO `wp_icl_languages_translations` VALUES("310", "ar", "uk", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("311", "ar", "ur", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("312", "ar", "uz", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("313", "ar", "vi", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("314", "ar", "yi", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("315", "ar", "zh-hans", "阿拉伯语");
INSERT INTO `wp_icl_languages_translations` VALUES("316", "ar", "zu", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("317", "ar", "zh-hant", "阿拉伯語");
INSERT INTO `wp_icl_languages_translations` VALUES("318", "ar", "ms", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("319", "ar", "gl", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("320", "ar", "bn", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("321", "bs", "en", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("322", "bs", "es", "Bosnio");
INSERT INTO `wp_icl_languages_translations` VALUES("323", "bs", "de", "Bosnisch");
INSERT INTO `wp_icl_languages_translations` VALUES("324", "bs", "fr", "Bosnien");
INSERT INTO `wp_icl_languages_translations` VALUES("325", "bs", "ar", "البوسنية");
INSERT INTO `wp_icl_languages_translations` VALUES("326", "bs", "bs", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("327", "bs", "bg", "Босненски");
INSERT INTO `wp_icl_languages_translations` VALUES("328", "bs", "ca", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("329", "bs", "cs", "Bosenština");
INSERT INTO `wp_icl_languages_translations` VALUES("330", "bs", "sk", "Bosniačtina");
INSERT INTO `wp_icl_languages_translations` VALUES("331", "bs", "cy", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("332", "bs", "da", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("333", "bs", "el", "Βοσνιακα");
INSERT INTO `wp_icl_languages_translations` VALUES("334", "bs", "eo", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("335", "bs", "et", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("336", "bs", "eu", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("337", "bs", "fa", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("338", "bs", "fi", "bosnia");
INSERT INTO `wp_icl_languages_translations` VALUES("339", "bs", "ga", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("340", "bs", "he", "בוסנית");
INSERT INTO `wp_icl_languages_translations` VALUES("341", "bs", "hi", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("342", "bs", "hr", "Bosanski");
INSERT INTO `wp_icl_languages_translations` VALUES("343", "bs", "hu", "bosnyák");
INSERT INTO `wp_icl_languages_translations` VALUES("344", "bs", "hy", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("345", "bs", "id", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("346", "bs", "is", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("347", "bs", "it", "Bosniaco");
INSERT INTO `wp_icl_languages_translations` VALUES("348", "bs", "ja", "ボスニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("349", "bs", "ko", "보즈니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("350", "bs", "ku", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("351", "bs", "lv", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("352", "bs", "lt", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("353", "bs", "mk", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("354", "bs", "mt", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("355", "bs", "mn", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("356", "bs", "ne", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("357", "bs", "nl", "Bosnisch");
INSERT INTO `wp_icl_languages_translations` VALUES("358", "bs", "no", "Bosnisk");
INSERT INTO `wp_icl_languages_translations` VALUES("359", "bs", "pa", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("360", "bs", "pl", "bośniacki");
INSERT INTO `wp_icl_languages_translations` VALUES("361", "bs", "pt-pt", "Bósnio");
INSERT INTO `wp_icl_languages_translations` VALUES("362", "bs", "pt-br", "Bósnio");
INSERT INTO `wp_icl_languages_translations` VALUES("363", "bs", "qu", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("364", "bs", "ro", "Bosniacă");
INSERT INTO `wp_icl_languages_translations` VALUES("365", "bs", "ru", "Боснийский");
INSERT INTO `wp_icl_languages_translations` VALUES("366", "bs", "sl", "Bosanski");
INSERT INTO `wp_icl_languages_translations` VALUES("367", "bs", "so", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("368", "bs", "sq", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("369", "bs", "sr", "босански");
INSERT INTO `wp_icl_languages_translations` VALUES("370", "bs", "sv", "Bosniska");
INSERT INTO `wp_icl_languages_translations` VALUES("371", "bs", "ta", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("372", "bs", "th", "บอสเนียน");
INSERT INTO `wp_icl_languages_translations` VALUES("373", "bs", "tr", "Boşnakça");
INSERT INTO `wp_icl_languages_translations` VALUES("374", "bs", "uk", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("375", "bs", "ur", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("376", "bs", "uz", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("377", "bs", "vi", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("378", "bs", "yi", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("379", "bs", "zh-hans", "波斯尼亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("380", "bs", "zu", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("381", "bs", "zh-hant", "波士尼亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("382", "bs", "ms", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("383", "bs", "gl", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("384", "bs", "bn", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("385", "bg", "en", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("386", "bg", "es", "Búlgaro");
INSERT INTO `wp_icl_languages_translations` VALUES("387", "bg", "de", "Bulgarisch");
INSERT INTO `wp_icl_languages_translations` VALUES("388", "bg", "fr", "Bulgare");
INSERT INTO `wp_icl_languages_translations` VALUES("389", "bg", "ar", "البلغارية");
INSERT INTO `wp_icl_languages_translations` VALUES("390", "bg", "bs", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("391", "bg", "bg", "Български");
INSERT INTO `wp_icl_languages_translations` VALUES("392", "bg", "ca", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("393", "bg", "cs", "Bulharština");
INSERT INTO `wp_icl_languages_translations` VALUES("394", "bg", "sk", "Bulharčina");
INSERT INTO `wp_icl_languages_translations` VALUES("395", "bg", "cy", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("396", "bg", "da", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("397", "bg", "el", "Βουλγαρικα");
INSERT INTO `wp_icl_languages_translations` VALUES("398", "bg", "eo", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("399", "bg", "et", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("400", "bg", "eu", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("401", "bg", "fa", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("402", "bg", "fi", "bulgaria");
INSERT INTO `wp_icl_languages_translations` VALUES("403", "bg", "ga", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("404", "bg", "he", "בולגרית");
INSERT INTO `wp_icl_languages_translations` VALUES("405", "bg", "hi", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("406", "bg", "hr", "Bugarski");
INSERT INTO `wp_icl_languages_translations` VALUES("407", "bg", "hu", "bolgár");
INSERT INTO `wp_icl_languages_translations` VALUES("408", "bg", "hy", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("409", "bg", "id", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("410", "bg", "is", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("411", "bg", "it", "Bulgaro");
INSERT INTO `wp_icl_languages_translations` VALUES("412", "bg", "ja", "ブルガリア語");
INSERT INTO `wp_icl_languages_translations` VALUES("413", "bg", "ko", "불가리아어");
INSERT INTO `wp_icl_languages_translations` VALUES("414", "bg", "ku", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("415", "bg", "lv", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("416", "bg", "lt", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("417", "bg", "mk", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("418", "bg", "mt", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("419", "bg", "mn", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("420", "bg", "ne", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("421", "bg", "nl", "Bulgaars");
INSERT INTO `wp_icl_languages_translations` VALUES("422", "bg", "no", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("423", "bg", "pa", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("424", "bg", "pl", "bułgarski");
INSERT INTO `wp_icl_languages_translations` VALUES("425", "bg", "pt-pt", "Búlgaro");
INSERT INTO `wp_icl_languages_translations` VALUES("426", "bg", "pt-br", "Búlgaro");
INSERT INTO `wp_icl_languages_translations` VALUES("427", "bg", "qu", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("428", "bg", "ro", "Bulgară");
INSERT INTO `wp_icl_languages_translations` VALUES("429", "bg", "ru", "Болгарский");
INSERT INTO `wp_icl_languages_translations` VALUES("430", "bg", "sl", "Bolgarščina");
INSERT INTO `wp_icl_languages_translations` VALUES("431", "bg", "so", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("432", "bg", "sq", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("433", "bg", "sr", "бугарски");
INSERT INTO `wp_icl_languages_translations` VALUES("434", "bg", "sv", "Bulgariska");
INSERT INTO `wp_icl_languages_translations` VALUES("435", "bg", "ta", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("436", "bg", "th", "บัลแกเรียน");
INSERT INTO `wp_icl_languages_translations` VALUES("437", "bg", "tr", "Bulgarca");
INSERT INTO `wp_icl_languages_translations` VALUES("438", "bg", "uk", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("439", "bg", "ur", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("440", "bg", "uz", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("441", "bg", "vi", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("442", "bg", "yi", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("443", "bg", "zh-hans", "保加利亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("444", "bg", "zu", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("445", "bg", "zh-hant", "保加利亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("446", "bg", "ms", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("447", "bg", "gl", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("448", "bg", "bn", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("449", "ca", "en", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("450", "ca", "es", "Catalán");
INSERT INTO `wp_icl_languages_translations` VALUES("451", "ca", "de", "Katalanisch");
INSERT INTO `wp_icl_languages_translations` VALUES("452", "ca", "fr", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("453", "ca", "ar", "الكاتالوينية");
INSERT INTO `wp_icl_languages_translations` VALUES("454", "ca", "bs", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("455", "ca", "bg", "Каталонски");
INSERT INTO `wp_icl_languages_translations` VALUES("456", "ca", "ca", "Català");
INSERT INTO `wp_icl_languages_translations` VALUES("457", "ca", "cs", "Katalánština");
INSERT INTO `wp_icl_languages_translations` VALUES("458", "ca", "sk", "Katalánčina");
INSERT INTO `wp_icl_languages_translations` VALUES("459", "ca", "cy", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("460", "ca", "da", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("461", "ca", "el", "Καταλανικα");
INSERT INTO `wp_icl_languages_translations` VALUES("462", "ca", "eo", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("463", "ca", "et", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("464", "ca", "eu", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("465", "ca", "fa", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("466", "ca", "fi", "katalaani");
INSERT INTO `wp_icl_languages_translations` VALUES("467", "ca", "ga", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("468", "ca", "he", "קטלאנית");
INSERT INTO `wp_icl_languages_translations` VALUES("469", "ca", "hi", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("470", "ca", "hr", "Katalonski");
INSERT INTO `wp_icl_languages_translations` VALUES("471", "ca", "hu", "katalán");
INSERT INTO `wp_icl_languages_translations` VALUES("472", "ca", "hy", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("473", "ca", "id", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("474", "ca", "is", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("475", "ca", "it", "Catalano");
INSERT INTO `wp_icl_languages_translations` VALUES("476", "ca", "ja", "カタルーニャ語");
INSERT INTO `wp_icl_languages_translations` VALUES("477", "ca", "ko", "카탈로니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("478", "ca", "ku", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("479", "ca", "lv", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("480", "ca", "lt", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("481", "ca", "mk", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("482", "ca", "mt", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("483", "ca", "mn", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("484", "ca", "ne", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("485", "ca", "nl", "Catalaans");
INSERT INTO `wp_icl_languages_translations` VALUES("486", "ca", "no", "catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("487", "ca", "pa", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("488", "ca", "pl", "kataloński");
INSERT INTO `wp_icl_languages_translations` VALUES("489", "ca", "pt-pt", "Catalão");
INSERT INTO `wp_icl_languages_translations` VALUES("490", "ca", "pt-br", "Catalão");
INSERT INTO `wp_icl_languages_translations` VALUES("491", "ca", "qu", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("492", "ca", "ro", "Catalană");
INSERT INTO `wp_icl_languages_translations` VALUES("493", "ca", "ru", "Каталанский");
INSERT INTO `wp_icl_languages_translations` VALUES("494", "ca", "sl", "Katalonščina");
INSERT INTO `wp_icl_languages_translations` VALUES("495", "ca", "so", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("496", "ca", "sq", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("497", "ca", "sr", "каталонски");
INSERT INTO `wp_icl_languages_translations` VALUES("498", "ca", "sv", "Katalanska");
INSERT INTO `wp_icl_languages_translations` VALUES("499", "ca", "ta", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("500", "ca", "th", "คะตะลาน");
INSERT INTO `wp_icl_languages_translations` VALUES("501", "ca", "tr", "Katalan dili");
INSERT INTO `wp_icl_languages_translations` VALUES("502", "ca", "uk", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("503", "ca", "ur", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("504", "ca", "uz", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("505", "ca", "vi", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("506", "ca", "yi", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("507", "ca", "zh-hans", "加泰罗尼亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("508", "ca", "zu", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("509", "ca", "zh-hant", "加泰羅尼亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("510", "ca", "ms", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("511", "ca", "gl", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("512", "ca", "bn", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("513", "cs", "en", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("514", "cs", "es", "Checo");
INSERT INTO `wp_icl_languages_translations` VALUES("515", "cs", "de", "Tschechisch");
INSERT INTO `wp_icl_languages_translations` VALUES("516", "cs", "fr", "Tchèque");
INSERT INTO `wp_icl_languages_translations` VALUES("517", "cs", "ar", "التشيكية");
INSERT INTO `wp_icl_languages_translations` VALUES("518", "cs", "bs", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("519", "cs", "bg", "Чешки");
INSERT INTO `wp_icl_languages_translations` VALUES("520", "cs", "ca", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("521", "cs", "cs", "Čeština");
INSERT INTO `wp_icl_languages_translations` VALUES("522", "cs", "sk", "Čeština");
INSERT INTO `wp_icl_languages_translations` VALUES("523", "cs", "cy", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("524", "cs", "da", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("525", "cs", "el", "Τσεχικη");
INSERT INTO `wp_icl_languages_translations` VALUES("526", "cs", "eo", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("527", "cs", "et", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("528", "cs", "eu", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("529", "cs", "fa", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("530", "cs", "fi", "tsekki");
INSERT INTO `wp_icl_languages_translations` VALUES("531", "cs", "ga", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("532", "cs", "he", "צ\'כית");
INSERT INTO `wp_icl_languages_translations` VALUES("533", "cs", "hi", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("534", "cs", "hr", "češki");
INSERT INTO `wp_icl_languages_translations` VALUES("535", "cs", "hu", "cseh");
INSERT INTO `wp_icl_languages_translations` VALUES("536", "cs", "hy", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("537", "cs", "id", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("538", "cs", "is", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("539", "cs", "it", "Ceco");
INSERT INTO `wp_icl_languages_translations` VALUES("540", "cs", "ja", "チェコ語");
INSERT INTO `wp_icl_languages_translations` VALUES("541", "cs", "ko", "체코슬로바키아어");
INSERT INTO `wp_icl_languages_translations` VALUES("542", "cs", "ku", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("543", "cs", "lv", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("544", "cs", "lt", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("545", "cs", "mk", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("546", "cs", "mt", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("547", "cs", "mn", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("548", "cs", "ne", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("549", "cs", "nl", "Tsjechisch");
INSERT INTO `wp_icl_languages_translations` VALUES("550", "cs", "no", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("551", "cs", "pa", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("552", "cs", "pl", "czeski");
INSERT INTO `wp_icl_languages_translations` VALUES("553", "cs", "pt-pt", "Tcheco");
INSERT INTO `wp_icl_languages_translations` VALUES("554", "cs", "pt-br", "Tcheco");
INSERT INTO `wp_icl_languages_translations` VALUES("555", "cs", "qu", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("556", "cs", "ro", "Cehă");
INSERT INTO `wp_icl_languages_translations` VALUES("557", "cs", "ru", "Чешский");
INSERT INTO `wp_icl_languages_translations` VALUES("558", "cs", "sl", "Češčina");
INSERT INTO `wp_icl_languages_translations` VALUES("559", "cs", "so", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("560", "cs", "sq", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("561", "cs", "sr", "чешки");
INSERT INTO `wp_icl_languages_translations` VALUES("562", "cs", "sv", "Tjeckiska");
INSERT INTO `wp_icl_languages_translations` VALUES("563", "cs", "ta", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("564", "cs", "th", "เช็ก");
INSERT INTO `wp_icl_languages_translations` VALUES("565", "cs", "tr", "Çekçe");
INSERT INTO `wp_icl_languages_translations` VALUES("566", "cs", "uk", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("567", "cs", "ur", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("568", "cs", "uz", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("569", "cs", "vi", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("570", "cs", "yi", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("571", "cs", "zh-hans", "捷克语");
INSERT INTO `wp_icl_languages_translations` VALUES("572", "cs", "zu", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("573", "cs", "zh-hant", "捷克語");
INSERT INTO `wp_icl_languages_translations` VALUES("574", "cs", "ms", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("575", "cs", "gl", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("576", "cs", "bn", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("577", "sk", "en", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("578", "sk", "es", "Eslavo");
INSERT INTO `wp_icl_languages_translations` VALUES("579", "sk", "de", "Slowakisch");
INSERT INTO `wp_icl_languages_translations` VALUES("580", "sk", "fr", "Slave");
INSERT INTO `wp_icl_languages_translations` VALUES("581", "sk", "ar", "السلافية");
INSERT INTO `wp_icl_languages_translations` VALUES("582", "sk", "bs", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("583", "sk", "bg", "Словашки");
INSERT INTO `wp_icl_languages_translations` VALUES("584", "sk", "ca", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("585", "sk", "cs", "Slovenština");
INSERT INTO `wp_icl_languages_translations` VALUES("586", "sk", "sk", "Slovenčina");
INSERT INTO `wp_icl_languages_translations` VALUES("587", "sk", "cy", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("588", "sk", "da", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("589", "sk", "el", "Σλαβικη");
INSERT INTO `wp_icl_languages_translations` VALUES("590", "sk", "eo", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("591", "sk", "et", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("592", "sk", "eu", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("593", "sk", "fa", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("594", "sk", "fi", "slaavi");
INSERT INTO `wp_icl_languages_translations` VALUES("595", "sk", "ga", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("596", "sk", "he", "סלאבית");
INSERT INTO `wp_icl_languages_translations` VALUES("597", "sk", "hi", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("598", "sk", "hr", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("599", "sk", "hu", "szláv");
INSERT INTO `wp_icl_languages_translations` VALUES("600", "sk", "hy", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("601", "sk", "id", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("602", "sk", "is", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("603", "sk", "it", "Slavo");
INSERT INTO `wp_icl_languages_translations` VALUES("604", "sk", "ja", "スラヴ語派");
INSERT INTO `wp_icl_languages_translations` VALUES("605", "sk", "ko", "슬라브어");
INSERT INTO `wp_icl_languages_translations` VALUES("606", "sk", "ku", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("607", "sk", "lv", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("608", "sk", "lt", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("609", "sk", "mk", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("610", "sk", "mt", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("611", "sk", "mn", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("612", "sk", "ne", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("613", "sk", "nl", "Slavisch");
INSERT INTO `wp_icl_languages_translations` VALUES("614", "sk", "no", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("615", "sk", "pa", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("616", "sk", "pl", "słowacki");
INSERT INTO `wp_icl_languages_translations` VALUES("617", "sk", "pt-pt", "Eslavo");
INSERT INTO `wp_icl_languages_translations` VALUES("618", "sk", "pt-br", "Eslavo");
INSERT INTO `wp_icl_languages_translations` VALUES("619", "sk", "qu", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("620", "sk", "ro", "Slavă");
INSERT INTO `wp_icl_languages_translations` VALUES("621", "sk", "ru", "Славянский");
INSERT INTO `wp_icl_languages_translations` VALUES("622", "sk", "sl", "Slovaščina");
INSERT INTO `wp_icl_languages_translations` VALUES("623", "sk", "so", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("624", "sk", "sq", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("625", "sk", "sr", "словачки");
INSERT INTO `wp_icl_languages_translations` VALUES("626", "sk", "sv", "Slavisk");
INSERT INTO `wp_icl_languages_translations` VALUES("627", "sk", "ta", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("628", "sk", "th", "สลาวิก");
INSERT INTO `wp_icl_languages_translations` VALUES("629", "sk", "tr", "Slav dili");
INSERT INTO `wp_icl_languages_translations` VALUES("630", "sk", "uk", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("631", "sk", "ur", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("632", "sk", "uz", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("633", "sk", "vi", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("634", "sk", "yi", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("635", "sk", "zh-hans", "斯拉夫语");
INSERT INTO `wp_icl_languages_translations` VALUES("636", "sk", "zu", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("637", "sk", "zh-hant", "斯拉夫語");
INSERT INTO `wp_icl_languages_translations` VALUES("638", "sk", "ms", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("639", "sk", "gl", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("640", "sk", "bn", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("641", "cy", "en", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("642", "cy", "es", "Galés");
INSERT INTO `wp_icl_languages_translations` VALUES("643", "cy", "de", "Walisisch");
INSERT INTO `wp_icl_languages_translations` VALUES("644", "cy", "fr", "Gallois");
INSERT INTO `wp_icl_languages_translations` VALUES("645", "cy", "ar", "الولزية");
INSERT INTO `wp_icl_languages_translations` VALUES("646", "cy", "bs", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("647", "cy", "bg", "Уелски");
INSERT INTO `wp_icl_languages_translations` VALUES("648", "cy", "ca", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("649", "cy", "cs", "Velšský");
INSERT INTO `wp_icl_languages_translations` VALUES("650", "cy", "sk", "Welština");
INSERT INTO `wp_icl_languages_translations` VALUES("651", "cy", "cy", "Cymraeg");
INSERT INTO `wp_icl_languages_translations` VALUES("652", "cy", "da", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("653", "cy", "el", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("654", "cy", "eo", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("655", "cy", "et", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("656", "cy", "eu", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("657", "cy", "fa", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("658", "cy", "fi", "kymri");
INSERT INTO `wp_icl_languages_translations` VALUES("659", "cy", "ga", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("660", "cy", "he", "וולשית");
INSERT INTO `wp_icl_languages_translations` VALUES("661", "cy", "hi", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("662", "cy", "hr", "Velški");
INSERT INTO `wp_icl_languages_translations` VALUES("663", "cy", "hu", "vels");
INSERT INTO `wp_icl_languages_translations` VALUES("664", "cy", "hy", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("665", "cy", "id", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("666", "cy", "is", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("667", "cy", "it", "Gallese");
INSERT INTO `wp_icl_languages_translations` VALUES("668", "cy", "ja", "ウェールズ語");
INSERT INTO `wp_icl_languages_translations` VALUES("669", "cy", "ko", "웨일즈어");
INSERT INTO `wp_icl_languages_translations` VALUES("670", "cy", "ku", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("671", "cy", "lv", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("672", "cy", "lt", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("673", "cy", "mk", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("674", "cy", "mt", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("675", "cy", "mn", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("676", "cy", "ne", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("677", "cy", "nl", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("678", "cy", "no", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("679", "cy", "pa", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("680", "cy", "pl", "walijski");
INSERT INTO `wp_icl_languages_translations` VALUES("681", "cy", "pt-pt", "Galês");
INSERT INTO `wp_icl_languages_translations` VALUES("682", "cy", "pt-br", "Galês");
INSERT INTO `wp_icl_languages_translations` VALUES("683", "cy", "qu", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("684", "cy", "ro", "Galeză");
INSERT INTO `wp_icl_languages_translations` VALUES("685", "cy", "ru", "Валлийский");
INSERT INTO `wp_icl_languages_translations` VALUES("686", "cy", "sl", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("687", "cy", "so", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("688", "cy", "sq", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("689", "cy", "sr", "велшки");
INSERT INTO `wp_icl_languages_translations` VALUES("690", "cy", "sv", "Walesiska");
INSERT INTO `wp_icl_languages_translations` VALUES("691", "cy", "ta", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("692", "cy", "th", "เวลช์");
INSERT INTO `wp_icl_languages_translations` VALUES("693", "cy", "tr", "Galce");
INSERT INTO `wp_icl_languages_translations` VALUES("694", "cy", "uk", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("695", "cy", "ur", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("696", "cy", "uz", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("697", "cy", "vi", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("698", "cy", "yi", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("699", "cy", "zh-hans", "威尔士语");
INSERT INTO `wp_icl_languages_translations` VALUES("700", "cy", "zu", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("701", "cy", "zh-hant", "威爾士語");
INSERT INTO `wp_icl_languages_translations` VALUES("702", "cy", "ms", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("703", "cy", "gl", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("704", "cy", "bn", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("705", "da", "en", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("706", "da", "es", "Danés");
INSERT INTO `wp_icl_languages_translations` VALUES("707", "da", "de", "Dänisch");
INSERT INTO `wp_icl_languages_translations` VALUES("708", "da", "fr", "Danois");
INSERT INTO `wp_icl_languages_translations` VALUES("709", "da", "ar", "الدانماركية");
INSERT INTO `wp_icl_languages_translations` VALUES("710", "da", "bs", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("711", "da", "bg", "Датски");
INSERT INTO `wp_icl_languages_translations` VALUES("712", "da", "ca", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("713", "da", "cs", "Dánský");
INSERT INTO `wp_icl_languages_translations` VALUES("714", "da", "sk", "Dánčina");
INSERT INTO `wp_icl_languages_translations` VALUES("715", "da", "cy", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("716", "da", "da", "Dansk");
INSERT INTO `wp_icl_languages_translations` VALUES("717", "da", "el", "Δανεζικα");
INSERT INTO `wp_icl_languages_translations` VALUES("718", "da", "eo", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("719", "da", "et", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("720", "da", "eu", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("721", "da", "fa", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("722", "da", "fi", "tanska");
INSERT INTO `wp_icl_languages_translations` VALUES("723", "da", "ga", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("724", "da", "he", "דנית");
INSERT INTO `wp_icl_languages_translations` VALUES("725", "da", "hi", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("726", "da", "hr", "Danski");
INSERT INTO `wp_icl_languages_translations` VALUES("727", "da", "hu", "dán");
INSERT INTO `wp_icl_languages_translations` VALUES("728", "da", "hy", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("729", "da", "id", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("730", "da", "is", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("731", "da", "it", "Danese");
INSERT INTO `wp_icl_languages_translations` VALUES("732", "da", "ja", "デンマーク語");
INSERT INTO `wp_icl_languages_translations` VALUES("733", "da", "ko", "덴마크어");
INSERT INTO `wp_icl_languages_translations` VALUES("734", "da", "ku", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("735", "da", "lv", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("736", "da", "lt", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("737", "da", "mk", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("738", "da", "mt", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("739", "da", "mn", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("740", "da", "ne", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("741", "da", "nl", "Deens");
INSERT INTO `wp_icl_languages_translations` VALUES("742", "da", "no", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("743", "da", "pa", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("744", "da", "pl", "duński");
INSERT INTO `wp_icl_languages_translations` VALUES("745", "da", "pt-pt", "Dinamarquês");
INSERT INTO `wp_icl_languages_translations` VALUES("746", "da", "pt-br", "Dinamarquês");
INSERT INTO `wp_icl_languages_translations` VALUES("747", "da", "qu", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("748", "da", "ro", "Daneză");
INSERT INTO `wp_icl_languages_translations` VALUES("749", "da", "ru", "Датский");
INSERT INTO `wp_icl_languages_translations` VALUES("750", "da", "sl", "Danščina");
INSERT INTO `wp_icl_languages_translations` VALUES("751", "da", "so", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("752", "da", "sq", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("753", "da", "sr", "дански");
INSERT INTO `wp_icl_languages_translations` VALUES("754", "da", "sv", "Danska");
INSERT INTO `wp_icl_languages_translations` VALUES("755", "da", "ta", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("756", "da", "th", "เดนมาร์ก");
INSERT INTO `wp_icl_languages_translations` VALUES("757", "da", "tr", "Danca");
INSERT INTO `wp_icl_languages_translations` VALUES("758", "da", "uk", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("759", "da", "ur", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("760", "da", "uz", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("761", "da", "vi", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("762", "da", "yi", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("763", "da", "zh-hans", "丹麦语");
INSERT INTO `wp_icl_languages_translations` VALUES("764", "da", "zu", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("765", "da", "zh-hant", "丹麥語");
INSERT INTO `wp_icl_languages_translations` VALUES("766", "da", "ms", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("767", "da", "gl", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("768", "da", "bn", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("769", "el", "en", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("770", "el", "es", "Griego");
INSERT INTO `wp_icl_languages_translations` VALUES("771", "el", "de", "Griechisch");
INSERT INTO `wp_icl_languages_translations` VALUES("772", "el", "fr", "Grec moderne");
INSERT INTO `wp_icl_languages_translations` VALUES("773", "el", "ar", "اليونانية");
INSERT INTO `wp_icl_languages_translations` VALUES("774", "el", "bs", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("775", "el", "bg", "Гръцки");
INSERT INTO `wp_icl_languages_translations` VALUES("776", "el", "ca", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("777", "el", "cs", "Řečtina");
INSERT INTO `wp_icl_languages_translations` VALUES("778", "el", "sk", "Gréčtina");
INSERT INTO `wp_icl_languages_translations` VALUES("779", "el", "cy", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("780", "el", "da", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("781", "el", "el", "Ελληνικα");
INSERT INTO `wp_icl_languages_translations` VALUES("782", "el", "eo", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("783", "el", "et", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("784", "el", "eu", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("785", "el", "fa", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("786", "el", "fi", "kreikka");
INSERT INTO `wp_icl_languages_translations` VALUES("787", "el", "ga", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("788", "el", "he", "יוונית");
INSERT INTO `wp_icl_languages_translations` VALUES("789", "el", "hi", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("790", "el", "hr", "Grčki");
INSERT INTO `wp_icl_languages_translations` VALUES("791", "el", "hu", "görög");
INSERT INTO `wp_icl_languages_translations` VALUES("792", "el", "hy", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("793", "el", "id", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("794", "el", "is", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("795", "el", "it", "Greco");
INSERT INTO `wp_icl_languages_translations` VALUES("796", "el", "ja", "ギリシア語");
INSERT INTO `wp_icl_languages_translations` VALUES("797", "el", "ko", "그리스어");
INSERT INTO `wp_icl_languages_translations` VALUES("798", "el", "ku", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("799", "el", "lv", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("800", "el", "lt", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("801", "el", "mk", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("802", "el", "mt", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("803", "el", "mn", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("804", "el", "ne", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("805", "el", "nl", "Grieks");
INSERT INTO `wp_icl_languages_translations` VALUES("806", "el", "no", "Gresk");
INSERT INTO `wp_icl_languages_translations` VALUES("807", "el", "pa", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("808", "el", "pl", "grecki");
INSERT INTO `wp_icl_languages_translations` VALUES("809", "el", "pt-pt", "Grego");
INSERT INTO `wp_icl_languages_translations` VALUES("810", "el", "pt-br", "Grego");
INSERT INTO `wp_icl_languages_translations` VALUES("811", "el", "qu", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("812", "el", "ro", "Greacă");
INSERT INTO `wp_icl_languages_translations` VALUES("813", "el", "ru", "Греческий");
INSERT INTO `wp_icl_languages_translations` VALUES("814", "el", "sl", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("815", "el", "so", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("816", "el", "sq", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("817", "el", "sr", "грчки");
INSERT INTO `wp_icl_languages_translations` VALUES("818", "el", "sv", "Grekiska");
INSERT INTO `wp_icl_languages_translations` VALUES("819", "el", "ta", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("820", "el", "th", "กรีก");
INSERT INTO `wp_icl_languages_translations` VALUES("821", "el", "tr", "Yunanca");
INSERT INTO `wp_icl_languages_translations` VALUES("822", "el", "uk", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("823", "el", "ur", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("824", "el", "uz", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("825", "el", "vi", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("826", "el", "yi", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("827", "el", "zh-hans", "希腊语");
INSERT INTO `wp_icl_languages_translations` VALUES("828", "el", "zu", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("829", "el", "zh-hant", "希臘語");
INSERT INTO `wp_icl_languages_translations` VALUES("830", "el", "ms", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("831", "el", "gl", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("832", "el", "bn", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("833", "eo", "en", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("834", "eo", "es", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("835", "eo", "de", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("836", "eo", "fr", "Espéranto");
INSERT INTO `wp_icl_languages_translations` VALUES("837", "eo", "ar", "الاسبرانتو");
INSERT INTO `wp_icl_languages_translations` VALUES("838", "eo", "bs", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("839", "eo", "bg", "Есперанто");
INSERT INTO `wp_icl_languages_translations` VALUES("840", "eo", "ca", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("841", "eo", "cs", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("842", "eo", "sk", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("843", "eo", "cy", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("844", "eo", "da", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("845", "eo", "el", "Εσπεραντο");
INSERT INTO `wp_icl_languages_translations` VALUES("846", "eo", "eo", "Esperanta");
INSERT INTO `wp_icl_languages_translations` VALUES("847", "eo", "et", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("848", "eo", "eu", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("849", "eo", "fa", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("850", "eo", "fi", "esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("851", "eo", "ga", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("852", "eo", "he", "אספרנטו");
INSERT INTO `wp_icl_languages_translations` VALUES("853", "eo", "hi", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("854", "eo", "hr", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("855", "eo", "hu", "eszperantó");
INSERT INTO `wp_icl_languages_translations` VALUES("856", "eo", "hy", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("857", "eo", "id", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("858", "eo", "is", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("859", "eo", "it", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("860", "eo", "ja", "エスペラント語");
INSERT INTO `wp_icl_languages_translations` VALUES("861", "eo", "ko", "에스페란토어");
INSERT INTO `wp_icl_languages_translations` VALUES("862", "eo", "ku", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("863", "eo", "lv", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("864", "eo", "lt", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("865", "eo", "mk", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("866", "eo", "mt", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("867", "eo", "mn", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("868", "eo", "ne", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("869", "eo", "nl", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("870", "eo", "no", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("871", "eo", "pa", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("872", "eo", "pl", "esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("873", "eo", "pt-pt", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("874", "eo", "pt-br", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("875", "eo", "qu", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("876", "eo", "ro", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("877", "eo", "ru", "Эсперанто");
INSERT INTO `wp_icl_languages_translations` VALUES("878", "eo", "sl", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("879", "eo", "so", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("880", "eo", "sq", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("881", "eo", "sr", "есперанто");
INSERT INTO `wp_icl_languages_translations` VALUES("882", "eo", "sv", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("883", "eo", "ta", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("884", "eo", "th", "เอสเปอรันโต");
INSERT INTO `wp_icl_languages_translations` VALUES("885", "eo", "tr", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("886", "eo", "uk", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("887", "eo", "ur", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("888", "eo", "uz", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("889", "eo", "vi", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("890", "eo", "yi", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("891", "eo", "zh-hans", "世界语");
INSERT INTO `wp_icl_languages_translations` VALUES("892", "eo", "zu", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("893", "eo", "zh-hant", "世界語");
INSERT INTO `wp_icl_languages_translations` VALUES("894", "eo", "ms", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("895", "eo", "gl", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("896", "eo", "bn", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("897", "et", "en", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("898", "et", "es", "Estonio");
INSERT INTO `wp_icl_languages_translations` VALUES("899", "et", "de", "Estnisch");
INSERT INTO `wp_icl_languages_translations` VALUES("900", "et", "fr", "Estonien");
INSERT INTO `wp_icl_languages_translations` VALUES("901", "et", "ar", "الأستونية");
INSERT INTO `wp_icl_languages_translations` VALUES("902", "et", "bs", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("903", "et", "bg", "Естонски");
INSERT INTO `wp_icl_languages_translations` VALUES("904", "et", "ca", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("905", "et", "cs", "Estonština");
INSERT INTO `wp_icl_languages_translations` VALUES("906", "et", "sk", "Estónčina");
INSERT INTO `wp_icl_languages_translations` VALUES("907", "et", "cy", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("908", "et", "da", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("909", "et", "el", "Εσθονικα");
INSERT INTO `wp_icl_languages_translations` VALUES("910", "et", "eo", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("911", "et", "et", "Eesti");
INSERT INTO `wp_icl_languages_translations` VALUES("912", "et", "eu", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("913", "et", "fa", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("914", "et", "fi", "eesti");
INSERT INTO `wp_icl_languages_translations` VALUES("915", "et", "ga", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("916", "et", "he", "אסטונית");
INSERT INTO `wp_icl_languages_translations` VALUES("917", "et", "hi", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("918", "et", "hr", "Estonski");
INSERT INTO `wp_icl_languages_translations` VALUES("919", "et", "hu", "észt");
INSERT INTO `wp_icl_languages_translations` VALUES("920", "et", "hy", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("921", "et", "id", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("922", "et", "is", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("923", "et", "it", "Estone");
INSERT INTO `wp_icl_languages_translations` VALUES("924", "et", "ja", "エストニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("925", "et", "ko", "에스토니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("926", "et", "ku", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("927", "et", "lv", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("928", "et", "lt", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("929", "et", "mk", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("930", "et", "mt", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("931", "et", "mn", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("932", "et", "ne", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("933", "et", "nl", "Ests");
INSERT INTO `wp_icl_languages_translations` VALUES("934", "et", "no", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("935", "et", "pa", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("936", "et", "pl", "estoński");
INSERT INTO `wp_icl_languages_translations` VALUES("937", "et", "pt-pt", "Estoniano");
INSERT INTO `wp_icl_languages_translations` VALUES("938", "et", "pt-br", "Estoniano");
INSERT INTO `wp_icl_languages_translations` VALUES("939", "et", "qu", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("940", "et", "ro", "Estoniană");
INSERT INTO `wp_icl_languages_translations` VALUES("941", "et", "ru", "Эстонский");
INSERT INTO `wp_icl_languages_translations` VALUES("942", "et", "sl", "Estonščina");
INSERT INTO `wp_icl_languages_translations` VALUES("943", "et", "so", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("944", "et", "sq", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("945", "et", "sr", "естонски");
INSERT INTO `wp_icl_languages_translations` VALUES("946", "et", "sv", "Estniska");
INSERT INTO `wp_icl_languages_translations` VALUES("947", "et", "ta", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("948", "et", "th", "เอสโตเนียน");
INSERT INTO `wp_icl_languages_translations` VALUES("949", "et", "tr", "Estonya dili");
INSERT INTO `wp_icl_languages_translations` VALUES("950", "et", "uk", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("951", "et", "ur", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("952", "et", "uz", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("953", "et", "vi", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("954", "et", "yi", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("955", "et", "zh-hans", "爱沙尼亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("956", "et", "zu", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("957", "et", "zh-hant", "愛沙尼亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("958", "et", "ms", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("959", "et", "gl", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("960", "et", "bn", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("961", "eu", "en", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("962", "eu", "es", "Euskera");
INSERT INTO `wp_icl_languages_translations` VALUES("963", "eu", "de", "Baskisch");
INSERT INTO `wp_icl_languages_translations` VALUES("964", "eu", "fr", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("965", "eu", "ar", "لغة الباسك");
INSERT INTO `wp_icl_languages_translations` VALUES("966", "eu", "bs", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("967", "eu", "bg", "Баски");
INSERT INTO `wp_icl_languages_translations` VALUES("968", "eu", "ca", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("969", "eu", "cs", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("970", "eu", "sk", "Baskičtina");
INSERT INTO `wp_icl_languages_translations` VALUES("971", "eu", "cy", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("972", "eu", "da", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("973", "eu", "el", "Βασκικα");
INSERT INTO `wp_icl_languages_translations` VALUES("974", "eu", "eo", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("975", "eu", "et", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("976", "eu", "eu", "Euskara");
INSERT INTO `wp_icl_languages_translations` VALUES("977", "eu", "fa", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("978", "eu", "fi", "baski");
INSERT INTO `wp_icl_languages_translations` VALUES("979", "eu", "ga", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("980", "eu", "he", "בסקית");
INSERT INTO `wp_icl_languages_translations` VALUES("981", "eu", "hi", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("982", "eu", "hr", "Baskijski");
INSERT INTO `wp_icl_languages_translations` VALUES("983", "eu", "hu", "baszk");
INSERT INTO `wp_icl_languages_translations` VALUES("984", "eu", "hy", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("985", "eu", "id", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("986", "eu", "is", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("987", "eu", "it", "Basco");
INSERT INTO `wp_icl_languages_translations` VALUES("988", "eu", "ja", "バスク語");
INSERT INTO `wp_icl_languages_translations` VALUES("989", "eu", "ko", "바스크어");
INSERT INTO `wp_icl_languages_translations` VALUES("990", "eu", "ku", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("991", "eu", "lv", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("992", "eu", "lt", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("993", "eu", "mk", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("994", "eu", "mt", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("995", "eu", "mn", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("996", "eu", "ne", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("997", "eu", "nl", "Baskisch");
INSERT INTO `wp_icl_languages_translations` VALUES("998", "eu", "no", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("999", "eu", "pa", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1000", "eu", "pl", "baskijski");
INSERT INTO `wp_icl_languages_translations` VALUES("1001", "eu", "pt-pt", "Basco");
INSERT INTO `wp_icl_languages_translations` VALUES("1002", "eu", "pt-br", "Basco");
INSERT INTO `wp_icl_languages_translations` VALUES("1003", "eu", "qu", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1004", "eu", "ro", "Bască");
INSERT INTO `wp_icl_languages_translations` VALUES("1005", "eu", "ru", "Баскский");
INSERT INTO `wp_icl_languages_translations` VALUES("1006", "eu", "sl", "Baskovščina");
INSERT INTO `wp_icl_languages_translations` VALUES("1007", "eu", "so", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1008", "eu", "sq", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1009", "eu", "sr", "баскијски");
INSERT INTO `wp_icl_languages_translations` VALUES("1010", "eu", "sv", "Baskiska");
INSERT INTO `wp_icl_languages_translations` VALUES("1011", "eu", "ta", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1012", "eu", "th", "บาสค์");
INSERT INTO `wp_icl_languages_translations` VALUES("1013", "eu", "tr", "Bask dili");
INSERT INTO `wp_icl_languages_translations` VALUES("1014", "eu", "uk", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1015", "eu", "ur", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1016", "eu", "uz", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1017", "eu", "vi", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1018", "eu", "yi", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1019", "eu", "zh-hans", "巴斯克语");
INSERT INTO `wp_icl_languages_translations` VALUES("1020", "eu", "zu", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1021", "eu", "zh-hant", "巴斯克語");
INSERT INTO `wp_icl_languages_translations` VALUES("1022", "eu", "ms", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1023", "eu", "gl", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1024", "eu", "bn", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1025", "fa", "en", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1026", "fa", "es", "Persa");
INSERT INTO `wp_icl_languages_translations` VALUES("1027", "fa", "de", "Persisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1028", "fa", "fr", "Perse");
INSERT INTO `wp_icl_languages_translations` VALUES("1029", "fa", "ar", "الفارسية");
INSERT INTO `wp_icl_languages_translations` VALUES("1030", "fa", "bs", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1031", "fa", "bg", "Персийски");
INSERT INTO `wp_icl_languages_translations` VALUES("1032", "fa", "ca", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1033", "fa", "cs", "Perský");
INSERT INTO `wp_icl_languages_translations` VALUES("1034", "fa", "sk", "Perzština");
INSERT INTO `wp_icl_languages_translations` VALUES("1035", "fa", "cy", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1036", "fa", "da", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1037", "fa", "el", "Περσικος");
INSERT INTO `wp_icl_languages_translations` VALUES("1038", "fa", "eo", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1039", "fa", "et", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1040", "fa", "eu", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1041", "fa", "fa", "فارسی");
INSERT INTO `wp_icl_languages_translations` VALUES("1042", "fa", "fi", "persia");
INSERT INTO `wp_icl_languages_translations` VALUES("1043", "fa", "ga", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1044", "fa", "he", "פרסית");
INSERT INTO `wp_icl_languages_translations` VALUES("1045", "fa", "hi", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1046", "fa", "hr", "Perzijski");
INSERT INTO `wp_icl_languages_translations` VALUES("1047", "fa", "hu", "perzsa");
INSERT INTO `wp_icl_languages_translations` VALUES("1048", "fa", "hy", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1049", "fa", "id", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1050", "fa", "is", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1051", "fa", "it", "Persiano");
INSERT INTO `wp_icl_languages_translations` VALUES("1052", "fa", "ja", "ペルシア語");
INSERT INTO `wp_icl_languages_translations` VALUES("1053", "fa", "ko", "페르시아어");
INSERT INTO `wp_icl_languages_translations` VALUES("1054", "fa", "ku", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1055", "fa", "lv", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1056", "fa", "lt", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1057", "fa", "mk", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1058", "fa", "mt", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1059", "fa", "mn", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1060", "fa", "ne", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1061", "fa", "nl", "Perzisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1062", "fa", "no", "Persisk");
INSERT INTO `wp_icl_languages_translations` VALUES("1063", "fa", "pa", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1064", "fa", "pl", "perski");
INSERT INTO `wp_icl_languages_translations` VALUES("1065", "fa", "pt-pt", "Persa");
INSERT INTO `wp_icl_languages_translations` VALUES("1066", "fa", "pt-br", "Persa");
INSERT INTO `wp_icl_languages_translations` VALUES("1067", "fa", "qu", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1068", "fa", "ro", "Persană");
INSERT INTO `wp_icl_languages_translations` VALUES("1069", "fa", "ru", "Персидский");
INSERT INTO `wp_icl_languages_translations` VALUES("1070", "fa", "sl", "Perzijski");
INSERT INTO `wp_icl_languages_translations` VALUES("1071", "fa", "so", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1072", "fa", "sq", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1073", "fa", "sr", "персијски");
INSERT INTO `wp_icl_languages_translations` VALUES("1074", "fa", "sv", "Persiska");
INSERT INTO `wp_icl_languages_translations` VALUES("1075", "fa", "ta", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1076", "fa", "th", "เปอร์เซียน");
INSERT INTO `wp_icl_languages_translations` VALUES("1077", "fa", "tr", "Farsça");
INSERT INTO `wp_icl_languages_translations` VALUES("1078", "fa", "uk", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1079", "fa", "ur", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1080", "fa", "uz", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1081", "fa", "vi", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1082", "fa", "yi", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1083", "fa", "zh-hans", "波斯语");
INSERT INTO `wp_icl_languages_translations` VALUES("1084", "fa", "zu", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1085", "fa", "zh-hant", "波斯語");
INSERT INTO `wp_icl_languages_translations` VALUES("1086", "fa", "ms", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1087", "fa", "gl", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1088", "fa", "bn", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1089", "fi", "en", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1090", "fi", "es", "Finlandés");
INSERT INTO `wp_icl_languages_translations` VALUES("1091", "fi", "de", "Finnisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1092", "fi", "fr", "Finnois");
INSERT INTO `wp_icl_languages_translations` VALUES("1093", "fi", "ar", "الفنلندية");
INSERT INTO `wp_icl_languages_translations` VALUES("1094", "fi", "bs", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1095", "fi", "bg", "Фински");
INSERT INTO `wp_icl_languages_translations` VALUES("1096", "fi", "ca", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1097", "fi", "cs", "Finský");
INSERT INTO `wp_icl_languages_translations` VALUES("1098", "fi", "sk", "Fínština");
INSERT INTO `wp_icl_languages_translations` VALUES("1099", "fi", "cy", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1100", "fi", "da", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1101", "fi", "el", "Φινλανδικη");
INSERT INTO `wp_icl_languages_translations` VALUES("1102", "fi", "eo", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1103", "fi", "et", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1104", "fi", "eu", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1105", "fi", "fa", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1106", "fi", "fi", "Suomi");
INSERT INTO `wp_icl_languages_translations` VALUES("1107", "fi", "ga", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1108", "fi", "he", "פינית");
INSERT INTO `wp_icl_languages_translations` VALUES("1109", "fi", "hi", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1110", "fi", "hr", "Finski");
INSERT INTO `wp_icl_languages_translations` VALUES("1111", "fi", "hu", "finn");
INSERT INTO `wp_icl_languages_translations` VALUES("1112", "fi", "hy", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1113", "fi", "id", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1114", "fi", "is", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1115", "fi", "it", "Finlandese");
INSERT INTO `wp_icl_languages_translations` VALUES("1116", "fi", "ja", "フィンランド語");
INSERT INTO `wp_icl_languages_translations` VALUES("1117", "fi", "ko", "핀란드어");
INSERT INTO `wp_icl_languages_translations` VALUES("1118", "fi", "ku", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1119", "fi", "lv", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1120", "fi", "lt", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1121", "fi", "mk", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1122", "fi", "mt", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1123", "fi", "mn", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1124", "fi", "ne", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1125", "fi", "nl", "Fins");
INSERT INTO `wp_icl_languages_translations` VALUES("1126", "fi", "no", "Finsk");
INSERT INTO `wp_icl_languages_translations` VALUES("1127", "fi", "pa", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1128", "fi", "pl", "fiński");
INSERT INTO `wp_icl_languages_translations` VALUES("1129", "fi", "pt-pt", "Finlandês");
INSERT INTO `wp_icl_languages_translations` VALUES("1130", "fi", "pt-br", "Finlandês");
INSERT INTO `wp_icl_languages_translations` VALUES("1131", "fi", "qu", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1132", "fi", "ro", "Finlandeză");
INSERT INTO `wp_icl_languages_translations` VALUES("1133", "fi", "ru", "Финский");
INSERT INTO `wp_icl_languages_translations` VALUES("1134", "fi", "sl", "Finski");
INSERT INTO `wp_icl_languages_translations` VALUES("1135", "fi", "so", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1136", "fi", "sq", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1137", "fi", "sr", "фински");
INSERT INTO `wp_icl_languages_translations` VALUES("1138", "fi", "sv", "Finska");
INSERT INTO `wp_icl_languages_translations` VALUES("1139", "fi", "ta", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1140", "fi", "th", "ฟินนิช");
INSERT INTO `wp_icl_languages_translations` VALUES("1141", "fi", "tr", "Fince");
INSERT INTO `wp_icl_languages_translations` VALUES("1142", "fi", "uk", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1143", "fi", "ur", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1144", "fi", "uz", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1145", "fi", "vi", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1146", "fi", "yi", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1147", "fi", "zh-hans", "芬兰语");
INSERT INTO `wp_icl_languages_translations` VALUES("1148", "fi", "zu", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1149", "fi", "zh-hant", "芬蘭語");
INSERT INTO `wp_icl_languages_translations` VALUES("1150", "fi", "ms", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1151", "fi", "gl", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1152", "fi", "bn", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1153", "ga", "en", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1154", "ga", "es", "Irlandés");
INSERT INTO `wp_icl_languages_translations` VALUES("1155", "ga", "de", "Irisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1156", "ga", "fr", "Irlandais");
INSERT INTO `wp_icl_languages_translations` VALUES("1157", "ga", "ar", "الأيرلندية");
INSERT INTO `wp_icl_languages_translations` VALUES("1158", "ga", "bs", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1159", "ga", "bg", "Ирландски");
INSERT INTO `wp_icl_languages_translations` VALUES("1160", "ga", "ca", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1161", "ga", "cs", "Irský");
INSERT INTO `wp_icl_languages_translations` VALUES("1162", "ga", "sk", "Írština");
INSERT INTO `wp_icl_languages_translations` VALUES("1163", "ga", "cy", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1164", "ga", "da", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1165", "ga", "el", "Ιρλανδικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1166", "ga", "eo", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1167", "ga", "et", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1168", "ga", "eu", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1169", "ga", "fa", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1170", "ga", "fi", "iiri");
INSERT INTO `wp_icl_languages_translations` VALUES("1171", "ga", "ga", "Gaeilge");
INSERT INTO `wp_icl_languages_translations` VALUES("1172", "ga", "he", "אירית");
INSERT INTO `wp_icl_languages_translations` VALUES("1173", "ga", "hi", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1174", "ga", "hr", "Irci");
INSERT INTO `wp_icl_languages_translations` VALUES("1175", "ga", "hu", "ír");
INSERT INTO `wp_icl_languages_translations` VALUES("1176", "ga", "hy", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1177", "ga", "id", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1178", "ga", "is", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1179", "ga", "it", "Irlandese");
INSERT INTO `wp_icl_languages_translations` VALUES("1180", "ga", "ja", "アイルランド語");
INSERT INTO `wp_icl_languages_translations` VALUES("1181", "ga", "ko", "아일랜드어");
INSERT INTO `wp_icl_languages_translations` VALUES("1182", "ga", "ku", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1183", "ga", "lv", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1184", "ga", "lt", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1185", "ga", "mk", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1186", "ga", "mt", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1187", "ga", "mn", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1188", "ga", "ne", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1189", "ga", "nl", "Iers");
INSERT INTO `wp_icl_languages_translations` VALUES("1190", "ga", "no", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1191", "ga", "pa", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1192", "ga", "pl", "irlandzki");
INSERT INTO `wp_icl_languages_translations` VALUES("1193", "ga", "pt-pt", "Irlandês");
INSERT INTO `wp_icl_languages_translations` VALUES("1194", "ga", "pt-br", "Irlandês");
INSERT INTO `wp_icl_languages_translations` VALUES("1195", "ga", "qu", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1196", "ga", "ro", "Irlandeză");
INSERT INTO `wp_icl_languages_translations` VALUES("1197", "ga", "ru", "Ирландский");
INSERT INTO `wp_icl_languages_translations` VALUES("1198", "ga", "sl", "Irski");
INSERT INTO `wp_icl_languages_translations` VALUES("1199", "ga", "so", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1200", "ga", "sq", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1201", "ga", "sr", "ирски");
INSERT INTO `wp_icl_languages_translations` VALUES("1202", "ga", "sv", "Irländska");
INSERT INTO `wp_icl_languages_translations` VALUES("1203", "ga", "ta", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1204", "ga", "th", "ไอริช");
INSERT INTO `wp_icl_languages_translations` VALUES("1205", "ga", "tr", "İrlanda dili");
INSERT INTO `wp_icl_languages_translations` VALUES("1206", "ga", "uk", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1207", "ga", "ur", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1208", "ga", "uz", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1209", "ga", "vi", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1210", "ga", "yi", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1211", "ga", "zh-hans", "爱尔兰语");
INSERT INTO `wp_icl_languages_translations` VALUES("1212", "ga", "zu", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1213", "ga", "zh-hant", "愛爾蘭語");
INSERT INTO `wp_icl_languages_translations` VALUES("1214", "ga", "ms", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1215", "ga", "gl", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1216", "ga", "bn", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1217", "he", "en", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1218", "he", "es", "Hebreo");
INSERT INTO `wp_icl_languages_translations` VALUES("1219", "he", "de", "Hebräisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1220", "he", "fr", "Hébreu");
INSERT INTO `wp_icl_languages_translations` VALUES("1221", "he", "ar", "العبرية");
INSERT INTO `wp_icl_languages_translations` VALUES("1222", "he", "bs", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1223", "he", "bg", "Иврит");
INSERT INTO `wp_icl_languages_translations` VALUES("1224", "he", "ca", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1225", "he", "cs", "Hebrejština");
INSERT INTO `wp_icl_languages_translations` VALUES("1226", "he", "sk", "Hebrejčina");
INSERT INTO `wp_icl_languages_translations` VALUES("1227", "he", "cy", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1228", "he", "da", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1229", "he", "el", "Εβραικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1230", "he", "eo", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1231", "he", "et", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1232", "he", "eu", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1233", "he", "fa", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1234", "he", "fi", "heprea");
INSERT INTO `wp_icl_languages_translations` VALUES("1235", "he", "ga", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1236", "he", "he", "עברית");
INSERT INTO `wp_icl_languages_translations` VALUES("1237", "he", "hi", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1238", "he", "hr", "Hebrejski");
INSERT INTO `wp_icl_languages_translations` VALUES("1239", "he", "hu", "héber");
INSERT INTO `wp_icl_languages_translations` VALUES("1240", "he", "hy", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1241", "he", "id", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1242", "he", "is", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1243", "he", "it", "Ebraico");
INSERT INTO `wp_icl_languages_translations` VALUES("1244", "he", "ja", "ヘブライ語");
INSERT INTO `wp_icl_languages_translations` VALUES("1245", "he", "ko", "히브리어");
INSERT INTO `wp_icl_languages_translations` VALUES("1246", "he", "ku", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1247", "he", "lv", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1248", "he", "lt", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1249", "he", "mk", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1250", "he", "mt", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1251", "he", "mn", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1252", "he", "ne", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1253", "he", "nl", "Hebreeuws");
INSERT INTO `wp_icl_languages_translations` VALUES("1254", "he", "no", "Hebraisk");
INSERT INTO `wp_icl_languages_translations` VALUES("1255", "he", "pa", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1256", "he", "pl", "hebrajski");
INSERT INTO `wp_icl_languages_translations` VALUES("1257", "he", "pt-pt", "Hebraico");
INSERT INTO `wp_icl_languages_translations` VALUES("1258", "he", "pt-br", "Hebraico");
INSERT INTO `wp_icl_languages_translations` VALUES("1259", "he", "qu", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1260", "he", "ro", "Ebraică");
INSERT INTO `wp_icl_languages_translations` VALUES("1261", "he", "ru", "Иврит");
INSERT INTO `wp_icl_languages_translations` VALUES("1262", "he", "sl", "Hebrejščina");
INSERT INTO `wp_icl_languages_translations` VALUES("1263", "he", "so", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1264", "he", "sq", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1265", "he", "sr", "Хебрејски");
INSERT INTO `wp_icl_languages_translations` VALUES("1266", "he", "sv", "Hebreiska");
INSERT INTO `wp_icl_languages_translations` VALUES("1267", "he", "ta", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1268", "he", "th", "ฮิบรู");
INSERT INTO `wp_icl_languages_translations` VALUES("1269", "he", "tr", "İbranice");
INSERT INTO `wp_icl_languages_translations` VALUES("1270", "he", "uk", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1271", "he", "ur", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1272", "he", "uz", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1273", "he", "vi", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1274", "he", "yi", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1275", "he", "zh-hans", "希伯来语");
INSERT INTO `wp_icl_languages_translations` VALUES("1276", "he", "zu", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1277", "he", "zh-hant", "希伯來語");
INSERT INTO `wp_icl_languages_translations` VALUES("1278", "he", "ms", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1279", "he", "gl", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1280", "he", "bn", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1281", "hi", "en", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1282", "hi", "es", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1283", "hi", "de", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1284", "hi", "fr", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1285", "hi", "ar", "الهندية");
INSERT INTO `wp_icl_languages_translations` VALUES("1286", "hi", "bs", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1287", "hi", "bg", "Хинди");
INSERT INTO `wp_icl_languages_translations` VALUES("1288", "hi", "ca", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1289", "hi", "cs", "Hindština");
INSERT INTO `wp_icl_languages_translations` VALUES("1290", "hi", "sk", "Hindčina");
INSERT INTO `wp_icl_languages_translations` VALUES("1291", "hi", "cy", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1292", "hi", "da", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1293", "hi", "el", "Ινδικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1294", "hi", "eo", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1295", "hi", "et", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1296", "hi", "eu", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1297", "hi", "fa", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1298", "hi", "fi", "hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1299", "hi", "ga", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1300", "hi", "he", "הודית");
INSERT INTO `wp_icl_languages_translations` VALUES("1301", "hi", "hi", "हिन्दी");
INSERT INTO `wp_icl_languages_translations` VALUES("1302", "hi", "hr", "Hindski");
INSERT INTO `wp_icl_languages_translations` VALUES("1303", "hi", "hu", "hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1304", "hi", "hy", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1305", "hi", "id", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1306", "hi", "is", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1307", "hi", "it", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1308", "hi", "ja", "ヒンディー語");
INSERT INTO `wp_icl_languages_translations` VALUES("1309", "hi", "ko", "힌두어");
INSERT INTO `wp_icl_languages_translations` VALUES("1310", "hi", "ku", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1311", "hi", "lv", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1312", "hi", "lt", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1313", "hi", "mk", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1314", "hi", "mt", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1315", "hi", "mn", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1316", "hi", "ne", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1317", "hi", "nl", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1318", "hi", "no", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1319", "hi", "pa", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1320", "hi", "pl", "hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1321", "hi", "pt-pt", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1322", "hi", "pt-br", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1323", "hi", "qu", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1324", "hi", "ro", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1325", "hi", "ru", "Хинди");
INSERT INTO `wp_icl_languages_translations` VALUES("1326", "hi", "sl", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1327", "hi", "so", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1328", "hi", "sq", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1329", "hi", "sr", "хинди");
INSERT INTO `wp_icl_languages_translations` VALUES("1330", "hi", "sv", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1331", "hi", "ta", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1332", "hi", "th", "ฮินดิ");
INSERT INTO `wp_icl_languages_translations` VALUES("1333", "hi", "tr", "Hintçe");
INSERT INTO `wp_icl_languages_translations` VALUES("1334", "hi", "uk", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1335", "hi", "ur", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1336", "hi", "uz", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1337", "hi", "vi", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1338", "hi", "yi", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1339", "hi", "zh-hans", "印地语");
INSERT INTO `wp_icl_languages_translations` VALUES("1340", "hi", "zu", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1341", "hi", "zh-hant", "印地語");
INSERT INTO `wp_icl_languages_translations` VALUES("1342", "hi", "ms", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1343", "hi", "gl", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1344", "hi", "bn", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1345", "hr", "en", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1346", "hr", "es", "Croata");
INSERT INTO `wp_icl_languages_translations` VALUES("1347", "hr", "de", "Kroatisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1348", "hr", "fr", "Croate");
INSERT INTO `wp_icl_languages_translations` VALUES("1349", "hr", "ar", "الكرواتية");
INSERT INTO `wp_icl_languages_translations` VALUES("1350", "hr", "bs", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1351", "hr", "bg", "Хърватски");
INSERT INTO `wp_icl_languages_translations` VALUES("1352", "hr", "ca", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1353", "hr", "cs", "Chorvatský");
INSERT INTO `wp_icl_languages_translations` VALUES("1354", "hr", "sk", "Chorvátština");
INSERT INTO `wp_icl_languages_translations` VALUES("1355", "hr", "cy", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1356", "hr", "da", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1357", "hr", "el", "Κροατικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1358", "hr", "eo", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1359", "hr", "et", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1360", "hr", "eu", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1361", "hr", "fa", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1362", "hr", "fi", "kroatia");
INSERT INTO `wp_icl_languages_translations` VALUES("1363", "hr", "ga", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1364", "hr", "he", "קרוטאית");
INSERT INTO `wp_icl_languages_translations` VALUES("1365", "hr", "hi", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1366", "hr", "hr", "Hrvatski");
INSERT INTO `wp_icl_languages_translations` VALUES("1367", "hr", "hu", "horvát");
INSERT INTO `wp_icl_languages_translations` VALUES("1368", "hr", "hy", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1369", "hr", "id", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1370", "hr", "is", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1371", "hr", "it", "Croato");
INSERT INTO `wp_icl_languages_translations` VALUES("1372", "hr", "ja", "クロアチア語");
INSERT INTO `wp_icl_languages_translations` VALUES("1373", "hr", "ko", "크로아시아어");
INSERT INTO `wp_icl_languages_translations` VALUES("1374", "hr", "ku", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1375", "hr", "lv", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1376", "hr", "lt", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1377", "hr", "mk", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1378", "hr", "mt", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1379", "hr", "mn", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1380", "hr", "ne", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1381", "hr", "nl", "Kroatisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1382", "hr", "no", "Kroatisk");
INSERT INTO `wp_icl_languages_translations` VALUES("1383", "hr", "pa", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1384", "hr", "pl", "chorwacki");
INSERT INTO `wp_icl_languages_translations` VALUES("1385", "hr", "pt-pt", "Croata");
INSERT INTO `wp_icl_languages_translations` VALUES("1386", "hr", "pt-br", "Croata");
INSERT INTO `wp_icl_languages_translations` VALUES("1387", "hr", "qu", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1388", "hr", "ro", "Croată");
INSERT INTO `wp_icl_languages_translations` VALUES("1389", "hr", "ru", "Хорватский");
INSERT INTO `wp_icl_languages_translations` VALUES("1390", "hr", "sl", "Hrvaški");
INSERT INTO `wp_icl_languages_translations` VALUES("1391", "hr", "so", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1392", "hr", "sq", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1393", "hr", "sr", "хрватски");
INSERT INTO `wp_icl_languages_translations` VALUES("1394", "hr", "sv", "Kroatiska");
INSERT INTO `wp_icl_languages_translations` VALUES("1395", "hr", "ta", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1396", "hr", "th", "โครเอเชีย");
INSERT INTO `wp_icl_languages_translations` VALUES("1397", "hr", "tr", "Hırvatça");
INSERT INTO `wp_icl_languages_translations` VALUES("1398", "hr", "uk", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1399", "hr", "ur", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1400", "hr", "uz", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1401", "hr", "vi", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1402", "hr", "yi", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1403", "hr", "zh-hans", "克罗地亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("1404", "hr", "zu", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1405", "hr", "zh-hant", "克羅地亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("1406", "hr", "ms", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1407", "hr", "gl", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1408", "hr", "bn", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1409", "hu", "en", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1410", "hu", "es", "Húngaro");
INSERT INTO `wp_icl_languages_translations` VALUES("1411", "hu", "de", "Ungarisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1412", "hu", "fr", "Hongrois");
INSERT INTO `wp_icl_languages_translations` VALUES("1413", "hu", "ar", "الهنغارية");
INSERT INTO `wp_icl_languages_translations` VALUES("1414", "hu", "bs", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1415", "hu", "bg", "Унгарски");
INSERT INTO `wp_icl_languages_translations` VALUES("1416", "hu", "ca", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1417", "hu", "cs", "Maďarština");
INSERT INTO `wp_icl_languages_translations` VALUES("1418", "hu", "sk", "Maďarčina");
INSERT INTO `wp_icl_languages_translations` VALUES("1419", "hu", "cy", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1420", "hu", "da", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1421", "hu", "el", "Ουγγρικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1422", "hu", "eo", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1423", "hu", "et", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1424", "hu", "eu", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1425", "hu", "fa", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1426", "hu", "fi", "unkari");
INSERT INTO `wp_icl_languages_translations` VALUES("1427", "hu", "ga", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1428", "hu", "he", "הונגרית");
INSERT INTO `wp_icl_languages_translations` VALUES("1429", "hu", "hi", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1430", "hu", "hr", "Mađarski");
INSERT INTO `wp_icl_languages_translations` VALUES("1431", "hu", "hu", "Magyar");
INSERT INTO `wp_icl_languages_translations` VALUES("1432", "hu", "hy", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1433", "hu", "id", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1434", "hu", "is", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1435", "hu", "it", "Ungherese");
INSERT INTO `wp_icl_languages_translations` VALUES("1436", "hu", "ja", "ハンガリー語");
INSERT INTO `wp_icl_languages_translations` VALUES("1437", "hu", "ko", "헝가리어");
INSERT INTO `wp_icl_languages_translations` VALUES("1438", "hu", "ku", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1439", "hu", "lv", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1440", "hu", "lt", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1441", "hu", "mk", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1442", "hu", "mt", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1443", "hu", "mn", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1444", "hu", "ne", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1445", "hu", "nl", "Hongaars");
INSERT INTO `wp_icl_languages_translations` VALUES("1446", "hu", "no", "Ungarsk");
INSERT INTO `wp_icl_languages_translations` VALUES("1447", "hu", "pa", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1448", "hu", "pl", "węgierski");
INSERT INTO `wp_icl_languages_translations` VALUES("1449", "hu", "pt-pt", "Húngaro");
INSERT INTO `wp_icl_languages_translations` VALUES("1450", "hu", "pt-br", "Húngaro");
INSERT INTO `wp_icl_languages_translations` VALUES("1451", "hu", "qu", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1452", "hu", "ro", "Ungară");
INSERT INTO `wp_icl_languages_translations` VALUES("1453", "hu", "ru", "Венгерский");
INSERT INTO `wp_icl_languages_translations` VALUES("1454", "hu", "sl", "Madžarski");
INSERT INTO `wp_icl_languages_translations` VALUES("1455", "hu", "so", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1456", "hu", "sq", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1457", "hu", "sr", "мађарски");
INSERT INTO `wp_icl_languages_translations` VALUES("1458", "hu", "sv", "Ungerska");
INSERT INTO `wp_icl_languages_translations` VALUES("1459", "hu", "ta", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1460", "hu", "th", "ฮังการี");
INSERT INTO `wp_icl_languages_translations` VALUES("1461", "hu", "tr", "Macarca");
INSERT INTO `wp_icl_languages_translations` VALUES("1462", "hu", "uk", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1463", "hu", "ur", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1464", "hu", "uz", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1465", "hu", "vi", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1466", "hu", "yi", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1467", "hu", "zh-hans", "匈牙利语");
INSERT INTO `wp_icl_languages_translations` VALUES("1468", "hu", "zu", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1469", "hu", "zh-hant", "匈牙利語");
INSERT INTO `wp_icl_languages_translations` VALUES("1470", "hu", "ms", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1471", "hu", "gl", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1472", "hu", "bn", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1473", "hy", "en", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1474", "hy", "es", "Armenio");
INSERT INTO `wp_icl_languages_translations` VALUES("1475", "hy", "de", "Armenisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1476", "hy", "fr", "Arménien");
INSERT INTO `wp_icl_languages_translations` VALUES("1477", "hy", "ar", "الأرمينية");
INSERT INTO `wp_icl_languages_translations` VALUES("1478", "hy", "bs", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1479", "hy", "bg", "Арменски");
INSERT INTO `wp_icl_languages_translations` VALUES("1480", "hy", "ca", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1481", "hy", "cs", "Arménský");
INSERT INTO `wp_icl_languages_translations` VALUES("1482", "hy", "sk", "Arménčina");
INSERT INTO `wp_icl_languages_translations` VALUES("1483", "hy", "cy", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1484", "hy", "da", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1485", "hy", "el", "Αρμενικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1486", "hy", "eo", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1487", "hy", "et", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1488", "hy", "eu", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1489", "hy", "fa", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1490", "hy", "fi", "armenia");
INSERT INTO `wp_icl_languages_translations` VALUES("1491", "hy", "ga", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1492", "hy", "he", "ארמנית");
INSERT INTO `wp_icl_languages_translations` VALUES("1493", "hy", "hi", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1494", "hy", "hr", "Armenac");
INSERT INTO `wp_icl_languages_translations` VALUES("1495", "hy", "hu", "örmény");
INSERT INTO `wp_icl_languages_translations` VALUES("1496", "hy", "hy", "Հայերեն");
INSERT INTO `wp_icl_languages_translations` VALUES("1497", "hy", "id", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1498", "hy", "is", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1499", "hy", "it", "Armeno");
INSERT INTO `wp_icl_languages_translations` VALUES("1500", "hy", "ja", "アルメニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("1501", "hy", "ko", "아르메니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("1502", "hy", "ku", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1503", "hy", "lv", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1504", "hy", "lt", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1505", "hy", "mk", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1506", "hy", "mt", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1507", "hy", "mn", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1508", "hy", "ne", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1509", "hy", "nl", "Armeens");
INSERT INTO `wp_icl_languages_translations` VALUES("1510", "hy", "no", "Armensk");
INSERT INTO `wp_icl_languages_translations` VALUES("1511", "hy", "pa", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1512", "hy", "pl", "ormiański");
INSERT INTO `wp_icl_languages_translations` VALUES("1513", "hy", "pt-pt", "Arménio");
INSERT INTO `wp_icl_languages_translations` VALUES("1514", "hy", "pt-br", "Arménio");
INSERT INTO `wp_icl_languages_translations` VALUES("1515", "hy", "qu", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1516", "hy", "ro", "Armeană");
INSERT INTO `wp_icl_languages_translations` VALUES("1517", "hy", "ru", "Армянский");
INSERT INTO `wp_icl_languages_translations` VALUES("1518", "hy", "sl", "Armenski");
INSERT INTO `wp_icl_languages_translations` VALUES("1519", "hy", "so", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1520", "hy", "sq", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1521", "hy", "sr", "јерменски");
INSERT INTO `wp_icl_languages_translations` VALUES("1522", "hy", "sv", "Armeniska");
INSERT INTO `wp_icl_languages_translations` VALUES("1523", "hy", "ta", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1524", "hy", "th", "อาร์เมเนีย");
INSERT INTO `wp_icl_languages_translations` VALUES("1525", "hy", "tr", "Ermenice");
INSERT INTO `wp_icl_languages_translations` VALUES("1526", "hy", "uk", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1527", "hy", "ur", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1528", "hy", "uz", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1529", "hy", "vi", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1530", "hy", "yi", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1531", "hy", "zh-hans", "亚美尼亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("1532", "hy", "zu", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1533", "hy", "zh-hant", "亞美尼亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("1534", "hy", "ms", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1535", "hy", "gl", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1536", "hy", "bn", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1537", "id", "en", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1538", "id", "es", "Indonesio");
INSERT INTO `wp_icl_languages_translations` VALUES("1539", "id", "de", "Indonesisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1540", "id", "fr", "Indonésien");
INSERT INTO `wp_icl_languages_translations` VALUES("1541", "id", "ar", "الأندونيسية");
INSERT INTO `wp_icl_languages_translations` VALUES("1542", "id", "bs", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1543", "id", "bg", "Индонезийски");
INSERT INTO `wp_icl_languages_translations` VALUES("1544", "id", "ca", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1545", "id", "cs", "Indonéský");
INSERT INTO `wp_icl_languages_translations` VALUES("1546", "id", "sk", "Indonézčina");
INSERT INTO `wp_icl_languages_translations` VALUES("1547", "id", "cy", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1548", "id", "da", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1549", "id", "el", "Ινδονησιακα");
INSERT INTO `wp_icl_languages_translations` VALUES("1550", "id", "eo", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1551", "id", "et", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1552", "id", "eu", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1553", "id", "fa", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1554", "id", "fi", "indonesia");
INSERT INTO `wp_icl_languages_translations` VALUES("1555", "id", "ga", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1556", "id", "he", "אינדונזית");
INSERT INTO `wp_icl_languages_translations` VALUES("1557", "id", "hi", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1558", "id", "hr", "Indonezijski");
INSERT INTO `wp_icl_languages_translations` VALUES("1559", "id", "hu", "indonéz");
INSERT INTO `wp_icl_languages_translations` VALUES("1560", "id", "hy", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1561", "id", "id", "Indonesia");
INSERT INTO `wp_icl_languages_translations` VALUES("1562", "id", "is", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1563", "id", "it", "Indonesiano");
INSERT INTO `wp_icl_languages_translations` VALUES("1564", "id", "ja", "インドネシア語");
INSERT INTO `wp_icl_languages_translations` VALUES("1565", "id", "ko", "인도네시아어");
INSERT INTO `wp_icl_languages_translations` VALUES("1566", "id", "ku", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1567", "id", "lv", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1568", "id", "lt", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1569", "id", "mk", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1570", "id", "mt", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1571", "id", "mn", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1572", "id", "ne", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1573", "id", "nl", "Indonesisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1574", "id", "no", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1575", "id", "pa", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1576", "id", "pl", "indonezyjski");
INSERT INTO `wp_icl_languages_translations` VALUES("1577", "id", "pt-pt", "Indonésio");
INSERT INTO `wp_icl_languages_translations` VALUES("1578", "id", "pt-br", "Indonésio");
INSERT INTO `wp_icl_languages_translations` VALUES("1579", "id", "qu", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1580", "id", "ro", "Indoneziană");
INSERT INTO `wp_icl_languages_translations` VALUES("1581", "id", "ru", "Индонезийский");
INSERT INTO `wp_icl_languages_translations` VALUES("1582", "id", "sl", "Indonezijski");
INSERT INTO `wp_icl_languages_translations` VALUES("1583", "id", "so", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1584", "id", "sq", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1585", "id", "sr", "индонезијски");
INSERT INTO `wp_icl_languages_translations` VALUES("1586", "id", "sv", "Indonesiska");
INSERT INTO `wp_icl_languages_translations` VALUES("1587", "id", "ta", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1588", "id", "th", "อินโดนีเซีย");
INSERT INTO `wp_icl_languages_translations` VALUES("1589", "id", "tr", "Endonezya dili");
INSERT INTO `wp_icl_languages_translations` VALUES("1590", "id", "uk", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1591", "id", "ur", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1592", "id", "uz", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1593", "id", "vi", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1594", "id", "yi", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1595", "id", "zh-hans", "印度尼西亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("1596", "id", "zu", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1597", "id", "zh-hant", "印尼語");
INSERT INTO `wp_icl_languages_translations` VALUES("1598", "id", "ms", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1599", "id", "gl", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1600", "id", "bn", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1601", "is", "en", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1602", "is", "es", "Islandés");
INSERT INTO `wp_icl_languages_translations` VALUES("1603", "is", "de", "Isländisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1604", "is", "fr", "Islandais");
INSERT INTO `wp_icl_languages_translations` VALUES("1605", "is", "ar", "الأيسلاندية");
INSERT INTO `wp_icl_languages_translations` VALUES("1606", "is", "bs", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1607", "is", "bg", "Исландски");
INSERT INTO `wp_icl_languages_translations` VALUES("1608", "is", "ca", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1609", "is", "cs", "Islandský");
INSERT INTO `wp_icl_languages_translations` VALUES("1610", "is", "sk", "Islančina");
INSERT INTO `wp_icl_languages_translations` VALUES("1611", "is", "cy", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1612", "is", "da", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1613", "is", "el", "Ισλανδικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1614", "is", "eo", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1615", "is", "et", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1616", "is", "eu", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1617", "is", "fa", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1618", "is", "fi", "islanti");
INSERT INTO `wp_icl_languages_translations` VALUES("1619", "is", "ga", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1620", "is", "he", "איסלנדית");
INSERT INTO `wp_icl_languages_translations` VALUES("1621", "is", "hi", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1622", "is", "hr", "Islandski");
INSERT INTO `wp_icl_languages_translations` VALUES("1623", "is", "hu", "izlandi");
INSERT INTO `wp_icl_languages_translations` VALUES("1624", "is", "hy", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1625", "is", "id", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1626", "is", "is", "Íslenska");
INSERT INTO `wp_icl_languages_translations` VALUES("1627", "is", "it", "Islandese");
INSERT INTO `wp_icl_languages_translations` VALUES("1628", "is", "ja", "アイスランド語");
INSERT INTO `wp_icl_languages_translations` VALUES("1629", "is", "ko", "아이슬랜드어");
INSERT INTO `wp_icl_languages_translations` VALUES("1630", "is", "ku", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1631", "is", "lv", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1632", "is", "lt", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1633", "is", "mk", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1634", "is", "mt", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1635", "is", "mn", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1636", "is", "ne", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1637", "is", "nl", "Ijslands");
INSERT INTO `wp_icl_languages_translations` VALUES("1638", "is", "no", "Islandsk");
INSERT INTO `wp_icl_languages_translations` VALUES("1639", "is", "pa", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1640", "is", "pl", "islandzki");
INSERT INTO `wp_icl_languages_translations` VALUES("1641", "is", "pt-pt", "Islandês");
INSERT INTO `wp_icl_languages_translations` VALUES("1642", "is", "pt-br", "Islandês");
INSERT INTO `wp_icl_languages_translations` VALUES("1643", "is", "qu", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1644", "is", "ro", "Islandeză");
INSERT INTO `wp_icl_languages_translations` VALUES("1645", "is", "ru", "Исландский");
INSERT INTO `wp_icl_languages_translations` VALUES("1646", "is", "sl", "Islandski");
INSERT INTO `wp_icl_languages_translations` VALUES("1647", "is", "so", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1648", "is", "sq", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1649", "is", "sr", "исландски");
INSERT INTO `wp_icl_languages_translations` VALUES("1650", "is", "sv", "Isländska");
INSERT INTO `wp_icl_languages_translations` VALUES("1651", "is", "ta", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1652", "is", "th", "ไอซ์แลนด์");
INSERT INTO `wp_icl_languages_translations` VALUES("1653", "is", "tr", "İzlandaca");
INSERT INTO `wp_icl_languages_translations` VALUES("1654", "is", "uk", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1655", "is", "ur", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1656", "is", "uz", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1657", "is", "vi", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1658", "is", "yi", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1659", "is", "zh-hans", "冰岛语");
INSERT INTO `wp_icl_languages_translations` VALUES("1660", "is", "zu", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1661", "is", "zh-hant", "冰島語");
INSERT INTO `wp_icl_languages_translations` VALUES("1662", "is", "ms", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1663", "is", "gl", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1664", "is", "bn", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1665", "it", "en", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1666", "it", "es", "Italiano");
INSERT INTO `wp_icl_languages_translations` VALUES("1667", "it", "de", "Italienisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1668", "it", "fr", "Italien");
INSERT INTO `wp_icl_languages_translations` VALUES("1669", "it", "ar", "الإيطالية");
INSERT INTO `wp_icl_languages_translations` VALUES("1670", "it", "bs", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1671", "it", "bg", "Италиански");
INSERT INTO `wp_icl_languages_translations` VALUES("1672", "it", "ca", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1673", "it", "cs", "Ital");
INSERT INTO `wp_icl_languages_translations` VALUES("1674", "it", "sk", "Taliančina");
INSERT INTO `wp_icl_languages_translations` VALUES("1675", "it", "cy", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1676", "it", "da", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1677", "it", "el", "Ιταλικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1678", "it", "eo", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1679", "it", "et", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1680", "it", "eu", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1681", "it", "fa", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1682", "it", "fi", "italia");
INSERT INTO `wp_icl_languages_translations` VALUES("1683", "it", "ga", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1684", "it", "he", "איטלקית");
INSERT INTO `wp_icl_languages_translations` VALUES("1685", "it", "hi", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1686", "it", "hr", "Talijanski");
INSERT INTO `wp_icl_languages_translations` VALUES("1687", "it", "hu", "olasz");
INSERT INTO `wp_icl_languages_translations` VALUES("1688", "it", "hy", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1689", "it", "id", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1690", "it", "is", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1691", "it", "it", "Italiano");
INSERT INTO `wp_icl_languages_translations` VALUES("1692", "it", "ja", "イタリア語");
INSERT INTO `wp_icl_languages_translations` VALUES("1693", "it", "ko", "이태리어");
INSERT INTO `wp_icl_languages_translations` VALUES("1694", "it", "ku", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1695", "it", "lv", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1696", "it", "lt", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1697", "it", "mk", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1698", "it", "mt", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1699", "it", "mn", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1700", "it", "ne", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1701", "it", "nl", "Italiaans");
INSERT INTO `wp_icl_languages_translations` VALUES("1702", "it", "no", "Italiensk");
INSERT INTO `wp_icl_languages_translations` VALUES("1703", "it", "pa", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1704", "it", "pl", "włoski");
INSERT INTO `wp_icl_languages_translations` VALUES("1705", "it", "pt-pt", "Italiano");
INSERT INTO `wp_icl_languages_translations` VALUES("1706", "it", "pt-br", "Italiano");
INSERT INTO `wp_icl_languages_translations` VALUES("1707", "it", "qu", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1708", "it", "ro", "Italiană");
INSERT INTO `wp_icl_languages_translations` VALUES("1709", "it", "ru", "Итальянский");
INSERT INTO `wp_icl_languages_translations` VALUES("1710", "it", "sl", "Italijanski");
INSERT INTO `wp_icl_languages_translations` VALUES("1711", "it", "so", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1712", "it", "sq", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1713", "it", "sr", "италијански");
INSERT INTO `wp_icl_languages_translations` VALUES("1714", "it", "sv", "Italienska");
INSERT INTO `wp_icl_languages_translations` VALUES("1715", "it", "ta", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1716", "it", "th", "อิตาลี");
INSERT INTO `wp_icl_languages_translations` VALUES("1717", "it", "tr", "İtalyanca");
INSERT INTO `wp_icl_languages_translations` VALUES("1718", "it", "uk", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1719", "it", "ur", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1720", "it", "uz", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1721", "it", "vi", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1722", "it", "yi", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1723", "it", "zh-hans", "意大利语");
INSERT INTO `wp_icl_languages_translations` VALUES("1724", "it", "zu", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1725", "it", "zh-hant", "義大利語");
INSERT INTO `wp_icl_languages_translations` VALUES("1726", "it", "ms", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1727", "it", "gl", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1728", "it", "bn", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1729", "ja", "en", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1730", "ja", "es", "Japonés");
INSERT INTO `wp_icl_languages_translations` VALUES("1731", "ja", "de", "Japanisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1732", "ja", "fr", "Japonais");
INSERT INTO `wp_icl_languages_translations` VALUES("1733", "ja", "ar", "اليابانية");
INSERT INTO `wp_icl_languages_translations` VALUES("1734", "ja", "bs", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1735", "ja", "bg", "Японски");
INSERT INTO `wp_icl_languages_translations` VALUES("1736", "ja", "ca", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1737", "ja", "cs", "Japonský");
INSERT INTO `wp_icl_languages_translations` VALUES("1738", "ja", "sk", "Japonština");
INSERT INTO `wp_icl_languages_translations` VALUES("1739", "ja", "cy", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1740", "ja", "da", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1741", "ja", "el", "Ιαπωνικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1742", "ja", "eo", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1743", "ja", "et", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1744", "ja", "eu", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1745", "ja", "fa", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1746", "ja", "fi", "japani");
INSERT INTO `wp_icl_languages_translations` VALUES("1747", "ja", "ga", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1748", "ja", "he", "יפנית");
INSERT INTO `wp_icl_languages_translations` VALUES("1749", "ja", "hi", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1750", "ja", "hr", "Japanski");
INSERT INTO `wp_icl_languages_translations` VALUES("1751", "ja", "hu", "japán");
INSERT INTO `wp_icl_languages_translations` VALUES("1752", "ja", "hy", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1753", "ja", "id", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1754", "ja", "is", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1755", "ja", "it", "Giapponese");
INSERT INTO `wp_icl_languages_translations` VALUES("1756", "ja", "ja", "日本語");
INSERT INTO `wp_icl_languages_translations` VALUES("1757", "ja", "ko", "일어");
INSERT INTO `wp_icl_languages_translations` VALUES("1758", "ja", "ku", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1759", "ja", "lv", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1760", "ja", "lt", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1761", "ja", "mk", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1762", "ja", "mt", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1763", "ja", "mn", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1764", "ja", "ne", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1765", "ja", "nl", "Japans");
INSERT INTO `wp_icl_languages_translations` VALUES("1766", "ja", "no", "Japansk");
INSERT INTO `wp_icl_languages_translations` VALUES("1767", "ja", "pa", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1768", "ja", "pl", "japoński");
INSERT INTO `wp_icl_languages_translations` VALUES("1769", "ja", "pt-pt", "Japonês");
INSERT INTO `wp_icl_languages_translations` VALUES("1770", "ja", "pt-br", "Japonês");
INSERT INTO `wp_icl_languages_translations` VALUES("1771", "ja", "qu", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1772", "ja", "ro", "Japoneză");
INSERT INTO `wp_icl_languages_translations` VALUES("1773", "ja", "ru", "Японский");
INSERT INTO `wp_icl_languages_translations` VALUES("1774", "ja", "sl", "Japonski");
INSERT INTO `wp_icl_languages_translations` VALUES("1775", "ja", "so", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1776", "ja", "sq", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1777", "ja", "sr", "јапански");
INSERT INTO `wp_icl_languages_translations` VALUES("1778", "ja", "sv", "Japanska");
INSERT INTO `wp_icl_languages_translations` VALUES("1779", "ja", "ta", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1780", "ja", "th", "ญี่ปุ่น");
INSERT INTO `wp_icl_languages_translations` VALUES("1781", "ja", "tr", "Japonca");
INSERT INTO `wp_icl_languages_translations` VALUES("1782", "ja", "uk", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1783", "ja", "ur", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1784", "ja", "uz", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1785", "ja", "vi", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1786", "ja", "yi", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1787", "ja", "zh-hans", "日语");
INSERT INTO `wp_icl_languages_translations` VALUES("1788", "ja", "zu", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1789", "ja", "zh-hant", "日語");
INSERT INTO `wp_icl_languages_translations` VALUES("1790", "ja", "ms", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1791", "ja", "gl", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1792", "ja", "bn", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1793", "ko", "en", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1794", "ko", "es", "Coreano");
INSERT INTO `wp_icl_languages_translations` VALUES("1795", "ko", "de", "Koreanisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1796", "ko", "fr", "Coréen");
INSERT INTO `wp_icl_languages_translations` VALUES("1797", "ko", "ar", "الكورية");
INSERT INTO `wp_icl_languages_translations` VALUES("1798", "ko", "bs", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1799", "ko", "bg", "Корейски");
INSERT INTO `wp_icl_languages_translations` VALUES("1800", "ko", "ca", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1801", "ko", "cs", "Korejský");
INSERT INTO `wp_icl_languages_translations` VALUES("1802", "ko", "sk", "Kórejčina");
INSERT INTO `wp_icl_languages_translations` VALUES("1803", "ko", "cy", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1804", "ko", "da", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1805", "ko", "el", "Κορεατικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1806", "ko", "eo", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1807", "ko", "et", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1808", "ko", "eu", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1809", "ko", "fa", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1810", "ko", "fi", "korea");
INSERT INTO `wp_icl_languages_translations` VALUES("1811", "ko", "ga", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1812", "ko", "he", "קוראנית");
INSERT INTO `wp_icl_languages_translations` VALUES("1813", "ko", "hi", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1814", "ko", "hr", "Korejski");
INSERT INTO `wp_icl_languages_translations` VALUES("1815", "ko", "hu", "koreai");
INSERT INTO `wp_icl_languages_translations` VALUES("1816", "ko", "hy", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1817", "ko", "id", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1818", "ko", "is", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1819", "ko", "it", "Coreano");
INSERT INTO `wp_icl_languages_translations` VALUES("1820", "ko", "ja", "韓国語");
INSERT INTO `wp_icl_languages_translations` VALUES("1821", "ko", "ko", "한국어");
INSERT INTO `wp_icl_languages_translations` VALUES("1822", "ko", "ku", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1823", "ko", "lv", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1824", "ko", "lt", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1825", "ko", "mk", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1826", "ko", "mt", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1827", "ko", "mn", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1828", "ko", "ne", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1829", "ko", "nl", "Koreaans");
INSERT INTO `wp_icl_languages_translations` VALUES("1830", "ko", "no", "Koreanske");
INSERT INTO `wp_icl_languages_translations` VALUES("1831", "ko", "pa", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1832", "ko", "pl", "koreański");
INSERT INTO `wp_icl_languages_translations` VALUES("1833", "ko", "pt-pt", "Coreano");
INSERT INTO `wp_icl_languages_translations` VALUES("1834", "ko", "pt-br", "Coreano");
INSERT INTO `wp_icl_languages_translations` VALUES("1835", "ko", "qu", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1836", "ko", "ro", "Coreană");
INSERT INTO `wp_icl_languages_translations` VALUES("1837", "ko", "ru", "Корейский");
INSERT INTO `wp_icl_languages_translations` VALUES("1838", "ko", "sl", "Korejski");
INSERT INTO `wp_icl_languages_translations` VALUES("1839", "ko", "so", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1840", "ko", "sq", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1841", "ko", "sr", "корејски");
INSERT INTO `wp_icl_languages_translations` VALUES("1842", "ko", "sv", "Koreanska");
INSERT INTO `wp_icl_languages_translations` VALUES("1843", "ko", "ta", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1844", "ko", "th", "เกาหลี");
INSERT INTO `wp_icl_languages_translations` VALUES("1845", "ko", "tr", "Kore dili");
INSERT INTO `wp_icl_languages_translations` VALUES("1846", "ko", "uk", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1847", "ko", "ur", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1848", "ko", "uz", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1849", "ko", "vi", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1850", "ko", "yi", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1851", "ko", "zh-hans", "韩语");
INSERT INTO `wp_icl_languages_translations` VALUES("1852", "ko", "zu", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1853", "ko", "zh-hant", "韓語");
INSERT INTO `wp_icl_languages_translations` VALUES("1854", "ko", "ms", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1855", "ko", "gl", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1856", "ko", "bn", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1857", "ku", "en", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1858", "ku", "es", "Kurdo");
INSERT INTO `wp_icl_languages_translations` VALUES("1859", "ku", "de", "Kurdisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1860", "ku", "fr", "Kurde");
INSERT INTO `wp_icl_languages_translations` VALUES("1861", "ku", "ar", "الكردية");
INSERT INTO `wp_icl_languages_translations` VALUES("1862", "ku", "bs", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1863", "ku", "bg", "Кюрдски");
INSERT INTO `wp_icl_languages_translations` VALUES("1864", "ku", "ca", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1865", "ku", "cs", "Kurdský");
INSERT INTO `wp_icl_languages_translations` VALUES("1866", "ku", "sk", "Kurdština");
INSERT INTO `wp_icl_languages_translations` VALUES("1867", "ku", "cy", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1868", "ku", "da", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1869", "ku", "el", "Κουρδικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1870", "ku", "eo", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1871", "ku", "et", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1872", "ku", "eu", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1873", "ku", "fa", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1874", "ku", "fi", "kurdi");
INSERT INTO `wp_icl_languages_translations` VALUES("1875", "ku", "ga", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1876", "ku", "he", "כורדית");
INSERT INTO `wp_icl_languages_translations` VALUES("1877", "ku", "hi", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1878", "ku", "hr", "Kurdski");
INSERT INTO `wp_icl_languages_translations` VALUES("1879", "ku", "hu", "kurd");
INSERT INTO `wp_icl_languages_translations` VALUES("1880", "ku", "hy", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1881", "ku", "id", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1882", "ku", "is", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1883", "ku", "it", "Curdo");
INSERT INTO `wp_icl_languages_translations` VALUES("1884", "ku", "ja", "クルド語");
INSERT INTO `wp_icl_languages_translations` VALUES("1885", "ku", "ko", "쿠르드어");
INSERT INTO `wp_icl_languages_translations` VALUES("1886", "ku", "ku", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1887", "ku", "lv", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1888", "ku", "lt", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1889", "ku", "mk", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1890", "ku", "mt", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1891", "ku", "mn", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1892", "ku", "ne", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1893", "ku", "nl", "Koerdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1894", "ku", "no", "Kurdisk");
INSERT INTO `wp_icl_languages_translations` VALUES("1895", "ku", "pa", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1896", "ku", "pl", "kurdyjski");
INSERT INTO `wp_icl_languages_translations` VALUES("1897", "ku", "pt-pt", "Curdo");
INSERT INTO `wp_icl_languages_translations` VALUES("1898", "ku", "pt-br", "Curdo");
INSERT INTO `wp_icl_languages_translations` VALUES("1899", "ku", "qu", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1900", "ku", "ro", "Kurdă");
INSERT INTO `wp_icl_languages_translations` VALUES("1901", "ku", "ru", "Курдский");
INSERT INTO `wp_icl_languages_translations` VALUES("1902", "ku", "sl", "Kurdščina");
INSERT INTO `wp_icl_languages_translations` VALUES("1903", "ku", "so", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1904", "ku", "sq", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1905", "ku", "sr", "курдски");
INSERT INTO `wp_icl_languages_translations` VALUES("1906", "ku", "sv", "Kurdiska");
INSERT INTO `wp_icl_languages_translations` VALUES("1907", "ku", "ta", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1908", "ku", "th", "เคอร์ดิช");
INSERT INTO `wp_icl_languages_translations` VALUES("1909", "ku", "tr", "Kürtçe");
INSERT INTO `wp_icl_languages_translations` VALUES("1910", "ku", "uk", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1911", "ku", "ur", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1912", "ku", "uz", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1913", "ku", "vi", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1914", "ku", "yi", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1915", "ku", "zh-hans", "库尔德语");
INSERT INTO `wp_icl_languages_translations` VALUES("1916", "ku", "zu", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1917", "ku", "zh-hant", "庫爾德語");
INSERT INTO `wp_icl_languages_translations` VALUES("1918", "ku", "ms", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1919", "ku", "gl", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1920", "ku", "bn", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1921", "lv", "en", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1922", "lv", "es", "Letón");
INSERT INTO `wp_icl_languages_translations` VALUES("1923", "lv", "de", "Lettisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1924", "lv", "fr", "Letton");
INSERT INTO `wp_icl_languages_translations` VALUES("1925", "lv", "ar", "اللاتفية");
INSERT INTO `wp_icl_languages_translations` VALUES("1926", "lv", "bs", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1927", "lv", "bg", "Латвийски");
INSERT INTO `wp_icl_languages_translations` VALUES("1928", "lv", "ca", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1929", "lv", "cs", "Lotyština");
INSERT INTO `wp_icl_languages_translations` VALUES("1930", "lv", "sk", "Lotyština");
INSERT INTO `wp_icl_languages_translations` VALUES("1931", "lv", "cy", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1932", "lv", "da", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1933", "lv", "el", "Λετονικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1934", "lv", "eo", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1935", "lv", "et", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1936", "lv", "eu", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1937", "lv", "fa", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1938", "lv", "fi", "latvia");
INSERT INTO `wp_icl_languages_translations` VALUES("1939", "lv", "ga", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1940", "lv", "he", "לטבית");
INSERT INTO `wp_icl_languages_translations` VALUES("1941", "lv", "hi", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1942", "lv", "hr", "Letonski");
INSERT INTO `wp_icl_languages_translations` VALUES("1943", "lv", "hu", "lett");
INSERT INTO `wp_icl_languages_translations` VALUES("1944", "lv", "hy", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1945", "lv", "id", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1946", "lv", "is", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1947", "lv", "it", "Lettone");
INSERT INTO `wp_icl_languages_translations` VALUES("1948", "lv", "ja", "ラトビア語");
INSERT INTO `wp_icl_languages_translations` VALUES("1949", "lv", "ko", "라트비아어");
INSERT INTO `wp_icl_languages_translations` VALUES("1950", "lv", "ku", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1951", "lv", "lv", "Latviešu");
INSERT INTO `wp_icl_languages_translations` VALUES("1952", "lv", "lt", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1953", "lv", "mk", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1954", "lv", "mt", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1955", "lv", "mn", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1956", "lv", "ne", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1957", "lv", "nl", "Lets");
INSERT INTO `wp_icl_languages_translations` VALUES("1958", "lv", "no", "Latvisk");
INSERT INTO `wp_icl_languages_translations` VALUES("1959", "lv", "pa", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1960", "lv", "pl", "łotewski");
INSERT INTO `wp_icl_languages_translations` VALUES("1961", "lv", "pt-pt", "Letão");
INSERT INTO `wp_icl_languages_translations` VALUES("1962", "lv", "pt-br", "Letão");
INSERT INTO `wp_icl_languages_translations` VALUES("1963", "lv", "qu", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1964", "lv", "ro", "Letoniană");
INSERT INTO `wp_icl_languages_translations` VALUES("1965", "lv", "ru", "латышский");
INSERT INTO `wp_icl_languages_translations` VALUES("1966", "lv", "sl", "Latvijščina");
INSERT INTO `wp_icl_languages_translations` VALUES("1967", "lv", "so", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1968", "lv", "sq", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1969", "lv", "sr", "летонски");
INSERT INTO `wp_icl_languages_translations` VALUES("1970", "lv", "sv", "Lettiska");
INSERT INTO `wp_icl_languages_translations` VALUES("1971", "lv", "ta", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1972", "lv", "th", "ลัตเวีย");
INSERT INTO `wp_icl_languages_translations` VALUES("1973", "lv", "tr", "Letonca");
INSERT INTO `wp_icl_languages_translations` VALUES("1974", "lv", "uk", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1975", "lv", "ur", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1976", "lv", "uz", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1977", "lv", "vi", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1978", "lv", "yi", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1979", "lv", "zh-hans", "拉脱维亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("1980", "lv", "zu", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1981", "lv", "zh-hant", "拉脫維亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("1982", "lv", "ms", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1983", "lv", "gl", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1984", "lv", "bn", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1985", "lt", "en", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("1986", "lt", "es", "Lituano");
INSERT INTO `wp_icl_languages_translations` VALUES("1987", "lt", "de", "Litauisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1988", "lt", "fr", "Lituanien");
INSERT INTO `wp_icl_languages_translations` VALUES("1989", "lt", "ar", "اللتوانية");
INSERT INTO `wp_icl_languages_translations` VALUES("1990", "lt", "bs", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("1991", "lt", "bg", "Литовски");
INSERT INTO `wp_icl_languages_translations` VALUES("1992", "lt", "ca", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("1993", "lt", "cs", "litevský");
INSERT INTO `wp_icl_languages_translations` VALUES("1994", "lt", "sk", "Litovčina");
INSERT INTO `wp_icl_languages_translations` VALUES("1995", "lt", "cy", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("1996", "lt", "da", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("1997", "lt", "el", "Λιθουανικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1998", "lt", "eo", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("1999", "lt", "et", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2000", "lt", "eu", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2001", "lt", "fa", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2002", "lt", "fi", "liettua");
INSERT INTO `wp_icl_languages_translations` VALUES("2003", "lt", "ga", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2004", "lt", "he", "ליטאית");
INSERT INTO `wp_icl_languages_translations` VALUES("2005", "lt", "hi", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2006", "lt", "hr", "Litvanski");
INSERT INTO `wp_icl_languages_translations` VALUES("2007", "lt", "hu", "litván");
INSERT INTO `wp_icl_languages_translations` VALUES("2008", "lt", "hy", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2009", "lt", "id", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2010", "lt", "is", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2011", "lt", "it", "Lituano");
INSERT INTO `wp_icl_languages_translations` VALUES("2012", "lt", "ja", "リトアニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("2013", "lt", "ko", "리투아니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("2014", "lt", "ku", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2015", "lt", "lv", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2016", "lt", "lt", "Lietuvos");
INSERT INTO `wp_icl_languages_translations` VALUES("2017", "lt", "mk", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2018", "lt", "mt", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2019", "lt", "mn", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2020", "lt", "ne", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2021", "lt", "nl", "Litouws");
INSERT INTO `wp_icl_languages_translations` VALUES("2022", "lt", "no", "Litauisk");
INSERT INTO `wp_icl_languages_translations` VALUES("2023", "lt", "pa", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2024", "lt", "pl", "litewski");
INSERT INTO `wp_icl_languages_translations` VALUES("2025", "lt", "pt-pt", "Lituano");
INSERT INTO `wp_icl_languages_translations` VALUES("2026", "lt", "pt-br", "Lituano");
INSERT INTO `wp_icl_languages_translations` VALUES("2027", "lt", "qu", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2028", "lt", "ro", "Lituaniană");
INSERT INTO `wp_icl_languages_translations` VALUES("2029", "lt", "ru", "Литовский");
INSERT INTO `wp_icl_languages_translations` VALUES("2030", "lt", "sl", "Litovščina");
INSERT INTO `wp_icl_languages_translations` VALUES("2031", "lt", "so", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2032", "lt", "sq", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2033", "lt", "sr", "литвански");
INSERT INTO `wp_icl_languages_translations` VALUES("2034", "lt", "sv", "Litauiska");
INSERT INTO `wp_icl_languages_translations` VALUES("2035", "lt", "ta", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2036", "lt", "th", "ลิธัวเนีย");
INSERT INTO `wp_icl_languages_translations` VALUES("2037", "lt", "tr", "Litvanyaca");
INSERT INTO `wp_icl_languages_translations` VALUES("2038", "lt", "uk", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2039", "lt", "ur", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2040", "lt", "uz", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2041", "lt", "vi", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2042", "lt", "yi", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2043", "lt", "zh-hans", "立陶宛语");
INSERT INTO `wp_icl_languages_translations` VALUES("2044", "lt", "zu", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2045", "lt", "zh-hant", "立陶宛語");
INSERT INTO `wp_icl_languages_translations` VALUES("2046", "lt", "ms", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2047", "lt", "gl", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2048", "lt", "bn", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2049", "mk", "en", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2050", "mk", "es", "Macedonio");
INSERT INTO `wp_icl_languages_translations` VALUES("2051", "mk", "de", "Mazedonisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2052", "mk", "fr", "Macédonien");
INSERT INTO `wp_icl_languages_translations` VALUES("2053", "mk", "ar", "المقدونية");
INSERT INTO `wp_icl_languages_translations` VALUES("2054", "mk", "bs", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2055", "mk", "bg", "Македонски");
INSERT INTO `wp_icl_languages_translations` VALUES("2056", "mk", "ca", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2057", "mk", "cs", "Makedonský");
INSERT INTO `wp_icl_languages_translations` VALUES("2058", "mk", "sk", "Macedónština");
INSERT INTO `wp_icl_languages_translations` VALUES("2059", "mk", "cy", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2060", "mk", "da", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2061", "mk", "el", "Μακεδονικο");
INSERT INTO `wp_icl_languages_translations` VALUES("2062", "mk", "eo", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2063", "mk", "et", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2064", "mk", "eu", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2065", "mk", "fa", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2066", "mk", "fi", "makedonia");
INSERT INTO `wp_icl_languages_translations` VALUES("2067", "mk", "ga", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2068", "mk", "he", "מקדונית");
INSERT INTO `wp_icl_languages_translations` VALUES("2069", "mk", "hi", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2070", "mk", "hr", "Makedonski");
INSERT INTO `wp_icl_languages_translations` VALUES("2071", "mk", "hu", "macedón");
INSERT INTO `wp_icl_languages_translations` VALUES("2072", "mk", "hy", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2073", "mk", "id", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2074", "mk", "is", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2075", "mk", "it", "Macedone");
INSERT INTO `wp_icl_languages_translations` VALUES("2076", "mk", "ja", "マケドニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("2077", "mk", "ko", "마케도니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("2078", "mk", "ku", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2079", "mk", "lv", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2080", "mk", "lt", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2081", "mk", "mk", "македонски");
INSERT INTO `wp_icl_languages_translations` VALUES("2082", "mk", "mt", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2083", "mk", "mn", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2084", "mk", "ne", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2085", "mk", "nl", "Macedonisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2086", "mk", "no", "Makedonsk");
INSERT INTO `wp_icl_languages_translations` VALUES("2087", "mk", "pa", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2088", "mk", "pl", "macedoński");
INSERT INTO `wp_icl_languages_translations` VALUES("2089", "mk", "pt-pt", "Macedônio");
INSERT INTO `wp_icl_languages_translations` VALUES("2090", "mk", "pt-br", "Macedônio");
INSERT INTO `wp_icl_languages_translations` VALUES("2091", "mk", "qu", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2092", "mk", "ro", "Macedoniană");
INSERT INTO `wp_icl_languages_translations` VALUES("2093", "mk", "ru", "Македонский");
INSERT INTO `wp_icl_languages_translations` VALUES("2094", "mk", "sl", "Makedonski");
INSERT INTO `wp_icl_languages_translations` VALUES("2095", "mk", "so", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2096", "mk", "sq", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2097", "mk", "sr", "македонски");
INSERT INTO `wp_icl_languages_translations` VALUES("2098", "mk", "sv", "Makedonska");
INSERT INTO `wp_icl_languages_translations` VALUES("2099", "mk", "ta", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2100", "mk", "th", "มาซิโดเนีย");
INSERT INTO `wp_icl_languages_translations` VALUES("2101", "mk", "tr", "Makedonyaca");
INSERT INTO `wp_icl_languages_translations` VALUES("2102", "mk", "uk", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2103", "mk", "ur", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2104", "mk", "uz", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2105", "mk", "vi", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2106", "mk", "yi", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2107", "mk", "zh-hans", "马其顿语");
INSERT INTO `wp_icl_languages_translations` VALUES("2108", "mk", "zu", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2109", "mk", "zh-hant", "馬其頓語");
INSERT INTO `wp_icl_languages_translations` VALUES("2110", "mk", "ms", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2111", "mk", "gl", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2112", "mk", "bn", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2113", "mt", "en", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2114", "mt", "es", "Maltés");
INSERT INTO `wp_icl_languages_translations` VALUES("2115", "mt", "de", "Maltesisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2116", "mt", "fr", "Maltais");
INSERT INTO `wp_icl_languages_translations` VALUES("2117", "mt", "ar", "المالطية");
INSERT INTO `wp_icl_languages_translations` VALUES("2118", "mt", "bs", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2119", "mt", "bg", "Малтийски");
INSERT INTO `wp_icl_languages_translations` VALUES("2120", "mt", "ca", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2121", "mt", "cs", "Maltština");
INSERT INTO `wp_icl_languages_translations` VALUES("2122", "mt", "sk", "Maltézština");
INSERT INTO `wp_icl_languages_translations` VALUES("2123", "mt", "cy", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2124", "mt", "da", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2125", "mt", "el", "Μαλτεζικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2126", "mt", "eo", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2127", "mt", "et", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2128", "mt", "eu", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2129", "mt", "fa", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2130", "mt", "fi", "malta");
INSERT INTO `wp_icl_languages_translations` VALUES("2131", "mt", "ga", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2132", "mt", "he", "מלטזית");
INSERT INTO `wp_icl_languages_translations` VALUES("2133", "mt", "hi", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2134", "mt", "hr", "Malteški");
INSERT INTO `wp_icl_languages_translations` VALUES("2135", "mt", "hu", "máltai");
INSERT INTO `wp_icl_languages_translations` VALUES("2136", "mt", "hy", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2137", "mt", "id", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2138", "mt", "is", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2139", "mt", "it", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2140", "mt", "ja", "マルタ語");
INSERT INTO `wp_icl_languages_translations` VALUES("2141", "mt", "ko", "몰타어");
INSERT INTO `wp_icl_languages_translations` VALUES("2142", "mt", "ku", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2143", "mt", "lv", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2144", "mt", "lt", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2145", "mt", "mk", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2146", "mt", "mt", "Malti");
INSERT INTO `wp_icl_languages_translations` VALUES("2147", "mt", "mn", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2148", "mt", "ne", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2149", "mt", "nl", "Maltees");
INSERT INTO `wp_icl_languages_translations` VALUES("2150", "mt", "no", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2151", "mt", "pa", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2152", "mt", "pl", "maltański");
INSERT INTO `wp_icl_languages_translations` VALUES("2153", "mt", "pt-pt", "Maltês");
INSERT INTO `wp_icl_languages_translations` VALUES("2154", "mt", "pt-br", "Maltês");
INSERT INTO `wp_icl_languages_translations` VALUES("2155", "mt", "qu", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2156", "mt", "ro", "Malteză");
INSERT INTO `wp_icl_languages_translations` VALUES("2157", "mt", "ru", "Мальтийский");
INSERT INTO `wp_icl_languages_translations` VALUES("2158", "mt", "sl", "Malteški");
INSERT INTO `wp_icl_languages_translations` VALUES("2159", "mt", "so", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2160", "mt", "sq", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2161", "mt", "sr", "малтешки");
INSERT INTO `wp_icl_languages_translations` VALUES("2162", "mt", "sv", "Maltesiska");
INSERT INTO `wp_icl_languages_translations` VALUES("2163", "mt", "ta", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2164", "mt", "th", "มอลทีส");
INSERT INTO `wp_icl_languages_translations` VALUES("2165", "mt", "tr", "Malta dili");
INSERT INTO `wp_icl_languages_translations` VALUES("2166", "mt", "uk", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2167", "mt", "ur", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2168", "mt", "uz", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2169", "mt", "vi", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2170", "mt", "yi", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2171", "mt", "zh-hans", "马耳他语");
INSERT INTO `wp_icl_languages_translations` VALUES("2172", "mt", "zu", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2173", "mt", "zh-hant", "馬爾他語");
INSERT INTO `wp_icl_languages_translations` VALUES("2174", "mt", "ms", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2175", "mt", "gl", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2176", "mt", "bn", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2177", "mn", "en", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2178", "mn", "es", "Mongol");
INSERT INTO `wp_icl_languages_translations` VALUES("2179", "mn", "de", "Mongolisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2180", "mn", "fr", "Mongol");
INSERT INTO `wp_icl_languages_translations` VALUES("2181", "mn", "ar", "المنغولية");
INSERT INTO `wp_icl_languages_translations` VALUES("2182", "mn", "bs", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2183", "mn", "bg", "Монголски");
INSERT INTO `wp_icl_languages_translations` VALUES("2184", "mn", "ca", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2185", "mn", "cs", "Mongolský");
INSERT INTO `wp_icl_languages_translations` VALUES("2186", "mn", "sk", "Mongolština");
INSERT INTO `wp_icl_languages_translations` VALUES("2187", "mn", "cy", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2188", "mn", "da", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2189", "mn", "el", "Μογγολικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2190", "mn", "eo", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2191", "mn", "et", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2192", "mn", "eu", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2193", "mn", "fa", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2194", "mn", "fi", "mongoli");
INSERT INTO `wp_icl_languages_translations` VALUES("2195", "mn", "ga", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2196", "mn", "he", "מונגולית");
INSERT INTO `wp_icl_languages_translations` VALUES("2197", "mn", "hi", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2198", "mn", "hr", "Mongolski");
INSERT INTO `wp_icl_languages_translations` VALUES("2199", "mn", "hu", "mongol");
INSERT INTO `wp_icl_languages_translations` VALUES("2200", "mn", "hy", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2201", "mn", "id", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2202", "mn", "is", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2203", "mn", "it", "Mongolo");
INSERT INTO `wp_icl_languages_translations` VALUES("2204", "mn", "ja", "モンゴル語");
INSERT INTO `wp_icl_languages_translations` VALUES("2205", "mn", "ko", "몽골어");
INSERT INTO `wp_icl_languages_translations` VALUES("2206", "mn", "ku", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2207", "mn", "lv", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2208", "mn", "lt", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2209", "mn", "mk", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2210", "mn", "mt", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2211", "mn", "mn", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2212", "mn", "ne", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2213", "mn", "nl", "Mongools");
INSERT INTO `wp_icl_languages_translations` VALUES("2214", "mn", "no", "Mongolsk");
INSERT INTO `wp_icl_languages_translations` VALUES("2215", "mn", "pa", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2216", "mn", "pl", "mongolski");
INSERT INTO `wp_icl_languages_translations` VALUES("2217", "mn", "pt-pt", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2218", "mn", "pt-br", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2219", "mn", "qu", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2220", "mn", "ro", "Mongoleză");
INSERT INTO `wp_icl_languages_translations` VALUES("2221", "mn", "ru", "Монгольский");
INSERT INTO `wp_icl_languages_translations` VALUES("2222", "mn", "sl", "Mongolski");
INSERT INTO `wp_icl_languages_translations` VALUES("2223", "mn", "so", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2224", "mn", "sq", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2225", "mn", "sr", "монголски");
INSERT INTO `wp_icl_languages_translations` VALUES("2226", "mn", "sv", "Mongoliska");
INSERT INTO `wp_icl_languages_translations` VALUES("2227", "mn", "ta", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2228", "mn", "th", "มองโกเลีย");
INSERT INTO `wp_icl_languages_translations` VALUES("2229", "mn", "tr", "Mongolca");
INSERT INTO `wp_icl_languages_translations` VALUES("2230", "mn", "uk", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2231", "mn", "ur", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2232", "mn", "uz", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2233", "mn", "vi", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2234", "mn", "yi", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2235", "mn", "zh-hans", "蒙古语");
INSERT INTO `wp_icl_languages_translations` VALUES("2236", "mn", "zu", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2237", "mn", "zh-hant", "蒙古語");
INSERT INTO `wp_icl_languages_translations` VALUES("2238", "mn", "ms", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2239", "mn", "gl", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2240", "mn", "bn", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2241", "ne", "en", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2242", "ne", "es", "Nepalí");
INSERT INTO `wp_icl_languages_translations` VALUES("2243", "ne", "de", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2244", "ne", "fr", "Népalais");
INSERT INTO `wp_icl_languages_translations` VALUES("2245", "ne", "ar", "النيبالية");
INSERT INTO `wp_icl_languages_translations` VALUES("2246", "ne", "bs", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2247", "ne", "bg", "Непалски");
INSERT INTO `wp_icl_languages_translations` VALUES("2248", "ne", "ca", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2249", "ne", "cs", "Nepálský");
INSERT INTO `wp_icl_languages_translations` VALUES("2250", "ne", "sk", "Nepálčina");
INSERT INTO `wp_icl_languages_translations` VALUES("2251", "ne", "cy", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2252", "ne", "da", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2253", "ne", "el", "Νεπαλι");
INSERT INTO `wp_icl_languages_translations` VALUES("2254", "ne", "eo", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2255", "ne", "et", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2256", "ne", "eu", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2257", "ne", "fa", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2258", "ne", "fi", "nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2259", "ne", "ga", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2260", "ne", "he", "נפאלית");
INSERT INTO `wp_icl_languages_translations` VALUES("2261", "ne", "hi", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2262", "ne", "hr", "Nepalski");
INSERT INTO `wp_icl_languages_translations` VALUES("2263", "ne", "hu", "nepáli");
INSERT INTO `wp_icl_languages_translations` VALUES("2264", "ne", "hy", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2265", "ne", "id", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2266", "ne", "is", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2267", "ne", "it", "Nepalese");
INSERT INTO `wp_icl_languages_translations` VALUES("2268", "ne", "ja", "ネパール語");
INSERT INTO `wp_icl_languages_translations` VALUES("2269", "ne", "ko", "네팔어");
INSERT INTO `wp_icl_languages_translations` VALUES("2270", "ne", "ku", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2271", "ne", "lv", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2272", "ne", "lt", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2273", "ne", "mk", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2274", "ne", "mt", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2275", "ne", "mn", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2276", "ne", "ne", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2277", "ne", "nl", "Nepalees");
INSERT INTO `wp_icl_languages_translations` VALUES("2278", "ne", "no", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2279", "ne", "pa", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2280", "ne", "pl", "nepalski");
INSERT INTO `wp_icl_languages_translations` VALUES("2281", "ne", "pt-pt", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2282", "ne", "pt-br", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2283", "ne", "qu", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2284", "ne", "ro", "Nepaleză");
INSERT INTO `wp_icl_languages_translations` VALUES("2285", "ne", "ru", "Непальский");
INSERT INTO `wp_icl_languages_translations` VALUES("2286", "ne", "sl", "Nepalščina");
INSERT INTO `wp_icl_languages_translations` VALUES("2287", "ne", "so", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2288", "ne", "sq", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2289", "ne", "sr", "непалски");
INSERT INTO `wp_icl_languages_translations` VALUES("2290", "ne", "sv", "Nepalesiska");
INSERT INTO `wp_icl_languages_translations` VALUES("2291", "ne", "ta", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2292", "ne", "th", "เนปาล");
INSERT INTO `wp_icl_languages_translations` VALUES("2293", "ne", "tr", "Nepal dili");
INSERT INTO `wp_icl_languages_translations` VALUES("2294", "ne", "uk", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2295", "ne", "ur", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2296", "ne", "uz", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2297", "ne", "vi", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2298", "ne", "yi", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2299", "ne", "zh-hans", "尼泊尔语");
INSERT INTO `wp_icl_languages_translations` VALUES("2300", "ne", "zu", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2301", "ne", "zh-hant", "尼泊爾語");
INSERT INTO `wp_icl_languages_translations` VALUES("2302", "ne", "ms", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2303", "ne", "gl", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2304", "ne", "bn", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2305", "nl", "en", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2306", "nl", "es", "Holandés");
INSERT INTO `wp_icl_languages_translations` VALUES("2307", "nl", "de", "Niederländisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2308", "nl", "fr", "Néerlandais");
INSERT INTO `wp_icl_languages_translations` VALUES("2309", "nl", "ar", "الهولندية");
INSERT INTO `wp_icl_languages_translations` VALUES("2310", "nl", "bs", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2311", "nl", "bg", "Холандски");
INSERT INTO `wp_icl_languages_translations` VALUES("2312", "nl", "ca", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2313", "nl", "cs", "Holandský");
INSERT INTO `wp_icl_languages_translations` VALUES("2314", "nl", "sk", "Holandčina");
INSERT INTO `wp_icl_languages_translations` VALUES("2315", "nl", "cy", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2316", "nl", "da", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2317", "nl", "el", "Ολλανδικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2318", "nl", "eo", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2319", "nl", "et", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2320", "nl", "eu", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2321", "nl", "fa", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2322", "nl", "fi", "hollanti");
INSERT INTO `wp_icl_languages_translations` VALUES("2323", "nl", "ga", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2324", "nl", "he", "הולנדית");
INSERT INTO `wp_icl_languages_translations` VALUES("2325", "nl", "hi", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2326", "nl", "hr", "Holandski");
INSERT INTO `wp_icl_languages_translations` VALUES("2327", "nl", "hu", "holland");
INSERT INTO `wp_icl_languages_translations` VALUES("2328", "nl", "hy", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2329", "nl", "id", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2330", "nl", "is", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2331", "nl", "it", "Olandese");
INSERT INTO `wp_icl_languages_translations` VALUES("2332", "nl", "ja", "オランダ語");
INSERT INTO `wp_icl_languages_translations` VALUES("2333", "nl", "ko", "화란어");
INSERT INTO `wp_icl_languages_translations` VALUES("2334", "nl", "ku", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2335", "nl", "lv", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2336", "nl", "lt", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2337", "nl", "mk", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2338", "nl", "mt", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2339", "nl", "mn", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2340", "nl", "ne", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2341", "nl", "nl", "Nederlands");
INSERT INTO `wp_icl_languages_translations` VALUES("2342", "nl", "no", "Nederlandsk");
INSERT INTO `wp_icl_languages_translations` VALUES("2343", "nl", "pa", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2344", "nl", "pl", "holenderski");
INSERT INTO `wp_icl_languages_translations` VALUES("2345", "nl", "pt-pt", "Holandês");
INSERT INTO `wp_icl_languages_translations` VALUES("2346", "nl", "pt-br", "Holandês");
INSERT INTO `wp_icl_languages_translations` VALUES("2347", "nl", "qu", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2348", "nl", "ro", "Olaneză");
INSERT INTO `wp_icl_languages_translations` VALUES("2349", "nl", "ru", "Голландский");
INSERT INTO `wp_icl_languages_translations` VALUES("2350", "nl", "sl", "Nizozemščina");
INSERT INTO `wp_icl_languages_translations` VALUES("2351", "nl", "so", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2352", "nl", "sq", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2353", "nl", "sr", "холандски");
INSERT INTO `wp_icl_languages_translations` VALUES("2354", "nl", "sv", "Nederländska");
INSERT INTO `wp_icl_languages_translations` VALUES("2355", "nl", "ta", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2356", "nl", "th", "ดัตช์");
INSERT INTO `wp_icl_languages_translations` VALUES("2357", "nl", "tr", "Hollandaca");
INSERT INTO `wp_icl_languages_translations` VALUES("2358", "nl", "uk", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2359", "nl", "ur", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2360", "nl", "uz", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2361", "nl", "vi", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2362", "nl", "yi", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2363", "nl", "zh-hans", "荷兰语");
INSERT INTO `wp_icl_languages_translations` VALUES("2364", "nl", "zu", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2365", "nl", "zh-hant", "荷蘭語");
INSERT INTO `wp_icl_languages_translations` VALUES("2366", "nl", "ms", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2367", "nl", "gl", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2368", "nl", "bn", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2369", "no", "en", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2370", "no", "es", "Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2371", "no", "de", "Norwegisch (Buchsprache)");
INSERT INTO `wp_icl_languages_translations` VALUES("2372", "no", "fr", "Norvégien Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2373", "no", "ar", "البوكمالية النرويجية");
INSERT INTO `wp_icl_languages_translations` VALUES("2374", "no", "bs", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2375", "no", "bg", "Норвежки книжовен");
INSERT INTO `wp_icl_languages_translations` VALUES("2376", "no", "ca", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2377", "no", "cs", "Norwegian bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2378", "no", "sk", "Nórsky jazyk Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2379", "no", "cy", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2380", "no", "da", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2381", "no", "el", "Νορβηγικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2382", "no", "eo", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2383", "no", "et", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2384", "no", "eu", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2385", "no", "fa", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2386", "no", "fi", "kirjanorja");
INSERT INTO `wp_icl_languages_translations` VALUES("2387", "no", "ga", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2388", "no", "he", "נורווגית");
INSERT INTO `wp_icl_languages_translations` VALUES("2389", "no", "hi", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2390", "no", "hr", "Književni norveški");
INSERT INTO `wp_icl_languages_translations` VALUES("2391", "no", "hu", "norvég bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2392", "no", "hy", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2393", "no", "id", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2394", "no", "is", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2395", "no", "it", "Norvegese Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2396", "no", "ja", "ノルウェー・ブークモール");
INSERT INTO `wp_icl_languages_translations` VALUES("2397", "no", "ko", "노르웨이 보크말어");
INSERT INTO `wp_icl_languages_translations` VALUES("2398", "no", "ku", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2399", "no", "lv", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2400", "no", "lt", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2401", "no", "mk", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2402", "no", "mt", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2403", "no", "mn", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2404", "no", "ne", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2405", "no", "nl", "Noors Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2406", "no", "no", "Norsk bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2407", "no", "pa", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2408", "no", "pl", "norweski bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2409", "no", "pt-pt", "Norueguês");
INSERT INTO `wp_icl_languages_translations` VALUES("2410", "no", "pt-br", "Norueguês");
INSERT INTO `wp_icl_languages_translations` VALUES("2411", "no", "qu", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2412", "no", "ro", "Bokmål (norvegiană)");
INSERT INTO `wp_icl_languages_translations` VALUES("2413", "no", "ru", "Норвежский букмол");
INSERT INTO `wp_icl_languages_translations` VALUES("2414", "no", "sl", "Knjižna norveščina");
INSERT INTO `wp_icl_languages_translations` VALUES("2415", "no", "so", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2416", "no", "sq", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2417", "no", "sr", "Норвешки бокмал");
INSERT INTO `wp_icl_languages_translations` VALUES("2418", "no", "sv", "Norskt Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2419", "no", "ta", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2420", "no", "th", "นอร์วิเจียนบอกมาล");
INSERT INTO `wp_icl_languages_translations` VALUES("2421", "no", "tr", "Bokmal Norveç dili");
INSERT INTO `wp_icl_languages_translations` VALUES("2422", "no", "uk", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2423", "no", "ur", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2424", "no", "uz", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2425", "no", "vi", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2426", "no", "yi", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2427", "no", "zh-hans", "挪威布克莫尔语");
INSERT INTO `wp_icl_languages_translations` VALUES("2428", "no", "zu", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2429", "no", "zh-hant", "挪威布克莫爾語");
INSERT INTO `wp_icl_languages_translations` VALUES("2430", "no", "ms", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2431", "no", "gl", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2432", "no", "bn", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2433", "pa", "en", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2434", "pa", "es", "Panyabí");
INSERT INTO `wp_icl_languages_translations` VALUES("2435", "pa", "de", "Pandschabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2436", "pa", "fr", "Panjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2437", "pa", "ar", "البنجابية");
INSERT INTO `wp_icl_languages_translations` VALUES("2438", "pa", "bs", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2439", "pa", "bg", "Панджабски");
INSERT INTO `wp_icl_languages_translations` VALUES("2440", "pa", "ca", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2441", "pa", "cs", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2442", "pa", "sk", "Pandžábčina");
INSERT INTO `wp_icl_languages_translations` VALUES("2443", "pa", "cy", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2444", "pa", "da", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2445", "pa", "el", "Panjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2446", "pa", "eo", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2447", "pa", "et", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2448", "pa", "eu", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2449", "pa", "fa", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2450", "pa", "fi", "pandzabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2451", "pa", "ga", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2452", "pa", "he", "פנג\'אבית");
INSERT INTO `wp_icl_languages_translations` VALUES("2453", "pa", "hi", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2454", "pa", "hr", "Pendžabljanin");
INSERT INTO `wp_icl_languages_translations` VALUES("2455", "pa", "hu", "pandzsábi");
INSERT INTO `wp_icl_languages_translations` VALUES("2456", "pa", "hy", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2457", "pa", "id", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2458", "pa", "is", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2459", "pa", "it", "Panjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2460", "pa", "ja", "パンジャーブ語");
INSERT INTO `wp_icl_languages_translations` VALUES("2461", "pa", "ko", "펀자브어");
INSERT INTO `wp_icl_languages_translations` VALUES("2462", "pa", "ku", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2463", "pa", "lv", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2464", "pa", "lt", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2465", "pa", "mk", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2466", "pa", "mt", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2467", "pa", "mn", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2468", "pa", "ne", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2469", "pa", "nl", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2470", "pa", "no", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2471", "pa", "pa", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2472", "pa", "pl", "pendżabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2473", "pa", "pt-pt", "Panjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2474", "pa", "pt-br", "Panjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2475", "pa", "qu", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2476", "pa", "ro", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2477", "pa", "ru", "Панджаби");
INSERT INTO `wp_icl_languages_translations` VALUES("2478", "pa", "sl", "Pandžabščina");
INSERT INTO `wp_icl_languages_translations` VALUES("2479", "pa", "so", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2480", "pa", "sq", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2481", "pa", "sr", "панџаби");
INSERT INTO `wp_icl_languages_translations` VALUES("2482", "pa", "sv", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2483", "pa", "ta", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2484", "pa", "th", "ปัญจาบ");
INSERT INTO `wp_icl_languages_translations` VALUES("2485", "pa", "tr", "Pencapça");
INSERT INTO `wp_icl_languages_translations` VALUES("2486", "pa", "uk", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2487", "pa", "ur", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2488", "pa", "uz", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2489", "pa", "vi", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2490", "pa", "yi", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2491", "pa", "zh-hans", "旁遮普语");
INSERT INTO `wp_icl_languages_translations` VALUES("2492", "pa", "zu", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2493", "pa", "zh-hant", "旁遮普語");
INSERT INTO `wp_icl_languages_translations` VALUES("2494", "pa", "ms", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2495", "pa", "gl", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2496", "pa", "bn", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2497", "pl", "en", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2498", "pl", "es", "Polaco");
INSERT INTO `wp_icl_languages_translations` VALUES("2499", "pl", "de", "Polnisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2500", "pl", "fr", "Polonais");
INSERT INTO `wp_icl_languages_translations` VALUES("2501", "pl", "ar", "البولندية");
INSERT INTO `wp_icl_languages_translations` VALUES("2502", "pl", "bs", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2503", "pl", "bg", "Полски");
INSERT INTO `wp_icl_languages_translations` VALUES("2504", "pl", "ca", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2505", "pl", "cs", "Polský");
INSERT INTO `wp_icl_languages_translations` VALUES("2506", "pl", "sk", "Polština");
INSERT INTO `wp_icl_languages_translations` VALUES("2507", "pl", "cy", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2508", "pl", "da", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2509", "pl", "el", "Πολωνικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2510", "pl", "eo", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2511", "pl", "et", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2512", "pl", "eu", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2513", "pl", "fa", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2514", "pl", "fi", "puola");
INSERT INTO `wp_icl_languages_translations` VALUES("2515", "pl", "ga", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2516", "pl", "he", "פולנית");
INSERT INTO `wp_icl_languages_translations` VALUES("2517", "pl", "hi", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2518", "pl", "hr", "Poljski");
INSERT INTO `wp_icl_languages_translations` VALUES("2519", "pl", "hu", "lengyel");
INSERT INTO `wp_icl_languages_translations` VALUES("2520", "pl", "hy", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2521", "pl", "id", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2522", "pl", "is", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2523", "pl", "it", "Polacco");
INSERT INTO `wp_icl_languages_translations` VALUES("2524", "pl", "ja", "ポーランド語");
INSERT INTO `wp_icl_languages_translations` VALUES("2525", "pl", "ko", "폴란드어");
INSERT INTO `wp_icl_languages_translations` VALUES("2526", "pl", "ku", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2527", "pl", "lv", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2528", "pl", "lt", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2529", "pl", "mk", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2530", "pl", "mt", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2531", "pl", "mn", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2532", "pl", "ne", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2533", "pl", "nl", "Pools");
INSERT INTO `wp_icl_languages_translations` VALUES("2534", "pl", "no", "Polsk");
INSERT INTO `wp_icl_languages_translations` VALUES("2535", "pl", "pa", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2536", "pl", "pl", "polski");
INSERT INTO `wp_icl_languages_translations` VALUES("2537", "pl", "pt-pt", "Polonês");
INSERT INTO `wp_icl_languages_translations` VALUES("2538", "pl", "pt-br", "Polonês");
INSERT INTO `wp_icl_languages_translations` VALUES("2539", "pl", "qu", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2540", "pl", "ro", "Poloneză");
INSERT INTO `wp_icl_languages_translations` VALUES("2541", "pl", "ru", "Польский");
INSERT INTO `wp_icl_languages_translations` VALUES("2542", "pl", "sl", "Poljski");
INSERT INTO `wp_icl_languages_translations` VALUES("2543", "pl", "so", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2544", "pl", "sq", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2545", "pl", "sr", "пољски");
INSERT INTO `wp_icl_languages_translations` VALUES("2546", "pl", "sv", "Polska");
INSERT INTO `wp_icl_languages_translations` VALUES("2547", "pl", "ta", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2548", "pl", "th", "โปแลนด์");
INSERT INTO `wp_icl_languages_translations` VALUES("2549", "pl", "tr", "Polonyaca");
INSERT INTO `wp_icl_languages_translations` VALUES("2550", "pl", "uk", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2551", "pl", "ur", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2552", "pl", "uz", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2553", "pl", "vi", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2554", "pl", "yi", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2555", "pl", "zh-hans", "波兰语");
INSERT INTO `wp_icl_languages_translations` VALUES("2556", "pl", "zu", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2557", "pl", "zh-hant", "波蘭語");
INSERT INTO `wp_icl_languages_translations` VALUES("2558", "pl", "ms", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2559", "pl", "gl", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2560", "pl", "bn", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2561", "pt-pt", "en", "Portuguese (Portugal)");
INSERT INTO `wp_icl_languages_translations` VALUES("2562", "pt-pt", "es", "Portugués, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2563", "pt-pt", "de", "Portugiesisch, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2564", "pt-pt", "fr", "Portugais - du Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2565", "pt-pt", "ar", "البرتغالية ، البرتغال");
INSERT INTO `wp_icl_languages_translations` VALUES("2566", "pt-pt", "bs", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2567", "pt-pt", "bg", "Португалски (Португалия)");
INSERT INTO `wp_icl_languages_translations` VALUES("2568", "pt-pt", "ca", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2569", "pt-pt", "cs", "Portugalština ( Portugalsko)");
INSERT INTO `wp_icl_languages_translations` VALUES("2570", "pt-pt", "sk", "Portugalština");
INSERT INTO `wp_icl_languages_translations` VALUES("2571", "pt-pt", "cy", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2572", "pt-pt", "da", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2573", "pt-pt", "el", "Πορτογαλικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2574", "pt-pt", "eo", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2575", "pt-pt", "et", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2576", "pt-pt", "eu", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2577", "pt-pt", "fa", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2578", "pt-pt", "fi", "portugali");
INSERT INTO `wp_icl_languages_translations` VALUES("2579", "pt-pt", "ga", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2580", "pt-pt", "he", "פורטוגזית");
INSERT INTO `wp_icl_languages_translations` VALUES("2581", "pt-pt", "hi", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2582", "pt-pt", "hr", "Portugalski (Portugal)");
INSERT INTO `wp_icl_languages_translations` VALUES("2583", "pt-pt", "hu", "portugál");
INSERT INTO `wp_icl_languages_translations` VALUES("2584", "pt-pt", "hy", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2585", "pt-pt", "id", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2586", "pt-pt", "is", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2587", "pt-pt", "it", "Portoghese, Portogallo");
INSERT INTO `wp_icl_languages_translations` VALUES("2588", "pt-pt", "ja", "ポルトガル語");
INSERT INTO `wp_icl_languages_translations` VALUES("2589", "pt-pt", "ko", "포르투갈 포르투갈어");
INSERT INTO `wp_icl_languages_translations` VALUES("2590", "pt-pt", "ku", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2591", "pt-pt", "lv", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2592", "pt-pt", "lt", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2593", "pt-pt", "mk", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2594", "pt-pt", "mt", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2595", "pt-pt", "mn", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2596", "pt-pt", "ne", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2597", "pt-pt", "nl", "Portugees, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2598", "pt-pt", "no", "Portugisisk (Portugal)");
INSERT INTO `wp_icl_languages_translations` VALUES("2599", "pt-pt", "pa", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2600", "pt-pt", "pl", "portugalski, Portugalia");
INSERT INTO `wp_icl_languages_translations` VALUES("2601", "pt-pt", "pt-pt", "Português");
INSERT INTO `wp_icl_languages_translations` VALUES("2602", "pt-pt", "pt-br", "Português");
INSERT INTO `wp_icl_languages_translations` VALUES("2603", "pt-pt", "qu", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2604", "pt-pt", "ro", "Portugheză (Portugalia)");
INSERT INTO `wp_icl_languages_translations` VALUES("2605", "pt-pt", "ru", "Португальский, Португалия");
INSERT INTO `wp_icl_languages_translations` VALUES("2606", "pt-pt", "sl", "Portugalščina ( Portugalska )");
INSERT INTO `wp_icl_languages_translations` VALUES("2607", "pt-pt", "so", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2608", "pt-pt", "sq", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2609", "pt-pt", "sr", "Португалски (Португалија)");
INSERT INTO `wp_icl_languages_translations` VALUES("2610", "pt-pt", "sv", "Portugisiska, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2611", "pt-pt", "ta", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2612", "pt-pt", "th", "โปรตุเกส");
INSERT INTO `wp_icl_languages_translations` VALUES("2613", "pt-pt", "tr", "Portekizce, Portekiz");
INSERT INTO `wp_icl_languages_translations` VALUES("2614", "pt-pt", "uk", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2615", "pt-pt", "ur", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2616", "pt-pt", "uz", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2617", "pt-pt", "vi", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2618", "pt-pt", "yi", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2619", "pt-pt", "zh-hans", "葡萄牙语（葡萄牙）");
INSERT INTO `wp_icl_languages_translations` VALUES("2620", "pt-pt", "zu", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2621", "pt-pt", "zh-hant", "葡萄牙語（葡萄牙）");
INSERT INTO `wp_icl_languages_translations` VALUES("2622", "pt-pt", "ms", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2623", "pt-pt", "gl", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2624", "pt-pt", "bn", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2625", "pt-br", "en", "Portuguese (Brazil)");
INSERT INTO `wp_icl_languages_translations` VALUES("2626", "pt-br", "es", "Portugués, Brasil");
INSERT INTO `wp_icl_languages_translations` VALUES("2627", "pt-br", "de", "Portugiesisch, Brasilien");
INSERT INTO `wp_icl_languages_translations` VALUES("2628", "pt-br", "fr", "Portugais - du Brésil");
INSERT INTO `wp_icl_languages_translations` VALUES("2629", "pt-br", "ar", "البرتغالية ،البرازيل");
INSERT INTO `wp_icl_languages_translations` VALUES("2630", "pt-br", "bs", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2631", "pt-br", "bg", "Португалски (Бразилия)");
INSERT INTO `wp_icl_languages_translations` VALUES("2632", "pt-br", "ca", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2633", "pt-br", "cs", "Portugalština ( Brazílie)");
INSERT INTO `wp_icl_languages_translations` VALUES("2634", "pt-br", "sk", "Brazílska Portugalština");
INSERT INTO `wp_icl_languages_translations` VALUES("2635", "pt-br", "cy", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2636", "pt-br", "da", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2637", "pt-br", "el", "Πορτογαλικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2638", "pt-br", "eo", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2639", "pt-br", "et", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2640", "pt-br", "eu", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2641", "pt-br", "fa", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2642", "pt-br", "fi", "Brasilian portugali");
INSERT INTO `wp_icl_languages_translations` VALUES("2643", "pt-br", "ga", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2644", "pt-br", "he", "פורטוגזית - ברזיל");
INSERT INTO `wp_icl_languages_translations` VALUES("2645", "pt-br", "hi", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2646", "pt-br", "hr", "Portugalski (Brazil)");
INSERT INTO `wp_icl_languages_translations` VALUES("2647", "pt-br", "hu", "brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2648", "pt-br", "hy", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2649", "pt-br", "id", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2650", "pt-br", "is", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2651", "pt-br", "it", "Portoghese, Brasile");
INSERT INTO `wp_icl_languages_translations` VALUES("2652", "pt-br", "ja", "ポルトガル語（ブラジル）");
INSERT INTO `wp_icl_languages_translations` VALUES("2653", "pt-br", "ko", "브라질 포르투갈어");
INSERT INTO `wp_icl_languages_translations` VALUES("2654", "pt-br", "ku", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2655", "pt-br", "lv", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2656", "pt-br", "lt", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2657", "pt-br", "mk", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2658", "pt-br", "mt", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2659", "pt-br", "mn", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2660", "pt-br", "ne", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2661", "pt-br", "nl", "Portugees, Brazilië");
INSERT INTO `wp_icl_languages_translations` VALUES("2662", "pt-br", "no", "Portugisisk (Brasil)");
INSERT INTO `wp_icl_languages_translations` VALUES("2663", "pt-br", "pa", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2664", "pt-br", "pl", "portugalski, Brazylia");
INSERT INTO `wp_icl_languages_translations` VALUES("2665", "pt-br", "pt-pt", "Português");
INSERT INTO `wp_icl_languages_translations` VALUES("2666", "pt-br", "pt-br", "Português");
INSERT INTO `wp_icl_languages_translations` VALUES("2667", "pt-br", "qu", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2668", "pt-br", "ro", "Portugheză (Brazilia)");
INSERT INTO `wp_icl_languages_translations` VALUES("2669", "pt-br", "ru", "Португальский, Бразилия");
INSERT INTO `wp_icl_languages_translations` VALUES("2670", "pt-br", "sl", "Portugalščina ( Brazilija )");
INSERT INTO `wp_icl_languages_translations` VALUES("2671", "pt-br", "so", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2672", "pt-br", "sq", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2673", "pt-br", "sr", "Португалски (Бразил)");
INSERT INTO `wp_icl_languages_translations` VALUES("2674", "pt-br", "sv", "Portugisiska, Brasilien");
INSERT INTO `wp_icl_languages_translations` VALUES("2675", "pt-br", "ta", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2676", "pt-br", "th", "โปรตุเกสบราซิล");
INSERT INTO `wp_icl_languages_translations` VALUES("2677", "pt-br", "tr", "Portekizce, Brezilya");
INSERT INTO `wp_icl_languages_translations` VALUES("2678", "pt-br", "uk", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2679", "pt-br", "ur", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2680", "pt-br", "uz", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2681", "pt-br", "vi", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2682", "pt-br", "yi", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2683", "pt-br", "zh-hans", "葡萄牙语（巴西）");
INSERT INTO `wp_icl_languages_translations` VALUES("2684", "pt-br", "zu", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2685", "pt-br", "zh-hant", "葡萄牙語（巴西）");
INSERT INTO `wp_icl_languages_translations` VALUES("2686", "pt-br", "ms", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2687", "pt-br", "gl", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2688", "pt-br", "bn", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2689", "qu", "en", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2690", "qu", "es", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2691", "qu", "de", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2692", "qu", "fr", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2693", "qu", "ar", "الكويتشوا");
INSERT INTO `wp_icl_languages_translations` VALUES("2694", "qu", "bs", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2695", "qu", "bg", "Кечуа");
INSERT INTO `wp_icl_languages_translations` VALUES("2696", "qu", "ca", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2697", "qu", "cs", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2698", "qu", "sk", "Jazyk Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2699", "qu", "cy", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2700", "qu", "da", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2701", "qu", "el", "Κετσουα");
INSERT INTO `wp_icl_languages_translations` VALUES("2702", "qu", "eo", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2703", "qu", "et", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2704", "qu", "eu", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2705", "qu", "fa", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2706", "qu", "fi", "ketsua");
INSERT INTO `wp_icl_languages_translations` VALUES("2707", "qu", "ga", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2708", "qu", "he", "קצ\'ואה");
INSERT INTO `wp_icl_languages_translations` VALUES("2709", "qu", "hi", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2710", "qu", "hr", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2711", "qu", "hu", "quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2712", "qu", "hy", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2713", "qu", "id", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2714", "qu", "is", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2715", "qu", "it", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2716", "qu", "ja", "ケチュア語");
INSERT INTO `wp_icl_languages_translations` VALUES("2717", "qu", "ko", "케추아어");
INSERT INTO `wp_icl_languages_translations` VALUES("2718", "qu", "ku", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2719", "qu", "lv", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2720", "qu", "lt", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2721", "qu", "mk", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2722", "qu", "mt", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2723", "qu", "mn", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2724", "qu", "ne", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2725", "qu", "nl", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2726", "qu", "no", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2727", "qu", "pa", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2728", "qu", "pl", "keczua");
INSERT INTO `wp_icl_languages_translations` VALUES("2729", "qu", "pt-pt", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2730", "qu", "pt-br", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2731", "qu", "qu", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2732", "qu", "ro", "Quechuană");
INSERT INTO `wp_icl_languages_translations` VALUES("2733", "qu", "ru", "Кечуа");
INSERT INTO `wp_icl_languages_translations` VALUES("2734", "qu", "sl", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2735", "qu", "so", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2736", "qu", "sq", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2737", "qu", "sr", "Кечуа");
INSERT INTO `wp_icl_languages_translations` VALUES("2738", "qu", "sv", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2739", "qu", "ta", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2740", "qu", "th", "คิวชัว");
INSERT INTO `wp_icl_languages_translations` VALUES("2741", "qu", "tr", "Quechua dili");
INSERT INTO `wp_icl_languages_translations` VALUES("2742", "qu", "uk", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2743", "qu", "ur", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2744", "qu", "uz", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2745", "qu", "vi", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2746", "qu", "yi", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2747", "qu", "zh-hans", "盖丘亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("2748", "qu", "zu", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2749", "qu", "zh-hant", "蓋丘亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("2750", "qu", "ms", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2751", "qu", "gl", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2752", "qu", "bn", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2753", "ro", "en", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2754", "ro", "es", "Rumano");
INSERT INTO `wp_icl_languages_translations` VALUES("2755", "ro", "de", "Rumänisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2756", "ro", "fr", "Roumain");
INSERT INTO `wp_icl_languages_translations` VALUES("2757", "ro", "ar", "الرومانية");
INSERT INTO `wp_icl_languages_translations` VALUES("2758", "ro", "bs", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2759", "ro", "bg", "Румънски");
INSERT INTO `wp_icl_languages_translations` VALUES("2760", "ro", "ca", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2761", "ro", "cs", "Rumunština");
INSERT INTO `wp_icl_languages_translations` VALUES("2762", "ro", "sk", "Rumunčina");
INSERT INTO `wp_icl_languages_translations` VALUES("2763", "ro", "cy", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2764", "ro", "da", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2765", "ro", "el", "Ρουμανικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2766", "ro", "eo", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2767", "ro", "et", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2768", "ro", "eu", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2769", "ro", "fa", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2770", "ro", "fi", "romania");
INSERT INTO `wp_icl_languages_translations` VALUES("2771", "ro", "ga", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2772", "ro", "he", "רומנית");
INSERT INTO `wp_icl_languages_translations` VALUES("2773", "ro", "hi", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2774", "ro", "hr", "Rumunjski");
INSERT INTO `wp_icl_languages_translations` VALUES("2775", "ro", "hu", "román");
INSERT INTO `wp_icl_languages_translations` VALUES("2776", "ro", "hy", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2777", "ro", "id", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2778", "ro", "is", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2779", "ro", "it", "Rumeno");
INSERT INTO `wp_icl_languages_translations` VALUES("2780", "ro", "ja", "ルーマニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("2781", "ro", "ko", "로마니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("2782", "ro", "ku", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2783", "ro", "lv", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2784", "ro", "lt", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2785", "ro", "mk", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2786", "ro", "mt", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2787", "ro", "mn", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2788", "ro", "ne", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2789", "ro", "nl", "Roemeens");
INSERT INTO `wp_icl_languages_translations` VALUES("2790", "ro", "no", "Rumensk");
INSERT INTO `wp_icl_languages_translations` VALUES("2791", "ro", "pa", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2792", "ro", "pl", "rumuński");
INSERT INTO `wp_icl_languages_translations` VALUES("2793", "ro", "pt-pt", "Romeno");
INSERT INTO `wp_icl_languages_translations` VALUES("2794", "ro", "pt-br", "Romeno");
INSERT INTO `wp_icl_languages_translations` VALUES("2795", "ro", "qu", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2796", "ro", "ro", "Română");
INSERT INTO `wp_icl_languages_translations` VALUES("2797", "ro", "ru", "Румынский");
INSERT INTO `wp_icl_languages_translations` VALUES("2798", "ro", "sl", "Romunščina");
INSERT INTO `wp_icl_languages_translations` VALUES("2799", "ro", "so", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2800", "ro", "sq", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2801", "ro", "sr", "румунски");
INSERT INTO `wp_icl_languages_translations` VALUES("2802", "ro", "sv", "Rumänska");
INSERT INTO `wp_icl_languages_translations` VALUES("2803", "ro", "ta", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2804", "ro", "th", "โรมาเนีย");
INSERT INTO `wp_icl_languages_translations` VALUES("2805", "ro", "tr", "Rumence");
INSERT INTO `wp_icl_languages_translations` VALUES("2806", "ro", "uk", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2807", "ro", "ur", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2808", "ro", "uz", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2809", "ro", "vi", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2810", "ro", "yi", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2811", "ro", "zh-hans", "罗马尼亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("2812", "ro", "zu", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2813", "ro", "zh-hant", "羅馬尼亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("2814", "ro", "ms", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2815", "ro", "gl", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2816", "ro", "bn", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2817", "ru", "en", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2818", "ru", "es", "Ruso");
INSERT INTO `wp_icl_languages_translations` VALUES("2819", "ru", "de", "Russisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2820", "ru", "fr", "Russe");
INSERT INTO `wp_icl_languages_translations` VALUES("2821", "ru", "ar", "الروسية");
INSERT INTO `wp_icl_languages_translations` VALUES("2822", "ru", "bs", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2823", "ru", "bg", "Руски");
INSERT INTO `wp_icl_languages_translations` VALUES("2824", "ru", "ca", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2825", "ru", "cs", "Ruský");
INSERT INTO `wp_icl_languages_translations` VALUES("2826", "ru", "sk", "Ruština");
INSERT INTO `wp_icl_languages_translations` VALUES("2827", "ru", "cy", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2828", "ru", "da", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2829", "ru", "el", "Ρωσικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2830", "ru", "eo", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2831", "ru", "et", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2832", "ru", "eu", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2833", "ru", "fa", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2834", "ru", "fi", "venäjä");
INSERT INTO `wp_icl_languages_translations` VALUES("2835", "ru", "ga", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2836", "ru", "he", "רוסית");
INSERT INTO `wp_icl_languages_translations` VALUES("2837", "ru", "hi", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2838", "ru", "hr", "Ruski");
INSERT INTO `wp_icl_languages_translations` VALUES("2839", "ru", "hu", "orosz");
INSERT INTO `wp_icl_languages_translations` VALUES("2840", "ru", "hy", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2841", "ru", "id", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2842", "ru", "is", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2843", "ru", "it", "Russo");
INSERT INTO `wp_icl_languages_translations` VALUES("2844", "ru", "ja", "ロシア語");
INSERT INTO `wp_icl_languages_translations` VALUES("2845", "ru", "ko", "러시아어");
INSERT INTO `wp_icl_languages_translations` VALUES("2846", "ru", "ku", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2847", "ru", "lv", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2848", "ru", "lt", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2849", "ru", "mk", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2850", "ru", "mt", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2851", "ru", "mn", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2852", "ru", "ne", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2853", "ru", "nl", "Russisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2854", "ru", "no", "Russisk");
INSERT INTO `wp_icl_languages_translations` VALUES("2855", "ru", "pa", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2856", "ru", "pl", "rosyjski");
INSERT INTO `wp_icl_languages_translations` VALUES("2857", "ru", "pt-pt", "Russo");
INSERT INTO `wp_icl_languages_translations` VALUES("2858", "ru", "pt-br", "Russo");
INSERT INTO `wp_icl_languages_translations` VALUES("2859", "ru", "qu", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2860", "ru", "ro", "Rusă");
INSERT INTO `wp_icl_languages_translations` VALUES("2861", "ru", "ru", "Русский");
INSERT INTO `wp_icl_languages_translations` VALUES("2862", "ru", "sl", "Ruščina");
INSERT INTO `wp_icl_languages_translations` VALUES("2863", "ru", "so", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2864", "ru", "sq", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2865", "ru", "sr", "руски");
INSERT INTO `wp_icl_languages_translations` VALUES("2866", "ru", "sv", "Ryska");
INSERT INTO `wp_icl_languages_translations` VALUES("2867", "ru", "ta", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2868", "ru", "th", "รัสเซีย");
INSERT INTO `wp_icl_languages_translations` VALUES("2869", "ru", "tr", "Rusça");
INSERT INTO `wp_icl_languages_translations` VALUES("2870", "ru", "uk", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2871", "ru", "ur", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2872", "ru", "uz", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2873", "ru", "vi", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2874", "ru", "yi", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2875", "ru", "zh-hans", "俄语");
INSERT INTO `wp_icl_languages_translations` VALUES("2876", "ru", "zu", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2877", "ru", "zh-hant", "俄語");
INSERT INTO `wp_icl_languages_translations` VALUES("2878", "ru", "ms", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2879", "ru", "gl", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2880", "ru", "bn", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2881", "sl", "en", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2882", "sl", "es", "Esloveno");
INSERT INTO `wp_icl_languages_translations` VALUES("2883", "sl", "de", "Slowenisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2884", "sl", "fr", "Slovène");
INSERT INTO `wp_icl_languages_translations` VALUES("2885", "sl", "ar", "السلوفانية");
INSERT INTO `wp_icl_languages_translations` VALUES("2886", "sl", "bs", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2887", "sl", "bg", "Словенски");
INSERT INTO `wp_icl_languages_translations` VALUES("2888", "sl", "ca", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2889", "sl", "cs", "Slovinština");
INSERT INTO `wp_icl_languages_translations` VALUES("2890", "sl", "sk", "Slovinčina");
INSERT INTO `wp_icl_languages_translations` VALUES("2891", "sl", "cy", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2892", "sl", "da", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2893", "sl", "el", "Σλοβενικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2894", "sl", "eo", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2895", "sl", "et", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2896", "sl", "eu", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2897", "sl", "fa", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2898", "sl", "fi", "sloveeni");
INSERT INTO `wp_icl_languages_translations` VALUES("2899", "sl", "ga", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2900", "sl", "he", "סלובנית");
INSERT INTO `wp_icl_languages_translations` VALUES("2901", "sl", "hi", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2902", "sl", "hr", "Slovenac");
INSERT INTO `wp_icl_languages_translations` VALUES("2903", "sl", "hu", "szlovén");
INSERT INTO `wp_icl_languages_translations` VALUES("2904", "sl", "hy", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2905", "sl", "id", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2906", "sl", "is", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2907", "sl", "it", "Sloveno");
INSERT INTO `wp_icl_languages_translations` VALUES("2908", "sl", "ja", "スロベニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("2909", "sl", "ko", "슬로베니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("2910", "sl", "ku", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2911", "sl", "lv", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2912", "sl", "lt", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2913", "sl", "mk", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2914", "sl", "mt", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2915", "sl", "mn", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2916", "sl", "ne", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2917", "sl", "nl", "Sloveens");
INSERT INTO `wp_icl_languages_translations` VALUES("2918", "sl", "no", "Slovensk");
INSERT INTO `wp_icl_languages_translations` VALUES("2919", "sl", "pa", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2920", "sl", "pl", "słoweński");
INSERT INTO `wp_icl_languages_translations` VALUES("2921", "sl", "pt-pt", "Esloveno");
INSERT INTO `wp_icl_languages_translations` VALUES("2922", "sl", "pt-br", "Esloveno");
INSERT INTO `wp_icl_languages_translations` VALUES("2923", "sl", "qu", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2924", "sl", "ro", "Slovenă");
INSERT INTO `wp_icl_languages_translations` VALUES("2925", "sl", "ru", "Словенский");
INSERT INTO `wp_icl_languages_translations` VALUES("2926", "sl", "sl", "Slovenščina");
INSERT INTO `wp_icl_languages_translations` VALUES("2927", "sl", "so", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2928", "sl", "sq", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2929", "sl", "sr", "словеначки");
INSERT INTO `wp_icl_languages_translations` VALUES("2930", "sl", "sv", "Slovenska");
INSERT INTO `wp_icl_languages_translations` VALUES("2931", "sl", "ta", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2932", "sl", "th", "สโลวีเนียน");
INSERT INTO `wp_icl_languages_translations` VALUES("2933", "sl", "tr", "Sloven dili");
INSERT INTO `wp_icl_languages_translations` VALUES("2934", "sl", "uk", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2935", "sl", "ur", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2936", "sl", "uz", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2937", "sl", "vi", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2938", "sl", "yi", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2939", "sl", "zh-hans", "斯洛文尼亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("2940", "sl", "zu", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2941", "sl", "zh-hant", "斯洛文尼亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("2942", "sl", "ms", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2943", "sl", "gl", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2944", "sl", "bn", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2945", "so", "en", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2946", "so", "es", "Somalí");
INSERT INTO `wp_icl_languages_translations` VALUES("2947", "so", "de", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2948", "so", "fr", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2949", "so", "ar", "الصومالية");
INSERT INTO `wp_icl_languages_translations` VALUES("2950", "so", "bs", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2951", "so", "bg", "Сомалийски");
INSERT INTO `wp_icl_languages_translations` VALUES("2952", "so", "ca", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2953", "so", "cs", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2954", "so", "sk", "Somálčina");
INSERT INTO `wp_icl_languages_translations` VALUES("2955", "so", "cy", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2956", "so", "da", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2957", "so", "el", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2958", "so", "eo", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2959", "so", "et", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2960", "so", "eu", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2961", "so", "fa", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2962", "so", "fi", "somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2963", "so", "ga", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2964", "so", "he", "סומלית");
INSERT INTO `wp_icl_languages_translations` VALUES("2965", "so", "hi", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2966", "so", "hr", "Somalijski");
INSERT INTO `wp_icl_languages_translations` VALUES("2967", "so", "hu", "szomáli");
INSERT INTO `wp_icl_languages_translations` VALUES("2968", "so", "hy", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2969", "so", "id", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2970", "so", "is", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2971", "so", "it", "Somalo");
INSERT INTO `wp_icl_languages_translations` VALUES("2972", "so", "ja", "ソマリ語");
INSERT INTO `wp_icl_languages_translations` VALUES("2973", "so", "ko", "소말리아어");
INSERT INTO `wp_icl_languages_translations` VALUES("2974", "so", "ku", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2975", "so", "lv", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2976", "so", "lt", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2977", "so", "mk", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2978", "so", "mt", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2979", "so", "mn", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2980", "so", "ne", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2981", "so", "nl", "Somalisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2982", "so", "no", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2983", "so", "pa", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2984", "so", "pl", "somalijski");
INSERT INTO `wp_icl_languages_translations` VALUES("2985", "so", "pt-pt", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2986", "so", "pt-br", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2987", "so", "qu", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2988", "so", "ro", "Somaleză");
INSERT INTO `wp_icl_languages_translations` VALUES("2989", "so", "ru", "Сомалийский");
INSERT INTO `wp_icl_languages_translations` VALUES("2990", "so", "sl", "Somalski");
INSERT INTO `wp_icl_languages_translations` VALUES("2991", "so", "so", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2992", "so", "sq", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2993", "so", "sr", "Сомалијски");
INSERT INTO `wp_icl_languages_translations` VALUES("2994", "so", "sv", "Somaliska");
INSERT INTO `wp_icl_languages_translations` VALUES("2995", "so", "ta", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2996", "so", "th", "โซมาลี");
INSERT INTO `wp_icl_languages_translations` VALUES("2997", "so", "tr", "Somalice");
INSERT INTO `wp_icl_languages_translations` VALUES("2998", "so", "uk", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2999", "so", "ur", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3000", "so", "uz", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3001", "so", "vi", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3002", "so", "yi", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3003", "so", "zh-hans", "索马里语");
INSERT INTO `wp_icl_languages_translations` VALUES("3004", "so", "zu", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3005", "so", "zh-hant", "索馬里語");
INSERT INTO `wp_icl_languages_translations` VALUES("3006", "so", "ms", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3007", "so", "gl", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3008", "so", "bn", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3009", "sq", "en", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3010", "sq", "es", "Albanés");
INSERT INTO `wp_icl_languages_translations` VALUES("3011", "sq", "de", "Albanisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3012", "sq", "fr", "Albanais");
INSERT INTO `wp_icl_languages_translations` VALUES("3013", "sq", "ar", "الألبانية");
INSERT INTO `wp_icl_languages_translations` VALUES("3014", "sq", "bs", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3015", "sq", "bg", "Албански");
INSERT INTO `wp_icl_languages_translations` VALUES("3016", "sq", "ca", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3017", "sq", "cs", "Albánský");
INSERT INTO `wp_icl_languages_translations` VALUES("3018", "sq", "sk", "Albánčina");
INSERT INTO `wp_icl_languages_translations` VALUES("3019", "sq", "cy", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3020", "sq", "da", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3021", "sq", "el", "Αλβανικα");
INSERT INTO `wp_icl_languages_translations` VALUES("3022", "sq", "eo", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3023", "sq", "et", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3024", "sq", "eu", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3025", "sq", "fa", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3026", "sq", "fi", "albania");
INSERT INTO `wp_icl_languages_translations` VALUES("3027", "sq", "ga", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3028", "sq", "he", "אלבנית");
INSERT INTO `wp_icl_languages_translations` VALUES("3029", "sq", "hi", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3030", "sq", "hr", "Albanac");
INSERT INTO `wp_icl_languages_translations` VALUES("3031", "sq", "hu", "albán");
INSERT INTO `wp_icl_languages_translations` VALUES("3032", "sq", "hy", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3033", "sq", "id", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3034", "sq", "is", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3035", "sq", "it", "Albanese");
INSERT INTO `wp_icl_languages_translations` VALUES("3036", "sq", "ja", "アルバニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("3037", "sq", "ko", "알바니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("3038", "sq", "ku", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3039", "sq", "lv", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3040", "sq", "lt", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3041", "sq", "mk", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3042", "sq", "mt", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3043", "sq", "mn", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3044", "sq", "ne", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3045", "sq", "nl", "Albaans");
INSERT INTO `wp_icl_languages_translations` VALUES("3046", "sq", "no", "Albansk");
INSERT INTO `wp_icl_languages_translations` VALUES("3047", "sq", "pa", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3048", "sq", "pl", "albański");
INSERT INTO `wp_icl_languages_translations` VALUES("3049", "sq", "pt-pt", "Albanês");
INSERT INTO `wp_icl_languages_translations` VALUES("3050", "sq", "pt-br", "Albanês");
INSERT INTO `wp_icl_languages_translations` VALUES("3051", "sq", "qu", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3052", "sq", "ro", "Albaneză");
INSERT INTO `wp_icl_languages_translations` VALUES("3053", "sq", "ru", "Албанский");
INSERT INTO `wp_icl_languages_translations` VALUES("3054", "sq", "sl", "Albanski");
INSERT INTO `wp_icl_languages_translations` VALUES("3055", "sq", "so", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3056", "sq", "sq", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3057", "sq", "sr", "албански");
INSERT INTO `wp_icl_languages_translations` VALUES("3058", "sq", "sv", "Albanska");
INSERT INTO `wp_icl_languages_translations` VALUES("3059", "sq", "ta", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3060", "sq", "th", "อัลเบเนีย");
INSERT INTO `wp_icl_languages_translations` VALUES("3061", "sq", "tr", "Arnavutça");
INSERT INTO `wp_icl_languages_translations` VALUES("3062", "sq", "uk", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3063", "sq", "ur", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3064", "sq", "uz", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3065", "sq", "vi", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3066", "sq", "yi", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3067", "sq", "zh-hans", "阿尔巴尼亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("3068", "sq", "zu", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3069", "sq", "zh-hant", "阿爾巴尼亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("3070", "sq", "ms", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3071", "sq", "gl", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3072", "sq", "bn", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3073", "sr", "en", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3074", "sr", "es", "Serbio");
INSERT INTO `wp_icl_languages_translations` VALUES("3075", "sr", "de", "Serbisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3076", "sr", "fr", "Serbe");
INSERT INTO `wp_icl_languages_translations` VALUES("3077", "sr", "ar", "الصربية");
INSERT INTO `wp_icl_languages_translations` VALUES("3078", "sr", "bs", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3079", "sr", "bg", "Сръбски");
INSERT INTO `wp_icl_languages_translations` VALUES("3080", "sr", "ca", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3081", "sr", "cs", "Srbský");
INSERT INTO `wp_icl_languages_translations` VALUES("3082", "sr", "sk", "Srbština");
INSERT INTO `wp_icl_languages_translations` VALUES("3083", "sr", "cy", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3084", "sr", "da", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3085", "sr", "el", "Σερβικα");
INSERT INTO `wp_icl_languages_translations` VALUES("3086", "sr", "eo", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3087", "sr", "et", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3088", "sr", "eu", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3089", "sr", "fa", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3090", "sr", "fi", "serbia");
INSERT INTO `wp_icl_languages_translations` VALUES("3091", "sr", "ga", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3092", "sr", "he", "סרבית");
INSERT INTO `wp_icl_languages_translations` VALUES("3093", "sr", "hi", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3094", "sr", "hr", "Srpski");
INSERT INTO `wp_icl_languages_translations` VALUES("3095", "sr", "hu", "szerb");
INSERT INTO `wp_icl_languages_translations` VALUES("3096", "sr", "hy", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3097", "sr", "id", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3098", "sr", "is", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3099", "sr", "it", "Serbo");
INSERT INTO `wp_icl_languages_translations` VALUES("3100", "sr", "ja", "セルビア語");
INSERT INTO `wp_icl_languages_translations` VALUES("3101", "sr", "ko", "세르비아어");
INSERT INTO `wp_icl_languages_translations` VALUES("3102", "sr", "ku", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3103", "sr", "lv", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3104", "sr", "lt", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3105", "sr", "mk", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3106", "sr", "mt", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3107", "sr", "mn", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3108", "sr", "ne", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3109", "sr", "nl", "Servisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3110", "sr", "no", "Serbisk");
INSERT INTO `wp_icl_languages_translations` VALUES("3111", "sr", "pa", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3112", "sr", "pl", "serbski");
INSERT INTO `wp_icl_languages_translations` VALUES("3113", "sr", "pt-pt", "Sérvio");
INSERT INTO `wp_icl_languages_translations` VALUES("3114", "sr", "pt-br", "Sérvio");
INSERT INTO `wp_icl_languages_translations` VALUES("3115", "sr", "qu", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3116", "sr", "ro", "Sârbă");
INSERT INTO `wp_icl_languages_translations` VALUES("3117", "sr", "ru", "Сербский");
INSERT INTO `wp_icl_languages_translations` VALUES("3118", "sr", "sl", "Srbski");
INSERT INTO `wp_icl_languages_translations` VALUES("3119", "sr", "so", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3120", "sr", "sq", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3121", "sr", "sr", "српски");
INSERT INTO `wp_icl_languages_translations` VALUES("3122", "sr", "sv", "Serbiska");
INSERT INTO `wp_icl_languages_translations` VALUES("3123", "sr", "ta", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3124", "sr", "th", "เซอร์เบีย");
INSERT INTO `wp_icl_languages_translations` VALUES("3125", "sr", "tr", "Sırpça");
INSERT INTO `wp_icl_languages_translations` VALUES("3126", "sr", "uk", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3127", "sr", "ur", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3128", "sr", "uz", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3129", "sr", "vi", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3130", "sr", "yi", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3131", "sr", "zh-hans", "赛尔维亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("3132", "sr", "zu", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3133", "sr", "zh-hant", "賽爾維亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("3134", "sr", "ms", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3135", "sr", "gl", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3136", "sr", "bn", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3137", "sv", "en", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3138", "sv", "es", "Sueco");
INSERT INTO `wp_icl_languages_translations` VALUES("3139", "sv", "de", "Schwedisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3140", "sv", "fr", "Suédois");
INSERT INTO `wp_icl_languages_translations` VALUES("3141", "sv", "ar", "السويدية");
INSERT INTO `wp_icl_languages_translations` VALUES("3142", "sv", "bs", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3143", "sv", "bg", "Шведски");
INSERT INTO `wp_icl_languages_translations` VALUES("3144", "sv", "ca", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3145", "sv", "cs", "Švédský");
INSERT INTO `wp_icl_languages_translations` VALUES("3146", "sv", "sk", "Švédština");
INSERT INTO `wp_icl_languages_translations` VALUES("3147", "sv", "cy", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3148", "sv", "da", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3149", "sv", "el", "Σουηδικη");
INSERT INTO `wp_icl_languages_translations` VALUES("3150", "sv", "eo", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3151", "sv", "et", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3152", "sv", "eu", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3153", "sv", "fa", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3154", "sv", "fi", "ruotsi");
INSERT INTO `wp_icl_languages_translations` VALUES("3155", "sv", "ga", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3156", "sv", "he", "שוודית");
INSERT INTO `wp_icl_languages_translations` VALUES("3157", "sv", "hi", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3158", "sv", "hr", "švedski");
INSERT INTO `wp_icl_languages_translations` VALUES("3159", "sv", "hu", "svéd");
INSERT INTO `wp_icl_languages_translations` VALUES("3160", "sv", "hy", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3161", "sv", "id", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3162", "sv", "is", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3163", "sv", "it", "Svedese");
INSERT INTO `wp_icl_languages_translations` VALUES("3164", "sv", "ja", "スウェーデン語");
INSERT INTO `wp_icl_languages_translations` VALUES("3165", "sv", "ko", "스웨덴어");
INSERT INTO `wp_icl_languages_translations` VALUES("3166", "sv", "ku", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3167", "sv", "lv", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3168", "sv", "lt", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3169", "sv", "mk", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3170", "sv", "mt", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3171", "sv", "mn", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3172", "sv", "ne", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3173", "sv", "nl", "Zweeds");
INSERT INTO `wp_icl_languages_translations` VALUES("3174", "sv", "no", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3175", "sv", "pa", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3176", "sv", "pl", "szwedzki");
INSERT INTO `wp_icl_languages_translations` VALUES("3177", "sv", "pt-pt", "Sueco");
INSERT INTO `wp_icl_languages_translations` VALUES("3178", "sv", "pt-br", "Sueco");
INSERT INTO `wp_icl_languages_translations` VALUES("3179", "sv", "qu", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3180", "sv", "ro", "Suedeză");
INSERT INTO `wp_icl_languages_translations` VALUES("3181", "sv", "ru", "Шведский");
INSERT INTO `wp_icl_languages_translations` VALUES("3182", "sv", "sl", "Švedščina");
INSERT INTO `wp_icl_languages_translations` VALUES("3183", "sv", "so", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3184", "sv", "sq", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3185", "sv", "sr", "шведски");
INSERT INTO `wp_icl_languages_translations` VALUES("3186", "sv", "sv", "Svenska");
INSERT INTO `wp_icl_languages_translations` VALUES("3187", "sv", "ta", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3188", "sv", "th", "สวีเดน");
INSERT INTO `wp_icl_languages_translations` VALUES("3189", "sv", "tr", "İsveççe");
INSERT INTO `wp_icl_languages_translations` VALUES("3190", "sv", "uk", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3191", "sv", "ur", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3192", "sv", "uz", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3193", "sv", "vi", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3194", "sv", "yi", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3195", "sv", "zh-hans", "瑞典语");
INSERT INTO `wp_icl_languages_translations` VALUES("3196", "sv", "zu", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3197", "sv", "zh-hant", "瑞典語");
INSERT INTO `wp_icl_languages_translations` VALUES("3198", "sv", "ms", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3199", "sv", "gl", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3200", "sv", "bn", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3201", "ta", "en", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3202", "ta", "es", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3203", "ta", "de", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3204", "ta", "fr", "Tamoul");
INSERT INTO `wp_icl_languages_translations` VALUES("3205", "ta", "ar", "التاميلية");
INSERT INTO `wp_icl_languages_translations` VALUES("3206", "ta", "bs", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3207", "ta", "bg", "Тамилски");
INSERT INTO `wp_icl_languages_translations` VALUES("3208", "ta", "ca", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3209", "ta", "cs", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3210", "ta", "sk", "Tamilčina");
INSERT INTO `wp_icl_languages_translations` VALUES("3211", "ta", "cy", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3212", "ta", "da", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3213", "ta", "el", "Ταμιλ");
INSERT INTO `wp_icl_languages_translations` VALUES("3214", "ta", "eo", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3215", "ta", "et", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3216", "ta", "eu", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3217", "ta", "fa", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3218", "ta", "fi", "tamili");
INSERT INTO `wp_icl_languages_translations` VALUES("3219", "ta", "ga", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3220", "ta", "he", "טמילית");
INSERT INTO `wp_icl_languages_translations` VALUES("3221", "ta", "hi", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3222", "ta", "hr", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3223", "ta", "hu", "tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3224", "ta", "hy", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3225", "ta", "id", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3226", "ta", "is", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3227", "ta", "it", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3228", "ta", "ja", "タミル語");
INSERT INTO `wp_icl_languages_translations` VALUES("3229", "ta", "ko", "타밀어");
INSERT INTO `wp_icl_languages_translations` VALUES("3230", "ta", "ku", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3231", "ta", "lv", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3232", "ta", "lt", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3233", "ta", "mk", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3234", "ta", "mt", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3235", "ta", "mn", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3236", "ta", "ne", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3237", "ta", "nl", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3238", "ta", "no", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3239", "ta", "pa", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3240", "ta", "pl", "tamilski");
INSERT INTO `wp_icl_languages_translations` VALUES("3241", "ta", "pt-pt", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3242", "ta", "pt-br", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3243", "ta", "qu", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3244", "ta", "ro", "Tamilă");
INSERT INTO `wp_icl_languages_translations` VALUES("3245", "ta", "ru", "Тамильский");
INSERT INTO `wp_icl_languages_translations` VALUES("3246", "ta", "sl", "Tamilščina");
INSERT INTO `wp_icl_languages_translations` VALUES("3247", "ta", "so", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3248", "ta", "sq", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3249", "ta", "sr", "тамилски");
INSERT INTO `wp_icl_languages_translations` VALUES("3250", "ta", "sv", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3251", "ta", "ta", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3252", "ta", "th", "ทมิฬ");
INSERT INTO `wp_icl_languages_translations` VALUES("3253", "ta", "tr", "Tamil dili");
INSERT INTO `wp_icl_languages_translations` VALUES("3254", "ta", "uk", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3255", "ta", "ur", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3256", "ta", "uz", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3257", "ta", "vi", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3258", "ta", "yi", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3259", "ta", "zh-hans", "泰米尔语");
INSERT INTO `wp_icl_languages_translations` VALUES("3260", "ta", "zu", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3261", "ta", "zh-hant", "泰米爾語");
INSERT INTO `wp_icl_languages_translations` VALUES("3262", "ta", "ms", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3263", "ta", "gl", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3264", "ta", "bn", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3265", "th", "en", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3266", "th", "es", "Tailandés");
INSERT INTO `wp_icl_languages_translations` VALUES("3267", "th", "de", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3268", "th", "fr", "Thaï");
INSERT INTO `wp_icl_languages_translations` VALUES("3269", "th", "ar", "التايلندية");
INSERT INTO `wp_icl_languages_translations` VALUES("3270", "th", "bs", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3271", "th", "bg", "Тайски");
INSERT INTO `wp_icl_languages_translations` VALUES("3272", "th", "ca", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3273", "th", "cs", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3274", "th", "sk", "Thajština");
INSERT INTO `wp_icl_languages_translations` VALUES("3275", "th", "cy", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3276", "th", "da", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3277", "th", "el", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3278", "th", "eo", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3279", "th", "et", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3280", "th", "eu", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3281", "th", "fa", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3282", "th", "fi", "thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3283", "th", "ga", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3284", "th", "he", "תאילנדית");
INSERT INTO `wp_icl_languages_translations` VALUES("3285", "th", "hi", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3286", "th", "hr", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3287", "th", "hu", "tájföldi");
INSERT INTO `wp_icl_languages_translations` VALUES("3288", "th", "hy", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3289", "th", "id", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3290", "th", "is", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3291", "th", "it", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3292", "th", "ja", "タイ語");
INSERT INTO `wp_icl_languages_translations` VALUES("3293", "th", "ko", "태국어");
INSERT INTO `wp_icl_languages_translations` VALUES("3294", "th", "ku", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3295", "th", "lv", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3296", "th", "lt", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3297", "th", "mk", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3298", "th", "mt", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3299", "th", "mn", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3300", "th", "ne", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3301", "th", "nl", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3302", "th", "no", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3303", "th", "pa", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3304", "th", "pl", "tajski");
INSERT INTO `wp_icl_languages_translations` VALUES("3305", "th", "pt-pt", "Tailandês");
INSERT INTO `wp_icl_languages_translations` VALUES("3306", "th", "pt-br", "Tailandês");
INSERT INTO `wp_icl_languages_translations` VALUES("3307", "th", "qu", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3308", "th", "ro", "Tailandeză");
INSERT INTO `wp_icl_languages_translations` VALUES("3309", "th", "ru", "Тайский");
INSERT INTO `wp_icl_languages_translations` VALUES("3310", "th", "sl", "Tajski");
INSERT INTO `wp_icl_languages_translations` VALUES("3311", "th", "so", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3312", "th", "sq", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3313", "th", "sr", "Тајландски");
INSERT INTO `wp_icl_languages_translations` VALUES("3314", "th", "sv", "Thailändska");
INSERT INTO `wp_icl_languages_translations` VALUES("3315", "th", "ta", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3316", "th", "th", "ไทย");
INSERT INTO `wp_icl_languages_translations` VALUES("3317", "th", "tr", "Tayca");
INSERT INTO `wp_icl_languages_translations` VALUES("3318", "th", "uk", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3319", "th", "ur", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3320", "th", "uz", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3321", "th", "vi", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3322", "th", "yi", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3323", "th", "zh-hans", "泰语");
INSERT INTO `wp_icl_languages_translations` VALUES("3324", "th", "zu", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3325", "th", "zh-hant", "泰語");
INSERT INTO `wp_icl_languages_translations` VALUES("3326", "th", "ms", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3327", "th", "gl", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3328", "th", "bn", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3329", "tr", "en", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3330", "tr", "es", "Turco");
INSERT INTO `wp_icl_languages_translations` VALUES("3331", "tr", "de", "Türkisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3332", "tr", "fr", "Turc");
INSERT INTO `wp_icl_languages_translations` VALUES("3333", "tr", "ar", "التركية");
INSERT INTO `wp_icl_languages_translations` VALUES("3334", "tr", "bs", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3335", "tr", "bg", "Турски");
INSERT INTO `wp_icl_languages_translations` VALUES("3336", "tr", "ca", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3337", "tr", "cs", "Turečtina");
INSERT INTO `wp_icl_languages_translations` VALUES("3338", "tr", "sk", "Turečtina");
INSERT INTO `wp_icl_languages_translations` VALUES("3339", "tr", "cy", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3340", "tr", "da", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3341", "tr", "el", "Τουρκικα");
INSERT INTO `wp_icl_languages_translations` VALUES("3342", "tr", "eo", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3343", "tr", "et", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3344", "tr", "eu", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3345", "tr", "fa", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3346", "tr", "fi", "turkki");
INSERT INTO `wp_icl_languages_translations` VALUES("3347", "tr", "ga", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3348", "tr", "he", "תורכית");
INSERT INTO `wp_icl_languages_translations` VALUES("3349", "tr", "hi", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3350", "tr", "hr", "Turski");
INSERT INTO `wp_icl_languages_translations` VALUES("3351", "tr", "hu", "török");
INSERT INTO `wp_icl_languages_translations` VALUES("3352", "tr", "hy", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3353", "tr", "id", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3354", "tr", "is", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3355", "tr", "it", "Turco");
INSERT INTO `wp_icl_languages_translations` VALUES("3356", "tr", "ja", "トルコ語");
INSERT INTO `wp_icl_languages_translations` VALUES("3357", "tr", "ko", "터어키어");
INSERT INTO `wp_icl_languages_translations` VALUES("3358", "tr", "ku", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3359", "tr", "lv", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3360", "tr", "lt", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3361", "tr", "mk", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3362", "tr", "mt", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3363", "tr", "mn", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3364", "tr", "ne", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3365", "tr", "nl", "Turks");
INSERT INTO `wp_icl_languages_translations` VALUES("3366", "tr", "no", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3367", "tr", "pa", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3368", "tr", "pl", "turecki");
INSERT INTO `wp_icl_languages_translations` VALUES("3369", "tr", "pt-pt", "Turco");
INSERT INTO `wp_icl_languages_translations` VALUES("3370", "tr", "pt-br", "Turco");
INSERT INTO `wp_icl_languages_translations` VALUES("3371", "tr", "qu", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3372", "tr", "ro", "Turcă");
INSERT INTO `wp_icl_languages_translations` VALUES("3373", "tr", "ru", "Турецкий");
INSERT INTO `wp_icl_languages_translations` VALUES("3374", "tr", "sl", "Turščina");
INSERT INTO `wp_icl_languages_translations` VALUES("3375", "tr", "so", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3376", "tr", "sq", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3377", "tr", "sr", "турски");
INSERT INTO `wp_icl_languages_translations` VALUES("3378", "tr", "sv", "Turkiska");
INSERT INTO `wp_icl_languages_translations` VALUES("3379", "tr", "ta", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3380", "tr", "th", "ตุรกี");
INSERT INTO `wp_icl_languages_translations` VALUES("3381", "tr", "tr", "Türkçe");
INSERT INTO `wp_icl_languages_translations` VALUES("3382", "tr", "uk", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3383", "tr", "ur", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3384", "tr", "uz", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3385", "tr", "vi", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3386", "tr", "yi", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3387", "tr", "zh-hans", "土耳其语");
INSERT INTO `wp_icl_languages_translations` VALUES("3388", "tr", "zu", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3389", "tr", "zh-hant", "土耳其語");
INSERT INTO `wp_icl_languages_translations` VALUES("3390", "tr", "ms", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3391", "tr", "gl", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3392", "tr", "bn", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3393", "uk", "en", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3394", "uk", "es", "Ucraniano");
INSERT INTO `wp_icl_languages_translations` VALUES("3395", "uk", "de", "Ukrainisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3396", "uk", "fr", "Ukrainien");
INSERT INTO `wp_icl_languages_translations` VALUES("3397", "uk", "ar", "الأوكرانية");
INSERT INTO `wp_icl_languages_translations` VALUES("3398", "uk", "bs", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3399", "uk", "bg", "Украински");
INSERT INTO `wp_icl_languages_translations` VALUES("3400", "uk", "ca", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3401", "uk", "cs", "Ukrajinský");
INSERT INTO `wp_icl_languages_translations` VALUES("3402", "uk", "sk", "Ukrajinčina");
INSERT INTO `wp_icl_languages_translations` VALUES("3403", "uk", "cy", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3404", "uk", "da", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3405", "uk", "el", "Ουκρανικα");
INSERT INTO `wp_icl_languages_translations` VALUES("3406", "uk", "eo", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3407", "uk", "et", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3408", "uk", "eu", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3409", "uk", "fa", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3410", "uk", "fi", "ukraina");
INSERT INTO `wp_icl_languages_translations` VALUES("3411", "uk", "ga", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3412", "uk", "he", "אוקראינית");
INSERT INTO `wp_icl_languages_translations` VALUES("3413", "uk", "hi", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3414", "uk", "hr", "Ukrajinski");
INSERT INTO `wp_icl_languages_translations` VALUES("3415", "uk", "hu", "ukrán");
INSERT INTO `wp_icl_languages_translations` VALUES("3416", "uk", "hy", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3417", "uk", "id", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3418", "uk", "is", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3419", "uk", "it", "Ucraino");
INSERT INTO `wp_icl_languages_translations` VALUES("3420", "uk", "ja", "ウクライナ語");
INSERT INTO `wp_icl_languages_translations` VALUES("3421", "uk", "ko", "우크라이나어");
INSERT INTO `wp_icl_languages_translations` VALUES("3422", "uk", "ku", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3423", "uk", "lv", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3424", "uk", "lt", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3425", "uk", "mk", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3426", "uk", "mt", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3427", "uk", "mn", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3428", "uk", "ne", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3429", "uk", "nl", "Oekraïens");
INSERT INTO `wp_icl_languages_translations` VALUES("3430", "uk", "no", "Ukrainsk");
INSERT INTO `wp_icl_languages_translations` VALUES("3431", "uk", "pa", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3432", "uk", "pl", "ukraiński");
INSERT INTO `wp_icl_languages_translations` VALUES("3433", "uk", "pt-pt", "Ucraniano");
INSERT INTO `wp_icl_languages_translations` VALUES("3434", "uk", "pt-br", "Ucraniano");
INSERT INTO `wp_icl_languages_translations` VALUES("3435", "uk", "qu", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3436", "uk", "ro", "Ucrainiană");
INSERT INTO `wp_icl_languages_translations` VALUES("3437", "uk", "ru", "Украинский");
INSERT INTO `wp_icl_languages_translations` VALUES("3438", "uk", "sl", "Ukrajinski");
INSERT INTO `wp_icl_languages_translations` VALUES("3439", "uk", "so", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3440", "uk", "sq", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3441", "uk", "sr", "украјински");
INSERT INTO `wp_icl_languages_translations` VALUES("3442", "uk", "sv", "Ukrainska");
INSERT INTO `wp_icl_languages_translations` VALUES("3443", "uk", "ta", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3444", "uk", "th", "ยูเครน");
INSERT INTO `wp_icl_languages_translations` VALUES("3445", "uk", "tr", "Ukraynaca");
INSERT INTO `wp_icl_languages_translations` VALUES("3446", "uk", "uk", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3447", "uk", "ur", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3448", "uk", "uz", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3449", "uk", "vi", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3450", "uk", "yi", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3451", "uk", "zh-hans", "乌克兰语");
INSERT INTO `wp_icl_languages_translations` VALUES("3452", "uk", "zu", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3453", "uk", "zh-hant", "烏克蘭語");
INSERT INTO `wp_icl_languages_translations` VALUES("3454", "uk", "ms", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3455", "uk", "gl", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3456", "uk", "bn", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3457", "ur", "en", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3458", "ur", "es", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3459", "ur", "de", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3460", "ur", "fr", "Ourdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3461", "ur", "ar", "الأردية");
INSERT INTO `wp_icl_languages_translations` VALUES("3462", "ur", "bs", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3463", "ur", "bg", "Урду");
INSERT INTO `wp_icl_languages_translations` VALUES("3464", "ur", "ca", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3465", "ur", "cs", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3466", "ur", "sk", "Urdština");
INSERT INTO `wp_icl_languages_translations` VALUES("3467", "ur", "cy", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3468", "ur", "da", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3469", "ur", "el", "Ουρντου");
INSERT INTO `wp_icl_languages_translations` VALUES("3470", "ur", "eo", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3471", "ur", "et", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3472", "ur", "eu", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3473", "ur", "fa", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3474", "ur", "fi", "urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3475", "ur", "ga", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3476", "ur", "he", "אורדו");
INSERT INTO `wp_icl_languages_translations` VALUES("3477", "ur", "hi", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3478", "ur", "hr", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3479", "ur", "hu", "urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3480", "ur", "hy", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3481", "ur", "id", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3482", "ur", "is", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3483", "ur", "it", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3484", "ur", "ja", "ウルドゥー語");
INSERT INTO `wp_icl_languages_translations` VALUES("3485", "ur", "ko", "우르두어");
INSERT INTO `wp_icl_languages_translations` VALUES("3486", "ur", "ku", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3487", "ur", "lv", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3488", "ur", "lt", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3489", "ur", "mk", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3490", "ur", "mt", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3491", "ur", "mn", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3492", "ur", "ne", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3493", "ur", "nl", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3494", "ur", "no", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3495", "ur", "pa", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3496", "ur", "pl", "urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3497", "ur", "pt-pt", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3498", "ur", "pt-br", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3499", "ur", "qu", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3500", "ur", "ro", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3501", "ur", "ru", "Урду");
INSERT INTO `wp_icl_languages_translations` VALUES("3502", "ur", "sl", "Urdujščina");
INSERT INTO `wp_icl_languages_translations` VALUES("3503", "ur", "so", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3504", "ur", "sq", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3505", "ur", "sr", "урду");
INSERT INTO `wp_icl_languages_translations` VALUES("3506", "ur", "sv", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3507", "ur", "ta", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3508", "ur", "th", "อุรดู");
INSERT INTO `wp_icl_languages_translations` VALUES("3509", "ur", "tr", "Urduca");
INSERT INTO `wp_icl_languages_translations` VALUES("3510", "ur", "uk", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3511", "ur", "ur", "اردو ");
INSERT INTO `wp_icl_languages_translations` VALUES("3512", "ur", "uz", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3513", "ur", "vi", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3514", "ur", "yi", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3515", "ur", "zh-hans", "乌尔都语");
INSERT INTO `wp_icl_languages_translations` VALUES("3516", "ur", "zu", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3517", "ur", "zh-hant", "烏爾都語");
INSERT INTO `wp_icl_languages_translations` VALUES("3518", "ur", "ms", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3519", "ur", "gl", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3520", "ur", "bn", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3521", "uz", "en", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3522", "uz", "es", "Uzbeko");
INSERT INTO `wp_icl_languages_translations` VALUES("3523", "uz", "de", "Usbekisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3524", "uz", "fr", "Ouzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3525", "uz", "ar", "الاوزباكية");
INSERT INTO `wp_icl_languages_translations` VALUES("3526", "uz", "bs", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3527", "uz", "bg", "Узбекски");
INSERT INTO `wp_icl_languages_translations` VALUES("3528", "uz", "ca", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3529", "uz", "cs", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3530", "uz", "sk", "Uzbekčina");
INSERT INTO `wp_icl_languages_translations` VALUES("3531", "uz", "cy", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3532", "uz", "da", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3533", "uz", "el", "Ουζμπεκικα");
INSERT INTO `wp_icl_languages_translations` VALUES("3534", "uz", "eo", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3535", "uz", "et", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3536", "uz", "eu", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3537", "uz", "fa", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3538", "uz", "fi", "uzbekki");
INSERT INTO `wp_icl_languages_translations` VALUES("3539", "uz", "ga", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3540", "uz", "he", "אוזבקית");
INSERT INTO `wp_icl_languages_translations` VALUES("3541", "uz", "hi", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3542", "uz", "hr", "Uzbečki");
INSERT INTO `wp_icl_languages_translations` VALUES("3543", "uz", "hu", "üzbég");
INSERT INTO `wp_icl_languages_translations` VALUES("3544", "uz", "hy", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3545", "uz", "id", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3546", "uz", "is", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3547", "uz", "it", "Uzbeco");
INSERT INTO `wp_icl_languages_translations` VALUES("3548", "uz", "ja", "ウズベク語");
INSERT INTO `wp_icl_languages_translations` VALUES("3549", "uz", "ko", "우즈베크어");
INSERT INTO `wp_icl_languages_translations` VALUES("3550", "uz", "ku", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3551", "uz", "lv", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3552", "uz", "lt", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3553", "uz", "mk", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3554", "uz", "mt", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3555", "uz", "mn", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3556", "uz", "ne", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3557", "uz", "nl", "Oezbeeks");
INSERT INTO `wp_icl_languages_translations` VALUES("3558", "uz", "no", "Usbekisk");
INSERT INTO `wp_icl_languages_translations` VALUES("3559", "uz", "pa", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3560", "uz", "pl", "uzbecki");
INSERT INTO `wp_icl_languages_translations` VALUES("3561", "uz", "pt-pt", "Uzbeque");
INSERT INTO `wp_icl_languages_translations` VALUES("3562", "uz", "pt-br", "Uzbeque");
INSERT INTO `wp_icl_languages_translations` VALUES("3563", "uz", "qu", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3564", "uz", "ro", "Uzbecă");
INSERT INTO `wp_icl_languages_translations` VALUES("3565", "uz", "ru", "Узбекский");
INSERT INTO `wp_icl_languages_translations` VALUES("3566", "uz", "sl", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3567", "uz", "so", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3568", "uz", "sq", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3569", "uz", "sr", "Узбек");
INSERT INTO `wp_icl_languages_translations` VALUES("3570", "uz", "sv", "Uzbekiska");
INSERT INTO `wp_icl_languages_translations` VALUES("3571", "uz", "ta", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3572", "uz", "th", "อุซเบก");
INSERT INTO `wp_icl_languages_translations` VALUES("3573", "uz", "tr", "Özbekçe");
INSERT INTO `wp_icl_languages_translations` VALUES("3574", "uz", "uk", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3575", "uz", "ur", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3576", "uz", "uz", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3577", "uz", "vi", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3578", "uz", "yi", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3579", "uz", "zh-hans", "乌兹别克语");
INSERT INTO `wp_icl_languages_translations` VALUES("3580", "uz", "zu", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3581", "uz", "zh-hant", "烏茲別克語");
INSERT INTO `wp_icl_languages_translations` VALUES("3582", "uz", "ms", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3583", "uz", "gl", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3584", "uz", "bn", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3585", "vi", "en", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3586", "vi", "es", "Vietnamita");
INSERT INTO `wp_icl_languages_translations` VALUES("3587", "vi", "de", "Vietnamesisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3588", "vi", "fr", "Vietnamien");
INSERT INTO `wp_icl_languages_translations` VALUES("3589", "vi", "ar", "الفيتنامية");
INSERT INTO `wp_icl_languages_translations` VALUES("3590", "vi", "bs", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3591", "vi", "bg", "Виетнамски");
INSERT INTO `wp_icl_languages_translations` VALUES("3592", "vi", "ca", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3593", "vi", "cs", "Vietnamský");
INSERT INTO `wp_icl_languages_translations` VALUES("3594", "vi", "sk", "Vietnamčina");
INSERT INTO `wp_icl_languages_translations` VALUES("3595", "vi", "cy", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3596", "vi", "da", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3597", "vi", "el", "Βιετναμεζικα");
INSERT INTO `wp_icl_languages_translations` VALUES("3598", "vi", "eo", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3599", "vi", "et", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3600", "vi", "eu", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3601", "vi", "fa", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3602", "vi", "fi", "vietnam");
INSERT INTO `wp_icl_languages_translations` VALUES("3603", "vi", "ga", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3604", "vi", "he", "וייטנאמית");
INSERT INTO `wp_icl_languages_translations` VALUES("3605", "vi", "hi", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3606", "vi", "hr", "Vijetnamski");
INSERT INTO `wp_icl_languages_translations` VALUES("3607", "vi", "hu", "vietnámi");
INSERT INTO `wp_icl_languages_translations` VALUES("3608", "vi", "hy", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3609", "vi", "id", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3610", "vi", "is", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3611", "vi", "it", "Vietnamita");
INSERT INTO `wp_icl_languages_translations` VALUES("3612", "vi", "ja", "ベトナム語");
INSERT INTO `wp_icl_languages_translations` VALUES("3613", "vi", "ko", "베트남어");
INSERT INTO `wp_icl_languages_translations` VALUES("3614", "vi", "ku", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3615", "vi", "lv", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3616", "vi", "lt", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3617", "vi", "mk", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3618", "vi", "mt", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3619", "vi", "mn", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3620", "vi", "ne", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3621", "vi", "nl", "Vietnamees");
INSERT INTO `wp_icl_languages_translations` VALUES("3622", "vi", "no", "Vietnamesisk");
INSERT INTO `wp_icl_languages_translations` VALUES("3623", "vi", "pa", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3624", "vi", "pl", "wietnamski");
INSERT INTO `wp_icl_languages_translations` VALUES("3625", "vi", "pt-pt", "Vietnamita");
INSERT INTO `wp_icl_languages_translations` VALUES("3626", "vi", "pt-br", "Vietnamita");
INSERT INTO `wp_icl_languages_translations` VALUES("3627", "vi", "qu", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3628", "vi", "ro", "Vietnameză");
INSERT INTO `wp_icl_languages_translations` VALUES("3629", "vi", "ru", "Вьетнамский");
INSERT INTO `wp_icl_languages_translations` VALUES("3630", "vi", "sl", "Vietnamščina");
INSERT INTO `wp_icl_languages_translations` VALUES("3631", "vi", "so", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3632", "vi", "sq", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3633", "vi", "sr", "вијетнамски");
INSERT INTO `wp_icl_languages_translations` VALUES("3634", "vi", "sv", "Vietnamesiska");
INSERT INTO `wp_icl_languages_translations` VALUES("3635", "vi", "ta", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3636", "vi", "th", "เวียดนาม");
INSERT INTO `wp_icl_languages_translations` VALUES("3637", "vi", "tr", "Vietnamca");
INSERT INTO `wp_icl_languages_translations` VALUES("3638", "vi", "uk", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3639", "vi", "ur", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3640", "vi", "uz", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3641", "vi", "vi", "Tiếng Việt");
INSERT INTO `wp_icl_languages_translations` VALUES("3642", "vi", "yi", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3643", "vi", "zh-hans", "越南语");
INSERT INTO `wp_icl_languages_translations` VALUES("3644", "vi", "zu", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3645", "vi", "zh-hant", "越南語");
INSERT INTO `wp_icl_languages_translations` VALUES("3646", "vi", "ms", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3647", "vi", "gl", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3648", "vi", "bn", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3649", "yi", "en", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3650", "yi", "es", "Yidis");
INSERT INTO `wp_icl_languages_translations` VALUES("3651", "yi", "de", "Jiddisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3652", "yi", "fr", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3653", "yi", "ar", "اليديشية");
INSERT INTO `wp_icl_languages_translations` VALUES("3654", "yi", "bs", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3655", "yi", "bg", "Идиш");
INSERT INTO `wp_icl_languages_translations` VALUES("3656", "yi", "ca", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3657", "yi", "cs", "Jidiš");
INSERT INTO `wp_icl_languages_translations` VALUES("3658", "yi", "sk", "Jidiš");
INSERT INTO `wp_icl_languages_translations` VALUES("3659", "yi", "cy", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3660", "yi", "da", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3661", "yi", "el", "Γιντις");
INSERT INTO `wp_icl_languages_translations` VALUES("3662", "yi", "eo", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3663", "yi", "et", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3664", "yi", "eu", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3665", "yi", "fa", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3666", "yi", "fi", "jiddi");
INSERT INTO `wp_icl_languages_translations` VALUES("3667", "yi", "ga", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3668", "yi", "he", "יידיש");
INSERT INTO `wp_icl_languages_translations` VALUES("3669", "yi", "hi", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3670", "yi", "hr", "Jidiš");
INSERT INTO `wp_icl_languages_translations` VALUES("3671", "yi", "hu", "jiddis");
INSERT INTO `wp_icl_languages_translations` VALUES("3672", "yi", "hy", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3673", "yi", "id", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3674", "yi", "is", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3675", "yi", "it", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3676", "yi", "ja", "イディッシュ語");
INSERT INTO `wp_icl_languages_translations` VALUES("3677", "yi", "ko", "이디시어");
INSERT INTO `wp_icl_languages_translations` VALUES("3678", "yi", "ku", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3679", "yi", "lv", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3680", "yi", "lt", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3681", "yi", "mk", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3682", "yi", "mt", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3683", "yi", "mn", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3684", "yi", "ne", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3685", "yi", "nl", "Jiddisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3686", "yi", "no", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3687", "yi", "pa", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3688", "yi", "pl", "jidysz");
INSERT INTO `wp_icl_languages_translations` VALUES("3689", "yi", "pt-pt", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3690", "yi", "pt-br", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3691", "yi", "qu", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3692", "yi", "ro", "Idiş");
INSERT INTO `wp_icl_languages_translations` VALUES("3693", "yi", "ru", "Идиш");
INSERT INTO `wp_icl_languages_translations` VALUES("3694", "yi", "sl", "Jidiš");
INSERT INTO `wp_icl_languages_translations` VALUES("3695", "yi", "so", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3696", "yi", "sq", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3697", "yi", "sr", "јидиш");
INSERT INTO `wp_icl_languages_translations` VALUES("3698", "yi", "sv", "Jiddisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3699", "yi", "ta", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3700", "yi", "th", "ยิชดิช");
INSERT INTO `wp_icl_languages_translations` VALUES("3701", "yi", "tr", "Eski İbranice");
INSERT INTO `wp_icl_languages_translations` VALUES("3702", "yi", "uk", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3703", "yi", "ur", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3704", "yi", "uz", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3705", "yi", "vi", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3706", "yi", "yi", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3707", "yi", "zh-hans", "依地语");
INSERT INTO `wp_icl_languages_translations` VALUES("3708", "yi", "zu", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3709", "yi", "zh-hant", "依地語");
INSERT INTO `wp_icl_languages_translations` VALUES("3710", "yi", "ms", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3711", "yi", "gl", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3712", "yi", "bn", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3713", "zh-hans", "en", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3714", "zh-hans", "es", "Chino simplificado");
INSERT INTO `wp_icl_languages_translations` VALUES("3715", "zh-hans", "de", "Vereinfachtes Chinesisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3716", "zh-hans", "fr", "Chinois simplifié");
INSERT INTO `wp_icl_languages_translations` VALUES("3717", "zh-hans", "ar", "الصينية المبسطة");
INSERT INTO `wp_icl_languages_translations` VALUES("3718", "zh-hans", "bs", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3719", "zh-hans", "bg", "Китайски  (опростен)");
INSERT INTO `wp_icl_languages_translations` VALUES("3720", "zh-hans", "ca", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3721", "zh-hans", "cs", "Čínština ( Zjednodušený )");
INSERT INTO `wp_icl_languages_translations` VALUES("3722", "zh-hans", "sk", "Zjednodušená Čínština");
INSERT INTO `wp_icl_languages_translations` VALUES("3723", "zh-hans", "cy", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3724", "zh-hans", "da", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3725", "zh-hans", "el", "Κινεζικα (Απλοποιημένα)");
INSERT INTO `wp_icl_languages_translations` VALUES("3726", "zh-hans", "eo", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3727", "zh-hans", "et", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3728", "zh-hans", "eu", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3729", "zh-hans", "fa", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3730", "zh-hans", "fi", "kiina");
INSERT INTO `wp_icl_languages_translations` VALUES("3731", "zh-hans", "ga", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3732", "zh-hans", "he", "סינית");
INSERT INTO `wp_icl_languages_translations` VALUES("3733", "zh-hans", "hi", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3734", "zh-hans", "hr", "Kineski (pojednostavljeni)");
INSERT INTO `wp_icl_languages_translations` VALUES("3735", "zh-hans", "hu", "egyszerűsített kínai");
INSERT INTO `wp_icl_languages_translations` VALUES("3736", "zh-hans", "hy", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3737", "zh-hans", "id", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3738", "zh-hans", "is", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3739", "zh-hans", "it", "Cinese semplificato");
INSERT INTO `wp_icl_languages_translations` VALUES("3740", "zh-hans", "ja", "簡体中国語");
INSERT INTO `wp_icl_languages_translations` VALUES("3741", "zh-hans", "ko", "중국어 간체");
INSERT INTO `wp_icl_languages_translations` VALUES("3742", "zh-hans", "ku", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3743", "zh-hans", "lv", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3744", "zh-hans", "lt", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3745", "zh-hans", "mk", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3746", "zh-hans", "mt", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3747", "zh-hans", "mn", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3748", "zh-hans", "ne", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3749", "zh-hans", "nl", "Vereenvoudigd Chinees");
INSERT INTO `wp_icl_languages_translations` VALUES("3750", "zh-hans", "no", "Kinesisk (forenklet)");
INSERT INTO `wp_icl_languages_translations` VALUES("3751", "zh-hans", "pa", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3752", "zh-hans", "pl", "chiński uproszczony");
INSERT INTO `wp_icl_languages_translations` VALUES("3753", "zh-hans", "pt-pt", "Chinês (Simplificado)");
INSERT INTO `wp_icl_languages_translations` VALUES("3754", "zh-hans", "pt-br", "Chinês (Simplificado)");
INSERT INTO `wp_icl_languages_translations` VALUES("3755", "zh-hans", "qu", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3756", "zh-hans", "ro", "Chineza simplificată");
INSERT INTO `wp_icl_languages_translations` VALUES("3757", "zh-hans", "ru", "Китайский (упрощенный)");
INSERT INTO `wp_icl_languages_translations` VALUES("3758", "zh-hans", "sl", "Kitajščina (poenostavljena )");
INSERT INTO `wp_icl_languages_translations` VALUES("3759", "zh-hans", "so", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3760", "zh-hans", "sq", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3761", "zh-hans", "sr", "Кинески (поједностављени)");
INSERT INTO `wp_icl_languages_translations` VALUES("3762", "zh-hans", "sv", "Förenklad kinesiska");
INSERT INTO `wp_icl_languages_translations` VALUES("3763", "zh-hans", "ta", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3764", "zh-hans", "th", "จีนประยุกต์");
INSERT INTO `wp_icl_languages_translations` VALUES("3765", "zh-hans", "tr", "Modern Çince");
INSERT INTO `wp_icl_languages_translations` VALUES("3766", "zh-hans", "uk", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3767", "zh-hans", "ur", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3768", "zh-hans", "uz", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3769", "zh-hans", "vi", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3770", "zh-hans", "yi", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3771", "zh-hans", "zh-hans", "简体中文");
INSERT INTO `wp_icl_languages_translations` VALUES("3772", "zh-hans", "zu", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3773", "zh-hans", "zh-hant", "簡體中文");
INSERT INTO `wp_icl_languages_translations` VALUES("3774", "zh-hans", "ms", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3775", "zh-hans", "gl", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3776", "zh-hans", "bn", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3777", "zu", "en", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3778", "zu", "es", "Zulú");
INSERT INTO `wp_icl_languages_translations` VALUES("3779", "zu", "de", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3780", "zu", "fr", "Zoulou");
INSERT INTO `wp_icl_languages_translations` VALUES("3781", "zu", "ar", "الزولو");
INSERT INTO `wp_icl_languages_translations` VALUES("3782", "zu", "bs", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3783", "zu", "bg", "Зулу");
INSERT INTO `wp_icl_languages_translations` VALUES("3784", "zu", "ca", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3785", "zu", "cs", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3786", "zu", "sk", "Jazyk Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3787", "zu", "cy", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3788", "zu", "da", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3789", "zu", "el", "Ζουλου");
INSERT INTO `wp_icl_languages_translations` VALUES("3790", "zu", "eo", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3791", "zu", "et", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3792", "zu", "eu", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3793", "zu", "fa", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3794", "zu", "fi", "zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3795", "zu", "ga", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3796", "zu", "he", "זולו ");
INSERT INTO `wp_icl_languages_translations` VALUES("3797", "zu", "hi", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3798", "zu", "hr", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3799", "zu", "hu", "zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3800", "zu", "hy", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3801", "zu", "id", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3802", "zu", "is", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3803", "zu", "it", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3804", "zu", "ja", "ズールー語");
INSERT INTO `wp_icl_languages_translations` VALUES("3805", "zu", "ko", "줄루어");
INSERT INTO `wp_icl_languages_translations` VALUES("3806", "zu", "ku", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3807", "zu", "lv", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3808", "zu", "lt", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3809", "zu", "mk", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3810", "zu", "mt", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3811", "zu", "mn", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3812", "zu", "ne", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3813", "zu", "nl", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3814", "zu", "no", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3815", "zu", "pa", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3816", "zu", "pl", "zuluski");
INSERT INTO `wp_icl_languages_translations` VALUES("3817", "zu", "pt-pt", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3818", "zu", "pt-br", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3819", "zu", "qu", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3820", "zu", "ro", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3821", "zu", "ru", "Зулу");
INSERT INTO `wp_icl_languages_translations` VALUES("3822", "zu", "sl", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3823", "zu", "so", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3824", "zu", "sq", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3825", "zu", "sr", "зулу");
INSERT INTO `wp_icl_languages_translations` VALUES("3826", "zu", "sv", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3827", "zu", "ta", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3828", "zu", "th", "ซูลู");
INSERT INTO `wp_icl_languages_translations` VALUES("3829", "zu", "tr", "Zulu dili");
INSERT INTO `wp_icl_languages_translations` VALUES("3830", "zu", "uk", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3831", "zu", "ur", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3832", "zu", "uz", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3833", "zu", "vi", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3834", "zu", "yi", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3835", "zu", "zh-hans", "祖鲁语");
INSERT INTO `wp_icl_languages_translations` VALUES("3836", "zu", "zu", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3837", "zu", "zh-hant", "祖魯語");
INSERT INTO `wp_icl_languages_translations` VALUES("3838", "zu", "ms", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3839", "zu", "gl", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3840", "zu", "bn", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3841", "zh-hant", "en", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3842", "zh-hant", "es", "Chino tradicional");
INSERT INTO `wp_icl_languages_translations` VALUES("3843", "zh-hant", "de", "Traditionelles Chinesisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3844", "zh-hant", "fr", "Chinois traditionnel");
INSERT INTO `wp_icl_languages_translations` VALUES("3845", "zh-hant", "ar", "الصينية التقليدية");
INSERT INTO `wp_icl_languages_translations` VALUES("3846", "zh-hant", "bs", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3847", "zh-hant", "bg", "Китайски (традиционен)");
INSERT INTO `wp_icl_languages_translations` VALUES("3848", "zh-hant", "ca", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3849", "zh-hant", "cs", "Čínština (tradiční )");
INSERT INTO `wp_icl_languages_translations` VALUES("3850", "zh-hant", "sk", "Tradičná Čínština");
INSERT INTO `wp_icl_languages_translations` VALUES("3851", "zh-hant", "cy", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3852", "zh-hant", "da", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3853", "zh-hant", "el", "Κινεζικα (Παραδοσιακά)");
INSERT INTO `wp_icl_languages_translations` VALUES("3854", "zh-hant", "eo", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3855", "zh-hant", "et", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3856", "zh-hant", "eu", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3857", "zh-hant", "fa", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3858", "zh-hant", "fi", "perinteinen kiina");
INSERT INTO `wp_icl_languages_translations` VALUES("3859", "zh-hant", "ga", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3860", "zh-hant", "he", "סינית מסורתית");
INSERT INTO `wp_icl_languages_translations` VALUES("3861", "zh-hant", "hi", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3862", "zh-hant", "hr", "Kineski (tradicionalni)");
INSERT INTO `wp_icl_languages_translations` VALUES("3863", "zh-hant", "hu", "hagyományos kínai");
INSERT INTO `wp_icl_languages_translations` VALUES("3864", "zh-hant", "hy", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3865", "zh-hant", "id", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3866", "zh-hant", "is", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3867", "zh-hant", "it", "Cinese tradizionale");
INSERT INTO `wp_icl_languages_translations` VALUES("3868", "zh-hant", "ja", "繁体中国語");
INSERT INTO `wp_icl_languages_translations` VALUES("3869", "zh-hant", "ko", "중국어 번체");
INSERT INTO `wp_icl_languages_translations` VALUES("3870", "zh-hant", "ku", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3871", "zh-hant", "lv", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3872", "zh-hant", "lt", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3873", "zh-hant", "mk", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3874", "zh-hant", "mt", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3875", "zh-hant", "mn", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3876", "zh-hant", "ne", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3877", "zh-hant", "nl", "Traditioneel Chinees");
INSERT INTO `wp_icl_languages_translations` VALUES("3878", "zh-hant", "no", "Kinesisk (tradisjonell)");
INSERT INTO `wp_icl_languages_translations` VALUES("3879", "zh-hant", "pa", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3880", "zh-hant", "pl", "chiński tradycyjny");
INSERT INTO `wp_icl_languages_translations` VALUES("3881", "zh-hant", "pt-pt", "Chinês (Tradicional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3882", "zh-hant", "pt-br", "Chinês (Tradicional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3883", "zh-hant", "qu", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3884", "zh-hant", "ro", "Chineza tradiţională");
INSERT INTO `wp_icl_languages_translations` VALUES("3885", "zh-hant", "ru", "Китайский (традиционный)");
INSERT INTO `wp_icl_languages_translations` VALUES("3886", "zh-hant", "sl", "Kitajščina (tradicionalna)");
INSERT INTO `wp_icl_languages_translations` VALUES("3887", "zh-hant", "so", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3888", "zh-hant", "sq", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3889", "zh-hant", "sr", "Кинески (традиционални)");
INSERT INTO `wp_icl_languages_translations` VALUES("3890", "zh-hant", "sv", "Traditionell kinesiska");
INSERT INTO `wp_icl_languages_translations` VALUES("3891", "zh-hant", "ta", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3892", "zh-hant", "th", "จีนดั้งเดิม");
INSERT INTO `wp_icl_languages_translations` VALUES("3893", "zh-hant", "tr", "Klasik Çince");
INSERT INTO `wp_icl_languages_translations` VALUES("3894", "zh-hant", "uk", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3895", "zh-hant", "ur", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3896", "zh-hant", "uz", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3897", "zh-hant", "vi", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3898", "zh-hant", "yi", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3899", "zh-hant", "zh-hans", "繁体中文");
INSERT INTO `wp_icl_languages_translations` VALUES("3900", "zh-hant", "zu", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3901", "zh-hant", "zh-hant", "繁體中文");
INSERT INTO `wp_icl_languages_translations` VALUES("3902", "zh-hant", "ms", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3903", "zh-hant", "gl", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3904", "zh-hant", "bn", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3905", "ms", "en", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3906", "ms", "es", "Malayo");
INSERT INTO `wp_icl_languages_translations` VALUES("3907", "ms", "de", "Malaiisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3908", "ms", "fr", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3909", "ms", "ar", "لغة الملايو");
INSERT INTO `wp_icl_languages_translations` VALUES("3910", "ms", "bs", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3911", "ms", "bg", "Малайски");
INSERT INTO `wp_icl_languages_translations` VALUES("3912", "ms", "ca", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3913", "ms", "cs", "Malajský");
INSERT INTO `wp_icl_languages_translations` VALUES("3914", "ms", "sk", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3915", "ms", "cy", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3916", "ms", "da", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3917", "ms", "el", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3918", "ms", "eo", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3919", "ms", "et", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3920", "ms", "eu", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3921", "ms", "fa", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3922", "ms", "fi", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3923", "ms", "ga", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3924", "ms", "he", "מלאית");
INSERT INTO `wp_icl_languages_translations` VALUES("3925", "ms", "hi", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3926", "ms", "hr", "Malajski");
INSERT INTO `wp_icl_languages_translations` VALUES("3927", "ms", "hu", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3928", "ms", "hy", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3929", "ms", "id", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3930", "ms", "is", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3931", "ms", "it", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3932", "ms", "ja", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3933", "ms", "ko", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3934", "ms", "ku", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3935", "ms", "lv", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3936", "ms", "lt", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3937", "ms", "mk", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3938", "ms", "mt", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3939", "ms", "mn", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3940", "ms", "ne", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3941", "ms", "nl", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3942", "ms", "no", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3943", "ms", "pa", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3944", "ms", "pl", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3945", "ms", "pt-pt", "Malaio");
INSERT INTO `wp_icl_languages_translations` VALUES("3946", "ms", "pt-br", "Malaio");
INSERT INTO `wp_icl_languages_translations` VALUES("3947", "ms", "qu", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3948", "ms", "ro", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3949", "ms", "ru", "Малайский");
INSERT INTO `wp_icl_languages_translations` VALUES("3950", "ms", "sl", "Malajščina");
INSERT INTO `wp_icl_languages_translations` VALUES("3951", "ms", "so", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3952", "ms", "sq", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3953", "ms", "sr", "малајски");
INSERT INTO `wp_icl_languages_translations` VALUES("3954", "ms", "sv", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3955", "ms", "ta", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3956", "ms", "th", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3957", "ms", "tr", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3958", "ms", "uk", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3959", "ms", "ur", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3960", "ms", "uz", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3961", "ms", "vi", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3962", "ms", "yi", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3963", "ms", "zh-hans", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3964", "ms", "zu", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3965", "ms", "zh-hant", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3966", "ms", "ms", "Melayu");
INSERT INTO `wp_icl_languages_translations` VALUES("3967", "ms", "gl", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3968", "ms", "bn", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3969", "gl", "en", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3970", "gl", "es", "Gallego");
INSERT INTO `wp_icl_languages_translations` VALUES("3971", "gl", "de", "Galicisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3972", "gl", "fr", "Galicien");
INSERT INTO `wp_icl_languages_translations` VALUES("3973", "gl", "ar", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3974", "gl", "bs", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3975", "gl", "bg", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3976", "gl", "ca", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3977", "gl", "cs", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3978", "gl", "sk", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3979", "gl", "cy", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3980", "gl", "da", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3981", "gl", "el", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3982", "gl", "eo", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3983", "gl", "et", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3984", "gl", "eu", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3985", "gl", "fa", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3986", "gl", "fi", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3987", "gl", "ga", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3988", "gl", "he", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3989", "gl", "hi", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3990", "gl", "hr", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3991", "gl", "hu", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3992", "gl", "hy", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3993", "gl", "id", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3994", "gl", "is", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3995", "gl", "it", "Gallego");
INSERT INTO `wp_icl_languages_translations` VALUES("3996", "gl", "ja", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3997", "gl", "ko", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3998", "gl", "ku", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3999", "gl", "lv", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4000", "gl", "lt", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4001", "gl", "mk", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4002", "gl", "mt", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4003", "gl", "mn", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4004", "gl", "ne", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4005", "gl", "nl", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4006", "gl", "no", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4007", "gl", "pa", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4008", "gl", "pl", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4009", "gl", "pt-pt", "Galego");
INSERT INTO `wp_icl_languages_translations` VALUES("4010", "gl", "pt-br", "Galego");
INSERT INTO `wp_icl_languages_translations` VALUES("4011", "gl", "qu", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4012", "gl", "ro", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4013", "gl", "ru", "Галисийский");
INSERT INTO `wp_icl_languages_translations` VALUES("4014", "gl", "sl", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4015", "gl", "so", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4016", "gl", "sq", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4017", "gl", "sr", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4018", "gl", "sv", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4019", "gl", "ta", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4020", "gl", "th", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4021", "gl", "tr", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4022", "gl", "uk", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4023", "gl", "ur", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4024", "gl", "uz", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4025", "gl", "vi", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4026", "gl", "yi", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4027", "gl", "zh-hans", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4028", "gl", "zu", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4029", "gl", "zh-hant", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4030", "gl", "ms", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4031", "gl", "gl", "Galego");
INSERT INTO `wp_icl_languages_translations` VALUES("4032", "gl", "bn", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4033", "bn", "en", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4034", "bn", "es", "Bengalí");
INSERT INTO `wp_icl_languages_translations` VALUES("4035", "bn", "de", "Bengalisch");
INSERT INTO `wp_icl_languages_translations` VALUES("4036", "bn", "fr", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4037", "bn", "ar", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4038", "bn", "bs", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4039", "bn", "bg", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4040", "bn", "ca", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4041", "bn", "cs", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4042", "bn", "sk", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4043", "bn", "cy", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4044", "bn", "da", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4045", "bn", "el", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4046", "bn", "eo", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4047", "bn", "et", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4048", "bn", "eu", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4049", "bn", "fa", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4050", "bn", "fi", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4051", "bn", "ga", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4052", "bn", "he", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4053", "bn", "hi", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4054", "bn", "hr", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4055", "bn", "hu", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4056", "bn", "hy", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4057", "bn", "id", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4058", "bn", "is", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4059", "bn", "it", "Bengalese");
INSERT INTO `wp_icl_languages_translations` VALUES("4060", "bn", "ja", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4061", "bn", "ko", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4062", "bn", "ku", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4063", "bn", "lv", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4064", "bn", "lt", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4065", "bn", "mk", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4066", "bn", "mt", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4067", "bn", "mn", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4068", "bn", "ne", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4069", "bn", "nl", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4070", "bn", "no", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4071", "bn", "pa", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4072", "bn", "pl", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4073", "bn", "pt-pt", "Bengalês");
INSERT INTO `wp_icl_languages_translations` VALUES("4074", "bn", "pt-br", "Bengalês");
INSERT INTO `wp_icl_languages_translations` VALUES("4075", "bn", "qu", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4076", "bn", "ro", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4077", "bn", "ru", "Бенгальский");
INSERT INTO `wp_icl_languages_translations` VALUES("4078", "bn", "sl", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4079", "bn", "so", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4080", "bn", "sq", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4081", "bn", "sr", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4082", "bn", "sv", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4083", "bn", "ta", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4084", "bn", "th", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4085", "bn", "tr", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4086", "bn", "uk", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4087", "bn", "ur", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4088", "bn", "uz", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4089", "bn", "vi", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4090", "bn", "yi", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4091", "bn", "zh-hans", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4092", "bn", "zu", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4093", "bn", "zh-hant", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4094", "bn", "ms", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4095", "bn", "gl", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4096", "bn", "bn", "हिन्दी");

/* INSERT TABLE DATA: wp_icl_locale_map */
INSERT INTO `wp_icl_locale_map` VALUES("en", "en_US");
INSERT INTO `wp_icl_locale_map` VALUES("it", "it_IT");

/* INSERT TABLE DATA: wp_icl_mo_files_domains */
INSERT INTO `wp_icl_mo_files_domains` VALUES("1", "wp-content/plugins/wpml-media-translation/locale/wpml-media-it_IT.mo", "2e857eb5c77b0ea4a60fdf8c6127c82d", "wpml-media", "not_imported", "0", "1581957923", "plugin", "wpml-media-translation/plugin.php");
INSERT INTO `wp_icl_mo_files_domains` VALUES("2", "wp-content/plugins/wpml-translation-management/locale/wpml-translation-management-it_IT.mo", "174748dbfaff1f2ad110bdec48fe3135", "wpml-translation-management", "not_imported", "0", "1581957688", "plugin", "wpml-translation-management/plugin.php");
INSERT INTO `wp_icl_mo_files_domains` VALUES("3", "wp-content/plugins/wpml-string-translation/locale/wpml-string-translation-it_IT.mo", "0ab263d196ab067dfe57a851ebe1fb4c", "wpml-string-translation", "not_imported", "0", "1581957656", "plugin", "wpml-string-translation/plugin.php");
INSERT INTO `wp_icl_mo_files_domains` VALUES("4", "wp-content/plugins/js_composer/locale/js_composer-it_IT.mo", "47341522947673f5c5b59e69a470efff", "js_composer", "not_imported", "0", "1581953114", "plugin", "js_composer/js_composer.php");
INSERT INTO `wp_icl_mo_files_domains` VALUES("5", "wp-content/plugins/revslider/languages/revslider-en_US.mo", "a184d5d08b87a37de2ee9dc9cd1760e3", "revslider", "not_imported", "0", "1581953108", "plugin", "revslider/revslider.php");
INSERT INTO `wp_icl_mo_files_domains` VALUES("6", "wp-content/plugins/revslider/languages/revsliderhelp-en_US.mo", "f7968a00207c17aa13c59dda852f8431", "revsliderhelp", "not_imported", "0", "1581953108", "plugin", "revslider/revslider.php");
INSERT INTO `wp_icl_mo_files_domains` VALUES("7", "wp-content/languages/it_IT.mo", "4868777c3503496b5ebfee2e7f76f6d8", "default", "not_imported", "0", "1631338775", "other", "");
INSERT INTO `wp_icl_mo_files_domains` VALUES("8", "wp-content/languages/admin-it_IT.mo", "126ba2ce03075d2118879a0c1873331a", "default", "not_imported", "0", "1631338775", "other", "");
INSERT INTO `wp_icl_mo_files_domains` VALUES("9", "wp-content/plugins/redux-framework/ReduxCore/languages/redux-framework-it_IT.mo", "c3e12a14a81880b16567059a59c40389", "redux-framework", "not_imported", "0", "1581953095", "plugin", "redux-framework/redux-framework.php");
INSERT INTO `wp_icl_mo_files_domains` VALUES("10", "wp-content/plugins/wp-user-avatar/lang/wp-user-avatar-en_US.mo", "d5e10c0eb1c8738bc5a9abcaff401270", "wp-user-avatar", "not_imported", "0", "1581953117", "plugin", "wp-user-avatar/wp-user-avatar.php");
INSERT INTO `wp_icl_mo_files_domains` VALUES("11", "wp-content/languages/plugins/contact-form-7-it_IT.mo", "14558cc4d5975c4462b4cdc1d255616d", "contact-form-7", "not_imported", "0", "1582107142", "plugin", "contact-form-7/wp-contact-form-7.php");
INSERT INTO `wp_icl_mo_files_domains` VALUES("12", "wp-content/languages/plugins/newsletter-it_IT.mo", "236530027699b4eb9bff17ca4d68b133", "newsletter", "not_imported", "0", "1582107144", "plugin", "newsletter/plugin.php");
INSERT INTO `wp_icl_mo_files_domains` VALUES("13", "wp-content/languages/plugins/woocommerce-it_IT.mo", "982297e24ec3805237c44388e5ea19ae", "woocommerce", "not_imported", "0", "1583039484", "plugin", "woocommerce/woocommerce.php");
INSERT INTO `wp_icl_mo_files_domains` VALUES("14", "wp-content/languages/plugins/wp-user-avatar-it_IT.mo", "97877361dc8c93fb5506e02404e70f5c", "wp-user-avatar", "not_imported", "0", "1582107147", "plugin", "wp-user-avatar/wp-user-avatar.php");
INSERT INTO `wp_icl_mo_files_domains` VALUES("15", "wp-content/languages/it_IT-1bba9045bb07c89671c88a3f328548e8.json", "e2784f07930c057b6d83fe6d77b27b5d", "default-wp-api-fetch", "not_imported", "0", "1582103245", "other", "");
INSERT INTO `wp_icl_mo_files_domains` VALUES("16", "wp-content/languages/it_IT-1a0cd6a7128913b15c1a10dd68951869.json", "683d59c0eb751d61ce83a70544082114", "default-wp-blocks", "not_imported", "0", "1582103245", "other", "");
INSERT INTO `wp_icl_mo_files_domains` VALUES("17", "wp-content/languages/it_IT-a25d1cc7bf7ca0b4e114f6bea64943f4.json", "ec238c6e0f6ea2747e729d6457105a83", "default-wp-keycodes", "not_imported", "0", "1582103245", "other", "");
INSERT INTO `wp_icl_mo_files_domains` VALUES("18", "wp-content/languages/it_IT-7f13c36c641b114bf18cd0bcc9ecc7e0.json", "3b2ff910043ee69787644760ac2ac148", "default-wp-components", "not_imported", "0", "1582103245", "other", "");
INSERT INTO `wp_icl_mo_files_domains` VALUES("19", "wp-content/languages/it_IT-803bf1ce2131e13efc590c1bc47851fc.json", "28056b5948e2f396bc4d6b3e78090944", "default-wp-block-editor", "not_imported", "0", "1582103245", "other", "");
INSERT INTO `wp_icl_mo_files_domains` VALUES("20", "wp-content/languages/it_IT-0ce75ad2f775d1cac9696967d484808c.json", "eb93982a11b481ca4d62bee19f47591d", "default-wp-nux", "not_imported", "0", "1582103245", "other", "");
INSERT INTO `wp_icl_mo_files_domains` VALUES("21", "wp-content/languages/it_IT-bf0f094965d3d4a95b47babcb35fc136.json", "1140e02c9b6ab728bb9fc25f8bdb1975", "default-wp-editor", "not_imported", "0", "1582103245", "other", "");
INSERT INTO `wp_icl_mo_files_domains` VALUES("22", "wp-content/languages/it_IT-f8f49d9fc4a9cf7d78ec99285417bd9c.json", "a2f41476e9a925d3e81b34c10b6c663a", "default-wp-block-library", "not_imported", "0", "1582103245", "other", "");
INSERT INTO `wp_icl_mo_files_domains` VALUES("23", "wp-content/languages/it_IT-8860e58c20c6a2ab5876a0f07be43bd9.json", "5c57b497cf2bc186035f85426f5cd7d1", "default-wp-edit-post", "not_imported", "0", "1582103245", "other", "");
INSERT INTO `wp_icl_mo_files_domains` VALUES("24", "wp-content/languages/continents-cities-it_IT.mo", "cdaf5e817c5fb722b97059b8b5b15c4d", "continents-cities", "not_imported", "0", "1582103245", "other", "");
INSERT INTO `wp_icl_mo_files_domains` VALUES("25", "wp-content/languages/it_IT-68f2cec7514bf8563c723a4d675fcfe6.json", "fc37953f92410a40b6c26e4da6139c71", "default-wp-format-library", "not_imported", "0", "1582103245", "other", "");
INSERT INTO `wp_icl_mo_files_domains` VALUES("26", "wp-content/plugins/instagram-feed/languages/instagram-feed-it_IT.mo", "7b2753931f24b2f4dfdc035b30eca124", "instagram-feed", "not_imported", "0", "1582290658", "plugin", "instagram-feed/instagram-feed.php");
INSERT INTO `wp_icl_mo_files_domains` VALUES("27", "wp-content/languages/it_IT-81c889563f09dd13de1701135dc62941.json", "24ae94a84474b1d6df93dda7446031e5", "default-media-views", "not_imported", "0", "1631338775", "other", "");
INSERT INTO `wp_icl_mo_files_domains` VALUES("28", "wp-content/languages/plugins/cookie-notice-it_IT.mo", "3312dc39af4a918d0c02ad83707a44d0", "cookie-notice", "not_imported", "0", "1613410427", "plugin", "cookie-notice/cookie-notice.php");
INSERT INTO `wp_icl_mo_files_domains` VALUES("29", "wp-content/languages/plugins/wp-gdpr-compliance-it_IT.mo", "22a49cddb57ff75553f117f7d3ef5c43", "wp-gdpr-compliance", "not_imported", "0", "1593070535", "plugin", "wp-gdpr-compliance/wp-gdpr-compliance.php");
INSERT INTO `wp_icl_mo_files_domains` VALUES("30", "wp-content/plugins/nextend-facebook-connect/languages/nextend-facebook-connect-en_US.mo", "edbe964475acb9ee9b28f36c7d480c41", "nextend-facebook-connect", "not_imported", "0", "1595942073", "plugin", "nextend-facebook-connect/nextend-facebook-connect.php");
INSERT INTO `wp_icl_mo_files_domains` VALUES("31", "wp-content/languages/plugins/duplicator-it_IT.mo", "858e23ef7714b38b71607367799749fc", "duplicator", "not_imported", "0", "1605514016", "plugin", "duplicator/duplicator.php");
INSERT INTO `wp_icl_mo_files_domains` VALUES("32", "wp-content/languages/admin-network-it_IT.mo", "5562e30e160bd67fde91963b25cb0bd1", "default", "not_imported", "0", "1620884937", "other", "");

/* INSERT TABLE DATA: wp_icl_string_packages */
INSERT INTO `wp_icl_string_packages` VALUES("1", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "229", "Page Builder Page 229", "", "", "229", "{\"total\":290,\"to_translate\":{\"it\":290}}");
INSERT INTO `wp_icl_string_packages` VALUES("2", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "649", "Page Builder Page 649", "", "", "649", "{\"total\":162,\"to_translate\":{\"it\":162}}");
INSERT INTO `wp_icl_string_packages` VALUES("3", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "648", "Page Builder Page 648", "", "", "648", "{\"total\":204,\"to_translate\":{\"it\":204}}");
INSERT INTO `wp_icl_string_packages` VALUES("4", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "647", "Page Builder Page 647", "", "", "647", "{\"total\":121,\"to_translate\":{\"it\":121}}");
INSERT INTO `wp_icl_string_packages` VALUES("5", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "646", "Page Builder Page 646", "", "", "646", "{\"total\":162,\"to_translate\":{\"it\":162}}");
INSERT INTO `wp_icl_string_packages` VALUES("6", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "645", "Page Builder Page 645", "", "", "645", "{\"total\":162,\"to_translate\":{\"it\":162}}");
INSERT INTO `wp_icl_string_packages` VALUES("7", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "1359", "Page Builder Page 1359", "", "", "1359", "{\"total\":129,\"to_translate\":{\"it\":129}}");
INSERT INTO `wp_icl_string_packages` VALUES("8", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2155", "Page Builder Page 2155", "", "", "2155", "{\"total\":93,\"to_translate\":{\"it\":93}}");
INSERT INTO `wp_icl_string_packages` VALUES("9", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2160", "Page Builder Page 2160", "", "", "2160", "{\"total\":212,\"to_translate\":{\"it\":212}}");
INSERT INTO `wp_icl_string_packages` VALUES("10", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2164", "Page Builder Page 2164", "", "", "2164", "{\"total\":169,\"to_translate\":{\"it\":169}}");
INSERT INTO `wp_icl_string_packages` VALUES("11", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "246", "Page Builder Page 246", "", "", "246", "{\"total\":860,\"to_translate\":{\"it\":860}}");
INSERT INTO `wp_icl_string_packages` VALUES("12", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "232", "Page Builder Page 232", "", "", "232", "{\"total\":117,\"to_translate\":{\"it\":117}}");
INSERT INTO `wp_icl_string_packages` VALUES("13", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "650", "Page Builder Page 650", "", "", "650", "{\"total\":223,\"to_translate\":{\"it\":223}}");
INSERT INTO `wp_icl_string_packages` VALUES("14", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "250", "Page Builder Page 250", "", "", "250", "{\"total\":2,\"to_translate\":{\"it\":2}}");
INSERT INTO `wp_icl_string_packages` VALUES("15", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "238", "Page Builder Page 238", "", "", "238", "{\"total\":58,\"to_translate\":{\"it\":58}}");
INSERT INTO `wp_icl_string_packages` VALUES("16", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "598", "Page Builder Page 598", "", "", "598", NULL);
INSERT INTO `wp_icl_string_packages` VALUES("17", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2209", "Page Builder Page 2209", "", "", "2209", "{\"total\":40,\"to_translate\":{\"it\":40}}");
INSERT INTO `wp_icl_string_packages` VALUES("18", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2240", "Page Builder Page 2240", "", "", "2240", "{\"total\":172,\"to_translate\":{\"it\":172}}");
INSERT INTO `wp_icl_string_packages` VALUES("19", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "254", "Page Builder Page 254", "", "", "254", "{\"total\":7,\"to_translate\":{\"it\":7}}");
INSERT INTO `wp_icl_string_packages` VALUES("25", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2444", "Page Builder Page 2444", "", "", "2444", "{\"total\":145,\"to_translate\":{\"it\":145}}");
INSERT INTO `wp_icl_string_packages` VALUES("20", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "1", "Page Builder Page 1", "", "", "1", "{\"total\":3635,\"to_translate\":{\"it\":3635}}");
INSERT INTO `wp_icl_string_packages` VALUES("21", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2285", "Page Builder Page 2285", "", "", "2285", "{\"total\":146,\"to_translate\":{\"it\":146}}");
INSERT INTO `wp_icl_string_packages` VALUES("22", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2325", "Page Builder Page 2325", "", "", "2325", "{\"total\":5937,\"to_translate\":{\"it\":5937}}");
INSERT INTO `wp_icl_string_packages` VALUES("23", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2339", "Page Builder Page 2339", "", "", "2339", "{\"total\":1649,\"to_translate\":{\"it\":1649}}");
INSERT INTO `wp_icl_string_packages` VALUES("24", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2376", "Page Builder Page 2376", "", "", "2376", "{\"total\":2720,\"to_translate\":{\"it\":2720}}");
INSERT INTO `wp_icl_string_packages` VALUES("26", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2447", "Page Builder Page 2447", "", "", "2447", "{\"total\":218,\"to_translate\":{\"it\":218}}");
INSERT INTO `wp_icl_string_packages` VALUES("27", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2493", "Page Builder Page 2493", "", "", "2493", "{\"total\":774,\"to_translate\":{\"it\":774}}");
INSERT INTO `wp_icl_string_packages` VALUES("28", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2509", "Page Builder Page 2509", "", "", "2509", "{\"total\":252,\"to_translate\":{\"it\":252}}");
INSERT INTO `wp_icl_string_packages` VALUES("29", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2513", "Page Builder Page 2513", "", "", "2513", "{\"total\":206,\"to_translate\":{\"it\":206}}");
INSERT INTO `wp_icl_string_packages` VALUES("30", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2516", "Page Builder Page 2516", "", "", "2516", "{\"total\":99,\"to_translate\":{\"it\":99}}");
INSERT INTO `wp_icl_string_packages` VALUES("31", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2520", "Page Builder Page 2520", "", "", "2520", "{\"total\":463,\"to_translate\":{\"it\":463}}");
INSERT INTO `wp_icl_string_packages` VALUES("32", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2523", "Page Builder Page 2523", "", "", "2523", "{\"total\":337,\"to_translate\":{\"it\":337}}");
INSERT INTO `wp_icl_string_packages` VALUES("33", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2526", "Page Builder Page 2526", "", "", "2526", "{\"total\":298,\"to_translate\":{\"it\":298}}");
INSERT INTO `wp_icl_string_packages` VALUES("34", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2530", "Page Builder Page 2530", "", "", "2530", "{\"total\":333,\"to_translate\":{\"it\":333}}");
INSERT INTO `wp_icl_string_packages` VALUES("35", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2533", "Page Builder Page 2533", "", "", "2533", "{\"total\":197,\"to_translate\":{\"it\":197}}");
INSERT INTO `wp_icl_string_packages` VALUES("36", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2536", "Page Builder Page 2536", "", "", "2536", "{\"total\":206,\"to_translate\":{\"it\":206}}");
INSERT INTO `wp_icl_string_packages` VALUES("37", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2539", "Page Builder Page 2539", "", "", "2539", "{\"total\":124,\"to_translate\":{\"it\":124}}");
INSERT INTO `wp_icl_string_packages` VALUES("38", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2544", "Page Builder Page 2544", "", "", "2544", "{\"total\":212,\"to_translate\":{\"it\":212}}");
INSERT INTO `wp_icl_string_packages` VALUES("39", "gutenberg", "Gutenberg", "3", "Page Builder Page 3", "", "", "3", NULL);
INSERT INTO `wp_icl_string_packages` VALUES("40", "page-builder-shortcode-strings", "Page Builder ShortCode Strings", "2795", "Page Builder Page 2795", "", "", "2795", "{\"total\":169,\"to_translate\":{\"it\":169}}");

/* INSERT TABLE DATA: wp_icl_strings */
INSERT INTO `wp_icl_strings` VALUES("1", "en", "WP", "Blog Title", "Studio Legale Lauro", NULL, NULL, "", "LINE", NULL, "0", "", "5ff0887b4c486c0329311e8d30610d58", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("2", "en", "WP", "Tagline", "International Law Firm", NULL, NULL, "", "LINE", NULL, "0", "", "6e70f8f3e0f8c134711af40ab6e4931b", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("3", "en", "Widgets", "widget title - 13348442cc6a27032d2b4aa28b75a5d3", "Search", NULL, NULL, "", "LINE", NULL, "0", "", "34e49796de494b93f918284a210a0a28", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("4", "en", "Widgets", "widget title - 341825a909ae0a19dd9dbea98ef3e021", "Recent Posts", NULL, NULL, "", "LINE", NULL, "0", "", "7079da0982f3d98e8a287de7ffc3b2c2", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("5", "en", "Widgets", "widget title - 69e7df6b9f7404b4007d936978a45c81", "Recent Comments", NULL, NULL, "", "LINE", NULL, "0", "", "a48c6eb3c5890b18ba90320a27899305", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("6", "en", "Widgets", "widget title - 178fde647037235223ac2a188a7106b1", "Archives", NULL, NULL, "", "LINE", NULL, "0", "", "478de4f6942954a0e26a7509c7d6152c", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("7", "en", "Widgets", "widget title - af1b98adf7f686b84cd0b443e022b7a0", "Categories", NULL, NULL, "", "LINE", NULL, "0", "", "5977452b184084c8b2c0d046daf75b27", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("8", "en", "Widgets", "widget title - b6755d218d5f4e1cef9cce9cc39aeda9", "Meta", NULL, NULL, "", "LINE", NULL, "0", "", "26a7f7efe61aa93765d79561fb28d76c", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("9", "en", "Widgets", "widget title - fb2819bc418c6b3a0c30230c3d2e14f3", "Instagram Feed", NULL, NULL, "", "LINE", NULL, "0", "", "fa4524b2fc6fadddd3115fbf7c96010a", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("10", "en", "Widgets", "widget title - 189f63f277cd73395561651753563065", "Tags", NULL, NULL, "", "LINE", NULL, "0", "", "81b49e018731719bfedf225b54f0c28d", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("11", "en", "Widgets", "widget title - bbaff12800505b22a853e8b7f4eb6a22", "Contact", NULL, NULL, "", "LINE", NULL, "0", "", "14d26c6e8f474f59c1bb03c009a1d251", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("12", "en", "Widgets", "widget title - eccaad13d49e3c11621d8e37328d6ed3", "Brochures", NULL, NULL, "", "LINE", NULL, "0", "", "e59c809a8e854cfb48d6b747e2937b72", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("13", "en", "Widgets", "widget title - 408b5bf3030e4b0e383628f5e4d87b31", "Product categories", NULL, NULL, "", "LINE", NULL, "0", "", "3ce0ea729e42a9db284f9b0e33b989df", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("14", "en", "Widgets", "widget title - 048af7b74c6719b139cfa16608cd90e0", "Price Range", NULL, NULL, "", "LINE", NULL, "0", "", "622283b8680df0dfb40868d3b4786e79", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("15", "en", "Widgets", "widget title - 7b247f76c157672226ab7131e6ac91c0", "Popular Tags", NULL, NULL, "", "LINE", NULL, "0", "", "e15f22870edb5e419d27c8f7b4716a6d", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("16", "en", "Widgets", "widget title - 98f770b0af18ca763421bac22b4b6805", "Features", NULL, NULL, "", "LINE", NULL, "0", "", "0679185e16b5a76ad2a3b707c1c63c17", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("17", "en", "Widgets", "widget title - bd908db5ccb07777ced8023dffc802f4", "Links", NULL, NULL, "", "LINE", NULL, "0", "", "fbae9ad185cab05f727ab55bbf0bda08", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("18", "en", "Widgets", "widget title - db5eb84117d06047c97c9a0191b5fffe", "Support", NULL, NULL, "", "LINE", NULL, "0", "", "ba0429cc81b9fc46e5f0362f33922a2a", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("19", "en", "Widgets", "widget body - 090a0bb174f8ab05c7da796ced1e5429", "[instagram-feed]", NULL, NULL, "", "LINE", NULL, "0", "", "03c8f81e0b78a34357c0a0e16e296f71", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("205", "en", "admin_texts_sb_instagram_settings", "[sb_instagram_settings]sb_instagram_btn_background", "", NULL, NULL, "", "LINE", NULL, "0", "", "28253d28f09012e7dd42dd920b04d7a8", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("20", "en", "Widgets", "widget body - 7e2510f0f85c839097e93c76016418b9", "[vc_gallery type=\"image_grid\" images=\"217,218,219,220,221,222\" img_size=\"580x580\"]", NULL, NULL, "", "LINE", NULL, "0", "", "c943a0e1669a2ee3e69da9e660a74b70", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("21", "en", "Widgets", "widget body - efdb8751b7a751651196dffe6534fdd5", "View our brochure for an easy to read guide on\r\nall of the services offer.", NULL, NULL, "", "LINE", NULL, "0", "", "7a9fa640a02c63ffbdad4650d85854d9", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("22", "en", "Widgets", "widget body - 27bb0ae34a45c70429ad2b6dad546201", "<div align=\"justify\"><span style=\"color: #999;\"><strong>Studio Legale Lauro</strong> is an Italian law firm, established in 1993 in Naples, providing a wide range of legal services in maritime, commercial and international law matters to the global maritime business sector and industries.</span></div>", NULL, NULL, "", "LINE", NULL, "0", "", "fce4daebbbf2ae598b864366bc252103", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("23", "en", "WP Endpoints", "wc-api", "wc-api", NULL, NULL, "", "LINE", NULL, "0", "", "3a448b300c73de9c6696651892b08d2f", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("24", "en", "WP Endpoints", "order-pay", "order-pay", NULL, NULL, "", "LINE", NULL, "0", "", "8d0ee533eb6eaa9960c52ecb3fc80232", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("25", "en", "WP Endpoints", "order-received", "order-received", NULL, NULL, "", "LINE", NULL, "0", "", "788874ce72f23c1454f440b8d35815b3", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("26", "en", "WP Endpoints", "orders", "orders", NULL, NULL, "", "LINE", NULL, "0", "", "f5f9fc388041e059c8b1f83336b490df", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("27", "en", "WP Endpoints", "view-order", "view-order", NULL, NULL, "", "LINE", NULL, "0", "", "3279ebce985565d6e492128e2981a27f", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("28", "en", "WP Endpoints", "downloads", "downloads", NULL, NULL, "", "LINE", NULL, "0", "", "0a4c47a0b5584af61c4bd049d4094237", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("29", "en", "WP Endpoints", "edit-account", "edit-account", NULL, NULL, "", "LINE", NULL, "0", "", "36476fa1633a9e4b0232405f0d2e4cf2", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("30", "en", "WP Endpoints", "edit-address", "edit-address", NULL, NULL, "", "LINE", NULL, "0", "", "ee95f503da62c65deeb3cea2062457b7", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("31", "en", "WP Endpoints", "payment-methods", "payment-methods", NULL, NULL, "", "LINE", NULL, "0", "", "060b683c986aad1749b3cc6a96cc79c4", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("32", "en", "WP Endpoints", "lost-password", "lost-password", NULL, NULL, "", "LINE", NULL, "0", "", "0e6b21413665a6946ffda25342fb8beb", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("33", "en", "WP Endpoints", "customer-logout", "customer-logout", NULL, NULL, "", "LINE", NULL, "0", "", "63708032f00538fbd9da6f9245ad98be", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("34", "en", "WP Endpoints", "add-payment-method", "add-payment-method", NULL, NULL, "", "LINE", NULL, "0", "", "4a4b86ea8e48687226190a36bb9581b7", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("35", "en", "WP Endpoints", "delete-payment-method", "delete-payment-method", NULL, NULL, "", "LINE", NULL, "0", "", "b24cb5a8ef00d18f0cb571af1194306b", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("36", "en", "WP Endpoints", "set-default-payment-method", "set-default-payment-method", NULL, NULL, "", "LINE", NULL, "0", "", "a0543fd199bc5816586c5a7f2459f655", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("37", "en", "Widgets", "widget title - d41d8cd98f00b204e9800998ecf8427e", "", NULL, NULL, "", "LINE", NULL, "0", "", "27952cd44e714f41ed62a77832f75b34", "", NULL);
INSERT INTO `wp_icl_strings` VALUES("135", "en", "page-builder-shortcode-strings-229", "f4bac7761b89f8250c767d1775311012", "[ct_contact_info style=\"style2\" content_color=\"#ffffff\" content_type=\"tel\" icon_list=\"flaticon\" content_info=\"+39 081 5800199\" icon_flaticon=\"flaticon-phone-call\"][vc_empty_space height=\"17\"][ct_contact_info style=\"style2\" content_color=\"#ffffff\" content_type=\"tel\" icon_list=\"flaticon\" content_info=\"info@studiolegalelauro.it\" icon_flaticon=\"flaticon-chat\"]", "1", "23", "", "VISUAL", "vc_column_inner: content", "0", "", "9f55d3fe94cfc5cfed08da3b1d96904c", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("68", "en", "page-builder-shortcode-strings-649", "44ac304ab346f39fd25755c51359e594", "\r\n<ul class=\"ct-list\">\r\n 	<li>Sed do eiusmod tempor incididunt ut</li>\r\n 	<li>Labore et dolore magna aliqua</li>\r\n 	<li>Ut enim ad minim veniam quis nostrud</li>\r\n 	<li>Andomised words which don\'t look</li>\r\n</ul>\r\n", "2", "2", "", "VISUAL", "vc_column_text: content", "0", "", "de19d5ab4dea11f25e51af61fd03d81c", "optional", "24");
INSERT INTO `wp_icl_strings` VALUES("69", "en", "page-builder-shortcode-strings-649", "d39a66da6ceecc308f7f130e82925847", "Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudan\r\ntium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.\r\n\r\nNemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequun\r\ntur magni dolores eos qui ratione voluptatem sequi nesciunt.", "2", "7", "", "VISUAL", "vc_column_text: content", "0", "", "8dc0abaa9cf541275213f98be8188d13", "optional", "56");
INSERT INTO `wp_icl_strings` VALUES("212", "en", "page-builder-shortcode-strings-246", "995f0c8a4e671977d438d7781de3ad02", "[ct_box_background_image bg_image=\"2049\" layer_image=\"2052\" box_height=\"551\" box_height_mobile=\"350\"]", "11", "2", "", "VISUAL", "vc_column: content", "0", "", "95f769ad1035ddee42d6133b86600dcf", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("185", "en", "page-builder-shortcode-strings-2155", "f4819bc9a329b1e95bd757d3319e520f", "[vc_empty_space height=\"92px\"]", "8", "1", "", "VISUAL", "vc_column: content", "0", "", "c173eaf4b9352ec4d49e77cf2096e0c6", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("67", "en", "page-builder-shortcode-strings-649", "80cd1442b9049a0f670f58b9051a0cef", "There are many variations of passages of Lorem Ipsum available, but the majority have suffered altera\r\ntion in some form, by injected humour, or randomised words which don\'t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn\'t anything embarrassing hidden.\r\n\r\nAll the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet.", "2", "1", "", "VISUAL", "vc_column_text: content", "0", "", "e4bfd276e1d5477dbc015bc077d6853d", "optional", "79");
INSERT INTO `wp_icl_strings` VALUES("179", "en", "page-builder-shortcode-strings-1359", "f4819bc9a329b1e95bd757d3319e520f", "[vc_empty_space height=\"92px\"]", "7", "1", "", "VISUAL", "vc_column: content", "0", "", "51b031b16926010a96f1216e77ec0484", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("673", "en", "page-builder-shortcode-strings-1359", "dd7932c75285537c7ca87cb57a378553", "[vc_empty_space][ct_team_member image=\"2092\" social=\"%5B%7B%7D%5D\" title=\"Francesco S. Lauro\" el_class=\"single-team\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"42\"]", "7", "2", "", "VISUAL", "vc_column: content", "0", "", "8091a8832821acf889ef66f14636f2ec", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("437", "en", "page-builder-shortcode-strings-2155", "6bc32a36e77b43c9a2e7daf3591b21b3", "\r\n<div align=\"justify\">\r\n\r\n<strong><strong>Ernesto Ardia </strong></strong>is a founding partner of Studio Legale Lauro, and was admitted to the Italian Bar in 1995. He represents clients in court and in international arbitrations, as well as before the Supreme Court.\r\n\r\nHe is active in shipping, commercial and corporate law. Ernesto is known for representing ship-owners in collisions, salvage and marine pollution.\r\n\r\nHe also receives instructions from clients worldwide, to enforce domestic and foreign court and arbitration judgments in Italian courts. He has on occasion dealt with bankruptcy proceedings.\r\n\r\nHe is a member of the International Propeller Club.\r\n\r\n</div>\r\n", "8", "3", "", "VISUAL", "vc_column_text: content", "0", "", "cf16034ed451b203a06b5bfb6c63ea6d", "optional", "93");
INSERT INTO `wp_icl_strings` VALUES("604", "en", "gutenberg-3", "3dd0a4229b899ec8637cf00ce4568714", "If you edit or publish an article, an additional cookie will be saved in your browser. This cookie includes no personal data and simply indicates the post ID of the article you just edited. It expires after 1 day.", "39", "14", "", "LINE", "core/paragraph", "0", "", "ae708292fe3d550570c6ac1c01259946", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("748", "en", "page-builder-shortcode-strings-2795", "ef3db4db70bd789f79f9c04f02c3a48b", "[vc_empty_space][ct_team_member image=\"2792\" social=\"%5B%7B%7D%5D\" title=\"Carlo Iannello\" el_class=\"single-team\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"42\"]", "40", "2", "", "VISUAL", "vc_column: content", "0", "", "85e568e5d70ae589b05d2a7225f07357", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("747", "en", "page-builder-shortcode-strings-2795", "f4819bc9a329b1e95bd757d3319e520f", "[vc_empty_space height=\"92px\"]", "40", "1", "", "VISUAL", "vc_column: content", "0", "", "887ad25e0713cadcc42e9af3b3efee09", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("394", "en", "page-builder-shortcode-strings-2447", "f4819bc9a329b1e95bd757d3319e520f", "[vc_empty_space height=\"92px\"]", "26", "1", "", "VISUAL", "vc_column: content", "0", "", "a97ef1a277b25f01a47b4f621a753a28", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("678", "en", "page-builder-shortcode-strings-2447", "9ec4c050418357a8af20dd0ddf98a306", "[vc_empty_space][ct_team_member image=\"2701\" social=\"%5B%7B%7D%5D\" title=\"Valentina Tremante\" el_class=\"single-team\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"42\"]", "26", "2", "", "VISUAL", "vc_column: content", "0", "", "785a6a4c51d19ff6b0bb6e8b534a5997", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("202", "en", "page-builder-shortcode-strings-2164", "3991a5ae47f2f4debe92bdc40f17db8d", "[ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"12\"][ct_icon icon=\"%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22icon_link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-dribbble%22%2C%22icon_link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22icon_link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22icon_link%22%3A%22%23%22%7D%5D\"]", "10", "5", "", "VISUAL", "vc_column_inner: content", "0", "", "54bfbf66708182b150145590a6ecb692", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("191", "en", "page-builder-shortcode-strings-2160", "f4819bc9a329b1e95bd757d3319e520f", "[vc_empty_space height=\"92px\"]", "9", "1", "", "VISUAL", "vc_column: content", "0", "", "112256f6bd84e1b1554a6e1c6f32d98f", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("203", "en", "page-builder-shortcode-strings-2164", "66e0560262493cac64a0cf40b3c524ca", "[ct_contact_info content_type=\"tel\" icon_list=\"fontawesome5\" icon_fontawesome5=\"fac fac-phone\" content_info=\"+39 081 5800199\" el_class=\"contact-info-group\"][ct_contact_info content_type=\"email\" icon_fontawesome=\"fa fa-envelope\" content_info=\"annavernillo@studiolegalelauro.it\" el_class=\"contact-info-group\"]", "10", "4", "", "VISUAL", "vc_column_inner: content", "0", "", "f7a6146063c62d8bffc4f83838a94c10", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("127", "en", "page-builder-shortcode-strings-229", "80d1cc56c4585d6aba54d1576060f7c2", "[rev_slider alias=\"home1-1\"]", "1", "1", "", "VISUAL", "vc_column: content", "0", "", "7dea79dcb3dfcc58fc212984cfc7c20b", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("830", "en", "page-builder-shortcode-strings-238", "f19715a720316c7dc6fe04a44df468e7", "</p>\r\n<h2 class=\"wpb_heading wpb_singleimage_heading\" style=\"text-align: center;\"><span style=\"color: #000000;\"><a style=\"color: #000000;\" href=\"https://sviluppo.studiolegalelauro.it/icc-young-arbitrators-forum/\">Young Arbitration Forum (YAF)</a></span></h2>\r\n<p>", "15", "4", "", "VISUAL", "vc_column_text: content", "0", "", "02d2fbf8f6894a23f9c96bbb88aba309", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("786", "en", "page-builder-shortcode-strings-2285", "16c1af81eab24209f56e32ae4dcf9127", "\r\n<div align=\"justify\">\r\n\r\nStudio Legale Lauro is always committed to promoting the personal and professional growth of its young professionals. This is only possible through the development of a friendly work environment which encourages cooperation among colleagues as well as the exchange of ideas. We strongly promote the presence of professionals with different legal backgrounds.\r\n\r\nWe are aware that our future is strictly related to the professional growth of our young lawyers. Our aim is to select the best Italians and foreign graduates. Therefore our partners follow recruitment in a very detailed way.\r\n\r\nIf you are interested in joining us and would like an interview, provided that you have the requirements for doing so, please send us your curriculum vitae as well as your transcripts and a personal statement explaining your interest in us to info@studiolegalelauro.it.\r\nYou will receive a reply within three weeks following your request.\r\n\r\n</div>\r\n", "21", "1", "", "VISUAL", "vc_column_text: content", "0", "", "07159ae4969955c2f28b633055444893", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("620", "en", "gutenberg-3", "2628e1ddbe9850a6d8f94ba089af3584", "What data breach procedures we have in place", "39", "30", "h3", "LINE", "core/heading", "0", "", "c8e31e2bf53a509e75c92d1c8c46772f", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("134", "en", "page-builder-shortcode-strings-229", "ed8f7313a8cd6edcba29467b3f45f5be", "[ct_contact_info style=\"style2\" content_color=\"#ffffff\" icon_list=\"flaticon\" content_info=\"Via Cardinale Guglielmo Sanfelice, 8 - 80134 Napoli (Italy)\" icon_flaticon=\"flaticon-placeholder\"]", "1", "22", "", "VISUAL", "vc_column_inner: content", "0", "", "a57fe41893f9e2f4a6233473a837d1a6", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("737", "en", "page-builder-shortcode-strings-2513", "f9f83362dfe86e73747a1a9758c73ab7", "[vc_empty_space][ct_team_member image=\"2757\" social=\"%5B%7B%7D%5D\" title=\"Mark Clough QC\" el_class=\"single-team\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"42\"]", "29", "2", "", "VISUAL", "vc_column: content", "0", "", "ff7632359506e3567cbc155a84beaef4", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("735", "en", "page-builder-shortcode-strings-2516", "96987cce443faf9fda070fef077b9622", "</p>\r\n<div align=\"justify\">\r\n<p><strong>Roderick Cordara</strong> is a leading UK shipping lawyer. He is a member of Essex Court Chambers, London. He has over 30 years’ experience in the shipping field. He acts as advocate and arbitrator. He has expertise in charter party &amp; bill of lading issues, marine insurance, and has also specialised in shipbuilding disputes world-wide. He has also acted in UK Government maritime enquiries.</p>\r\n<p>He is a Queen’s Counsel in the UK and Senior Counsel in Australia, where he has chambers. He read law at Cambridge University (BA 1st class). He sits as arbitrator in shipping &amp; shipbuilding matters.</div>\r\n<p>", "30", "3", "", "VISUAL", "vc_column_text: content", "0", "", "cf1b674debe355ba85580f61c794464b", "optional", "99");
INSERT INTO `wp_icl_strings` VALUES("835", "en", "page-builder-shortcode-strings-232", "2fdf51d19207b03dc000d37957fb64cb", "\r\n<h4 style=\"text-align: center;\"><strong><span style=\"color: #000000;\"><a style=\"color: #000000;\" href=\"https://sviluppo.studiolegalelauro.it/Expertise/banking-and-corporate-finance/\">BANKING &amp; CORPORATE FINANCE</a></span></strong></h4>\r\n", "12", "4", "", "VISUAL", "vc_column_text: content", "0", "", "4e928408fb81baec371557eb3db0dcb2", "optional", "4");
INSERT INTO `wp_icl_strings` VALUES("70", "en", "page-builder-shortcode-strings-649", "eda63b570db82e05c2fd7b5f0c3bb20f", "Audit", "2", "4", "", "LINE", "vc_tta_section: title", "0", "", "6344cc72c003c497495e15afa7aef71f", "optional", "1");
INSERT INTO `wp_icl_strings` VALUES("71", "en", "page-builder-shortcode-strings-649", "83de191c12c3c109006c4593128d8bb6", "Strategy", "2", "6", "", "LINE", "vc_tta_section: title", "0", "", "513617052f6f3f6d2708af9f24d525e9", "optional", "1");
INSERT INTO `wp_icl_strings` VALUES("72", "en", "page-builder-shortcode-strings-649", "19bea5bec76c66ef8bd189aa23a4c860", "Sustainability", "2", "8", "", "LINE", "vc_tta_section: title", "0", "", "816cfd848f8f5f20ff33d4775f07ce77", "optional", "1");
INSERT INTO `wp_icl_strings` VALUES("599", "en", "gutenberg-3", "07ba9d77d430d118d299360255dac4f1", "Contact forms", "39", "9", "h3", "LINE", "core/heading", "0", "", "bc5b4ef748832b8eca1a1717aecd3cb3", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("600", "en", "gutenberg-3", "7a8d96f03f84c9ede39e1f8033cbeb46", "Cookies", "39", "10", "h3", "LINE", "core/heading", "0", "", "5b3e5f105ae83b6b52e32f25b6e1a2bd", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("601", "en", "gutenberg-3", "f96c570e659d1e80084446210267f518", "If you leave a comment on our site you may opt-in to saving your name, email address and website in cookies. These are for your convenience so that you do not have to fill in your details again when you leave another comment. These cookies will last for one year.", "39", "11", "", "LINE", "core/paragraph", "0", "", "5cd2c6cd76d8ab5ffdf98bd1e963155e", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("597", "en", "gutenberg-3", "c4d6dbe16261202a8a2f0cea31ca8fd3", "Media", "39", "7", "h3", "LINE", "core/heading", "0", "", "12675a823862c3668f5357ad51400b72", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("598", "en", "gutenberg-3", "9c6be572a444a512980d43e76e601e89", "If you upload images to the website, you should avoid uploading images with embedded location data (EXIF GPS) included. Visitors to the website can download and extract any location data from images on the website.", "39", "8", "", "LINE", "core/paragraph", "0", "", "1699ab584f7086282e1bb9a4508c1f1e", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("789", "en", "page-builder-shortcode-strings-647", "d05d2248e6a20069c0abfbbb4c344b3c", "\r\n<div align=\"justify\">\r\n\r\nStudio Legale Lauro advises public and private clients in developing a safe strategy to yield an enduring advantage in the energy market by focusing strong on the new international and european regulations, conceiving a path of sustainability which takes account of the latest innovations in fossil fuels as well as the green economy concerns, in terms of alternative energy sources.\r\n\r\nThe Firm assists its clients in litigations and disputes arising from fossil fuels disasters – such as oil tankers collisions, bunkers disputes, and every marine pollution related issues.\r\n\r\nThe Firm, through its experts, helps the clients to build a company strategy to prevent the risks and to limit the corporate liability for environmental harms under international and domestic civil and administrative regulations.\r\n\r\n</div>\r\n", "4", "1", "", "VISUAL", "vc_column_text: content", "0", "", "342f78708ff23e270c316eb8c4aa88cb", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("580", "en", "Cookie Notice", "step_two_title", "", NULL, NULL, "", "LINE", NULL, "0", "", "852e9c195b62b64903db893870c7be95", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("581", "en", "Cookie Notice", "step_two_desc", "", NULL, NULL, "", "LINE", NULL, "0", "", "bca40af9cbb4070aa869968114af24dc", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("582", "en", "Cookie Notice", "step_three_title", "", NULL, NULL, "", "LINE", NULL, "0", "", "b772cd5b24d653abcb314839e549d7fe", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("583", "en", "Cookie Notice", "step_three_desc", "", NULL, NULL, "", "LINE", NULL, "0", "", "cff697b310bed2c83b99bbce85904655", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("584", "en", "Cookie Notice", "step_four_title", "", NULL, NULL, "", "LINE", NULL, "0", "", "fcf9e5aaf115273f3fb651bc93fd6229", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("585", "en", "Cookie Notice", "step_four_desc", "", NULL, NULL, "", "LINE", NULL, "0", "", "8be072c2232306b1de81ae85bdb48c24", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("586", "en", "Cookie Notice", "step_five_title", "", NULL, NULL, "", "LINE", NULL, "0", "", "6ca54e88fcb1996ec410d48faf003714", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("587", "en", "Cookie Notice", "step_five_desc", "", NULL, NULL, "", "LINE", NULL, "0", "", "b516f5bd7b032b20d746fe7143447c11", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("588", "en", "Cookie Notice", "confirmed", "", NULL, NULL, "", "LINE", NULL, "0", "", "8be2b8e66366be88a761112c3e347f6c", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("589", "en", "Cookie Notice", "recovered", "", NULL, NULL, "", "LINE", NULL, "0", "", "1bcaac0c7ed9ee06b07cbcb5208b47eb", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("590", "en", "Cookie Notice", "Custom link", "", NULL, NULL, "", "LINE", NULL, "0", "", "694489ef617805c56e417f38900b9982", "", NULL);
INSERT INTO `wp_icl_strings` VALUES("591", "en", "gutenberg-3", "b74b235bcbf0e7c49291a61f2d50efe0", "Who we are", "39", "1", "h2", "LINE", "core/heading", "0", "", "0c01ba0a680c4d039375e15032ecafda", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("592", "en", "gutenberg-3", "a4b3601f6b3ce11959a18da3ad915f2c", "Our website address is: http://sviluppo.studiolegalelauro.it.", "39", "2", "", "LINE", "core/paragraph", "0", "", "89b96ce2c8d0dae9511ac2c869935d0f", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("593", "en", "gutenberg-3", "09f8863012003cf8537a1766bc3d5c5d", "What personal data we collect and why we collect it", "39", "3", "h2", "LINE", "core/heading", "0", "", "5c410bf6b282fc7b447d22573e39dabf", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("594", "en", "gutenberg-3", "f96e9874a2de2cdd1fe0b8a1c6aa6951", "Comments", "39", "4", "h3", "LINE", "core/heading", "0", "", "c4ac2e24c7dc20ac6fe0ff4613ec5e6f", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("595", "en", "gutenberg-3", "15457895bb970c750b1afa98567ccacc", "When visitors leave comments on the site we collect the data shown in the comments form, and also the visitor’s IP address and browser user agent string to help spam detection.", "39", "5", "", "LINE", "core/paragraph", "0", "", "6d92eaff71144ac4d28ad0c1d1055211", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("85", "en", "page-builder-shortcode-strings-646", "80cd1442b9049a0f670f58b9051a0cef", "There are many variations of passages of Lorem Ipsum available, but the majority have suffered altera\r\ntion in some form, by injected humour, or randomised words which don\'t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn\'t anything embarrassing hidden.\r\n\r\nAll the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet.", "5", "1", "", "VISUAL", "vc_column_text: content", "0", "", "c77c6c94234ba4e768ec5904addfb832", "optional", "79");
INSERT INTO `wp_icl_strings` VALUES("86", "en", "page-builder-shortcode-strings-646", "44ac304ab346f39fd25755c51359e594", "\r\n<ul class=\"ct-list\">\r\n 	<li>Sed do eiusmod tempor incididunt ut</li>\r\n 	<li>Labore et dolore magna aliqua</li>\r\n 	<li>Ut enim ad minim veniam quis nostrud</li>\r\n 	<li>Andomised words which don\'t look</li>\r\n</ul>\r\n", "5", "2", "", "VISUAL", "vc_column_text: content", "0", "", "bfd6fee43016a9a6c7f5ea166fe8575d", "optional", "24");
INSERT INTO `wp_icl_strings` VALUES("87", "en", "page-builder-shortcode-strings-646", "d39a66da6ceecc308f7f130e82925847", "Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudan\r\ntium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.\r\n\r\nNemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequun\r\ntur magni dolores eos qui ratione voluptatem sequi nesciunt.", "5", "7", "", "VISUAL", "vc_column_text: content", "0", "", "64fba996616af1e4457c31ef57230cc3", "optional", "56");
INSERT INTO `wp_icl_strings` VALUES("88", "en", "page-builder-shortcode-strings-646", "eda63b570db82e05c2fd7b5f0c3bb20f", "Audit", "5", "4", "", "LINE", "vc_tta_section: title", "0", "", "2220b41501702a03fcb43f3aa2bec9fd", "optional", "1");
INSERT INTO `wp_icl_strings` VALUES("89", "en", "page-builder-shortcode-strings-646", "83de191c12c3c109006c4593128d8bb6", "Strategy", "5", "6", "", "LINE", "vc_tta_section: title", "0", "", "c83a0337c3f6156f9b707699be036ff0", "optional", "1");
INSERT INTO `wp_icl_strings` VALUES("90", "en", "page-builder-shortcode-strings-646", "19bea5bec76c66ef8bd189aa23a4c860", "Sustainability", "5", "8", "", "LINE", "vc_tta_section: title", "0", "", "06b3dd4a6574862ec70c670eee7392b0", "optional", "1");
INSERT INTO `wp_icl_strings` VALUES("91", "en", "page-builder-shortcode-strings-645", "80cd1442b9049a0f670f58b9051a0cef", "There are many variations of passages of Lorem Ipsum available, but the majority have suffered altera\r\ntion in some form, by injected humour, or randomised words which don\'t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn\'t anything embarrassing hidden.\r\n\r\nAll the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet.", "6", "1", "", "VISUAL", "vc_column_text: content", "0", "", "455b9c881b2f89e4307c5b4580745f4a", "optional", "79");
INSERT INTO `wp_icl_strings` VALUES("92", "en", "page-builder-shortcode-strings-645", "44ac304ab346f39fd25755c51359e594", "\r\n<ul class=\"ct-list\">\r\n 	<li>Sed do eiusmod tempor incididunt ut</li>\r\n 	<li>Labore et dolore magna aliqua</li>\r\n 	<li>Ut enim ad minim veniam quis nostrud</li>\r\n 	<li>Andomised words which don\'t look</li>\r\n</ul>\r\n", "6", "2", "", "VISUAL", "vc_column_text: content", "0", "", "e0f802b28df0538889b2862c0a557816", "optional", "24");
INSERT INTO `wp_icl_strings` VALUES("93", "en", "page-builder-shortcode-strings-645", "d39a66da6ceecc308f7f130e82925847", "Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudan\r\ntium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.\r\n\r\nNemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequun\r\ntur magni dolores eos qui ratione voluptatem sequi nesciunt.", "6", "7", "", "VISUAL", "vc_column_text: content", "0", "", "ac2ecd351d514257461921348652df9e", "optional", "56");
INSERT INTO `wp_icl_strings` VALUES("94", "en", "page-builder-shortcode-strings-645", "eda63b570db82e05c2fd7b5f0c3bb20f", "Audit", "6", "4", "", "LINE", "vc_tta_section: title", "0", "", "f794af61c8c4535146eddf1af00c6810", "optional", "1");
INSERT INTO `wp_icl_strings` VALUES("95", "en", "page-builder-shortcode-strings-645", "83de191c12c3c109006c4593128d8bb6", "Strategy", "6", "6", "", "LINE", "vc_tta_section: title", "0", "", "d3451fb088af9d0d5ab310e2439cd724", "optional", "1");
INSERT INTO `wp_icl_strings` VALUES("96", "en", "page-builder-shortcode-strings-645", "19bea5bec76c66ef8bd189aa23a4c860", "Sustainability", "6", "8", "", "LINE", "vc_tta_section: title", "0", "", "c6dc48870f858f8cc276392f951cf473", "optional", "1");
INSERT INTO `wp_icl_strings` VALUES("520", "en", "page-builder-shortcode-strings-2447", "48515c323dc4f39add52246604f84127", "[ct_contact_info content_type=\"tel\" icon_list=\"fontawesome5\" icon_fontawesome5=\"fac fac-phone\" content_info=\"+39 081 5800199\" el_class=\"contact-info-group\"][ct_contact_info content_type=\"email\" icon_fontawesome=\"fa fa-envelope\" content_info=\"valentinatremante@studiolegalelauro.it\" el_class=\"contact-info-group\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"12\"]", "26", "4", "", "VISUAL", "vc_column_inner: content", "0", "", "ad6ef9f0ea3a5a86417e3a5f8d21bdee", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("303", "en", "page-builder-shortcode-strings-229", "fe1af83247bdd6bd586833c9966f9238", "[rev_slider alias=\"home2\"][vc_empty_space height=\"92px\"]", "1", "19", "", "VISUAL", "vc_column: content", "0", "", "754f904b1e666e556934e7b8f4240778", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("606", "en", "gutenberg-3", "9b9215d44174c699fcba1da009938299", "Articles on this site may include embedded content (e.g. videos, images, articles, etc.). Embedded content from other websites behaves in the exact same way as if the visitor has visited the other website.", "39", "16", "", "LINE", "core/paragraph", "0", "", "22c97f1a2a266f0f6029d1c068eca6af", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("519", "en", "page-builder-shortcode-strings-2444", "ffd5b26f8059b3dc53a92ea9db788dd5", "[ct_contact_info content_type=\"tel\" icon_list=\"fontawesome5\" icon_fontawesome5=\"fac fac-phone\" content_info=\"+39 081 5800199\" el_class=\"contact-info-group\"][ct_contact_info content_type=\"email\" icon_fontawesome=\"fa fa-envelope\" content_info=\"giuseppedesanto@studiolegalelauro.it\" el_class=\"contact-info-group\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"12\"]", "25", "4", "", "VISUAL", "vc_column_inner: content", "0", "", "4c5d5d33dd1b6fa3d269f1630381d6b7", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("195", "en", "page-builder-shortcode-strings-2160", "3991a5ae47f2f4debe92bdc40f17db8d", "[ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"12\"][ct_icon icon=\"%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22icon_link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-dribbble%22%2C%22icon_link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22icon_link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22icon_link%22%3A%22%23%22%7D%5D\"]", "9", "5", "", "VISUAL", "vc_column_inner: content", "0", "", "5290a80437d4ff0b9a19f61845b597c0", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("607", "en", "gutenberg-3", "c7edd02bc3ad749d12747f0c08530128", "These websites may collect data about you, use cookies, embed additional third-party tracking, and monitor your interaction with that embedded content, including tracking your interaction with the embedded content if you have an account and are logged in to that website.", "39", "17", "", "LINE", "core/paragraph", "0", "", "cedce8c898e878b521c62d6ac588b8ba", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("518", "en", "page-builder-shortcode-strings-1359", "b4a738cd435e86781d800cd00e64bc89", "[ct_contact_info content_type=\"tel\" icon_list=\"fontawesome5\" icon_fontawesome5=\"fac fac-phone\" content_info=\"+39 081 5800199\" el_class=\"contact-info-group\"][ct_contact_info content_type=\"email\" icon_fontawesome=\"fa fa-envelope\" content_info=\"francescolauro@studiolegalelauro.it\" el_class=\"contact-info-group\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"12\"]", "7", "4", "", "VISUAL", "vc_column_inner: content", "0", "", "17bf3bb6eac831f2f33642af8dc1a364", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("189", "en", "page-builder-shortcode-strings-2155", "3991a5ae47f2f4debe92bdc40f17db8d", "[ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"12\"][ct_icon icon=\"%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22icon_link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-dribbble%22%2C%22icon_link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22icon_link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22icon_link%22%3A%22%23%22%7D%5D\"]", "8", "5", "", "VISUAL", "vc_column_inner: content", "0", "", "5b480ea37fbb5de643455e5a14217156", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("144", "en", "page-builder-shortcode-strings-229", "554b802072f342c35140ae5b9f74478a", "[ct_box_background_image bg_image=\"2049\" layer_image=\"2052\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"50\"][vc_empty_space height=\"122px\"]", "1", "3", "", "VISUAL", "vc_column: content", "0", "", "62ce2b87b0458dbe8350a191e41221a1", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("198", "en", "page-builder-shortcode-strings-2164", "f4819bc9a329b1e95bd757d3319e520f", "[vc_empty_space height=\"92px\"]", "10", "1", "", "VISUAL", "vc_column: content", "0", "", "ca3482b113e519be0aa3fc777a478935", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("206", "en", "admin_texts_sb_instagram_settings", "[sb_instagram_settings]sb_instagram_btn_text_color", "", NULL, NULL, "", "LINE", NULL, "0", "", "579926b0dfd0b563576b7b532404c7a7", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("207", "en", "admin_texts_sb_instagram_settings", "[sb_instagram_settings]sb_instagram_btn_text", "Load More...", NULL, NULL, "", "LINE", NULL, "0", "", "c1ea350f56d79c8ebe58a014cdeca720", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("208", "en", "admin_texts_sb_instagram_settings", "[sb_instagram_settings]sb_instagram_folow_btn_background", "#870101", NULL, NULL, "", "LINE", NULL, "0", "", "432fba0a1252f6cb8df2a2ccbb241c9e", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("209", "en", "admin_texts_sb_instagram_settings", "[sb_instagram_settings]sb_instagram_follow_btn_text_color", "", NULL, NULL, "", "LINE", NULL, "0", "", "baed1aa852eefca69d427e33d94a3583", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("210", "en", "admin_texts_sb_instagram_settings", "[sb_instagram_settings]sb_instagram_follow_btn_text", "Follow on Instagram", NULL, NULL, "", "LINE", NULL, "0", "", "da5b5561679fc644a5a8d7187a647915", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("440", "en", "page-builder-shortcode-strings-2164", "4bedabfc1b07c385368de6bcc5999e7c", "<strong>Anna Vernillo</strong> graduated in Law from the University of Naples Federico II cum laude and was admitted to the Italian Bar in 2011.\r\n\r\nAnna trained at well-known law firms in Italy and in the UK, where she acquired extensive expertise in EU Law and international trade law. She has further developed her experience in shipping and commercial law, international law, international private law and transport matters. She is involved in a wide range of the firm’s litigation and international arbitration cases.\r\n\r\nAnna combines local and international litigation expertise with strategic and commercial advice to achieve the best outcome for Italian and foreign businesses. Her experience in domestic and cross-border disputes and international arbitration covers a wide range of matters including commercial agreements, agency agreements, logistic and shipping metters, debt recovery, contractual and non-contractual liability, import-export issues; bankruptcy and real estate issues.\r\n\r\nAnna advices on any issues regarding the entire life cycle of a company and on day-to-day operations.\r\n\r\nShe speaks Italian and English.", "10", "3", "", "VISUAL", "vc_column_text: content", "0", "", "47a06f8d47a9f023657e0f6557a051c6", "optional", "169");
INSERT INTO `wp_icl_strings` VALUES("439", "en", "page-builder-shortcode-strings-2444", "da9384f06cdbae0a15fe11e7dfb57ad8", "<strong>Giuseppe De Santo</strong> (Naples, 27.06.1976) graduated in Law at Federico II University of Naples, qualifying with score of 110/110 cum laude in 2000.\r\n\r\nAdmitted to the Italian Bar in 2004, he has been working the shipping field for almost 20 years during which he acquired significant experience in Maritime Law, including marine casualties, salvage, cargo claims, personal injuries, yachting and sailing related matters, including yacht charter.\r\n\r\nGiuseppe has also developed significant expertise in International Trade matters including, Sale &amp; Purchase operations, Turnkey contracts, site construction contracts, customs related issues.\r\n\r\nGiuseppe’s practice area also includes drafting and reviewing international contracts, among which, agency contracts, shipbuilding contracts, yacht sale purchase/refitting contracts, EPC contracts, O&amp;M contracts, Commodities Sale &amp; Purchase Contracts. Giuseppe is in charge of important litigation cases and contractual matters for the Firm’s clients. In 2011 Giuseppe qualified as a professional mediator.", "25", "3", "", "VISUAL", "vc_column_text: content", "0", "", "847a155bc531cf21b4fdb3d304dc85a7", "optional", "145");
INSERT INTO `wp_icl_strings` VALUES("438", "en", "page-builder-shortcode-strings-2160", "dc8c86534096f292214c3b7e44bb803a", "<strong>Giannicola Forte</strong> advises Italian and foreign clients to built up suitable strategies for their business and activities in Italy or abroad, gaining significant experience on commercial contracts, ship sale and purchase, ship finance and lending transactions, guarantees and securities, corporate structures and joint ventures, commercial litigation, cross-border transactions, environmental and pollution matters.\r\n\r\nGiannicola’s practice covers a wide range of matters including charter-parties, bills of lading disputes, cargo claims, passenger injuries and illness claims, crew claims and contracts, dispute resolution and litigation on Hague Rules/Hague-Visby Rules, Hamburg Rules, and other P&amp;I matters; H&amp;M matters and casualties as collisions, groundings, salvage, towage; ships/bunkers arrest and release; yachting; road carriage; agreements for commercial and business aircraft, aero engines and other aviation assets; share sale and purchase; agency; logistic; liability of freight forwarders, carriers, warehouse keepers; cross-border dispute; import-export trading; bankruptcy, court decisions/arbitration awards enforcements, debt recovery/collection.\r\n\r\nHe also has experience in taxation, real estate, intellectual property, no-profit organizations, and through a professional network coordinates multi-jurisdictional litigations, court decisions/arbitration award enforcements and worldwide actions to secure claims.\r\n\r\nGiannicola is active in charity and cultural projects, is a member of IBA, is admitted to the Italian Bar, Naples’s Section, and speaks Italian, English and Spanish.", "9", "3", "", "VISUAL", "vc_column_text: content", "0", "", "0d5f091a61bb50847579eb1110f33765", "optional", "212");
INSERT INTO `wp_icl_strings` VALUES("613", "en", "gutenberg-3", "cdd4e5562c577440ea6142ddedf026bd", "What rights you have over your data", "39", "23", "h2", "LINE", "core/heading", "0", "", "e8196e8f7b3561b9a7eb05d7af0b0841", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("614", "en", "gutenberg-3", "727cde41f2c6f389b029d3ac67dae1b1", "If you have an account on this site, or have left comments, you can request to receive an exported file of the personal data we hold about you, including any data you have provided to us. You can also request that we erase any personal data we hold about you. This does not include any data we are obliged to keep for administrative, legal, or security purposes.", "39", "24", "", "LINE", "core/paragraph", "0", "", "abb1a9f27a56324110abcf325c11cfe1", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("608", "en", "gutenberg-3", "d8d37c641f27b2d987f4be26c48a848a", "Analytics", "39", "18", "h3", "LINE", "core/heading", "0", "", "f816bfc620880df6c64bc457c5d4358a", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("609", "en", "gutenberg-3", "28c82947e40dffe049b931f3c0bb3fce", "Who we share your data with", "39", "19", "h2", "LINE", "core/heading", "0", "", "9e9b149af592d7827cb8e7ece03db846", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("722", "en", "page-builder-shortcode-strings-250", "2cabaa672290e6fc2f9ea6167ec07a4f", "[ct_team_member image=\"2744\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Ffrancesco-bentivegna%2F|||\" title=\"Francesco Bentivegna\"][vc_empty_space height=\"62px\"]", "14", "9", "", "VISUAL", "vc_column: content", "0", "", "b799251c84e3b8bff2aa6553eec23dd5", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("867", "en", "page-builder-shortcode-strings-229", "5eaf5a084748a290ca604ac5fcc3f79d", "[ct_team_member image=\"2092\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Ffrancesco-lauro%2F|||\" title=\"Francesco S. Lauro\"][vc_empty_space]", "1", "12", "", "VISUAL", "vc_column_inner: content", "0", "", "db8049eb714e81c98b69ef49645bf22f", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("868", "en", "page-builder-shortcode-strings-229", "9c4337890f46e6e3b1b4409f77d4a493", "[ct_team_member image=\"2698\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Fgiuseppe-de-santo%2F|||\" title=\"Giuseppe De Santo\"][vc_empty_space]", "1", "15", "", "VISUAL", "vc_column_inner: content", "0", "", "0462bf472e9f1f2b42c4713d2f2dcf86", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("578", "en", "Cookie Notice", "step_one_title", "", NULL, NULL, "", "LINE", NULL, "0", "", "0bf7e4c4f5ce84d5974f8d9b980314ff", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("579", "en", "Cookie Notice", "step_one_desc", "", NULL, NULL, "", "LINE", NULL, "0", "", "77bc3ff7114fbb74634ce6b5772310d6", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("837", "en", "page-builder-shortcode-strings-232", "fb0b524733935f4be2ae0cd4b8c28442", "\r\n<h4 style=\"text-align: center;\"><strong><span style=\"color: #000000;\"><a style=\"color: #000000;\" href=\"https://sviluppo.studiolegalelauro.it/Expertise/energy/\">ENERGY &amp; ENVIROMENT</a></span></strong></h4>\r\n", "12", "6", "", "VISUAL", "vc_column_text: content", "0", "", "a321e85026c69d886ddf7b151777a360", "optional", "3");
INSERT INTO `wp_icl_strings` VALUES("838", "en", "page-builder-shortcode-strings-232", "14c000f49e8c34a930a32e5c922e0969", "\r\n<p style=\"text-align: justify;\">Studio Legale Lauro advises public and private clients in developing a safe strategy to yield an enduring advantage in the energy market by focusing strong on the new international and european regulations.</p>\r\n", "12", "7", "", "VISUAL", "vc_column_text: content", "0", "", "d86c558139b892dfde8fab62616642e7", "optional", "32");
INSERT INTO `wp_icl_strings` VALUES("842", "en", "page-builder-shortcode-strings-232", "ae60c05ece6e55008eb58a07f097be4a", "[vc_empty_space height=\"92px\"][ct_heading text=\"<span style=\"color: &#96;&#96;#870101&#96;&#96;;\">Expertise</span>\" align_lg=\"align-center\" align_md=\"align-center-md\" align_sm=\"align-center-sm\" align_xs=\"align-center-xs\" font_weight=\"\" text_color=\"#870101\" show_gap=\"show\" description_font_weight=\"inherit\"]", "12", "1", "", "VISUAL", "vc_column: content", "0", "", "cd9cd146545a90842ee26af4f8f5f68f", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("827", "en", "page-builder-shortcode-strings-250", "8594c5b98a18f217fefcb47c33834df6", "</p>\r\n<h2 style=\"text-align: center;\">Of Counsel</h2>\r\n<p>", "14", "8", "", "VISUAL", "vc_column_text: content", "0", "", "06d0f935f9d3c06efb68fe7e4d4a1f6b", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("834", "en", "page-builder-shortcode-strings-232", "887e6108bb14cf701b7aa7863475be05", "\r\n<p style=\"text-align: justify;\">The Firm has developed a significant expertise in the shipping sector through a strong partnership with leading international, european and italian associations of merchant shipowners and operators (ICS, ECSA and CONFITARMA) as well as with the major players of the shipping industry.</p>\r\n", "12", "3", "", "VISUAL", "vc_column_text: content", "0", "", "17cf135a4dfa775fed59e8de660f5f47", "optional", "42");
INSERT INTO `wp_icl_strings` VALUES("865", "en", "page-builder-shortcode-strings-229", "40394232173b00b0dca91d73d3d22b67", "</p>\r\n<h4 style=\"text-align: center;\"><span style=\"color: #ffffff;\">ENERGY &amp; ENVIROMENT</span></h4>\r\n<p>", "1", "9", "", "VISUAL", "vc_column_text: content", "0", "", "a9139a695424616c6ab8c864514ad4d3", "optional", "3");
INSERT INTO `wp_icl_strings` VALUES("866", "en", "page-builder-shortcode-strings-229", "1e2266171fb9c60c99e0947c746f4da9", "</p>\r\n<div align=\"justify\"><a href=\"https://sviluppo.studiolegalelauro.it/index.php/Expertise/energy/\"><span style=\"color: #ffffff;\">Studio Legale Lauro advises public and private clients in developing a safe strategy to yield an enduring advantage in the energy market by focusing strong on the new international and european regulations.</span></a></div>\r\n<p>", "1", "10", "", "VISUAL", "vc_column_text: content", "0", "", "c7d8548ee3c781cebbea584738725d32", "optional", "32");
INSERT INTO `wp_icl_strings` VALUES("726", "en", "page-builder-shortcode-strings-250", "3ba0bdeac23dbb214eeed95c9d0dab04", "[ct_team_member image=\"2754\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Fmark-clough-qc%2F|||\" title=\"Mark Clough QC\"][vc_empty_space height=\"62px\"]", "14", "11", "", "VISUAL", "vc_column: content", "0", "", "e374d195c126cfd0a125ba5b4b4d8c71", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("724", "en", "page-builder-shortcode-strings-2509", "cf3b28aa3fe69b77ce80139be03edce5", "<strong>Arturo Capasso</strong> gained a B.A. in Economics at the Università di Napoli in 1984, a Masters in Business Administration at Columbia University, New York in 1988 and a Ph.D. in Corporate Finance at the Università di Bergamo and Università Cattolica Milano in 1990. In 1990 he became Adjunct Professor Università Parthenope Napoli and in 1994 Assistant Professor Università di Napoli Federico II. In 1998 he became Associate Professor Università di Salerno and he has been a Full Professor at the Università del Sannio since 2002.</p>\r\n<p>Presently he is Professor of Corporate Governance, Director of the Graduate Program in Economics and Management and Director of the Master in Clinical Governance at the Università del Sannio.</p>\r\n<div align=\"justify\">\r\n<p>He is also Professor of Corporate Finance and Professor of Business Valuation at the Master in Economic and Finance (MEF) at the Università di Napoli Federico II.</p>\r\n<p>His chief research interests lie in the areas of corporate strategy, corporate governance, finance, project finance, shipping finance, healthcare management, venture capital and private equity finance.</p>\r\n<p>He was panelist or track organizer in several editions of the AOM Conference and EURAM Conference. Sits in the editorial board of “Journal of Management and Governance” and acts as referee for many international journals. He is an active consultant for many companies and institutions in Italy and abroad. Sits in the board of directors of Vertis SGR (Private Equity and Venture Capital Fund Management). Independent Director in Napoli Servizi S.p.A. (no-profit organization fully owned by the City of Naples).</div>\r\n<p>", "28", "3", "", "VISUAL", "vc_column_text: content", "0", "", "f803a8459e87b0b5b13af341fd9e701a", "optional", "252");
INSERT INTO `wp_icl_strings` VALUES("666", "en", "page-builder-shortcode-strings-250", "28dbc496daf475b5e42b0f0442a09d52", "[vc_empty_space height=\"62px\"][ct_team_member image=\"2096\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Fgiannicola-forte%2F|||\" title=\"Giannicola Forte\"]", "14", "4", "", "VISUAL", "vc_column_inner: content", "0", "", "468a287d83f361f5bddc8750cda0d669", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("742", "en", "page-builder-shortcode-strings-2523", "d033bef5576613f8d64a5c2d4c9ee205", "[vc_empty_space][ct_team_member image=\"2781\" social=\"%5B%7B%7D%5D\" title=\"Michele Di Fiore\" el_class=\"single-team\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"42\"]", "32", "2", "", "VISUAL", "vc_column: content", "0", "", "4dff0c00b5c05090089789b6be79f8c5", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("661", "en", "page-builder-shortcode-strings-1359", "d210dd00eacb30bd72f62ff1fa310884", "\r\n<div align=\"justify\">\r\n\r\n<strong>Francesco Saverio Lauro </strong>is the Managing Partner of Studio Legale Lauro. He graduated in law at Federico II University, Naples, qualifying as first in his class and did postgraduate maritime law studies at University College London.\r\n\r\nIn 1993 he founded Studio Legale Lauro with Ernesto Ardia.\r\n\r\nHe was President of the Port Authority of Naples (1996-2000). He is, or has been, Chairman and Board Member of well-known shipping and state owned transportation companies in Italy, Greece and Malta.\r\n\r\nA supporting member of the London Maritime Arbitration Association, Francesco acts as advocate in important commercial disputes before arbitration tribunals worldwide and Italian courts. He has expertise in commercial and maritime law, construction contracts and M&amp;A deals.\r\n\r\nHe is the organizer of the international conference <a href=\"http://www.shippingandthelaw.org/\" target=\"_blank\" rel=\"noopener noreferrer\">Shipping and the Law.</a>\r\n\r\n</div>\r\n", "7", "3", "", "VISUAL", "vc_column_text: content", "0", "", "fe140013420cc9c3d72e76b2d0ba6485", "optional", "129");
INSERT INTO `wp_icl_strings` VALUES("864", "en", "page-builder-shortcode-strings-229", "0fbd197b7992f54488fd592b162aeb4a", "</p>\r\n<div align=\"justify\"><a href=\"https://sviluppo.studiolegalelauro.it/index.php/Expertise/banking-and-corporate-finance/\"><span style=\"color: #ffffff;\">Studio Legale Lauro combines its sector expertise across fields such as shipping, energy market and green economy, with a wealth of experience in the full range of financing products offered to shipowners, traders and exporters.</span></a></div>\r\n<p>", "1", "8", "", "VISUAL", "vc_column_text: content", "0", "", "1495ce26b83dc07ec4e1fcaf9b45de7d", "optional", "35");
INSERT INTO `wp_icl_strings` VALUES("863", "en", "page-builder-shortcode-strings-229", "b1690ba386f86775e3e79c05b593c47a", "</p>\r\n<h4 style=\"text-align: center;\"><span style=\"color: #ffffff;\">BANKING &amp; CORPORATE FINANCE</span></h4>\r\n<p>", "1", "7", "", "VISUAL", "vc_column_text: content", "0", "", "2e5cd9c3b4e975dd25fbbbcfe27ff87b", "optional", "4");
INSERT INTO `wp_icl_strings` VALUES("603", "en", "gutenberg-3", "f3c6bbfeea481f0c62818305b1f1b649", "When you log in, we will also set up several cookies to save your login information and your screen display choices. Login cookies last for two days, and screen options cookies last for a year. If you select \"Remember Me\", your login will persist for two weeks. If you log out of your account, the login cookies will be removed.", "39", "13", "", "LINE", "core/paragraph", "0", "", "654950c62660e9b66d0d1333c523c06c", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("259", "en", "page-builder-shortcode-strings-2209", "cb9d673eef4a2b25b75cd205f364eb5f", "Restructuring Agreements", "17", "5", "", "LINE", "vc_single_image: title", "0", "", "d6bd41e1282d6c16f7e1902c86643a2f", "optional", "2");
INSERT INTO `wp_icl_strings` VALUES("253", "en", "page-builder-shortcode-strings-2209", "8cd8206d6c08ce764c9edf62521ccf06", "Shipping and the Law", "17", "1", "", "LINE", "vc_single_image: title", "0", "", "460081dc28dc6ed5e79580589f186a1d", "optional", "4");
INSERT INTO `wp_icl_strings` VALUES("258", "en", "page-builder-shortcode-strings-2209", "658be31ab84f7d608cb57c0ce30e7d9f", "Young Arbitration Forum (YAF)", "17", "3", "", "LINE", "vc_single_image: title", "0", "", "c19125879490c1270472e205f04f0bd2", "optional", "4");
INSERT INTO `wp_icl_strings` VALUES("257", "en", "page-builder-shortcode-strings-2209", "ec276269316c76215412f4908bfaabe6", "On 15-16 May 2015 Studio Legale Lauro is hosting in Naples a Young Arbitration Forum (YAF).", "17", "6", "", "VISUAL", "vc_column_text: content", "0", "", "10985d305819c8da640739f4f48a4130", "optional", "17");
INSERT INTO `wp_icl_strings` VALUES("255", "en", "page-builder-shortcode-strings-2209", "fcddde4fcb5d213656fd634d0ae5d883", "Shipping and the Law has become an annual appointment for Italy’s maritime industry.", "17", "2", "", "VISUAL", "vc_column_text: content", "0", "", "57cbc263c54ab7cd975c5172ed5dd449", "optional", "13");
INSERT INTO `wp_icl_strings` VALUES("249", "en", "page-builder-shortcode-strings-598", "eda292f7cdd132fcf73437b8856b7d7c", "[ct_heading text=\"<cite>Shipping and the Law</cite>\" align_lg=\"align-center\" align_md=\"align-center-md\" align_sm=\"align-center-sm\" align_xs=\"align-center-xs\" font_size_sm=\"24\" font_size_xs=\"24\" font_weight=\"\" show_gap=\"show\" subtitle=\"Events\" description_font_weight=\"inherit\" margin_bottom=\"0\"]", "16", "1", "", "VISUAL", "vc_column_inner: content", "0", "", "04cca40a7ddc351a3f15fb0393d66aa5", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("250", "en", "page-builder-shortcode-strings-598", "b7a521a3a7504e88b2cd363393a7f287", "Since 2010, Studio Legale Lauro has hosted many of the world major shipping-sector firms at “Shipping &amp; the Law”, the yearly conference held in Naples, to discuss the current hottest topics in the shipping industry.", "16", "2", "", "VISUAL", "vc_column_text: content", "0", "", "5fa9fdef4fe25e44c7b63d61522e95c6", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("260", "en", "page-builder-shortcode-strings-238", "4790bae4eead462808cbd388c66320bf", "Over the past nine years, Shipping and the Law has become an annual appointment for Italy’s maritime industry.", "15", "3", "", "VISUAL", "vc_column_text: content", "0", "", "bbe3f27a62a0ed5b367f0e99ce35f787", "optional", "18");
INSERT INTO `wp_icl_strings` VALUES("262", "en", "page-builder-shortcode-strings-238", "ec276269316c76215412f4908bfaabe6", "On 15-16 May 2015 Studio Legale Lauro is hosting in Naples a Young Arbitration Forum (YAF).", "15", "5", "", "VISUAL", "vc_column_text: content", "0", "", "675e950cac5c3b9b988e9e2e61e54169", "optional", "17");
INSERT INTO `wp_icl_strings` VALUES("266", "en", "page-builder-shortcode-strings-238", "56af9204089995dba3b8912b4e86a97d", "A Workshop organized by Studio Legale Lauro in association with Fleet Hamburg LLP.", "15", "7", "", "VISUAL", "vc_column_text: content", "0", "", "db439db9c387b970bada3611501c1f69", "optional", "13");
INSERT INTO `wp_icl_strings` VALUES("342", "en", "page-builder-shortcode-strings-2376", "453711929f59b925dff65d2f81ef7292", "<strong>1. The background</strong> – The complex economic scenario resulting from the 2008 global crisis has affected, in different ways, areas of business conduct that had previously been largely immune from uncertainty, inability or unwillingness of the parties involved to maintain and perform the actions required of them in order to properly implement their intentions and commitments.\r\nWhile it is well known that areas of business exist where arrangements and agreements, whether binding or not, are consistently subject to review, withdrawals, disputes and nonperformance, such situations have tended to be rather unusual in connection with the acquisition and disposal of interests in corporations, where the relevance and seriousness of such transactions and of the associated costs normally ensure a reasonably high degree of reliability in the relevant process.\r\nOf course, there have always been transactions that are envisaged, structured or even initiated but ultimately cannot be finalized. And certainly, the increased average complexity of deals that are generated during a problematic economic cycle is a factor in pushing upwards the ratio of failed transaction. However, it is fair to say that the significant widespread impact of the 2008 crisis and the genuine difficulty of foreseeing its effects on specific corporations or entire business sectors or industries, have resulted in a degree of uncertainty and friction previously unknown.\r\nThis article does not intend to discuss specifically any case of non-performance connected to (even though not necessarily caused by) the 2008 crisis, but rather to generally review and consider the most common and effective ways for parties to protect their interests and focuses on specific instruments provided in certain legal systems that appear well suited to such purpose.\r\n\r\n<strong>2. How to increase performance reliability</strong> – Deteriorated financial conditions may be the base reason for non-completion of an acquisition by a party. Such deterioration, actual or expected, may affect the ability of the purchaser to meet its financial obligations or may concern the target, possibly to an extent that determines a change in the intention of the prospective purchaser to complete the transaction. irrespective of any review of the price. Beyond such considerations, there are a variety of reasons and grounds which may constitute the basis for a change by one (or more) of the parties involved to finalize the deal, including obviously a disagreement regarding the relevant terms and conditions.\r\nEach party engaged in negotiations, however, often wishes to ensure that the other party or parties are genuinely committed to apply their best endeavors to reach an agreement. We know that there is a fairly limited possibility, in practical terms, for one party to enforce the assumed obligation of the other participants to act on the basis of good faith to finalize and execute a share purchase (or similar) agreement. Different jurisdictions take different approaches, both in terms of their legal principles and in the way such principles are applied by the competent courts to concepts such as good faith in negotiations and pre-contract liability.\r\nBreak-up fees – i.e. an amount to be paid to the other party by the party willing to withdraw from negotiations – are broadly recognized as acceptable, as a measure to restore to the nonwithdrawing party the costs borne in the process, and would need to be made clearly binding in a specific agreement between the parties. Still, it is not obvious to find a distinction between a legitimate withdrawal from negotiations and a situation in which a withdrawal would result in an obligation to pay break-up fees and the search for objective elements as the basis for the application of such remedy may be complicated. Further treating break-up fees agreements as mere cost sharing arrangements rather than as penalties (which several jurisdictions subject to judicial screening) may not be an obvious conclusion. Of course, the mere existence of a breakup fees binding arrangement is likely to represent at least a disincentive to start negotiations without a genuine purpose and therefore afford a degree of “security” regarding the reliability (at least initially) of the parties’ intentions.\r\n\r\n<strong>3. Tools to strengthen delayed performance obligations</strong> – More relevant however, for the purpose of this article, are situations where the parties have concluded an acquisition by executing a share purchase agreement and each of them wish to ensure that the other will properly and timely perform its obligations. Clearly this is particularly important in those situations, which constitute however the normal circumstances in the largest majority of transactions, when the parties’ fundamental obligations (i.e. payment of price and delivery of shares) are not to be performed immediately and simultaneously but rather are scheduled to be performed at different times.\r\nModalities of payment of the acquisition price which offer to the purchaser the possibility to delay payment in full or in part (e.g. a payment in installments) clearly represent a risk for the seller, which accepts exposure to a potential total or partial non-performance for a certain period of time. Such arrangements normally offer at the same time opportunities for the seller to offset the connected risk. Obviously, explicit or implied contractual terms, such as a reservation of title, combined with a requirement that shares are delivered only upon payment by the purchaser having been made in full, provide some protection for a seller against the risk of failure to pay.\r\nOther common arrangements are based on the request by the seller for some form of guarantees to secure payment of the price by the purchaser. Typically, bank guarantees are used to this end, although the connected costs and the financial institutions’ requirements may restrict the willingness and the ability of the parties to resort to such instruments.\r\nIt is to be noted that in acquisitions the object of the transaction is (with rare exceptions) the relevant shareholding as a whole; i.e. whatever the percentage of share capital or number of shares that are the object of the deal, such percentage or number is treated as one single inseparable object. As much as this may appear obvious it is important to keep in mind that while money constituting payment for such one inseparable shareholding may be fractioned over time, the shareholding such money is directed to acquire will not be split and will be transferred in its entirety at one time. An effect of this is that, in the event that the seller has acquired appropriate protection through one or more of the methods mentioned above, a fractioned payment would end up as a risk for the purchaser who may find itself in the position of having paid to the seller over time a (possibly significant) portion of the acquisition price, not only prior to having acquired the target shareholding, but also without having acquired any proportional entitlement to any asset, in particular to any of the shares of the target.\r\n\r\n<strong>4. The Italian caparra confirmatoria</strong> – It is interesting therefore to note, as the focus of this article, that legal systems in a number of civil law jurisdictions have historically offered to contracting parties instruments that take into account – on one side the frequent practice of facilitating payment by spreading the same over a period of time and, on the other side, the common expectation that a (non-negligible) part of the payment be made in advance to strengthen reliability of the contract – and are directed at creating a form of mutual guarantee against non-performance to the benefit of both parties, or better, of each party acting toward a due and proper performance of the contract. An example of this, that we wish to briefly review, is the practice of the caparra confirmatoria provided in various forms and with different legal names under a number of civil law jurisdictions, including France, Italy, Germany and Switzerland. In particular, it is interesting to consider the features of such practice as provided under Italian law, which is particularly clear in defining the concept and the scope of the caparra confirmatoria. In fact the Italian law caparra confirmatoria has been chosen to expressly apply in international share acquisition agreements (normally with a degree of Italian connection) precisely because of its implications in terms of seller’s protection against failed or incomplete payment by the purchaser.\r\nUnder Italian law, a caparra confirmatoria is a sum of money given by one party to a contract to the other party with the effect that in case the contract is duly performed the caparra is returned or put toward payment, while in case the contract is not performed (i) if the non performing party is the party that has given the caparra, the other party may rescind the contract and retain the caparra, and (ii) if the non performing party is the party that has received the caparra, the other party may rescind the agreement and demand twice the amount of the caparra. The caparra confirmatoria may also in principle consist of fungible goods instead of money, although this would be rather uncommon in the context of share acquisitions. Therefore, in essence, the effect of a caparra confirmatoria is that each party is entitled to cash a net amount corresponding to the amount of the caparra in case the other party breaches the contract. The performing party has in any event the option to seek damages from the non-performing party by waiving the right to the caparra confirmatoria and pursuing its claim according to the ordinary rules.\r\nThe practical purpose of the caparra confirmatoria is therefore a broad one: to strengthen the parties’ mutual obligations; to provide protection to the contract parties and the transaction; and to pre-determine an agreed amount of liquidated damages resulting from a potential breach of contract. It is generally perceived as an instrument directed at regulating the consequences of a breach of specific contractual obligations – in the interest of both parties. In fact the caparra confirmatoria is an alternative remedy to ordinary damages suffered as a result of breach of contract, which remain available to the performing party subject to the waiver of its rights in favour of the caparra confirmatoria. It intends to facilitate the resolution of a potential conflict in case of a breach, giving the innocent party an opportunity to avail itself of a “pre-packed” solution. Further, as an alternative remedy, the caparra does not result in a limitation to the debtor’s liability, and does not therefore contradict the principle of the Italian civil code, embedded in the laws of many other civil law jurisdictions, by which an agreement cannot contain a clause that excludes or limits in advance the potential liability of the debtor for willful misconduct or gross negligence. According to such principle, a predetermination of liquidated damages would be void to the extent that it applied to damages caused by the debtor’s willful misconduct or gross negligence and excludes the possibility of the claimant demanding higher compensation.\r\nA further advantage of the caparra confirmatoria is its flexibility. The nature of the caparra confirmatoria under Italian law is that of a contract itself, separate from (although connected and ancillary to) the principal contract to which it relates. As an ancillary contract to the principal contract the enforceability of the caparra confirmatoria is affected by elements that impact the validity of the principal contract. However, it is also a bilateral agreement and the parties are free (with some limitations) to determine which obligations of the principal contract are in fact protected by this remedy; i.e. in which cases the non-performance of the agreement by one of the Parties triggers the option to enforce the caparra confirmatoria. In connection with the effect of pre-determining the consequences of a breach of contract, the the caparra confirmatoria is different from that of the clausola penale (i.e. penalty clause), and the Italian civil code distinguishes the two concepts very clearly, not only by using a different term in the relevant section but also by regulating the two concepts under separate articles.\r\nIn legal literature there exists an extensive debate regarding similarities and differences between the caparra confirmatoria and penalty clauses. In summary, while the similarity is mainly in the broad purpose that both concepts have of pre-determining the consequence of a breach of contract, the differences have been underlined from various angles, in particular, that (i) the caparra confirmatoria implies an advance on the main payment obligation and becomes part of such obligation in case of due performance of the agreement; (ii) the caparra confirmatoria is bilateral in nature, for the protection of both parties so limiting the risk of disproportion; and (iii) a penalty clause may be supplemented by the right to seek further damages, i.e. the innocent party may retain the penalty and claim further damages, while the enforcement of the caparra confirmatoria is alternative to an action in damages, i.e. the innocent party may either enforce the caparra or claim damages for breach of contract under the ordinary action rules but not both.\r\nA further point of distinction, which in many legal systems is a matter of particular sensitivity and is founded on the substantially different nature of the two instruments, is that while the Italian civil code expressly provides that an excessive penalty clause may be reduced by a Court this is not the case with respect to a caparra confirmatoria. The Italian Supreme Court in several decisions has confirmed that the amount agreed by the parties as caparra confirmatoria cannot be subject to Court review primarily on the basis of (i) the significant differences between a caparra confirmatoria and a penalty clause, and (ii) the refusal to extend by analogy the power of a Court to re-determine the amount of a penalty clause also with respect to the amount of a caparra confirmatoria. The power of Courts to reduce the amount agreed by the parties as a penalty, which is explicitly provided by the Italian civil code with respect to penalty clauses only, must be considered as an exceptional limitation to the general principle of freedom of contract and as such, in accordance with general principles of Italian law, its application cannot be extended by analogy to other matters, in particular to a substantially different instruments such as the caparra confirmatoria. This results in a further advantage of the caparra confirmatoria; i.e. its reliability.\r\n\r\n<strong>5. Similar tools in other jurisdictions</strong> – It would be interesting to explore how other jurisdictions approach instruments similar to the caparra confirmatoria. That would, however, be a fairly complex exercise as the shape that the same broad concept of the caparra has taken in different systems may differ substantially. As an example, Swiss law accepts, at least in a number of areas, that the caparra may be additional, and not only alternative, to damages. Austrian law (and, to a somewhat lesser extent, Swiss law) also recognizes that the amount of the caparra confirmatoria may be equitably reduced.\r\nWhile the legal effects and implications of the “arrhes” in French law appear to rely primarily on the specific contract wording rather than on established general principles. In summary then, the legal framework provided by Italian law appears to offer an effective and reliable instrument to deal with the sellers’ exposure to the risk of incomplete payment by the purchaser, in particular in situations when an advanced partial payment occurring at closing may be qualified by the parties as a caparra confirmatoria. It also does not prejudice the position of the purchasers, that in fact would be afforded the same degree of protection, and would be able to count on the simplicity of the caparra system (perhaps also relying on an escrow arrangements with respect to the advanced payment) in case of a breach by the seller.\r\nAnd, ultimately, mindful of the principle of freedom of contract, Italian law devolves to the negotiations between the parties (with only exceptional limitations) the definition of the obligations protected by the caparra and the significance in economic terms that the parties intend to the compliance to or breach of those obligations, making the caparra confirmatoria a helpful instrument to protect the rights of the parties in an acquisition agreement.\r\n\r\n<strong>Author:</strong>\r\n\r\nFrancesco S. Lauro\r\n\r\nYou can download the pdf version of the article by clicking <a href=\"https://sviluppo.studiolegalelauro.it/wp-content/uploads/2020/03/The-Legal-500-MA-Country-Comparative-Guide-Guarantee-of-Performance-in-the-Acquisition-of-Company-Shares-1.pdf\" target=\"_blank\" rel=\"noopener noreferrer\">HERE</a>\r\n\r\nYou can reach the content to the following link:<a href=\"https://www.legal500.com/guides/hot-topic/guarantee-of-performance-in-the-acquisiTIon-of-company-shares/\" target=\"_blank\" rel=\"noopener noreferrer\"> https://www.legal500.com/guides/hot-topic/guarantee-of-performance-in-the-acquisiTIon-of-company-shares/</a>", "24", "1", "", "VISUAL", "vc_column_text: content", "0", "", "72493bdc772a9e831be5ba6518fa8862", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("308", "en", "page-builder-shortcode-strings-2285", "eb76c035d5d0a2bd2a0d0834b93c9c26", "2266", "21", "2", "", "LINE", "contact-form-7: id", "0", "", "1c3746241128cb47b2c3217805107fbe", "optional", "1");
INSERT INTO `wp_icl_strings` VALUES("295", "en", "Widgets", "widget body - d41d8cd98f00b204e9800998ecf8427e", "", NULL, NULL, "", "LINE", NULL, "0", "", "b65cd63f406f41d7ba726f1c41d6578b", "", NULL);
INSERT INTO `wp_icl_strings` VALUES("283", "en", "page-builder-shortcode-strings-254", "3e2823f0c53f5d8e10a9bc2a89a8bee8", "[ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"32\"][ct_contact_form id=\"7\"]", "19", "3", "", "VISUAL", "vc_column: content", "0", "", "e1db837ce6dbacac66b079a953022aca", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("615", "en", "gutenberg-3", "e146d449e7a61237988d1e3e75c862d8", "Where we send your data", "39", "25", "h2", "LINE", "core/heading", "0", "", "274066cface10dc50570c3879b466d9b", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("616", "en", "gutenberg-3", "ad34927851cf505388dd655eb28d9170", "Visitor comments may be checked through an automated spam detection service.", "39", "26", "", "LINE", "core/paragraph", "0", "", "6cf850499c388b3c06b13a4551a6478a", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("617", "en", "gutenberg-3", "06bd9d38000a068b8e421c5b4056d929", "Your contact information", "39", "27", "h2", "LINE", "core/heading", "0", "", "2703d6c68a8860001cffa06a452bfec1", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("618", "en", "gutenberg-3", "1145e37974b6064f7297286ce4c1d084", "Additional information", "39", "28", "h2", "LINE", "core/heading", "0", "", "932575eabf132953dce67234e894b1fe", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("293", "en", "WPML", "Text for alternative languages for posts", "This post is also available in: %s", NULL, NULL, "", "LINE", NULL, "0", "", "c9203e3110feb389a62b2f341a6c346a", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("294", "en", "Widgets", "widget title - 5c93310dd0291e121181e830cdda892e", "Gallery", NULL, NULL, "", "LINE", NULL, "0", "", "5589df17541c764c8d9c15754ee67046", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("831", "en", "page-builder-shortcode-strings-238", "c084155ed3703b12af533ed7e2f587ca", "</p>\r\n<h2 class=\"wpb_heading wpb_singleimage_heading\" style=\"text-align: center;\"><span style=\"color: #000000;\"><a style=\"color: #000000;\" href=\"https://sviluppo.studiolegalelauro.it/wp-content/uploads/2020/02/Restructuring-Agreements-1.jpg\">Restructuring Agreements</a></span></h2>\r\n<p>", "15", "6", "", "VISUAL", "vc_column_text: content", "0", "", "e092dfa52a8e2022af914151e77e430c", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("826", "en", "page-builder-shortcode-strings-250", "c7701b64e5b2cc20246e867f1be889e7", "[ct_heading text=\"We are a compact and integrated team, skilled and highly regarded, with a real depth and breadth of expertise\" align_lg=\"align-center\" align_md=\"align-center-md\" align_sm=\"align-center-sm\" align_xs=\"align-center-xs\" font_size_sm=\"24\" font_size_xs=\"24\" font_weight=\"\" show_gap=\"show\" subtitle=\"Team\" subtitle_font_size=\"22\" description_font_weight=\"inherit\" margin_bottom=\"0\"]", "14", "1", "", "VISUAL", "vc_column_inner: content", "0", "", "d57c7c899019003cb653534b3243eae6", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("280", "en", "page-builder-shortcode-strings-2240", "68e3ca35b7daf7f8c1c6fd4df7a2e5c7", "\r\n<div id=\"left_text\">\r\n<div id=\"container1\">\r\n<div id=\"content1\">\r\n\r\nOn 15-16 May 2015 Studio Legale Lauro is hosting in Naples a Young Arbitration Forum (YAF) under the auspices of the Paris International Chamber of Commerce (ICC).\r\n\r\nDuring the first day of this ICC YAF event on \'The Arbitration Agreement\', the conference, which is free to attend, will take place in the \'Sala dei Baroni\' (Baron’s Hall) of the XIII century Maschio Angioino of Naples. The works will be opened by the founder of Studio Legale Lauro, Francesco S. Lauro. Leading arbitration practitioners from all over Europe, the keynote speaker Prof. Loukas Mistelis (Queen Mary University of London), and the Secretary General of the International Court of Arbitration of the International Chamber of Commerce, Prof. Andrea Carlevaris, will address the most important issues regarding the drafting of a valid and enforceable\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div id=\"right_text\">\r\n<div id=\"container2\">\r\n<div id=\"content2\">\r\n<p class=\"nofisrtletter\">arbitration agreement, one of the hottest issues of today international arbitration. The conference will be followed by a Gala Dinner in the famous D’Angelo Santa Caterina terrace, which has one of the best view on the city of Naples.</p>\r\n<a href=\"https://sviluppo.studiolegalelauro.it/wp-content/uploads/2020/02/ICCYAF-Programme-Naples-15-16-May-2015.pdf\" target=\"_blank\" rel=\"noopener noreferrer\">PROGRAMME</a>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n", "18", "1", "", "VISUAL", "vc_column_text: content", "0", "", "804456006bd9546fba6279bdb1031ad8", "optional", "172");
INSERT INTO `wp_icl_strings` VALUES("619", "en", "gutenberg-3", "150e5312a2327e382cd9d99ca04d2523", "How we protect your data", "39", "29", "h3", "LINE", "core/heading", "0", "", "4c9219c4d0621946bc971337cbb737b9", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("813", "en", "page-builder-shortcode-strings-229", "3a8a60fdd176a7f93b901a768384067c", "[ct_heading text=\"Send a request to our secretary office\" font_size_sm=\"24\" font_size_xs=\"24\" font_weight=\"\" text_color=\"#ffffff\" show_gap=\"show\" subtitle=\"Contact us\" subtitle_font_size=\"22\" description_font_weight=\"inherit\" margin_bottom=\"0\"]", "1", "21", "", "VISUAL", "vc_column_inner: content", "0", "", "3c398f6a7d66347ec3d9ce8bf4a32622", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("664", "en", "page-builder-shortcode-strings-250", "e0f362f5e9525d5d828fa30fd4285b86", "[ct_team_member image=\"2092\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Ffrancesco-lauro%2F|||\" title=\"Francesco S. Lauro\"]", "14", "2", "", "VISUAL", "vc_column_inner: content", "0", "", "d0b1429a7823bd55b32ac42a9fca3e50", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("665", "en", "page-builder-shortcode-strings-250", "9afa703e5d9bf81f86c2bc928141af76", "[vc_empty_space height=\"62px\"][ct_team_member image=\"2094\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Fernesto-ardia%2F|||\" title=\"Ernesto Ardia\"]", "14", "3", "", "VISUAL", "vc_column_inner: content", "0", "", "f9df0313e284b7a4f474744025d69a17", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("442", "en", "page-builder-shortcode-strings-2493", "f4819bc9a329b1e95bd757d3319e520f", "[vc_empty_space height=\"92px\"]", "27", "1", "", "VISUAL", "vc_column: content", "0", "", "02cdb5f613ca72e4c9971f8c1460c6e4", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("605", "en", "gutenberg-3", "daf72dcf13209e51ca0085df2e83e0f5", "Embedded content from other websites", "39", "15", "h3", "LINE", "core/heading", "0", "", "651a5518863e352be421541e2ec2fed3", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("458", "en", "page-builder-shortcode-strings-2509", "f4819bc9a329b1e95bd757d3319e520f", "[vc_empty_space height=\"92px\"]", "28", "1", "", "VISUAL", "vc_column: content", "0", "", "fd6211b2a0f7176a6722406e7d5d19d6", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("441", "en", "page-builder-shortcode-strings-2447", "8da8feddd8e31ada8d3e8cbf2424b14f", "<strong>Valentina Tremante</strong> was primarily engaged in contentious work such as disputes and subsequent litigation relating to bills of lading and sale of goods agreements.\r\n\r\nBesides this, Valentina handled various aspects of cases covering a broad spectrum of the shipping industry: contractual &amp; tort disputes, marine casualties, sale &amp; purchase, shipbuilding contracts, charter-parties, yachting, options agreements, M&amp;A transactions and private agreements, commercial litigation, international trade, cargo claims, air transport claims, limitation of shipowner’s liability. In particular, she has been involved in all types of dispute concerning the issuance and/or circulation of bills of lading or waybills and she routinely assists clients in any issue arising in relation to shipbuilding contracts, including matters relating to clauses for the cancellation and delayed delivery of the ship, penalties.\r\n\r\nValentina’s experience covered preparing, reviewing, drafting a wide variety of business contracts and related documents. Due to the nature of this work environment, she also gained experience in preparing settlements and arbitration cases, as well as in advising clients in relation to liability issues concerning international conventions (i.e. Hague Rules/Hague - Visby Rules etc.) and marine insurance claims (P&amp;I).\r\n\r\nValentina gained her LL.M. in International Maritime Law from City, University of London with a Dissertation topic on the refund guarantees in the shipbuilding contracts.\r\n\r\nShe speaks Italian, English and Spanish.", "26", "3", "", "VISUAL", "vc_column_text: content", "0", "", "4717b98b84c1d831dff832a6877d816e", "optional", "218");
INSERT INTO `wp_icl_strings` VALUES("351", "en", "page-builder-shortcode-strings-2160", "30c86fcd1b4d03993958014d2232b9f0", "[ct_contact_info content_type=\"tel\" icon_list=\"fontawesome5\" icon_fontawesome5=\"fac fac-phone\" content_info=\"+39 081 5800199\" el_class=\"contact-info-group\"][ct_contact_info content_type=\"email\" icon_fontawesome=\"fa fa-envelope\" content_info=\"g.forte@studiolegalelauro.it\" el_class=\"contact-info-group\"]", "9", "4", "", "VISUAL", "vc_column_inner: content", "0", "", "6c1320beb316460cc33703d5029f792f", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("667", "en", "page-builder-shortcode-strings-250", "3e5bcbf5ba343094bd7fafce85ba6bc2", "[ct_team_member image=\"2698\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Fgiuseppe-de-santo%2F|||\" title=\"Giuseppe De Santo\"]", "14", "5", "", "VISUAL", "vc_column_inner: content", "0", "", "264b0203490cbfccf0461b124720b30f", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("668", "en", "page-builder-shortcode-strings-250", "91094b6b997f6a53822ea8e52603bfe0", "[vc_empty_space height=\"62px\"][ct_team_member image=\"2098\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Fanna-vernillo%2F|||\" title=\"Anna Vernillo\"]", "14", "6", "", "VISUAL", "vc_column_inner: content", "0", "", "d253ed172950e2ea916f0e6ed8c0f9dd", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("669", "en", "page-builder-shortcode-strings-250", "44538e1937a9e4548573c145b59fc729", "[vc_empty_space height=\"62px\"][ct_team_member image=\"2701\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Fvalentina-tremante%2F|||\" title=\"Valentina Tremante\"]", "14", "7", "", "VISUAL", "vc_column_inner: content", "0", "", "930d9d9d44b46ecd2827e6ef7f9b3cdb", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("746", "en", "page-builder-shortcode-strings-2164", "ee104f52083d022a53dee5989e2f7aed", "[vc_empty_space][ct_team_member image=\"2098\" social=\"%5B%7B%7D%5D\" title=\"Anna Vernillo\" el_class=\"single-team\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"42\"]", "10", "2", "", "VISUAL", "vc_column: content", "0", "", "0b07cb268cd4b8cd6fab9a6f856d4ea6", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("764", "en", "page-builder-shortcode-strings-2530", "e867defaf90271076cc1a55896f2192e", "[vc_empty_space][ct_team_member image=\"2824\" social=\"%5B%7B%7D%5D\" title=\"Måns Jacobsson\" el_class=\"single-team\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"42\"]", "34", "2", "", "VISUAL", "vc_column: content", "0", "", "5dc063a6e32ee77f7125ac0decd402e8", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("768", "en", "page-builder-shortcode-strings-2526", "12b284669e11af7ed46fd5e4fc0ad925", "[vc_empty_space][ct_team_member image=\"2820\" social=\"%5B%7B%7D%5D\" title=\"Biagio Grasso\" el_class=\"single-team\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"42\"]", "33", "2", "", "VISUAL", "vc_column: content", "0", "", "48770ad5f5f32f13ae5bbd45650e6c2f", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("816", "en", "page-builder-shortcode-strings-246", "f447709e95ddcbec76ce5983376c34b0", "</p>\r\n<div align=\"justify\">\r\n<p><strong>What do you see as the main points that differentiate Studio Legale Lauro from its competitors?</strong></p>\r\n<p>There is a phrase which expresses the way we act: “Less is more”. In other words, we always tend towards efficiency and precision. Our clients are generally big companies and very busy people who do not have the time to read very long advices full of caveats or long engagement letters. Our aim is to achieve the best interests for our clients, full stop! We are not interested at all in billing a lot of hours and consider that the legal cost of cases should never be disproportioned in respect of the benefits granted by the legal assistance. If we can close a deal or a litigation in a favorable, simple and quick, way we always do it. Our aim is to achieve the best result for our clients and limit their costs, risks and time is of essence.</p>\r\n<p><strong>Which practices do you see growing in the next 12 months? What are the drivers behind that?</strong></p>\r\n<p>I believe that the fall outs of the coronavirus will feature during the next 12 months in many ways. There are and there will be lot of opportunities for new deals and acquisitions for our clients who are generally strong and successful companies but also a lot of litigations, good faith and force majeure cases, bankruptcy proceedings. Also, the necessary state aids and loans to sustain the economy should be granted to the parties who deserve them and should not be a competition distortion.</p>\r\n<p><strong>What’s the main change you’ve made in the firm that will benefit clients?</strong></p>\r\n<p>We are trying to innovate constantly, but if you ask me to indicate just one thing I would mention the recent recruitment Marilisa Varrone as our Chief Marketing Officer and Strategist. Marilisa worked with me after she graduated more than 20 years ago when I was the President of Naples Port Authority and helped me to put together a strategic think tank with young bright professionals and academics that had an important role in a very productive presidency and after other interesting experiences is now back supporting us.</p>\r\n<p><strong>Is technology changing the way you interact with your clients, and the services you can provide them?</strong></p>\r\n<p>Right now, I am answering this interview from my home from where I am connected worldwide through the internet and the most advance conference office. I always considered that a good business lawyer should be h24 available to answer the phone and be able to leave, with a small suitecase, towards any destination in the next hour, however now that this is not possible we can appreciate the benefits of the most updated communication technology.</p>\r\n<p><strong>Can you give us a practical example of how you have helped a client to add value to their business?</strong></p>\r\n<p>First of all, if I am what I am as a lawyer this is mainly due to my clients who taught me what their businesses are and to understand what they need from their lawyer. If you want to be of use to your clients, you must understand exactly what their business interest are, both in the short and the long term. Then obviously you have also to try to establish a good empathy with them, intervene at the right time and always offer practicable, discriminatory solutions. I think we do that SLL.</p>\r\n<p><strong>Are clients looking for stability and strategic direction from their law firms – where do you see the firm in three years’ time?</strong></p>\r\n<p>As I said above, in my opinion clients like that their lawyers understand them, their strategic priorities and interest. They are also interested in the firm being well organised and able to furnish them with the best possible assistance. It is difficult to speak about the future at these challenging times and after the Corona Virus epidemic break out, I would be very happy if the trend which brought us to handle so important and interesting cases and matters could continue and in the meantime we would have succeeded in the large majority of them.</p>\r\n<p>&nbsp;</p>\r\n<p>Visit the following link for more:</p>\r\n<p><a href=\"https://www.legal500.com/firms/22489-studio-legale-lauro/22492-naples-italy/#firm_profiles\" target=\"_blank\" rel=\"noopener noreferrer\">https://www.legal500.com/firms/22489-studio-legale-lauro/22492-naples-italy/#firm_profiles</a></p>\r\n<p>&nbsp;</div>\r\n<p>", "11", "3", "", "VISUAL", "vc_column_text: content", "0", "", "fdcfa1e8002aca197622ebdeed096509", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("433", "en", "page-builder-shortcode-strings-254", "bf32d93f9ce2a7069dcef8d7291d70ea", "[ct_heading text=\"Send a request to our secretary office\" align_lg=\"align-center\" align_md=\"align-center-md\" align_sm=\"align-center-sm\" align_xs=\"align-center-xs\" font_weight=\"\" subtitle=\"Contact us\" subtitle_font_size=\"22\" description_font_weight=\"inherit\"][vc_empty_space height=\"62px\"]", "19", "1", "", "VISUAL", "vc_column: content", "0", "", "25a3f53e827889c540f6d498d133e717", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("829", "en", "page-builder-shortcode-strings-238", "0c50b56e9c3f75626fcb69c3167b6c79", "</p>\r\n<h2 class=\"wpb_heading wpb_singleimage_heading\" style=\"text-align: center;\"><span style=\"color: #000000;\"><a style=\"color: #000000;\" href=\"http://www.shippingandthelaw.org/\" target=\"_blank\" rel=\"noopener noreferrer\">Shipping and the Law</a></span></h2>\r\n<p>", "15", "2", "", "VISUAL", "vc_column_text: content", "0", "", "cb8a71dd4df93b9d59373ff6a1278d14", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("610", "en", "gutenberg-3", "968ea77d93bdf6f40ddff1774eb49752", "How long we retain your data", "39", "20", "h2", "LINE", "core/heading", "0", "", "c4b4d4df762c26fc76806d35c8d98def", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("611", "en", "gutenberg-3", "c69e1199dd0d38025613579db59719b9", "If you leave a comment, the comment and its metadata are retained indefinitely. This is so we can recognize and approve any follow-up comments automatically instead of holding them in a moderation queue.", "39", "21", "", "LINE", "core/paragraph", "0", "", "89c92847d10fd7f5e24f4ed49154ca53", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("612", "en", "gutenberg-3", "70345b8a1cc0ff4b6cacf313bfd58d7a", "For users that register on our website (if any), we also store the personal information they provide in their user profile. All users can see, edit, or delete their personal information at any time (except they cannot change their username). Website administrators can also see and edit that information.", "39", "22", "", "LINE", "core/paragraph", "0", "", "bc4ba232d2af421fcc53c3475a7c2c02", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("738", "en", "page-builder-shortcode-strings-250", "48706ebf7627a74c4d71ab61fd7cb8f0", "[ct_team_member image=\"2777\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Faniello-cuomo%2F|||\" title=\"Aniello Cuomo\"][vc_empty_space height=\"62px\"]", "14", "13", "", "VISUAL", "vc_column: content", "0", "", "8dd2cd762cc314d4c11d06e1ff5b556a", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("728", "en", "page-builder-shortcode-strings-2513", "27c08104a4297e0564ca42302c55845c", "</p>\r\n<div align=\"justify\">\r\n<p><strong>Mark Clough</strong>, Counsel, EU and Competition law (Brussels)</p>\r\n<p>Qualifications: MA Joint Hons, St Andrews (1976), Barrister, Gray\'s Inn (1978), English Solicitor (1995), Solicitor Advocate (1996), QC (1999), Scottish Solicitor (2013)</p>\r\n<p>Mark is one of the UK\'s leading experts in EU and competition law, including competition litigation, merger control, state aid, public procurement, international trade and economic regulation.</p>\r\n<p>He was appointed Queen’s Counsel in 1999 and a Scottish Solicitor in 2013.</p>\r\n<p>Mark was chairman of the Solicitors Association of Higher Court Advocates, SAHCA (2003 – 2006) and chair of the EU Committee of the Law Society (2010 2013).</p>\r\n<p>He is a member of the Joint tribunal of the Law Society and Bar adjudicating disputes on fees between barristers and solicitors As an elected member of the Council of the European Law Institute based in Vienna, he currently chairs the Project Group on the European Commission’s proposed directive on competition law damages and its published Recommendation on Collective Redress. Mark is recognized by Global Competition Law Review, Legal 500 and Chambers UK as a leading expert in his field. He is listed in Band One for Competition Law in Chambers Scotland. He is also listed in Band Two for Public Procurement in Chambers UK (2013/14).</div>\r\n<p>", "29", "3", "", "VISUAL", "vc_column_text: content", "0", "", "e865f6fd4e06b647b6f038359e15f302", "optional", "206");
INSERT INTO `wp_icl_strings` VALUES("725", "en", "page-builder-shortcode-strings-2509", "8665e74c1b97ecd31f7685b1f1997df4", "[vc_empty_space][ct_team_member image=\"2748\" social=\"%5B%7B%7D%5D\" title=\"Arturo Capasso\" el_class=\"single-team\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"42\"]", "28", "2", "", "VISUAL", "vc_column: content", "0", "", "04dc50ade64e82e008ef4466b85e825e", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("720", "en", "page-builder-shortcode-strings-250", "9e13af21ed1241fb6c809d3da906716e", "[ct_team_member image=\"2748\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Farturo-capasso%2F|||\" title=\"Arturo Capasso\"][vc_empty_space height=\"62px\"]", "14", "10", "", "VISUAL", "vc_column: content", "0", "", "21f1c531c5c0fdf6e4e8e093c31ed255", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("469", "en", "page-builder-shortcode-strings-2516", "f4819bc9a329b1e95bd757d3319e520f", "[vc_empty_space height=\"92px\"]", "30", "1", "", "VISUAL", "vc_column: content", "0", "", "cd43916cc0533226b99f4fcedaa4fbc9", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("475", "en", "page-builder-shortcode-strings-2520", "f4819bc9a329b1e95bd757d3319e520f", "[vc_empty_space height=\"92px\"]", "31", "1", "", "VISUAL", "vc_column: content", "0", "", "1113e3dc389e1ca1398df3357c3c9b06", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("736", "en", "page-builder-shortcode-strings-2516", "ec878891ba200243131242c6860d7408", "[vc_empty_space][ct_team_member image=\"2771\" social=\"%5B%7B%7D%5D\" title=\"Roderick Cordara QC\" el_class=\"single-team\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"42\"]", "30", "2", "", "VISUAL", "vc_column: content", "0", "", "569490ffb02f273ebb6931f58dea48e6", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("740", "en", "page-builder-shortcode-strings-2520", "9d88d0d20c9d9f64c763650cc40ea793", "</p>\r\n<div align=\"justify\">\r\n<p><strong>Aniello Cuomo</strong> was born in Nocera Inferiore, Salerno, on 9th April 1956. Graduated at Law School of Università degli Studi di Salerno on 1982, started the legal practice in civil and administrative law. On 1983 he passed the exam for public employment and became Junior Lieutenant in the roles of Harbour Master Authorities, a Navy sector within the Ministry of Transportation. On 1988 ha was admitted as lawyer to the Italian Bar attending the following courses years: Maritime transport technique “Law, Technique and Economics of Maritime transport” “La Sapienza” University of Rome, 1989; Course of specialization in International Maritime Law “The new law of the sea and its application in the Mediterranean” University of Rome “Tor Vergata”, 1994. On June 2016 he leaved the Harbour Master service with the rank of Vice Admiral, and he started again the legal practice advising on administrative and maritime matters, focusing in particular on public maritime domain, port activities, coastal administrative services, ownership of vessels, seafarers contracts, pleasure boating and everything related to maritime navigation.</p>\r\n<p>In the course of his over 30-year career as an officer of the Maritime Authorities, he has held numerous positions, including among others: Commander of the Port of Piombino; Director of the local Port Labuor Office; Vice Commander of the ports of Naples and Salerno; Head of section of the state property - litigation of the Port Authority of Naples.</p>\r\n<p>In the 90s he managed the complex and numerous cases of violation of maritime public domain that affected the shoreline in the Campania Region, taking care of both criminal and administrative aspects linked to the related litigations resulting from the abusive construction of the Coppola Pinetamare Village State property, located on the coast of the Municipality of Castelvolturno.</p>\r\n<p>He has been a lecturer in the area of management and use of the maritime domain, of protection of the coastal strip and port system, in professional training courses (Formez) and university masters. From 1992 to 2001 he collaborated with the legal journal “Prime Note” published by Editions of the Autonomies of Rome, publishing comments and notes to regulations concerning maritime, port, shipbuilding and shipowning. He is the author, also of other publications, in maritime matters, among which the most relevant are reported: “Genesi ed evoluzione di una coscienza ambientale globale (Genesis and evolution of a global environmental consciousness)” in “Le Coste Salernitane”, curated by Massimo Rosi and Ferdinando Jannuzzi, Giannini Editore, Napoli, 2005; “Tutela della zona costiera” (Protection of the coastal area) in “L’area costiera mediterranea” (The Mediterranean coastal area) curated by Massimo Rosi and Ferdinando Jannuzzi, Giannini Editore, Napoli, 2002; “Il demanio marittimo: gestione ed uso”( The maritime domain: management and use) in “La fascia costiera della Campania” (The coastal strip of Campania ) curated by Massimo Rosi, Giannini Editore, Napoli, 1999.</div>\r\n<p>", "31", "3", "", "VISUAL", "vc_column_text: content", "0", "", "0aa51a64058bce743a0f31c7873634bb", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("767", "en", "page-builder-shortcode-strings-250", "a13504fbdb72e5672df152535da7787c", "[ct_team_member image=\"2792\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Fcarlo-iannello%2F|||\" title=\"Carlo Iannello\"][vc_empty_space height=\"62px\"]", "14", "16", "", "VISUAL", "vc_column: content", "0", "", "9e16d1d52e9401643d9afa62c3adaf16", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("753", "en", "page-builder-shortcode-strings-250", "d6636e2bdbd215a96b84283e16096c51", "[ct_team_member image=\"2802\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Fgiulio-maggiore%2F|||\" title=\"Giulio Maggiore\"][vc_empty_space height=\"62px\"]", "14", "18", "", "VISUAL", "vc_column: content", "0", "", "c209c80bd45c8c8270b1addc11bdd5f7", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("602", "en", "gutenberg-3", "dba7023a85d0bedcc5d270416cdbea66", "If you visit our login page, we will set a temporary cookie to determine if your browser accepts cookies. This cookie contains no personal data and is discarded when you close your browser.", "39", "12", "", "LINE", "core/paragraph", "0", "", "0937fb6340e3126453def837a4f1139d", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("743", "en", "page-builder-shortcode-strings-2523", "79f1f0671f5cc3fe64d04f0d7a2ddce6", "</p>\r\n<div align=\"justify\"><strong>Michele Di Fiore</strong> was born in Naples in 1958. He graduated in Law cum laude at Federico II University, Naples with a thesis on “Science of the Finance and Financial Law”. He attended a master course at the IPSOA Institute, where specialising in Tax Law and Practice, Audit and Corporate Law. Until 2001 he worked on the title, “Subject Expert for the teaching of Tax Law”, researching and teaching at the Department of the Tax Law at the law school of the University of Salerno. He attended and obtained two PhDs in “Tax Law of Companies” held at the University of Naples. He is registered with the Bar of Naples since 18.12.90. Between 1993-1995, he attended the Specialization Course in “Commercial Law” a the University of Naples. He has the title of “Official Auditor” and is enrolled at the special register in the Ministry of Justice since 1995. On 25.3.199 he enrolled at the Roll of Barristers of the Supreme Court. He held the position of Secretary of the National (Tax) Union and afterwards, he held the position of Deputy Vice President of the National Union of Chambers of Lawyers Tax. He has spoken at various conferences on topics of tax law and business law and has also published several articles in scientific journals on issues of tax law and business law. He was appointed Professor of Financial law and Professor of International Tax Law at the University of Naples “Federico II” - Faculty of Law. Since 2011 he is the Director of the School of Higher Education and Specialization for tax law with offices in Milan, Rome and Naples. He is a member of the Committee’s study on tax law set by the Council of the Bar of Naples. He is a member of the Executive Council of the National Union of Chambers of Lawyers Tax Consultants. In 2014 he was appointed Adjunct Professor of Tax Law as part of the master “Advocacy tax” established by the University degli Studi di Salerno.</div>\r\n<p>", "32", "3", "", "VISUAL", "vc_column_text: content", "0", "", "b1e3ecf335256233dd719b3fac3d4259", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("739", "en", "page-builder-shortcode-strings-2520", "17656231189dea96c507b7db8f0f13fa", "[vc_empty_space][ct_team_member image=\"2777\" social=\"%5B%7B%7D%5D\" title=\"Aniello Cuomo\" el_class=\"single-team\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"42\"]", "31", "2", "", "VISUAL", "vc_column: content", "0", "", "6ecddfea52af4b37f4752e659367dcd1", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("457", "en", "page-builder-shortcode-strings-2160", "84ec1a38da9b89126d342cc82d1368f2", "[ct_team_member image=\"2096\" social=\"%5B%7B%7D%5D\" title=\"Giannicola Forte\" position=\"Lawyer\" el_class=\"single-team\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"42\"]", "9", "2", "", "VISUAL", "vc_column: content", "0", "", "a93bd018107104da18f49b87be6c7562", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("463", "en", "page-builder-shortcode-strings-2513", "f4819bc9a329b1e95bd757d3319e520f", "[vc_empty_space height=\"92px\"]", "29", "1", "", "VISUAL", "vc_column: content", "0", "", "b991dc092cf558effe237cf81a76b211", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("869", "en", "page-builder-shortcode-strings-229", "ddbbf5c177c1de92fca1cdc8b022b864", "[ct_heading text=\"Learn something more from<br />\r\nour latest contributions\" align_lg=\"align-center\" align_md=\"align-center-md\" align_sm=\"align-center-sm\" align_xs=\"align-center-xs\" font_size_sm=\"24\" font_size_xs=\"24\" font_weight=\"\" show_gap=\"show\" subtitle=\"Publications\" subtitle_font_size=\"22\" description_font_weight=\"inherit\" margin_bottom=\"0\"][vc_empty_space][vc_empty_space]", "1", "20", "", "VISUAL", "vc_column_inner: content", "0", "", "b4986b033c0c39de0ed03438d16bfc75", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("766", "en", "page-builder-shortcode-strings-2795", "b3f31a3fafc89a2b3c3d9d366066050e", "\r\n<p style=\"text-align: justify;\">Carlo Iannello was born in Naples, Italy, on 26 November 1970.</p>\r\n<strong>Degree:</strong>\r\nGraduated with a degree in Law on 4 July 1996 with a grade of 110 with Honors at the University of Studies of Naples “Federico II” with a thesis on Constitutional Law entitled «Federalismo e regionalismo: tendenze evolutive e prospettive di riforma nel dibattito sulla forma dello Stato italiano»\r\n\r\n<strong>Post-grad:</strong>\r\n- From the years 1997-1998 and 2000-2001, he carried out a cycle of studies for a doctorate entitled «Diritto pubblico interno e comunitario» -From 2001 to 2003 he carried out a post-doc research project (later becoming a winner of a post-doc grant) at the Faculty of Law of the Secondo Università degli Studi di Napoli to enhance the relationship between local autonomy and the community government.\r\n\r\n<strong>Titles:</strong>\r\n- Since 1 February , he has been the associate professor at the Università degli Studi della Campania «Luigi Vanvitelli»;\r\n- On 7 December 2000, he obtained the title of Research Fellow, later writing a doctoral dissertation on «Servizi pubblici locali e forme privatistiche di gestione»\r\n\r\n<strong>Teaching experience:</strong>\r\n- Since 1 February 2007, he has served the Distabif (environmental end Science Departement at the Second University of Studies of Naples), where he teaches «Diritto dell’Ambiente» and «Legislazione delle biotecnologie»;\r\n- From the academic year 2008-2009, he taught «Diritto pubblico dell’Economia» at the Department of Law of the Secondo Università degli Studi di Napoli;\r\n- He was appointed to teach Institutions of public law at the Faculty of Economic and Business Sciences at the Università degli Studi del Sannio for the academic years 2002-2003 and 2003-2004\r\n\r\n<strong>Scientific Collaborations:</strong>\r\n- He is the director of an interdisciplinary master on the management of public local services;\r\n- he is vice-director of LMDP (Laboratoire Méditerranéen de Droit Public);\r\n- he has been a member of the scientific committee of the «Scuola di Governo del territorio» (inter-university consortium);\r\n- He has been a member of the editing committee of the magazine “Rassegna di diritto pubblico europeo” (Esi, Napoli) since its foundation;\r\n-Since 2010, he has been a member of the editing committee of the online review “Economia e Politica” www.economiaepolitica.it;\r\n-He is a member of CIRB, Comitato Interuniversitario di Ricerca Bioetica;\r\n- In the years 2004 and 2005, he took part in the scientific committee of the project Formez entitled «La gestione associata del servizio personale nei comuni di piccole dimensioni»;\r\n- He is one of the founders of the Società di Studi Politici, a member of the Comitato Scientifico delle Assise della Città di Napoli and Mezzogiorno d’Italia;\r\n- He has collaborated for years with the activities at the Istituto Italiano per gli Studi Filosofici;\r\n- He founded the School of Politics and Administration (RED) which was attended by leading Italian and foreign researchers (the first edition took care of local policies and the second took care of the major themes of bio-politics).\r\n\r\n<strong>Research activities:</strong>\r\n- He is studying the effects of neoliberal policies on representative democracy as part of the school policy activities;\r\n-He was a component in the research entitled «Giurisdizione e pluralismi» (Jurisdictions and Pluralisms), published in 2012, scientific coordinator, Prof. Roberto Toniatti and scientific supervisor, Prof. Lorenzo Chieffi;\r\n- He was a component in the research entitled «Politica energetica e competenze comunitarie», published in 2008, scientific coordinator, Prof. Giovanni Pitruzzella and scientific supervisor, Prof. Lorenzo Chieffi\r\n\r\n<strong>Research and teaching experience abroad:</strong>\r\n- during the month of March 2017, He taught «Droit du vivant» in France, University of Touluse 1 Capitole;\r\n- during the month of April 2016, he spent a period of study in Spain, University of Murcia, where he studied environmental law issues;\r\n- He took part in the IV \"Congreso International de bioderecho\" held in Murcia (Spain) 15 to 21 April 2016. As part of the \"Jornadas sobre Suelos contaminados: bioderecho y salud (15 y 21 de abril)\" he has played two reports about the remediation of contaminated sites in Italian end European law;\r\n- on the 4th of December 2015 he organized an international conference entitled \"The independent authorities including regulatory function and judicial review\" taking a report entitled \"The independent authorities: the economic courts of neoliberalism”;\r\n- he was in the international conference held in Rabat (28-29 October 2015), \"Existe-t-il un droit public méditerranéen?\", Organized by the LDPM; he presented a report on the recent transformations of the public law (\"Les politiques néolibérales et la transformation du droit public \" (in press);\r\n- he took part in the \"Seconde journée Louis Rolland: Justice (s) constitutionnelle (s) en Méditerranée\" (13 March 2015), organized by the LDPM; he presented a paper on access to constitutional courts in Spain, France and Italy (in press).\r\n- On March 2015 he carried out a month of university teaching as a guest professor at the University of Maine (Francia), oriented towards Master 2 (droit public comparé);\r\n- He organized the conference entitled «Autorità indipendenti e tutela giurisdizionale» (20 October 2014) which took place in Santa Maria Capua Vetere, doing a report entitled «Le autorità indipendenti nella lettura delle giurisdizioni»;\r\n- He participates in the project \"Laboratoire Méditerranéen de Droit Public\", officially opened on 19 March 2012 in Paris, held under the \'Collectif L\'Unité du Droit \", which aims to create the first treaty on public Mediterranean law;\r\n- From the end of March to the end of April 2011, he carried out a month of university teaching as a guest professor at the University of Paris 2 PanthéonAssas, oriented towards Master 2 (juriste territorial) and Master 2 (droit public comparé);\r\n- In the month of September 2011, he carried out two weeks of research in Paris as a guest of the director of CERSA (Centre d’Etudes et de Recherche de Sciences Administratives et Politiques), Jacques Chevallier, to enhance the subject matter connected to the right to water and the management of hydro resources where he came into contact with Prof. Gilles Guglielmi and he was invited to participate in the activities of the «Laboratoire Méditerranéen de Droit Public»;\r\n-In the year of 2007, he carried out activity in consulting in the field of a project of international cooperation between Marocco and the European Union which was managed by the Ministero per l’Ambiente and the Tutela del Territorio e del Mare. He was directed to help the Maroccan institutions to make their legislation of garbage and evaluation of environmental impact closer to the community standards;\r\n- In 2007, he carried out a period of study in Paris for two months (August and September) where he came into contact with Prof. Gérard Marcou, professor of public law at the University of Paris-1 «La Sorbonne» and then in Montpellier as a guest of Prof. Jean-Luis Autin, professor of public law at the University of Montpellier 1 . His studies were to enhance the relationship between local French authorities and community law (this research was later published in a collection by Lorenzo Chieffi entitled Regioni e dinamiche di integrazione europea, Giappichelli, Torino, 2003);\r\n- In 2000, he carried out a period of study of four months (March-June) in France at the University of Montpellier 1, under the scientific direction of Prof. JeanLuis Autin where he enhanced the subject of local public services in the French system and while drafting a chapter of comparison with the French system in his doctoral dissertation.\r\n\r\n<strong>Foreign languages:</strong>\r\nExcellent knowledge of the French language and fair knowledge of English both in written and oral forms as a language at work\r\n\r\n<strong>Professional experience:</strong>\r\n- In 1999, he passed the Bar exam for the qualification of practicing law professionally\r\n\r\n<strong>Professional experience in the public interest:</strong>\r\n- Naples city councillor (2011-2016)\r\n- Chairman of the planning commission of the city council (2011-2013)\r\n- CEO of the company (GESAC) that manages the Naples airport (2010)\r\n\r\n", "40", "3", "", "VISUAL", "vc_column_text: content", "0", "", "25cdd0a693e830b9805fde357aa95ad2", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("479", "en", "page-builder-shortcode-strings-2523", "f4819bc9a329b1e95bd757d3319e520f", "[vc_empty_space height=\"92px\"]", "32", "1", "", "VISUAL", "vc_column: content", "0", "", "792d273e20d56d05c6f7cc06f44ae1fb", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("763", "en", "page-builder-shortcode-strings-250", "f2079908550d505167f54aab37e29f08", "[ct_team_member image=\"2824\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Fmans-jacobsson%2F|||\" title=\"Måns Jacobsson\"][vc_empty_space height=\"62px\"]", "14", "17", "", "VISUAL", "vc_column: content", "0", "", "0272ab6a0ce3df24f23762a012c55872", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("709", "en", "page-builder-shortcode-strings-2526", "28065fb37008184f7bf8aaf1b4462c2b", "\r\n<div align=\"justify\">\r\n\r\nProfessor <strong>Biagio Grasso</strong> is an experienced lawyer in Civil Law, particularly in relation to Common Law and Civil Liability. His professional qualifications come from forty years of practicing law which has brought him also to the Italian High Courts and from his academic work undertaken during his tenure as Professor of Civil Law at the well-known and prestigious University of Naples Federico II for more than 30 years. This has led him to be an important scholar and personality in scientific debate of the entire sector of Italian Civil Law. Based upon the recommendation of his peers, he received the prestigious appointment of ‘Professor Emeritus’ of Civil Law, bestowed to him by the Ministry of Scientific Research (an award of the highest honor, given to those who have made important contributions to the study and implementation of law).\r\n\r\nProfessor Biagio Grasso, therefore, has the specialized knowledge and competence to undertake even the most complex and problematic issues that may arise within the entire sphere of Italian Law. Recently, he has been involved in many cases relating to professional responsibility resulting from the breach of obligations relating to the conduct of the surgical medical profession, and has represented patients and/or their relatives in seeking compensation.\r\n\r\nIn other cases, he has defended doctors accused of committing errors during medical operations, and also addressed the issue of the relationship between the responsibility of the medical professional and that of the clinical setting in which the operation took place, as well as the effectiveness of the insurance policy that protects their responsibilities. In other instances, he has assisted patients and/or family members who have claimed damages, considering the faults that were made by medical professionals who may have contributed and aggravated to the medical malpractice made by surgical doctor.\r\n\r\n</div>\r\n", "33", "3", "", "VISUAL", "vc_column_text: content", "0", "", "5885a52409db52ac14aca1f5c237ba7a", "optional", "298");
INSERT INTO `wp_icl_strings` VALUES("483", "en", "page-builder-shortcode-strings-2526", "f4819bc9a329b1e95bd757d3319e520f", "[vc_empty_space height=\"92px\"]", "33", "1", "", "VISUAL", "vc_column: content", "0", "", "de3509eb81e48686ae915d46688a18f6", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("733", "en", "page-builder-shortcode-strings-250", "7ee455f76404671bed667c66e137b557", "[ct_team_member image=\"2771\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Froderick-cordara-qc%2F|||\" title=\"Roderick Cordara QC\"][vc_empty_space height=\"62px\"]", "14", "12", "", "VISUAL", "vc_column: content", "0", "", "0d2baf0d8ccdcb55f94f32f8a0597c13", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("488", "en", "page-builder-shortcode-strings-2530", "f4819bc9a329b1e95bd757d3319e520f", "[vc_empty_space height=\"92px\"]", "34", "1", "", "VISUAL", "vc_column: content", "0", "", "14ae2a3bb9784c956bf3c0f428480eeb", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("761", "en", "page-builder-shortcode-strings-250", "4dee928b6ef4be0f659da81fce063b59", "[ct_team_member image=\"2820\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Fbiagio-grasso%2F|||\" title=\"Biagio Grasso\"][vc_empty_space height=\"62px\"]", "14", "15", "", "VISUAL", "vc_column: content", "0", "", "9c0f4ab6c58fcacc247afee4697b47f9", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("713", "en", "page-builder-shortcode-strings-2539", "8aacb4678fdc7333c503d5d531f4ef2e", "\r\n<div align=\"justify\">\r\n\r\nMr. <strong>Yugui Wang</strong> is a founder of China Ship owners Mutual Assurance Association (CPI).\r\n\r\nFrom 1993 to 2013, he was the Managing Director of CPI. During the same period, Mr. Yugui Wang was also an Executive Member of Counsel of China Maritime Law Association (CMLA).\r\n\r\nFrom 2002-2013, Mr. Yugui Wang was a Supervisor for Haitong Securities Co., Ltd., a company listed on Shanghai Stock Exchange.\r\n\r\nIn addition, Mr. Yugui Wang was an Executive Member from 2006 to 2013, and a Member of Classification Committee of China Classification Society (CCS) from 2001 to 2013.\r\n\r\nCurrently, Mr. Yugui Wang is an Arbitrator of Maritime Arbitration Commission of China Council for the Promotion of International Trade (CCPIT) and the Non-Executive Director of China Minsheng Bank.\r\n\r\n</div>\r\n", "37", "3", "", "VISUAL", "vc_column_text: content", "0", "", "a2a4d9d63276a88b9d4f91397e1473c0", "optional", "124");
INSERT INTO `wp_icl_strings` VALUES("765", "en", "page-builder-shortcode-strings-2530", "df49336293895ede4ab088555c2e75a0", "\r\n<div align=\"justify\">\r\n\r\n<strong>Måns Jacobsson</strong> was from 1985 to 2006 Director and Chief Executive Officer of the International Oil Pollution Compensation Funds (IOPC Funds). Since his retirement from the IOPC Funds at the end of 2006 he is working as academic lecturer and as a consultant in maritime and environmental matters. Måns Jacobsson studied law at Lund University in Sweden, graduating in 1964. He served as a judge at district court and appellate court level in Sweden 1964-1970. He worked as legal advisor in the Department for International Civil Law of the Swedish Ministry of Justice 1970-1981 and was Head of that Department 1982-1984. He held the post of President of Division of the Stockholm Court of Appeal 1985-2006. Måns Jacobsson is member of the Board of Governors of the World Maritime University (WMU) in Malmö (Sweden). He is Visiting Professor at WMU and at the Maritime Universities in Dalian and Shanghai (People’s Republic of China) and Honorary Professor at the University of Nottingham (United Kingdom). He is a member of the Institute of International Shipping and Trade Law at the University of Swansea (United Kingdom) and Visiting Fellow at the IMO International Maritime Law Institute (IMLI) in Malta. He was member of the Executive Council of Comité Maritime International (CMI) 2007-2014 and is Honorary Member of the Italian and French Maritime Law Associations. He is also an Academic Associate of Quadrant Chambers, a set of leading barristers in London specialising in commercial law Måns Jacobsson has published numerous articles in various fields of law, such as maritime law, torts, patent law, nuclear law and treaty law. In 2015 he published a book in Swedish on maritime transport of environmentally hazardous substances - international liability regimes. In 2007 the University of Southampton conferred upon him the Degree of Doctor of Laws honoris causa. In 2010 he was awarded the King of Sweden’s Gold Medal for significant achievements in the field of marine environment and shipping.\r\n\r\nFor further details see mansjacobsson.wordpress.com\r\n\r\n</div>\r\n", "34", "3", "", "VISUAL", "vc_column_text: content", "0", "", "81a70183d5aae3b0bda7b92d18857533", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("498", "en", "page-builder-shortcode-strings-2536", "f4819bc9a329b1e95bd757d3319e520f", "[vc_empty_space height=\"92px\"]", "36", "1", "", "VISUAL", "vc_column: content", "0", "", "f8e637aa9d31c974d5e09dd755abce61", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("760", "en", "page-builder-shortcode-strings-250", "18960cbdb1ed8aa4922dd1fb4de4bce8", "[ct_team_member image=\"2811\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Fyuguy-wang%2F|||\" title=\"Yugui Wang\"][vc_empty_space height=\"62px\"]", "14", "20", "", "VISUAL", "vc_column: content", "0", "", "a85602ce6ac06beb1b61b59bdfb80ad5", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("711", "en", "page-builder-shortcode-strings-2533", "a97fbb8fdfc9427e494e816fa049ff35", "\r\n<div align=\"justify\">\r\n\r\n<strong>Giulio Maggiore</strong> is Associate Professor of Management at the University Unitelma Sapienza in Rome, where he is also Director of the Master in Management and coordination functions for the health-care professionals. He is also Adjunct Professor of Marketing at the Università degli Studi Internazionali di Roma (UNINT) and Research Associate at the Istituto di ricerche sulle attività terziarie (IRAT) of the Italian National Research Council (CNR).\r\n\r\nHe graduated in business economics at the University of Naples in 1990 and gained a PhD in Business Administration from the University of Catania in 1996. From 1997 to 2008 he was Adjunct Professor at the University of Sannio, teaching Business Economics (1997-2001) and Management of Communications Companies (2001-2008). In 2008 he joined the university Unitelma Sapienza, where he is now associate professor. Here he has been teaching several courses, including Business Economics and Management, Governance and Management in Public Administration and Management of Innovation.\r\n\r\nHis current research interests refer to service innovation, IT strategy, healthcare management and tourism marketing. Since 1990 he has also been working as a business consultant in the areas of strategic planning, marketing and communications, in collaboration with numerous public and private organizations.\r\n\r\n</div>\r\n", "35", "3", "", "VISUAL", "vc_column_text: content", "0", "", "c3100d91563a826604494a74ac771a85", "optional", "197");
INSERT INTO `wp_icl_strings` VALUES("756", "en", "page-builder-shortcode-strings-250", "fce059512c1a26c897b08aa1422306ea", "[ct_team_member image=\"2806\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Fnicola-tremante%2F|||\" title=\"Nicola Tremante\"][vc_empty_space height=\"62px\"]", "14", "19", "", "VISUAL", "vc_column: content", "0", "", "3b882d31ac9a05b747fba32e147e25eb", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("754", "en", "page-builder-shortcode-strings-2533", "39094dc0c81afefc424c72af8a6797c9", "[vc_empty_space][ct_team_member image=\"2802\" social=\"%5B%7B%7D%5D\" title=\"Giulio Maggiore\" el_class=\"single-team\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"42\"]", "35", "2", "", "VISUAL", "vc_column: content", "0", "", "0abcb76889007e1c7883b2a2962b81b4", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("494", "en", "page-builder-shortcode-strings-2533", "f4819bc9a329b1e95bd757d3319e520f", "[vc_empty_space height=\"92px\"]", "35", "1", "", "VISUAL", "vc_column: content", "0", "", "b8f0e7cf6517154caa301a9208455211", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("712", "en", "page-builder-shortcode-strings-2536", "1d770ecc26da748e6ecdc817a5b79d1e", "\r\n<div align=\"justify\">\r\n\r\n<strong>Nicola Tremante</strong> specialises in civil and commercial law and international banking and finance law as well. His areas of practice are banking and finance law (loan agreements, capital markets, derivatives, etc.), commercial law (general corporate, M&amp;A, transnational commercial contracts, guarantees, joint ventures), real estate, domestic and transnational litigation. After a broad experience as an in-house lawyer with Banco di Napoli in Naples where he focused on the legal aspects of international banking and finance for almost 20 years, he was in charge of the Naples Office of Studio Gianni, Origoni, Grippo &amp; Partners until 2008 and also served as a judge at the Benevento Court from 2005 to 2011.\r\n\r\nFollowing his graduation with full marks first in Law and thereafter in Civil Law at the University of Naples Federico II, he attended courses at the Academy of American and International Law, University of Dallas, at the Academy of International Law of The Hague, at the London School of Economics and Political Sciences, and at the University of Maryland (USA) and he also gained experience at top law firms in London (Middleton Potts) and in New York (Milbank Tweed; Pavia &amp; Harcourt). He is a member of the Naples Bar.\r\n\r\nHe speaks Italian, English and French.\r\n\r\n</div>\r\n", "36", "3", "", "VISUAL", "vc_column_text: content", "0", "", "f165683184ea08b9fa7c212619c35e2e", "optional", "206");
INSERT INTO `wp_icl_strings` VALUES("335", "en", "page-builder-shortcode-strings-1", "314a3a723560d1c7b5353165fe315f18", "In recent years requests from ships in distress seeking refuge in coastal waters and ports have given rise to difficult legal questions and also often become politically sensitive. Traditionally, when the only issue was human lives in danger, it was not questioned that a ship in distress was entitled to refuge by coastal States. Likewise, if the purpose of the ship seeking shelter was to preserve property, ships were not normally refused refuge either. In view of the large quantities of oil and other hazardous cargoes carried by sea and the increased importance of environmental issues, coastal States have increasingly become reluctant to allow ships in distress carrying such cargoes to enter their ports and coastal waters if the entry of the ship would represent a significant risk to the environment of the State concerned.\r\n\r\nIn a number of cases ships have been refused entry in view of the environmental risks, real or perceived, which the ship represented. The most extreme example is that of the <em>Castor</em>, a ship carrying a cargo of gasoline, which developed a major crack on its main deck during a storm off the coast of Morocco in December 2000. As its cargo was non-persistent oil, it did not present a significant pollution risk, but it was considered that there was a serious risk of explosion. Requests for permission to enter coastal waters to lighten the ship were refused by seven States, and the ship had to be towed around the Mediterranean for several weeks before a transfer operation could be carried out in Libyan waters. Other examples of requests for refuge being refused by coastal States in respect of ships carrying hazardous cargo are the <em>Prestige</em> (Spain, 2002), the <em>Stolt Valor</em> (Saudi Arabia, 2012) and the <em>Flamina</em> en route to Antwerp (Belgium, 2012). In 2013 it took almost 100 days before the chemical tanker <em>Maritime Maisie</em>, which had caught fire after a collision with 30 000 tonnes of hazardous cargo on board, was granted access to a place of refuge in the Republic of Korea.\r\n\r\nThere are, however, also cases where requests for refuge have been granted by the coastal State in spite of the fact that allowing the ship entry represented a serious pollution risk. A notable case is the <em>Sea Empress</em>, a laden tanker in distress that in 1996 was allowed to enter the port of Milford Haven in Wales. Another example, also in the United Kingdom, is the <em>Napoli</em> in 2007. In the latter case the United Kingdom authorities took the courageous decision to beach the vessel on the South Devon coast, which most likely avoided serious environmental damage. A more recent example is the car carrier <em>Modern Express</em> which was in distress in the Bay of Biscay in 2016 and was granted access to the port of Bilbao (Spain). In 2019, the containership Grande America, carrying containers, some of them containing hazardous substances, and a number of motor vehicles, caught fire in the Bay of Biscay. The ship was granted permission to enter the port of Bilbao, but this permission was not used since the ship sank a significant distance off the Spanish coast.\r\n\r\nIt should be noted that this analysis is made from a largely European perspective. It should also be mentioned that it relates to commercial ships only and does not address problems in respect of craft carrying migrants across the Mediterranean.\r\n\r\n<strong>Right to a place of refuge under public international law</strong>\r\n\r\nVarious opinions have been expressed as to the position of public international law regarding the extent to which a coastal State is obliged to allow a ship in distress to enter its coastal waters. The prevailing view appears to be that if the entry of the ship involves significant environmental risks for the coastal State, there is no legal obligation for that State to grant the ship access to a place of refuge. A coastal State that grants access is entitled to making the access conditional on additional requirements. It is also considered that there is no general right for a coastal State to refuse access to a ship in distress. The widely accepted view seems to be that any decision whether or not to grant a ship access is to be taken in the light of the particular circumstances of the case.\r\n\r\nIt should be pointed out that a State which refuses a ship in distress access to a place of refuge might incur liability under public international law for pollution damage caused in another State as a result of such refusal. The question of inter-State liability under public international law in cases of transboundary pollution is not, however, addressed in this note.\r\n\r\n<strong>IMO Guidelines on places of refuge</strong>\r\n\r\nIn 2003 the Assembly of the International Maritime Organization (IMO) adopted Guidelines on places of refuge for ships in need of assistance. The purpose of the Guidelines, which are not mandatory (“soft law”), is to set up a common framework for assessing the situation of ships in need of assistance. According to the Guidelines there are circumstances under which it is desirable to carry out a cargo transfer operation or other operations to prevent or minimise damage or pollution and that for this purpose it would usually be advantageous to take the ship to a place of refuge.\r\n\r\nIn the 2003 Guidelines it is stated that granting access to a place of refuge could involve a political decision which can only be taken on a case-by-case basis. Consideration has to be given to the balance between, on the one hand, the advantage for the affected ship and the environment resulting from bringing the ship into a place of refuge and, on the other hand, the risk to the environment resulting from that ship being near the coast. Coastal States should establish procedures consistent with the Guidelines by which to act on requests for assistance.\r\n\r\nReference should also be made to the 2007 IMO Guidelines on the Control of Ships in an Emergency. The purpose of these Guidelines is to provide Governments and others engaged in a maritime emergency with a framework of authority within which they will be expected to operate.\r\n\r\n<strong>Consideration within IMO of liability issues in relation to places of refuge</strong>\r\n\r\nThe IMO Guidelines on places of refuge of 2003 do not address liability and compensation issues.\r\n\r\nAs requested by the IMO Assembly, the IMO Legal Committee considered in 2005 whether there was a need for an additional, legally binding instrument regarding liability in relation to places of refuge. The Committee took the view that there was no need for an additional convention on this matter. The Committee stated that the more urgent priority would be to implement all existing liability and compensation conventions, namely the 1992 Civil Liability Convention<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftn1\" name=\"_ftnref1\">[1]</a>, the 1992 Fund Convention<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftn2\" name=\"_ftnref2\">[2]</a>, the 2003 Supplementary Fund Protocol,<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftn3\" name=\"_ftnref3\">[3]</a> the 2001 Bunkers Convention<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftn4\" name=\"_ftnref4\">[4]</a> and the 1996 HNS Convention<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftn5\" name=\"_ftnref5\">[5]</a> (later replaced by the 2010 HNS Convention).<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftn6\" name=\"_ftnref6\">[6]</a> In 2014 the Legal Committee once more emphasised the importance of ratification and implementation of the relevant IMO liability conventions.<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftn7\" name=\"_ftnref7\">[7]</a>\r\n\r\n<strong>European Union consideration of issues relating to places of refuge</strong>\r\n\r\nThe issue of places of refuge has also been dealt with within the European Union. A Directive adopted in 2002 for the purpose of establishing a Community vessel traffic monitoring and information system (amended in 2009) deals briefly with the procedures to be followed by European Union Member States when considering whether to grant a place of refuge.\r\n\r\nHowever, the Directive does not spell out any criteria to be applied for taking decisions on requests by ships in distress. In the preamble to the Directive it is stated that the IMO Guidelines are to form the basis of any plans prepared by Member States in order to respond effectively to the threats posed by ships in need of assistance. Under the Directive EU Member States are required to designate one or more competent authorities, which have the required expertise and the power to take independent decisions concerning the accommodation of ships in need of assistance. In the Directive it is also stated that ports that accommodate a ship in distress should be able to rely on prompt compensation in respect of costs and damage arising from the operation and that, for this reason, it is important that the relevant international conventions are applied.\r\n\r\nThis Directive has been supplemented by the EU Operational Guidelines on Places of Refuge (2018), developed by the European Maritime Safety Agency (EMSA). The Guidelines (including Annexes, some 70 pages), although non-mandatory in nature, are intended to support the more uniform application of the underlying legal provisions in the Directive.\r\n\r\nThe Guidelines aim at the creation of a robust operational process leading to well-advised and, where possible, quicker decision making. They provide practical guidance for the competent authorities and the main parties involved in managing a request for a place of refuge. They support the requirement for national plans to include procedures for international coordination and decision-making.\r\n\r\nAlthough the Guidelines deal mainly with the operational process, there are also some statements of a more substantive character. For instance, it is stated that a place of refuge request cannot be refused for commercial or financial reasons, nor should commercial interests become the main driver for the handling of such requests, or for the selection of a potential place of refuge. It is further stated that lack of proof of adequate insurance cover cannot in itself form sufficient reason to refuse a request for a place of refuge.\r\n\r\n<strong>European Community Directive on Environmental Liability</strong>\r\n\r\nOf relevance in this context is European Community Directive 2004/35/EC on environmental liability that in principle applies to place of refuge situations.<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftn8\" name=\"_ftnref8\">[8]</a>\r\n\r\nUnlike the international liability conventions referred to above, the Directive does not deal with traditional damage such as damage to property and economic loss. It applies to certain types of environmental damage caused by various activities such as the transport by sea of dangerous and polluting goods. The Directive also applies to preventive measures, i.e. measures taken after an event with a view to prevent or minimise environmental damage, as well as to remedial measures, that is actions to restore the damage environment. Consequently, there is a certain overlap between the concept of damage in the EU Directive and that concept in the maritime liability conventions.\r\n\r\nThe Directive does not apply, however, to environmental damage arising from incidents in respect of which liability or compensation falls within the scope of the 1992 Civil Liability Convention, the 2001 Bunkers Convention or the 2010 HNS Convention, provided the Convention is in force and applies to the incident.\r\n\r\nSince all EU Member States having a coastline are parties to the 1992 Civil Liability Convention and the 2001 Bunkers Convention, the 2004 Directive will not apply to oil spills in European waters.\r\n\r\nOn the other hand, as a result of the 2010 HNS Convention not being in force, the Directive does at present apply to place of refuge situations in European waters where damage is caused by hazardous substances other than persistent oil.\r\n\r\n<strong>Compensation for damage caused by oil and other hazardous substances in place of refuge situations</strong>\r\n\r\nA question that will have to be considered by those responsible for taking a decision on whether to grant a ship in distress carrying a hazardous cargo or large quantities of bunkers access to a place of refuge is whether it would be possible to get compensation for damage caused by the ca<strong>r</strong>go or the bunkers.\r\n\r\nAs regards<em> oil tankers</em>, the shipowner has under the 1992 Civil Liability Convention strict liability for pollution damage, his liability is covered by insurance, and claimants have the right of direct action against the insurer. The International Oil Pollution Compensation Fund 1992 (1992 Fund) will step in and pay additional compensation up to an aggregate amount of US$280 million if the total damage exceeds the amount payable by the shipowner and his insurer. The financial protection is even better for States that are parties to the 2003 Supplementary Fund Protocol, as a result of the very high amount available for compensation for pollution damage in these States, US$1 030 million.<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftn9\" name=\"_ftnref9\">[9]</a> Of the EU coastal States all except one (Romania) are members of the 1992 Fund, and all but four (Bulgaria, Cyprus, Malta and Romania) are parties to the 2003 Protocol.\r\n\r\nAn important aspect is the provisions in the 1992 Civil Liability Convention that channel the liability to the registered shipowner and provide responder immunity, except in rare cases, to those, including States and other public authorities, carrying out salvage and clean-up operations or taking other preventive measures. These provisions should, as regards cases involving oil tankers, result in reducing hesitation on the part of these groups to intervene rapidly also in difficult circumstances.\r\n\r\nIt is submitted that those having suffered pollution damage in a State belonging to the international regime created by the 1992 Conventions as a result of a tanker oil spill would, except in rare cases, rather pursue their claims under the international regime than take legal action against a State or public authority where normally negligence or failure to act with due diligence on the part of the defendant would have to be established.\r\n\r\nWith respect to place of refuge situations involving<em> ships other than oil tankers</em>, liability issues relating to oil pollution are governed by the 2001 Bunkers Convention to which all EU coastal States are parties. Also, under that Convention the shipowner (which includes the charterer, manager and operator of the ship) has strict liability for pollution damage, his liability is covered by insurance and claimants have the right of direct action against the insurer. However, the limitation amounts, which will normally be determined under the Convention on limitation of liability for maritime claims (LLMC), may be relatively low.<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftn10\" name=\"_ftnref10\">[10]</a> For States that are not parties to the LLMC, limitation of liability will be governed by national law. There is no second layer of compensation from an international fund.\r\n\r\nThe Bunkers Convention does not, therefore, give the same protection as the regime relating to spills from oil tankers. Admittedly, spills of bunker oil from non-tankers are seldom of the same magnitude as a major tanker oil spill, and in most bunker spill cases the Bunkers Convention gives a reasonably good financial protection for coastal States in place of refuge situations. There have however been several cases where bunker oil spills caused damage for very high amounts, and in these cases the financial protection under the Bunkers Convention was clearly inadequate. For this reason, a number of States have made reservations to the LLMC against the limitation amounts for bunker oil spills. One State, New Zealand, has even denounced the LLMC in the light of its experience in relation to an incident in 2011 involving a containership (the <em>Rena</em>)<strong>.</strong>\r\n\r\nUntil the HNS Convention enters into force, there is no international regime governing liability for damage caused by <em>cargoes other than oil.</em> Liability issues relating to such cargoes will be decided pursuant to applicable national law, and the shipowner and any other potentially liable party will normally be liable only if negligence on their part is proven. In addition, the shipowner may be entitled to limit his liability to an amount which is insufficient to provide full compensation to the public authorities and other claimants, and there is no second layer of compensation from an international fund. Although the EU Directive on environmental liability will apply, the Directive does not cover traditional damage such as property damage and economic loss, but only certain types of damage to the environment and costs of restoration.\r\n\r\nOnce the 2010 HNS Convention has entered into force, the situation will be largely the same for ships in distress carrying other hazardous cargoes than oil as for oil tankers.<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftn11\" name=\"_ftnref11\">[11]</a> If the amount payable by the shipowner is insufficient to compensate all claimants in full, additional compensation will be available from the International Hazardous and Noxious Substances Fund (HNS Fund). The total amount available for compensation under that Convention will be US$345 million, i.e. higher than under the 1992 Civil Liability and Fund Conventions (US$280 million), but significantly lower than under the Supplementary Fund Protocol <strong>(</strong>US$1 030 million<strong>).</strong>\r\n\r\nFor States not parties to the above-mentioned treaty instruments, issues of liability and compensation for damage in place of refuge situations will be governed by the applicable national law. It should be noted that the United States is not a party to any of the instruments that are in force, nor will it become a party to the HNS Convention. Consequently, issues relating to liability and compensation in place of refuge situations in United States waters will be governed by the relevant US legislation, primarily the Oil Pollution Act 1990 (OPA-90).<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftn12\" name=\"_ftnref12\">[12]</a>\r\n\r\n<strong>Concluding observations</strong>\r\n\r\nThe above analysis shows that mandatory international law is not of any great guidance to those who have to take a decision when receiving a request for granting a ship in distress access to a State’s ports or coastal waters. The IMO Guidelines are of only limited assistance in this regard. However, as for the EU Member States, the IMO Guidelines coupled with the EU Directive and the EU Operational Guidelines, if fully applied, should contribute to a more efficient and uniform handling of requests for places of refuge within the EU.\r\n\r\nThe reality is, however, that granting or refusing a ship access to a place of refuge often involves a difficult and delicate decision which can only be made on a case-by-case basis, taking into account all interests involved. Under the EU Directive Member States are required to designate competent authorities, which have the power to take independent decisions concerning the accommodation of ships in need of assistance. It is nevertheless likely that in major cases such a decision will, at least in some States, in reality be taken at a high political level. This is in particular so, if the ship carries oil or other hazardous substances because of strong resistance from local politicians and authorities, as well as from the general public and businesses in the area concerned. The authorities involved may fear that granting such a request could result in major damage and expenses, for example costs for clean-up of polluted beaches, costs of salvage operations, and loss of income in the fisheries and tourism sectors. There may also be fears that it will be difficult to get compensation for the damage caused.\r\n\r\nThese concerns are understandable. It should in any event be recognised that a refusal to grant access to a place of refuge may also result in significant damage, as was amply illustrated by the <em>Prestige</em> incident in Spain in 2002.\r\n\r\nStates have chosen different mechanisms for decision-making in such cases. The most radical one is the procedures adopted in the United Kingdom, where a senior civil servant, the Secretary of State’s Representative (SOSREP), has been given the authority to take all necessary decisions in place of refuge situations.\r\n\r\nSome States have, after careful consideration, pre-selected suitable places of refuge along their respective coasts that could be used should the need arise. The advantage of such an approach is that the selection can be made without the pressure of an ongoing incident. This might also facilitate the decision by the competent authorities when faced with a request for access to a place of refuge by a ship in distress.\r\n\r\n&nbsp;\r\n\r\n<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftnref1\" name=\"_ftn1\">[1]</a> International Convention on Civil Liability for Oil Pollution Damage, 1992; 140 States parties.\r\n\r\n<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftnref2\" name=\"_ftn2\">[2]</a> International Convention on the Establishment of International Fund for Compensation for Oil Pollution Damage, 1992; 117 States parties.\r\n\r\n<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftnref3\" name=\"_ftn3\">[3]</a> Protocol of 2003 to the International Convention on the Establishment of an International Fund for Compensation for Oil Pollution Damage, 1992; 32 States parties.\r\n\r\n<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftnref4\" name=\"_ftn4\">[4]</a> International Convention on Civil Liability for Bunker Oil Pollution Damage, 2001; 95 States parties.\r\n\r\n<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftnref5\" name=\"_ftn5\">[5]</a> International Convention on Liability and Compensation for Damage in Connection with the Carriage of Hazardous and Noxious Substances by Sea, 2010; five States parties (not in force).\r\n\r\n<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftnref6\" name=\"_ftn6\">[6]</a> In 2009 the Legal Committee considered a draft Convention on places of refuge intended to supplement the IMO Guidelines prepared by the Comité Maritime International (CMI), an international non-governmental organisation. The Legal Committee decided again that there was no need for a new convention.\r\n\r\n<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftnref7\" name=\"_ftn7\">[7]</a> As for the liability and compensation regimes established under these treaties see Måns Jacobsson, The IMO: Liability and Compensation, and Global Ocean Governance, in <em>The IMLI Treatise on Global Ocean Governance, Vol III The IMO and Global Ocean Governance</em>, Chapter 3, Oxford University Press 2018.\r\n\r\n<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftnref8\" name=\"_ftn8\">[8]</a> The 2004 Directive was amended by Directive 2013/30/EU on safety of offshore and gas operations, but the amendments are not relevant for the purpose of this note.\r\n\r\n<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftnref9\" name=\"_ftn9\">[9]</a> The limitation amounts in the treaties dealt with in this note are expressed I the Special Drawing Right (SDR) of the International Monetary Fund. Conversion into United States dollars has been made at the rate applicable on 2 December 2019.\r\n\r\n<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftnref10\" name=\"_ftn10\">[10]</a> The original version of the LLMC of 1976 has 55 States parties. The revised version of 1996, which provides for higher limits than the original Convention, has been ratified by 59 States. All EU coastal States are parties to the 1996 LLMC, except Italy that has ratified neither the 1996 LLMC nor the 1976 LLMC. Italy has however introduced national legislation which largely reflects the provisions of the 1996 LLMC.\r\n\r\n<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftnref11\" name=\"_ftn11\">[11]</a> So far, the 2010 HNS Convention has been ratified by only five States, viz. Canada, Denmark, Norway, South Africa and Turkey. It has been suggested that the Convention may enter into force in 2022/2023.\r\n\r\n<a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/#_ftnref12\" name=\"_ftn12\">[12]</a> Of other States not belonging to the 1992 Civil Liability and Fund Convention regime could be mentioned Brazil, Egypt and Saudi Arabia.\r\n<p class=\"yiv2146332637MsoNormal\"><strong><span lang=\"EN-US\">Authors:</span></strong></p>\r\n<p class=\"yiv2146332637MsoNormal\"><span lang=\"EN-US\">Måns Jacobsson - Maritime and Environmental Consultant</span></p>\r\n<p class=\"yiv2146332637MsoNormal\">Francesco S. Lauro – Managing Partner</p>\r\nYou can download the pdf version of the article by clicking <a href=\"https://sviluppo.studiolegalelauro.it/wp-content/uploads/2020/02/pdf-palces-of-refuge.pdf\" target=\"_blank\" rel=\"noopener noreferrer\">HERE</a>\r\n\r\nYou can reach the content to the following link: <a href=\"https://www.legal500.com/guides/hot-topic/places-of-refuge/\" target=\"_blank\" rel=\"noopener noreferrer\">https://www.legal500.com/guides/hot-topic/places-of-refuge/</a>.", "20", "1", "", "VISUAL", "wpml_string_wrapper: content", "0", "", "0db9ba693480b94ec50cb65e844edb12", "optional", "3635");
INSERT INTO `wp_icl_strings` VALUES("334", "en", "page-builder-shortcode-strings-2339", "c7c876c0e702926724d7703772ac705e", "<strong>Extract from the ‘Editor’s Note’</strong>\r\n\r\nIn October 2013, at the fourth edition of ‘Shipping and the Law’, the annual Naples gathering of the international shipping community organized by Studio Legale Lauro, Måns Jacobson took over the torch as the conference legal key note speaker from Francesco Berlingieri, who had performed the role with such distinction at the first three Shipping and the Law conferences from 2010 to 2012.\r\n\r\nJust a month ago I suggested to Måns that Studio Legale Lauro could publish a short book containing the five key note speeches he gave from 2013 to 2017 and I take this opportunity to thank him for having accepted that suggestion and for carrying out in such a short time the editing necessary to make the texts suitable for publication, based on his speaking notes and audio-video recordings of the original speeches.\r\n\r\nAs the title suggests, ‘<em>Five Speeches on Civil Liability for Marine Pollution</em>’ is not just an anthology assembling individual speeches. In fact, a common topic features in four of the speeches, i.e. compensation for damage arising from oil spills, whilst the same dilemma recurs in all five speeches: the problematic relationship between international uniform regimes based on international conventions – such as the 1992 Civil Liability and Fund Conventions or the United Nations Convention on the Law of the Sea (Unclos) – and the domestic laws of states parties in the often uneven interpretation by national courts. This dilemma is well expressed by the leading question which constitutes the title of the third speech: To what extent do international treaties result in the uniformity of maritime law?\r\n\r\nAs emerges not only from his third speech published here, but also from the other four, Måns is a strong supporter of international uniformity of maritime law. Despite his zeal for this, however, he never loses sight of the general context in which the forces governing the physics of international and national legislations are deployed and how court decisions arise. This balanced and pragmatic attitude reflects the multiple roles he covered in his brilliant career, as Swedish judge and senior Ministry of Justice official as well as over twenty years as Iocp Funds Director, and as an academic.\r\n\r\nThanks to such experience Måns displays a fair degree of leniency with the consciousness of the problems which national courts may have in the interpretation and application of maritime law treaties: Judges are also human beings – he says – and they are as a result of their training strongly influenced by the legal traditions and the legal interpretation technique prevailing in their respective country. Such consciousness also extends to some factual often recurring elements: The courts may sometimes be influenced by political considerations, and the public anger that often arises after a major shipping incident may influence the court. At the same time his longstanding experience and the deep understanding of the function of law causes him to note that law is not – and should not be – static, but must develop to take into account changes in society, and in economic, social and political priorities, so as to ensure that the law meets the requirements of society in a rapidly changing world. It is therefore necessary from time to time to amend treaties or adopt new ones, even though these changes may result in less, rather than more, uniformity of maritime law since that might lead to having in force two or more treaties dealing with the same subject matter.\r\n\r\nMåns does not refrain from expressing his views on the steps which could be taken to obtain more uniformity in maritime law which, in any event, is characterized by a higher degree of uniformity than most other fields of law. As regards States Members of the European Union he points out that treaties to which the EU is a party take precedence over other EU legislation as well as over domestic legislation in these States and in this way assigns to the European Court of Justice the competence of treaty interpretation, which could promote uniformity as between these States, as well as putting ourselves in a wider ‘de iure condendo’ realm. Probably the best solution, from a ‘de iure condendo’ perspective, might in his view lay in conferring jurisdiction for disputes on the interpretation of the maritime law treaties on an international court or tribunal, as in the case of the competence given by Unclos in certain matters to the United Nations Tribunal on the Law of the Sea. However, Måns’ awareness of the political international context unfortunately does not leave great room to hope that any major improvement will be achieved in the foreseeable future since we are not, as in most areas of human life, living in the perfect world.\r\n\r\nFour of the five speeches appear to focus on tanker oil spills compensation by commenting on national court decisions, which sometimes vary among different jurisdictions. They involve notorious cases such as the Erika in France, which is dealt with in the first speech, and the Prestige which relates mainly to Spain, but also to the United Kingdom, United States, Portugal, France and the European Court of Human Rights jurisdictions, which is dealt with in the second and fourth speeches. In the background glimpses the far cry of some other incidents such as the Patmos, Agip Abruzzo and Haven in Italy, the Aegean Sea in Spain and the Braer in the United Kingdom, as well as the Hebei Spirit in the Republic of Korea.\r\n\r\nOne of the main problems dealt with in the Erika by the French courts, as reported in Måns’ first speech, is the application of the so called ‘channelling of liability’ which under the 1992 Civil Liability Convention places the liability on the registered owner of the vessel and prohibits in principle compensation claims against several groups of persons listed in the relevant provision under letters a) to f). The approach of the French Court of Cassation, which considered the vessel’s classification society to be included under letter b), embraces an interpretation of that channelling provision which, according to Måns, may be wider than that intended by the Diplomatic Conference which gave birth to the 1992 Civil Liability Convention even though, as a matter of fact, the Court of Cassation removed any protection given by the Convention, finding that the classification society as well as the representative of the shipowner, the president of the management company and the charterer had been guilty of recklessness as defined in the Convention. These findings, even though based on specific facts, in Måns’ view may constitute precedents weakening a protection which had been considered, perhaps with an excessive optimism, as more or less ‘unbreakable’.\r\n\r\nAnother result of the Erika French Court of Appeal and the subsequent Court of Cassation judgements was to introduce the right of compensation for pure environmental damage in favour of local and regional authorities and associations for environmental protection. Even though the judgements did not violate the Civil Liability Convention since they were against defendants to which that convention did not apply, Måns considers the decision unfortunate from the perspective of international uniformity, since it introduced a concept, which was later codified by the French legislator in 2016, different from that of the regime of compensation under the international conventions.\r\n\r\nThe second and the fourth speeches, which deal with the worldwide development of the Prestige case, see our author navigating as a contemporary Odysseus through procellous seas and often conflicting winds blown by major and minor gods, such as the decisions by Spanish criminal courts at different levels and the Constitutional Court, the American Civil Court of first instance and Court of Appeals, the French first instance court and Court of Appeal, the Portuguese Maritime Court in Lisbon, by an arbitration tribunal in London (on the interpretation of the London P&amp;I Club’s Rules ‘pay to be paid’ provision) and subsequently by the High Court of Justice, and by the European Court of Human Rights as regards the criminal proceedings against the Master in Spain. In such a crowded judicial Olympus the role of Zeus is performed by the Spanish Supreme Court, which Måns however does not refrain from criticising, as the moderns often do with the jealous mythologic gods. From Måns’ international uniformity of maritime law perspective, the Court in fact did not respect the 1992 Civil Liability Convention as regards the insurer’s right to limit and the exclusion of moral damage from compensation, whilst the prison sentence on the Master did not, in his view, respect the United Nations Convention on the Law of the Sea.\r\n\r\nIn the fifth speech, the last of this book, the author addresses a problem which regards not only claims for compensation arising from oil spills falling under the 1992 Civil Liability and Fund Conventions but, in a wider scenario, is generally debated for tortious claims of many types in any jurisdiction; are pure economic loss compensation claims admissible? Obviously, Måns answer as to the interpretation of the Civil Liability and Fund Conventions reflects the necessarily cautious uniform approach of the Assemblies of the Funds, but also reports in real time his successor’s, as Director, proposals which were submitted in October 2017, simultaneously with the eighth edition of Shipping and the Law, to open the door for qualified claims by employees who lost their jobs due to the economic impact of the pollution. Måns’ approach is to be open to change. In his view the Funds’ criteria for admissibility of compensation claims should be reviewed from time to time, in the light of experience gained from dealing with various tanker oil spills since, as he says, law is not static, not cast in stone and that applies to international treaties as well as to national legislation.\r\n\r\n&nbsp;\r\n<p style=\"text-align: right;\"><strong>Francesco S. Lauro</strong></p>\r\n&nbsp;\r\n\r\nPlease click <a href=\"https://sviluppo.studiolegalelauro.it/wp-content/uploads/2020/03/Mans-Jacobsson-Five-Speeches-on-Civil-Liability-for-Marine-Pollution.pdf\" target=\"_blank\" rel=\"noopener noreferrer\">HERE</a> to download the pdf version of “Five Speeches on Civil Liability for Marine Pollution”.", "23", "1", "", "VISUAL", "vc_column_text: content", "0", "", "390dfdebc2472a43e428ef290aace05d", "optional", "1649");
INSERT INTO `wp_icl_strings` VALUES("386", "en", "page-builder-shortcode-strings-2444", "f4819bc9a329b1e95bd757d3319e520f", "[vc_empty_space height=\"92px\"]", "25", "1", "", "VISUAL", "vc_column: content", "0", "", "e19fba1bc53df40ef017c6d62510fed4", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("828", "en", "page-builder-shortcode-strings-238", "774efd240b5e60cb5d1b8fab1ab8abe4", "[ct_heading text=\"<font color=``#870101``>Events</font>\" align_lg=\"align-center\" align_md=\"align-center-md\" align_sm=\"align-center-sm\" align_xs=\"align-center-xs\" font_size_sm=\"24\" font_size_xs=\"24\" font_weight=\"\" show_gap=\"show\" subtitle_font_size=\"22\" description_font_weight=\"inherit\" margin_bottom=\"0\"]", "15", "1", "", "VISUAL", "vc_column_inner: content", "0", "", "7e52bcc9ef9cb3474f80ac3ea8047d1d", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("833", "en", "page-builder-shortcode-strings-232", "8d8ae28add743748c27ce659207ae5f1", "\r\n<h4 style=\"text-align: center;\"><strong><a href=\"https://sviluppo.studiolegalelauro.it/Expertise/shipping/\"><span style=\"color: #000000;\">SHIPPING </span></a></strong></h4>\r\n", "12", "2", "", "VISUAL", "vc_column_text: content", "0", "", "ae4a180573d9dbca6fb262d7f54661a7", "optional", "1");
INSERT INTO `wp_icl_strings` VALUES("346", "en", "Widgets", "widget title - 263ca12cb0f775f58aa11887387700df", "TWITTER FEED", NULL, NULL, "", "LINE", NULL, "0", "", "9cb13c1e18136aabd79d2f714dd16e60", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("347", "en", "Widgets", "widget body - 3420caa6ce54302fa6c46fcd2190205f", "[custom-twitter-feeds]", NULL, NULL, "", "LINE", NULL, "0", "", "83f91ba9c87b2a4ba3edf0903df7a51f", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("348", "en", "page-builder-shortcode-strings-2325", "c53112c528c693e090f42356f4c51077", "<strong>1 Overview</strong>\r\n\r\n<strong>1.1 Regulatory Bodies</strong>\r\n\r\nMaritime activities in Italy are generally conducted under the overall supervision of the Ministry of Infrastructure and Transport, whose many functions are carried out by the General Command of the Coast Guard (see Article 13, paragraph 2, of the Prime Minister\'s Decree 11 72, February 2014), in some areas through its dependent offices.\r\n\r\nTo enhance competition, efficient management and costs savings for stakeholders, companies and consumers, the Transport Regulatory Authority was established in Italy to guarantee fair and non-discriminatory conditions for access to railways, ports and airport infrastructures.\r\n\r\nThere are bodies duly authorised by the Ministry for certification of ships, to carry out inspections on board ships and to issue necessary certification (certificates under authorisation).\r\n\r\n<strong>1.2 Competition Laws and Regulation</strong>\r\n\r\nUnder Italian law and applicable European rules effective in Italy, maritime transport is subject to the principles of protection of competition and the freedom to provide services.\r\n\r\nThe Competition and Market Authority can authorise agreements or categories of prohibited agreements, such as under the EU, and Block Regulations for Shipping Consortia, which:\r\n<ul>\r\n 	<li>give rise to improvements in the conditions offered in the market;</li>\r\n 	<li>have effects such as to entail a substantial benefit for consumers; and</li>\r\n 	<li>take into account the need to ensure the necessary international competitiveness for companies, connected in particular with increases in production, or with qualitative improvements of the production itself or of the distribution or with technical or technological progress.</li>\r\n</ul>\r\nSuch authorisation cannot, however, allow restrictions not strictly necessary to achieve the purposes referred to in this paragraph, nor can it allow competition to be eliminated from a substantial part of the market.\r\n\r\n<strong>1.3 Top Ten Flag States</strong>\r\n\r\nGlobally, Italy ranks 15th for cargo tonnage (GT 15,396,260) and 18th for registered ships (1430).\r\n\r\n<strong>1.4 Maritime Conventions</strong>\r\n\r\nThe following Maritime Conventions have been ratified by Italy:\r\n<ul>\r\n 	<li>the Convention for the unification of certain rules of law respecting collisions between vessels, 1910;</li>\r\n 	<li>the International Convention for the Unification of certain Rules relating to Bills of Lading (Hague–Visby Rules) 1924 and 1979 Protocol;</li>\r\n 	<li>the International Convention for the Unification of certain Rules relating to Maritime Liens and Mortgages and Protocol of Signature, 1926;</li>\r\n 	<li>the International Convention for the Unification of certain Rules concerning the Immunity of State-owned ships, 1926 and the Supplementary Protocol, 1934;</li>\r\n 	<li>the Convention on the International Maritime Organization (IMO Convention), 1948;</li>\r\n 	<li>the International Convention for the Unification of certain Rules relating to Arrest of Sea-going Ships (Arrest Convention), 1952;</li>\r\n 	<li>the International Convention for the Unification of certain Rules relating to Penal Jurisdiction in matters of Collision or other Incidents of Navigation, 1952;</li>\r\n 	<li>the International Convention on certain Rules concerning Civil Jurisdiction in matters of Collision, 1952;</li>\r\n 	<li>the Convention on Facilitation of International Maritime Traffic (FAL), 1965;</li>\r\n 	<li>the Convention relating to Civil Liability in the Field of Maritime Carriage of Nuclear Material (NUCLEAR Convention),1971;</li>\r\n 	<li>the International Convention for Safe Containers (CSC Convention), 1972;</li>\r\n 	<li>the 1976 Protocol to the Athens Convention relating to the Carriage of Passengers and their Luggage by Sea, 1974;</li>\r\n 	<li>the United Nations Convention on a Code of Conduct for Liner Conferences, 1974;1982;</li>\r\n 	<li>the United Nations Convention on the Law of the Sea (Montego-Bay Convention), 1982;</li>\r\n 	<li>the Convention on the Prevention of Marine Pollution by Dumping of Wastes and Other Matter (London Convention) 1972 and the London Convention Protocol 1996;</li>\r\n 	<li>the Protocol of 1993 relating to the Convention for the Safety of Fishing Vessels (SFV Protocol), 1993;</li>\r\n 	<li>the Convention on the International Maritime Satellite Organization (IMSO Convention), 1976 and INMARSAT OA, 1976;</li>\r\n 	<li>the United Nations Convention on the Law of the Sea (UNCLOS), 1982;</li>\r\n 	<li>the International Convention for the Safety of Life at Sea (SOLAS), 1974 and SOLAS Protocol 1978 and 1988; Convention for the Suppression of Unlawful Acts Against the Safety of Maritime Navigation, Protocol for the Suppression of Unlawful Acts Against the Safety of Fixed Platforms Located on the Continental Shelf (SUA Convention), 1988 and 1988 Protocol;</li>\r\n 	<li>the International Convention on Oil Pollution Preparedness, Response and Co-operation (OPRC Convention), 1990;</li>\r\n 	<li>the International Convention on maritime search and rescue,1979 (SAR Convention);</li>\r\n 	<li>the International Convention for the Prevention of Pollution from Ships (MARPOL Convention 1973/78) and 1997 Protocol;</li>\r\n 	<li>the Standards of Training, Certification and Watchkeeping for Seafarers (STCW 1978/95);</li>\r\n 	<li>the International Convention on Maximum Load Lines (ILLC Convention),1966;</li>\r\n 	<li>the Load Lines Protocol 1988;</li>\r\n 	<li>the International Convention on Tonnage Measurement of Ships, 1969;</li>\r\n 	<li>the Convention on the International Regulations for Preventing Collisions at Sea, 1972 (COLREG);</li>\r\n 	<li>the International Convention on Salvage, 1989;</li>\r\n 	<li>the Maritime Labour Convention (MLC Convention), 2006;</li>\r\n 	<li>the International Convention Relating to Intervention on the High Seas in Cases of Oil Pollution Casualties, 1969 and Intervention Protocol 1973;</li>\r\n 	<li>the International Convention on Civil Liability for Oil Pollution Damage (CLC),1969 and Protocols 1976 and 1992;</li>\r\n 	<li>the International Convention on the Establishment of an International Fund for Compensation for Oil Pollution Damage (IFC Convention),1971 and Supplementary Fund Protocol;</li>\r\n 	<li>the International Convention on Civil Liability for Bunker Oil Pollution Damage (Bunkers Convention), 2001</li>\r\n 	<li>the International Convention on the Control of Harmful Anti-fouling Systems on Ships (Anti-fouling), 2001; and</li>\r\n 	<li>the Convention on the Protection of the Underwater Cultural Heritage, 2001.</li>\r\n</ul>\r\n<strong>1.5 Classification Societies</strong>\r\n\r\nThe classification societies recognised in Italy are:\r\n<ul>\r\n 	<li>Lloyd\'s Register Group Limited;</li>\r\n 	<li>the American Bureau of Shipping;</li>\r\n 	<li>Bureau Veritas Marine &amp; Offshore SAS;</li>\r\n 	<li>RINA Services;</li>\r\n 	<li>Det Norske Veritas.</li>\r\n</ul>\r\n<strong>1.6 Types of Registrations</strong>\r\n\r\nSince1998, a vessel can be registered in the Italian so-called “international” registry, which has three sections dedicated to different eligibility requirements, as follows: a section for Italian or EU ship-owners, another section dedicated to new buildings or vessels coming from foreign registers belonging to non-EU subjects, who directly manage vessels through a permanent organisation in Italy, and a third section for vessels belonging to non-EU subjects which are suspended from a foreign (non-EU) register following a bareboat charter in favour of Italian or European subjects.\r\n\r\n<strong>1.7 Types of Discounts</strong>\r\n\r\nAs other EU Countries have done, Italy has implemented the regulatory provisions for the application of tonnage tax. A vessel-operator has the option to compute taxable income derived from use of vessels in international trade on a conventional basis, by multiplying permitted aspects of the vessel’s net tonnage and adjusting the resulting amount by factors related to the vessel’s age. Income fixed according to that scheme is taxable at the statutory corporate income tax rate of 24%, without any allowance for deductions.\r\n\r\nEntry in one of the international registry’s \"three sections\" brings with it access to social security relief and tax credits toward crew members’ wages.\r\n\r\n<strong>1.8 Citizenship Requirements for Registration</strong>\r\n\r\nShip-owners from European Union countries are allowed to register vessels in Italy. Non-EU ship-owners can register a vessel in Italy coming from a non-EU registry only if they have a permanent establishment in Italy. A non-EU ship-owner can also register a vessel in Italy by suspending the flag of the foreign underlining register and chartering her on a bareboat basis to an Italian or EU ship-owner and flying the Italian flag.\r\n\r\n<strong>1.9 Cabotage Laws</strong>\r\n\r\nCabotage in Italy is implemented according to EU Regulation No 3577/92, with permitted restrictions - in particular, concerning the citizenship of crew and ship-owners (Italian or EU).\r\n\r\n<strong>2 Ship Finance and Securities</strong>\r\n\r\n<strong>2.1 Ship Finance Centre</strong>\r\n\r\nAssuming that a ship finance centre is viewed not only as a place characterised by a heavy concentration of demand and supply of ship finance, but also as a hub for cross-border financing around the world, then Italy cannot, sensibly, be considered a ship finance centre, as such. However, for Italian owners and shipping companies, a restricted number of the Italian Banks and foreign banks with subsidiaries in Italy provide adequate ship finance services, both in terms of long-term loans based on ship mortgages and short/medium-term loans and lines of credit to the shipping companies based on reputation, rating and the collaterals that can be provided (eg, shares pledge, other collaterals, freight contract assignment, personal guarantees, etc).\r\n\r\n<strong>2.2 Document Registration</strong>\r\n\r\nFinancial facilities or other agreements between the parties can either be privately executed by the parties or this can be done before a public notary. Public notary execution is, anyway, needed in case of registration of mortgages or other encumbrances. Mortgages and encumbrances over the subject vessel - in order to securitise the obligations of the financial facility toward a third party - ought to be registered in the Italian Ship Register held by the Harbour Master’s office at the port of registration of the vessel.\r\n\r\nThe registration of a mortgage or an encumbrance needs to be done in the Italian language and, therefore, any financing documentation in a foreign language will have to be translated into Italian.\r\n\r\n<strong>2.3 Preferred Modes of Ship Finance Registrations</strong>\r\n\r\nTraditional bank lending, backed by a security package achieved primarily by a first lien mortgage, has traditionally been the most prominent source of funding for shipping industry. During the last decade, the tightening on capital adequacy has produced a banking disengagement in terms of loans to the maritime industry that has led to changes in the financing structure of shipping business (see f<strong>2.4 Collateral Guarantees</strong>).\r\n\r\n<strong>2.4 Collateral Guarantees</strong>\r\n\r\nTypical forms of collateral over ships, other than mortgages, used in Italian financing transactions are as follows:\r\n<ul>\r\n 	<li>a \"pledge\" over a shipping company\'s shares;</li>\r\n 	<li>present and future receivables arising under a contract can be pledged or assigned;</li>\r\n 	<li>cross-collateralisation (collateral for one debt is used as collateral for another debt with the same creditor) is sometimes used to improve the quality of credit;</li>\r\n 	<li>the security package for a shipping loan might include a personal guarantee provided by the individual ship-owner.</li>\r\n</ul>\r\n<strong>2.5 Public Registry</strong>\r\n\r\nAll information relating to the ownership of a ship, any real rights, mortgages, liens or other encumbrances on it is publicly available. This information is held in each competent office of each port Authority for inspection but is not available online.\r\n\r\n<strong>2.6 Certified Information</strong>\r\n\r\nOnly the vessel’s statutory documentation required by international conventions is issued in Italian and English. All certificates requested by the competent authorities, ie, the Ministry of transportation or by Harbour Masters, are issued in Italian only. This certified information pertains to the technical characteristics and ownership of the ship.\r\n\r\n<strong>2.7 Reflagging</strong>\r\n\r\nIn general, when a vessel is reflagged from Italy to a different jurisdiction, the Italian registry operates in isolation. Co-ordination of information and documentation between national registries is usually handled by the ship-owners involved. Where a vessel is bareboat-chartered, the Ministry of Transportation may exchange information and documentation with the central authority of the bareboat registry.\r\n\r\n<strong>2.8 Costs of Registering a Ship Mortgage</strong>\r\n\r\nThe main costs of registering a ship mortgage in Italy relate to public notary activities, sworn translations, apostille of documentation, stamp and tax duties for registration and depend upon the value of the mortgage.\r\n\r\n<strong>2.9 Multiple Mortgages</strong>\r\n\r\nIt is possible to register further mortgages over a vessel after the first mortgage. The first mortgage establishes a priority right over subsequent mortgages. A vessel can be deleted from the Italian ship register only after the deletion of any/all mortgages.\r\n\r\n<strong>2.10 Pledge Agreements</strong>\r\n\r\nA pledge over a vessel can be registered in the ship register in the same way as a mortgage over a vessel.\r\n\r\n<strong>2.11 Maritime Liens</strong>\r\n\r\nLiens (in Italian <em>privilegi</em>) over a vessel or freight secure a claim against the vessel or her operator for:\r\n<ul>\r\n 	<li>judicial expenses due to the administration, anchorage tax, port duties and other taxes, pilots;</li>\r\n 	<li>seafarers’ employment credits;</li>\r\n 	<li>credits for seafarers’ repatriation and for social security bodies;</li>\r\n 	<li>expenses for the custody and maintenance of the vessel;</li>\r\n 	<li>salvage rewards and general average contributions;</li>\r\n 	<li>costs of collision or casualties;</li>\r\n 	<li>damages to berths and ports;</li>\r\n 	<li>damages for death or injuries to passengers and crew;</li>\r\n 	<li>damages or loss to cargo or luggage;</li>\r\n 	<li>credits for contracts signed by the Master for the ship.</li>\r\n</ul>\r\nLiens are different from mortgages and can be registered separately to secure the above claims.\r\n\r\n<strong>2.12 Duly Recorded Mortgages</strong>\r\n\r\nA vessel cannot be sold or deleted from the Italian registry without the deletion of any mortgage or lien duly registered. A mortgage, which is granted for a secured amount, can be deleted with the full repayment of any secured obligations by formal application for deletion to the register.\r\n\r\n<strong>3 Government Requisition of Vessels</strong>\r\n\r\n<strong>3.1 Authority to Requisition Vessels</strong>\r\n\r\nAn Italian ship is subject to requisition in the event that a state of war is declared, or in the case of national general or partial mobilisation, or in the event of a serious international crisis.\r\n\r\n<strong>4 Capital Markets</strong>\r\n\r\n<strong>4.1 Typical Means of Raising Capital</strong>\r\n\r\nItalian companies rely on banks as a source of financing. Borrowing has historically covered the largest part of a shipping company’s financial CAPEX requirements. The residual amount was, typically, provided by ship-owners’ equity contribution, retained earnings and, in some cases, by privately placed high-yield bond issuing.\r\n\r\nIn the last decade, structural and cyclical factors led to the development of different financing sources for shipping companies. Nevertheless, in Italy, evidence suggest that alternative forms of financing have not really taken off. In particular, use of the stock market and the private placement of debt to raise capital remain a low-volume option. Private equity can usually be considered a possible alternative only in special situations.\r\n\r\n<strong>4.2 Fleet Mortgages and Syndicated Loans</strong>\r\n\r\nFleet mortgages and syndicated loans represent almost 90% of Italian shipping-sector loans.\r\n\r\n<strong>4.3 Role of the Flag of the Vessel</strong>\r\n\r\nShip registration and the flag of the vessel are crucial elements in the overall valuation and pricing of ship-finance transactions, since international banks prefer countries where legislation assures efficiency and straightforward enforcement of a ship mortgage. Italian legislation has been improved recently but it is still characterised by some inefficiency.\r\n\r\n<strong>4.4 Securitisation </strong>\r\n\r\nSecuritisation has not been a viable solution in traditional shipping sectors, except for some peculiar structures to securitise NPLs/UTPs (bad loans).\r\n\r\nIn 2019, Law Decree 34/2019 (Decree 34) introduced some changes in the Italian Securitisation Law (Law 130 of 1999) intended to enhance the activity range of securitisation vehicles (SPVs) and overcome some legal rigidities which had made difficult or inefficient either the securitisation of revenues arising from the disposal of real estate or other registered assets.\r\n\r\nThe main changes to Italian securitisation law can be summarised as follows:\r\n<ul>\r\n 	<li>the transfer to SPVs of credit facilities in connection with securitisation of non-performing loans (NPLs) to facilitate disposals of so-called “unlikely to pay” loans (UTPs). In the case of securitisations of NPLs held by banks or financial intermediaries, the seller of the NPLs will now be able to couple the assignment of the receivables to the SPV with the transfer of the underlying contractual obligations as lender to another bank or a financial intermediary;</li>\r\n 	<li>change in Italian securitisation, introducing provisions aimed at facilitating securitisation structures involving real estate or other registered assets.</li>\r\n</ul>\r\nThe strategies of management and recovery of Italian mortgage NPLs have led investors to develop dedicated companies to be used as purchaser of the mortgaged assets in the context of enforcement proceedings whenever the auction value of the asset was about to go below the allocated purchase price for the corresponding securitised loans.\r\n\r\n<strong>4.5 Participation of Capital Markets in Shipping Transactions</strong>\r\n\r\nHistorically, Italian Capital Markets have been quite \"tight\" and \"dry\" both for equity and debt instruments. In Italy, the attractiveness of the shipping industry for private and institutional investors is quite low since shipping is generally considered a volatile, higher-risk business. For instance, there were only three Italian listed shipping companies in the 80s/90s. Now, only one of those remains listed (which is d’Amico International Shipping-DIS). Listing is not attractive for the issuer, since shares generally have to be priced below the NAV (Net Asset Value) of the company, due to lack of interest from investors.\r\n\r\nRecent legislation has opened up the Italian loan market to other categories of participants, such as Italian securitisation companies, insurance companies, pension funds and closed-end investment funds. This could in time result in more activity, especially amongst banks, by creating a more unified and efficient private placement market and establishing standardised transaction models for private placement transactions.\r\n\r\n<strong>5 Maritime Labour</strong>\r\n\r\n<strong>5.1 Labour Laws and Conventions</strong>\r\n\r\nThe MLC 2006 sets out shipping companies’ obligations regarding seafarers’ contractual arrangements, oversight of manning agencies, working hours, health and safety, crew accommodation, catering standards and seafarers’ welfare. Training requirements are ruled by the STCW Convention 95 as amended by the 2010 Manila Amendments. Also, the Code of Navigation, Council Regulation (EEC) No 3572/92 concerning maritime cabotage and a number on internal laws (L. 135/77, L. 30/98, L. 271/99, L. 272/99 applicable for ships at dry dock), plus Collective Labour Agreements, CLA for EU seafarers, CBA for nondomiciled seafarers embarked on cargo vessels listed in the Italian International Registry and the SEC POEA Rules (governing the employment of Filipino seafarers on board ocean-going ships) will be applicable.\r\n\r\n<strong>5.2 Local Seafarers</strong>\r\n\r\nArticle 318 of the Code of Navigation states that crew members of Italian-flagged ships must all be Italian or from EU States but allows the CLA to waive this ruling to allow non-Italian crew members.\r\n\r\nPursuant to Law 30/1998, for vessels on bareboat charter and listed in the Italian International Registry, a minimum of six EU crew members must be retained: the CLA can further allow that only the Master is from the EU, provided that he or she passes the national examination for language at the Harbour Master\'s office of the port of Registry of the vessel. One cadet is also mandatory.\r\n\r\nIf the vessel is engaged in cabotage trade, 100% of the crew members must be from the EU.\r\n\r\n<strong>5.3 Minimum Wage Requirements and Overtime</strong>\r\n\r\nMinimum wage, daily working hours and rest periods are governed by Legislative Decree 27 July 1999 n. 271 (DLGS 271/1999) and the CLA.\r\n\r\n<strong>5.4 Justified Dismissal</strong>\r\n\r\nFollowing a decision of the Italian Constitutional Court in 1991, dismissal of seafarers is allowed where there is just cause (ie, when a situation arises such that the employment relationship cannot be continued, even temporarily), or where there are justifiable reasons for dismissal (which can be “subjective”, consisting of a serious non-fulfilment of the employee’s contractual obligations and “objective”, which occurs when dismissal is justified by reasons inherent in the production activity, the organisation of work and its proper functioning). This area is governed by the CLA for EU personnel and the CBA for non-EU personnel.\r\n\r\n<strong>5.5 Occupational Injuries and Insurance</strong>\r\n\r\nThe Italian Workers’ Compensation Authority, INAIL, the nationally appointed social insurer, is responsible for providing compulsory insurance on behalf of all Italian crew members and shore staff against accidents at work and occupational diseases. The current system of compensation in favour of workers provides for a public insurance scheme covering work-related accidents and occupational diseases. In the event that a crewman or woman is injured at work, he or she is entitled to payment in proportion to the percentage of permanent disability (and in some circumstances, the level of his or her salary). The value of the permanent disability differs for the purposes of:\r\n<ul>\r\n 	<li>compensation payable pursuant to the INAIL insurance scheme; and</li>\r\n 	<li>third-party liability claims which are pursued in the Italian courts against the offender or the employer.</li>\r\n</ul>\r\nHowever, the compensation payable pursuant to the INAIL insurance scheme is limited and there might be  a sizeable difference between the compensation that a worker receives pursuant to the INAIL criteria and the amount he or she would be entitled to receive following a successful claim in court, applying the general principles of Italian tort law: the employer remains liable in law to compensate its crew member for that shortfall.\r\n\r\nShip-owners’ private insurance generally covers either liability to the social insurers (who has the right to seek payment by indemnity against the employer (if the latter is held liable for a crime) or the difference required to compensate the injured seafarer beyond the INAIL insurance criteria.\r\n\r\n<strong>5.6 Maritime Disputes</strong>\r\n\r\nMaritime labour disputes (as well all employment complaints) are dealt with by Labour Courts and are subject to a special procedure which is faster than standard court procedure - although the amount of time it takes to decide employment-related disputes differs amongst territorial locations.\r\n\r\n<strong>5.7 Repatriation</strong>\r\n\r\nRepatriation of seafarers is governed by the CLA, the rules of which are in line with the CCNL. Provisions are made in line with MLC regulations as far as entitlement to repatriation, maximum duration of service periods on board and repatriation arrangement/costs are concerned.\r\n\r\n<strong>5.8 International Bargaining Forum (ITF) Agreements</strong>\r\n\r\nAn Italian \"non-dom\" collective bargaining agreement (CBA) is a national bargaining agreement recognised by the ITF and applicable to all non-EU seafarers on board Italian-flagged vessels. Ship-owners have the option to apply for the international Total Crew Cost Agreement (TCC) signed by the ITF with trade unions of the country of origin of the seafarers. Based on Confitarma (Italian Shipowners Association) data, approximately 80% of seafarers are employed under a \"non-dom\" CBA.\r\n\r\n<strong>6 Maritime Courts</strong>\r\n\r\n<strong>6.1 Courts of First Instance and Appeal</strong>\r\n\r\nIn Italy there are no specific courts designed to handle maritime disputes. Maritime disputes are handled by the general civil courts.\r\n\r\n<strong>6.2 Determining a Maritime Dispute</strong>\r\n\r\nThe Italian Code of Navigation, in force since 1942, lists as maritime disputes, “Cause maritime”:\r\n<ul>\r\n 	<li>maritime labour disputes;</li>\r\n 	<li>claims for damage caused by collisions or which occurred during anchoring, mooring operations and manoeuvres in ports or at other waiting places, or connected to the loading, unloading and handling of goods in ports;</li>\r\n 	<li>damage to fishing nets or tools, or compensation/cost reimbursement in respect of salvage, vessels’ removals, assistance and recovery and premiums for wreck recoveries.</li>\r\n</ul>\r\nThese “maritime proceedings” are decided before the civil courts, but the competent court can appoint experts to assist on technical issues. If the parties agree, they may request that a decision be taken by an arbitration tribunal made up of those appointed experts.\r\n\r\n<strong>6.3 Arbitration and Mediation</strong>\r\n\r\nItalian law provides for i) mandatory mediations and ii) facultative mediations, depending on the dispute matter. If mandatory mediation applies (eg, for insurance, banking and financial agreements, joint ownership, property rights, lease agreements and gratuitous loans) the parties must try a prior mediation procedure: in this case, the written mediation request has to be filed before serving a writ of summons since mediation is a pre-condition of judicial action. The mediation procedure is managed by bodies that must be registered in a special register regulated by specific decrees of the Ministry of Justice.\r\n\r\nItalian arbitration proceedings are governed the Italian Code of Civil Procedure.  Disputes over labour matters may be decided by arbitrators only if so provided by law or by collective labour contracts. Italian arbitration proceedings result in an enforceable award with the same effect as a judgment rendered by the judicial authority pursuant to Article 824–bis of the Italian Code of Civil Proceedings and can be appealed.\r\n\r\nSeparately, Article 808-ter of the Italian Code of Civil Proceedings provides for “Arbitrato Irrituale”, which is a procedure leading to a decision which has the nature of a settlement agreement.\r\n\r\n<strong>6.4 Judicial Sale of Vessels</strong>\r\n\r\nThe procedure to sell a vessel by judicial sale is closely supervised by the competent civil court, which is that of the place where the vessel is located. Sale proceedings can be initiated if the claimant has an enforceable entitlement, such as an enforceable Italian or foreign award and/or judgment, or an acknowledgment of debt contained in a notarial deed. A vessel cannot be sold privately by a mortgagee and the only remedy for a creditor to satisfy its claim on a vessel is a judicial sale at public auction. A creditor without an enforceable entitlement can start proceedings to obtain such an entitlement; pending the time to get this, its claim can be secured by way of an arrest of the vessel.\r\n\r\n<strong>6.5 Execution of Foreign Resolutions</strong>\r\n\r\nFor EU judgments, the Regulation (EU) 1215/2012 on jurisdiction and the recognition and enforcement of judgments in civil and commercial matters replaced Regulation 44/2001 and ensures that judgments rendered in one EU Member State in civil or commercial matters can be enforced in other EU Member States without formalities.\r\n\r\nThe enforcement of non-EU judgments is governed by the Italian International Private Law (Law 218/1995). In the absence of any special applicable convention, foreign judgments are recognised in Italy pursuant to Articles 64, 65 and 66 of the Italian International Private Law. In particular, pursuant to Article 64, a judgment rendered by a foreign authority shall be recognised in Italy without requiring any further proceedings if:\r\n<ul>\r\n 	<li>the foreign judge rendering the judgment had jurisdiction according to Italian jurisdictional principles;</li>\r\n 	<li>the defendant was served with the documents instituting the proceedings pursuant to the law in force in the place where the proceedings were carried out, and the fundamental rights of the defence were complied with;</li>\r\n 	<li>the parties appeared in accordance with forum law, or default was declared in accordance with that law;</li>\r\n 	<li>the judgment has become final (res judicata) according to the law in force in the place where it was pronounced;</li>\r\n 	<li>the judgment is not in conflict with another judgment rendered by an Italian judge which is res judicata;</li>\r\n 	<li>no further proceedings are pending before an Italian court between the same parties on the same subject, which began before the foreign proceedings; and</li>\r\n 	<li>the effects of the judgment are not contrary to Italian public policy.</li>\r\n</ul>\r\nItaly is also party to the 1958 Convention on the Recognition and Enforcement of Foreign Arbitral Awards (New York Convention), according to which rules each contracting state must recognise arbitral awards as binding and enforce them in accordance with the rules of procedure of the territory where the award is relied on. In Italy, a court order declaring the effectiveness of a foreign arbitration award will be issued without the other party having been heard, provided that the formalities stipulated by Article 839 of the Code of Civil Procedure are complied with. In Italy, the New York Convention is applied in respect of both contracting and non-contracting states. Italy made no reservations to the New York Convention when adopting it. A party wishing to enforce a foreign award in Italy must file a petition with the Court of Appeal of the district in which the other party has its domicile; if that party has no domicile in Italy, the Court of Appeal of Rome has default jurisdiction. The President of the Court of Appeal, after having ascertained the formal regularity of the award, shall declare by decree the enforceability of the foreign award, unless:\r\n<ul>\r\n 	<li>the dispute cannot be the subject of an arbitration agreement under Italian law; or</li>\r\n 	<li>the award contains provisions contrary to public policy.</li>\r\n</ul>\r\n<strong>6.6 Order of Priority of Maritime Claims</strong>\r\n\r\nThe order of priority of maritime liens is determined by the law of the flag of the vessel. In the event that the flag of the vessel is changed, maritime liens are governed by the law of the flag at the time when the lien arose with regard to the existence/validity of that lien and by the law of the vessel flag at the time the security is enforced in respect of enforcement and the realisation of the security provided by the lien. Maritime liens sources are the Italian Code of Navigation, which applies to Italian flag vessels, and by the 1926 Brussels Convention on Maritime Liens and Mortgages which Italy ratified in 1928, which applies to non-Italian flag vessels. The types of liens listed by both sources are substantially the same.\r\n\r\nAccording to Article 575 of the Navigation Code, a ship mortgage is next in the order of priority of maritime liens. Pursuant to Article 548, the liens set out in the Navigation Code are preferred over any other general or special lien set out by Italian law. The priority status of ship mortgages depends on the date of the registration of the mortgage in the public register.\r\n\r\n<strong>6.7 Sisterships or Vessels Owned by Affiliates</strong>\r\n\r\nVessels under the flag of states which ratified the 1952 Brussels Convention on Arrest of Sea-going Ships (ratified by Italy in 1979) can only be arrested in respect of the Maritime Claims stipulated by this Convention, whilst vessels of states which did not ratify the Convention can be arrested in respect of the Convention Maritime Claims under the rules of the Convention (which permit sister-ship arrests) as well as under the Italian conservative arrest rules (although an Italian claimant can arrest an Italian vessel only under those internal conservative arrest rules).\r\n\r\nSister ships can be arrested under the Convention rules, with the exception of those for maritime claims listed under o) and q) in Article 1 of the 1952 Brussels Convention and those owned by the owner of the arrested vessel when he or she is not the debtor of the Maritime Claim. Also, under national conservative arrest rules a sister ship can be arrested. However, vessels owned by affiliates cannot generally be arrested.\r\n\r\n<strong>6.8 Limitations of Liability</strong>\r\n\r\nThe Italian Navigation Code provides that a ship-owner may limit his or her overall liability to an amount equal to the value of the ship and the amount of the freight and any voyage proceeds. If the value of the ship at the time when limitation is requested is less than one fifth of the value of the ship at the beginning of the voyage, the limitation amount is equal to that amount of one fifth; but if the value of the ship is higher than two fifths of the value of the ship at the beginning of the voyage, the limit is equal to two fifths of the value. Article 7-8 of the Legislative Decree 111/2012 applies the limitation figures of the 76 LLMC Convention, 96 Protocol to Italian vessels over 300 GRT, whilst the Code of Navigation limitation rules remain in place only for vessels under 300 GRT.\r\n\r\nHowever, a \"problem\" exists in Italian jurisprudence, because the Decree was issued as the enactment in Italy of the European Directive 2009/20 on compulsory insurance for marine claim liability and presumes the application of the LLMC Convention, as amended by the 96 Protocol, on the assumption that the LLMC Convention would be adopted by Italy shortly thereafter. However, Italy has not yet fully adopted the LLMC Convention, resulting in a lacuna.\r\n\r\nThe matter is also complicated by a recent judgment of the Court of Nola, which applied the old Code of Navigation system to a vessel over 300 GRT. However, this judgment is considered to be incorrect (Italian court judgments are not binding precedent). The majority of Italian maritime law practitioners and experts consider that the limitation figures of the 76 LLMC Convention, 96 Protocol, apply to vessels over 300 GRT, at least as an Italian internal regulation. It is also considered, notwithstanding some dissenting opinions, that the provisions concerning the limitation proceedings of the Code of Navigation should be adapted to the new limitation figures.  The matter, however, remains unresolved currently under Italian law.\r\n\r\nWhilst the Decree does not expressly provide any exception to limitation, there is a consensus that the late Professor Francesco Berlingieri’s opinion that the personal wilful misconduct or gross negligence of the owner would exclude the right to limitation - in view of the judgment of the Italian Constitutional Court No 199/2005 that excludes, in these cases, package/unit limitation provided by the Italian Code of Navigation for the Carrier. Italy also applies the Hague-Visby Rules for maritime carriage.\r\n\r\n<strong>6.9 Exceptional Actions for Ending a Maritime Claim</strong>\r\n\r\nWe cannot identify any exceptional actions for ending a maritime claim in the jurisdiction of Italy as there are no specific maritime courts in the country.\r\n\r\n<strong>7 Legislation on Corporations and Tax System</strong>\r\n\r\n<strong>7.1 New Corporate or Tax Legislation</strong>\r\n\r\nThe tax facilities for shipping companies are:\r\n<ul>\r\n 	<li>IRES (<em>imposta sul reddito sulle società</em>) is the Italian corporate income tax (universal tax - worldwide taxation principle). Companies are subject to IRES based on their statutory income, adjusted for non-taxable revenues and/or non-deductible costs according to IRES provisions. IRES is levied at the ordinary rate of 24%;</li>\r\n 	<li>companies are also subject to IRAP <em>(imposta regionale sulle attività produttive</em>), a regional tax on business activities, which is determined by applying a tax rate of 3.9% to the income statement “operating margin” (without deducting, however, labour costs, bad debts and accruals for risks). Regions have the power to increase or decrease IRAP rates slightly.</li>\r\n</ul>\r\nAs of the tax year 2005, shipping companies have been able to opt for Tonnage Tax. Italian tax-resident shipping companies, as well as non-resident shipping companies operating in Italy through a permanent establishment, can qualify for and then elect to be subject to the Italian tonnage tax regime. The regime basically allows for the determination of presumptive income based on the net tonnage of the qualifying ships, apportioned to the effective shipping days (tonnage income). The tonnage income is subject to IRES only.\r\n\r\nTo qualify for the tonnage tax, a ship must:\r\n<ul>\r\n 	<li>have a net tonnage of more than 100 net tons;</li>\r\n 	<li>be used for goods transportation, passenger transportation, salvage, towing, and other services; and</li>\r\n 	<li>operate in international shipping as defined by the rules regulating the Italian International Registry. Ships which are bareboat chartered are excluded. Chartered ships with crew are included in the tonnage tax regime if their global net tonnage is less than 50% of the total net tonnage.</li>\r\n</ul>\r\nCapital gains and losses on transactions on qualified vessels are included in the above fixed income.\r\n\r\nFurthermore, IRAP does not apply to qualified vessels.\r\n\r\nItalian companies must submit the following documents in their financial statements: a balance sheet, profit and loss statement, notes to the accounts and an annual report.\r\n\r\nAnnual reports are not required for smaller companies, which can instead prepare short-form balance sheets if financial and economic parameters are met for two consecutive financial years. Such companies cannot adopt IAS/IFRS accounting principles.\r\n\r\n<strong>7.2 Tax System</strong>\r\n\r\nAs above noted in <strong>7.1 New Corporate or Tax Legislation</strong>, the tax system is a mix of universal and territorial rules and regulations.\r\n\r\n<strong>7.3 Settling Matters Once a Company Ceases to Exist </strong>\r\n\r\nA company ceases to exist upon its formal deletion from the Companies’ Register.\r\n\r\nIn the case of debts outstanding after deletion, the creditors have a right to proceed against the liquidators of the company, or against its shareholders in respect of distributed proceeds. Such an action must be commenced within one year following the deletion of the company from the Register.\r\n\r\n<strong>7.4 International Tax Treaties</strong>\r\n\r\nAlthough Italy has a large network of tax treaties and bilateral agreements with the EU and other countries to avoid double taxation of income and capital, Italy is not party to any international treaty on taxation regulating or dealing with shipping income.\r\n\r\n<strong> </strong>\r\n\r\n<strong>Authors</strong>:\r\n\r\nFrancesco S. Lauro – Managing Partner\r\n\r\nErnesto Ardia – Founding Partner\r\n\r\nGiannicola Forte – Lawyer\r\n\r\nAnna Vernillo - Lawyer\r\n\r\n<strong> </strong>\r\n\r\n&nbsp;\r\n\r\nYou can download the pdf version of the contribution by clicking <a href=\"https://sviluppo.studiolegalelauro.it/wp-content/uploads/2020/03/Chambers-Global-Practice-Guide-Shipping-Law-and-Practice.pdf\" target=\"_blank\" rel=\"noopener noreferrer\">HERE</a>\r\n\r\nYou can reach the content to the following link: <a href=\"https://practiceguides.chambers.com/practice-guides/shipping-2020/italy\" target=\"_blank\" rel=\"noopener noreferrer\">https://practiceguides.chambers.com/practice-guides/shipping-2020/italy</a>", "22", "1", "", "VISUAL", "vc_column_text: content", "0", "", "a3de84aacb1b33926dece8a7c0334012", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("502", "en", "page-builder-shortcode-strings-2539", "f4819bc9a329b1e95bd757d3319e520f", "[vc_empty_space height=\"92px\"]", "37", "1", "", "VISUAL", "vc_column: content", "0", "", "dac76af8108a6930e02daced44d0ee75", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("571", "en", "Cookie Notice", "Message in the notice", "We use cookies to ensure that we give you the best experience on our website. If you continue to use this site we will assume that you are happy with it.", NULL, NULL, "", "LINE", NULL, "0", "", "690273c84ab2e9f16976a541ecfefc5f", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("572", "en", "Cookie Notice", "Button text", "Ok", NULL, NULL, "", "LINE", NULL, "0", "", "9ec94d99bbb498802ad0f7a220ea706e", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("573", "en", "Cookie Notice", "Refuse button text", "No", NULL, NULL, "", "LINE", NULL, "0", "", "3c3b3c75bf18e3dbbd7f87cf2eb1fe06", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("509", "en", "page-builder-shortcode-strings-2544", "f4819bc9a329b1e95bd757d3319e520f", "[vc_empty_space height=\"92px\"]", "38", "1", "", "VISUAL", "vc_column: content", "0", "", "d99b191897428c4957f38d6b788fca35", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("759", "en", "page-builder-shortcode-strings-2539", "4aa659fe527b8aa014710cbf49ae7bd4", "[vc_empty_space][ct_team_member image=\"2811\" social=\"%5B%7B%7D%5D\" title=\"Yugui Wang\" el_class=\"single-team\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"42\"]", "37", "2", "", "VISUAL", "vc_column: content", "0", "", "e2984fef2f6baa33009f73ea34420ec2", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("741", "en", "page-builder-shortcode-strings-250", "549aa1d9807e1010fa8a95f6e2bf4cc5", "[ct_team_member image=\"2781\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Fmichele-di-fiore%2F|||\" title=\"Michele Di Fiore\"][vc_empty_space height=\"62px\"]", "14", "14", "", "VISUAL", "vc_column: content", "0", "", "a504754ce853ca04443eb004a9fef91d", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("676", "en", "page-builder-shortcode-strings-2544", "ee4c1040a12c36fb050261dfa75a6f49", "[vc_empty_space][ct_team_member image=\"2096\" social=\"%5B%7B%7D%5D\" title=\"Giannicola Forte\" el_class=\"single-team\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"42\"]", "38", "2", "", "VISUAL", "vc_column: content", "0", "", "138ef0eb32925228eeb3304334d4548b", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("513", "en", "page-builder-shortcode-strings-2544", "3991a5ae47f2f4debe92bdc40f17db8d", "[ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"12\"][ct_icon icon=\"%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22icon_link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-dribbble%22%2C%22icon_link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22icon_link%22%3A%22%23%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22icon_link%22%3A%22%23%22%7D%5D\"]", "38", "5", "", "VISUAL", "vc_column_inner: content", "0", "", "ac3bf6451035c7d7f746a771fac16c5e", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("677", "en", "page-builder-shortcode-strings-2444", "c4455835a365384a2f88cf2e9e21e480", "[vc_empty_space][ct_team_member image=\"2698\" social=\"%5B%7B%7D%5D\" title=\"Giuseppe De Santo\" el_class=\"single-team\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"42\"]", "25", "2", "", "VISUAL", "vc_column: content", "0", "", "31991447d9ccbd2b7a03cb892f1f4653", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("515", "en", "page-builder-shortcode-strings-2544", "dc8c86534096f292214c3b7e44bb803a", "<strong>Giannicola Forte</strong> advises Italian and foreign clients to built up suitable strategies for their business and activities in Italy or abroad, gaining significant experience on commercial contracts, ship sale and purchase, ship finance and lending transactions, guarantees and securities, corporate structures and joint ventures, commercial litigation, cross-border transactions, environmental and pollution matters.\r\n\r\nGiannicola’s practice covers a wide range of matters including charter-parties, bills of lading disputes, cargo claims, passenger injuries and illness claims, crew claims and contracts, dispute resolution and litigation on Hague Rules/Hague-Visby Rules, Hamburg Rules, and other P&amp;I matters; H&amp;M matters and casualties as collisions, groundings, salvage, towage; ships/bunkers arrest and release; yachting; road carriage; agreements for commercial and business aircraft, aero engines and other aviation assets; share sale and purchase; agency; logistic; liability of freight forwarders, carriers, warehouse keepers; cross-border dispute; import-export trading; bankruptcy, court decisions/arbitration awards enforcements, debt recovery/collection.\r\n\r\nHe also has experience in taxation, real estate, intellectual property, no-profit organizations, and through a professional network coordinates multi-jurisdictional litigations, court decisions/arbitration award enforcements and worldwide actions to secure claims.\r\n\r\nGiannicola is active in charity and cultural projects, is a member of IBA, is admitted to the Italian Bar, Naples’s Section, and speaks Italian, English and Spanish.", "38", "3", "", "VISUAL", "vc_column_text: content", "0", "", "961c2dee79c7530e351a53bfaddb0d9c", "optional", "212");
INSERT INTO `wp_icl_strings` VALUES("516", "en", "page-builder-shortcode-strings-2544", "30c86fcd1b4d03993958014d2232b9f0", "[ct_contact_info content_type=\"tel\" icon_list=\"fontawesome5\" icon_fontawesome5=\"fac fac-phone\" content_info=\"+39 081 5800199\" el_class=\"contact-info-group\"][ct_contact_info content_type=\"email\" icon_fontawesome=\"fa fa-envelope\" content_info=\"g.forte@studiolegalelauro.it\" el_class=\"contact-info-group\"]", "38", "4", "", "VISUAL", "vc_column_inner: content", "0", "", "a716ca30fdbf3b2abd9836a7be4fbbe0", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("577", "en", "Cookie Notice", "headline", "", NULL, NULL, "", "LINE", NULL, "0", "", "26b4074285b70d444f704e6ecf0f26ff", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("574", "en", "Cookie Notice", "Revoke message text", "You can revoke your consent any time using the Revoke consent button.", NULL, NULL, "", "LINE", NULL, "0", "", "dce33395abec87c885e3d5cb66ab114e", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("575", "en", "Cookie Notice", "Revoke button text", "Revoke consent", NULL, NULL, "", "LINE", NULL, "0", "", "5e85e6fd69c6f613862e21ac171fd3f8", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("576", "en", "Cookie Notice", "Privacy policy text", "Privacy policy", NULL, NULL, "", "LINE", NULL, "0", "", "5a4d21dc2abece45f6bfde2a7dd5fb44", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("817", "en", "page-builder-shortcode-strings-229", "dd4e66fdab1dd65dbde593bbc0a31725", "[ct_heading text=\"We are a compact and integrated team, skilled and highly regarded, with a real depth and breadth of expertise\" align_lg=\"align-center\" align_md=\"align-center-md\" align_sm=\"align-center-sm\" align_xs=\"align-center-xs\" font_size_sm=\"24\" font_size_xs=\"24\" font_weight=\"\" text_color=\"#000000\" show_gap=\"show\" subtitle=\"Team\" subtitle_font_size=\"22\" description_font_weight=\"inherit\" margin_bottom=\"0\"][vc_empty_space]", "1", "11", "", "VISUAL", "vc_column_inner: content", "0", "", "19e66cf3254a83f58f2780ea600fd2a2", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("815", "en", "page-builder-shortcode-strings-246", "cd2aa41c418aa6c4d6eb48e31d9c9a22", "</p>\r\n<div align=\"justify\">\r\n<p><strong>Studio Legale Lauro</strong> is an Italian law firm, established in 1993 in Naples, providing a wide range of legal services in maritime, commercial and international law matters to the global maritime business sector and industries.</p>\r\n<p>The firm consistently deals with all aspects of law relating to the shipping industry, assisting owners, charterers, P&amp;I clubs, marine underwriters, banks and financial institutions in various fields, such as ship and other asset arrest, charterparties and bills of lading disputes, ship-building contracts, collisions, salvage, marine pollution, international trade and commodity trading, cross-border transactions and loan agreements, as well as criminal and labour law.</p>\r\n<p>Having strong relationships with leading ship-owners and financial institutions, the firm has developed significant expertise in M&amp;A operations, joint-venture agreements, insurance, taxation, bankruptcy proceedings, corporate matters, administrative regulations and competition law.</p>\r\n<p>Since 2010, Studio Legale Lauro has hosted many of the world major shipping-sector firms at “Shipping &amp; the Law”, the yearly conference held in Naples, to discuss the current hottest topics in the shipping industry (<a href=\"http://www.shippingandthelaw.org/\" target=\"_blank\" rel=\"noopener noreferrer\">www.shippingandthelaw.org</a>).</div>\r\n<p>", "11", "1", "", "VISUAL", "vc_column_text: content", "0", "", "b36ab36922f7f0a86950bd9233f793d4", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("596", "en", "gutenberg-3", "b959eb876826ab3e5061a64059055a24", "An anonymized string created from your email address (also called a hash) may be provided to the Gravatar service to see if you are using it. The Gravatar service privacy policy is available here: https://automattic.com/privacy/. After approval of your comment, your profile picture is visible to the public in the context of your comment.", "39", "6", "", "LINE", "core/paragraph", "0", "", "c2d463470642ce733686833d0aa866c4", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("862", "en", "page-builder-shortcode-strings-229", "75a11b215fc53fa56cbc7fdcb6b75fe7", "</p>\r\n<div align=\"justify\"><a href=\"https://sviluppo.studiolegalelauro.it/index.php/Expertise/shipping/\"><span style=\"color: #ffffff;\">The Firm has developed a significant expertise in the shipping sector through a strong partnership with leading international, european and italian associations of merchant shipowners and operators (ICS, ECSA and CONFITARMA) as well as with the major players of the shipping industry.</span></a></div>\r\n<p>", "1", "6", "", "VISUAL", "vc_column_text: content", "0", "", "022d327f83a6114c0ecc5554d08f8695", "optional", "42");
INSERT INTO `wp_icl_strings` VALUES("870", "en", "page-builder-shortcode-strings-229", "1026566841783ae93c259ad348be9dbf", "[vc_empty_space height=\"62px\"][ct_team_member image=\"2094\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Fernesto-ardia%2F|||\" title=\"Ernesto Ardia\"][vc_empty_space]", "1", "13", "", "VISUAL", "vc_column_inner: content", "0", "", "549122d3697b0d35213754f183b8a187", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("871", "en", "page-builder-shortcode-strings-229", "660f5d3db69934638120c2903230330d", "[vc_empty_space height=\"62px\"][ct_team_member image=\"2096\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Fgiannicola-forte%2F|||\" title=\"Giannicola Forte\"][vc_empty_space]", "1", "14", "", "VISUAL", "vc_column_inner: content", "0", "", "54c38fde478fa73469d168846dde75cc", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("872", "en", "page-builder-shortcode-strings-229", "0090e4ff2929d5377f749f760dc886e5", "[vc_empty_space height=\"62px\"][ct_team_member image=\"2098\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Fanna-vernillo%2F|||\" title=\"Anna Vernillo\"][vc_empty_space]", "1", "16", "", "VISUAL", "vc_column_inner: content", "0", "", "f5a3a338defe7acea0613160a2a796d3", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("873", "en", "page-builder-shortcode-strings-229", "d384c8715e33a3f1849e87f231986676", "[vc_empty_space height=\"62px\"][ct_team_member image=\"2701\" item_link=\"url:https%3A%2F%2Fsviluppo.studiolegalelauro.it%2Findex.php%2Fvalentina-tremante%2F|||\" title=\"Valentina Tremante\"][vc_empty_space]", "1", "17", "", "VISUAL", "vc_column_inner: content", "0", "", "fe054d77d07ec6cc20bf7202f045cb50", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("621", "en", "gutenberg-3", "b6cfcf7247f4a3e56b477c61b3ba7759", "What third parties we receive data from", "39", "31", "h3", "LINE", "core/heading", "0", "", "b58dfa56881572008e2c41a1aceba501", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("622", "en", "gutenberg-3", "c679d23616d0090d0fdf22066ad2357a", "What automated decision making and/or profiling we do with user data", "39", "32", "h3", "LINE", "core/heading", "0", "", "025e64587d3e1be2707f028f52eaf630", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("623", "en", "gutenberg-3", "feb3264957a93972d36fd96dc6987a2c", "Industry regulatory disclosure requirements", "39", "33", "h3", "LINE", "core/heading", "0", "", "92be97eaa7c0423cab45ff0117860715", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("674", "en", "page-builder-shortcode-strings-2155", "f050408dd38fdc91414695beddc2f949", "[vc_empty_space][ct_team_member image=\"2094\" social=\"%5B%7B%7D%5D\" title=\"Ernesto Ardia\" el_class=\"single-team\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"42\"]", "8", "2", "", "VISUAL", "vc_column: content", "0", "", "59518fbc3ffd8d6012091ba5d7aec4c8", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("675", "en", "page-builder-shortcode-strings-2155", "63a6274611e229b0754c01b02f036830", "[ct_contact_info content_type=\"tel\" icon_list=\"fontawesome5\" icon_fontawesome5=\"fac fac-phone\" content_info=\"+39 081 5800199\" el_class=\"contact-info-group\"][ct_contact_info content_type=\"email\" icon_fontawesome=\"fa fa-envelope\" content_info=\"ernestoardia@studiolegalelauro.it\" el_class=\"contact-info-group\"]", "8", "4", "", "VISUAL", "vc_column_inner: content", "0", "", "a3f1372919a38f582d81592d799cbe57", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("860", "en", "page-builder-shortcode-strings-229", "e1cde2e133c04e05f476379375de363b", "</p>\r\n<div align=\"justify\">\r\n<p><strong>Studio Legale Lauro</strong> is an Italian law firm, established in 1993 in Naples, providing a wide range of legal services in maritime, commercial and international law matters to the global maritime business sector and industries.</p>\r\n<p>The firm consistently deals with all aspects of law relating to the shipping industry, assisting owners, charterers, P&amp;I clubs, marine underwriters, banks and financial institutions in various fields, such as ship and other asset arrest, charterparties and bills of lading disputes, ship-building contracts, collisions, salvage, marine pollution, international trade and commodity trading, cross-border transactions and loan agreements, as well as criminal and labour law.</p>\r\n<p>Having strong relationships with leading ship-owners and financial institutions, the firm has developed significant expertise in M&amp;A operations, joint-venture agreements, insurance, taxation, bankruptcy proceedings, corporate matters, administrative regulations and competition law.</p>\r\n<p>Since 2010, Studio Legale Lauro has hosted many of the world major shipping-sector firms at “Shipping &amp; the Law”, the yearly conference held in Naples, to discuss the current hottest topics in the shipping industry (www.shippingandthelaw.org).</div>\r\n<p>", "1", "2", "", "VISUAL", "vc_column_text: content", "0", "", "c2e5df77ead75052cb73b4bac4bf4154", "optional", "173");
INSERT INTO `wp_icl_strings` VALUES("861", "en", "page-builder-shortcode-strings-229", "a12eebe40032a24e793c3ba72f79857d", "</p>\r\n<h4 style=\"text-align: center;\"><span style=\"color: #ffffff;\">SHIPPING </span></h4>\r\n<p>", "1", "5", "", "VISUAL", "vc_column_text: content", "0", "", "8f38db7f14f06ee91664f23c8f633741", "optional", "1");
INSERT INTO `wp_icl_strings` VALUES("859", "en", "page-builder-shortcode-strings-648", "5da97e875d69ec73396ccf9b4d939512", "\r\n<div align=\"justify\">Studio Legale Lauro combines its sector expertise across fields such as shipping, energy market and green economy, with a wealth of experience in the full range of financing products offered to shipowners, traders and exporters.The Firm supports a broad spectrum of participants in the shipping industry – from the world’s largest shipowners to global investment and development banks, specialised funds and other financial institutions.\r\nKnowing that financial institutions require solutions tailored to their specific credit risk requirements, SLL works closely with its specialised counselors providing detailed advices and legal due diligence to support proposed financings.\r\n\r\nStudio Legale Lauro advises financial institutions in respect of the commercial, political and economic risk factors, and in the arrangement and negotiation of appropriate insurance products.\r\n\r\nThe Firm is recognised as particularly expert in guiding clients through the various forms of investment protection offered by insurance, contractual provisions and international law, for credit risk hedging purposes.\r\n\r\nStudio Legale Lauro advises institutional and private investors to develop the correct investment thesis, assessing revenue growth and cost-reduction opportunities.\r\n\r\nThe firm has developed significant expertise in shares sale and purchase agreements, M&amp;A operations, joint-venture agreements and bankruptcy proceedings, in the context of corporate law, administrative regulations and competition law.\r\n\r\n</div>\r\n", "3", "1", "", "VISUAL", "vc_column_text: content", "0", "", "ca25dc7b46a7587e44cae0d3ac44c282", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("787", "en", "page-builder-shortcode-strings-650", "6ac7195beb1c0f0c4f0d33b606f429f4", "\r\n<div align=\"justify\">The Firm has developed a significant expertise in the shipping sector through a strong partnership with leading international, european and italian associations of merchant shipowners and operators (ICS, ECSA and CONFITARMA) as well as with the major players of the shipping industry.Studio Legale Lauro provides a full range of legal services for clients, from legal consultancy in the contracts drafting and negotiation to legal representation in litigation and arbitration procedures worldwide.\r\n\r\nThe core areas of shipping-related expertise are:\r\n\r\n– drafting and reviewing international contracts, such as ship sale and purchase contracts, charter-party contracts, agency contracts, ship-building contracts, yacht sale and purchase/refitting contracts, EPC/Turnkey contracts, O&amp;M contracts, commodities sale and purchase contracts; site construction contracts, carriage contracts/documents, including bills of lading;\r\n\r\n– disputes resolution and litigation on Hague Rules/Hague-Visby Rules, Hamburg Rules; bills of lading disputes, customs related issues, crew claims and contracts, admiralty claims;\r\n\r\n– legal assistance in marine incidents and casualties as collisions, groundings, salvage, towage and related cargo claims, passenger injuries and illness claims, ships/bunkers arrest and release, limitation of shipowner’s liability;\r\n\r\n– legal advice in the subscription of protection and indemnity insurance provided by the most important UK-based P&amp;I Clubs, as well as for hull and machinery insurance, charter liability insurance and cargo insurance, providing assistance during the whole period of insurance cover.\r\n\r\n</div>\r\n", "13", "1", "", "VISUAL", "vc_column_text: content", "0", "", "e3bb848eff9ab28ececde597c9e11f94", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("784", "en", "page-builder-shortcode-strings-254", "059944f748bcebec87dfb4159964e7d5", "\r\n<div align=\"justify\">\r\n\r\nPlease contact us using the information below.\r\n\r\n</div>\r\n", "19", "2", "", "VISUAL", "vc_column_text: content", "0", "", "0ba2577b9845e38ec032a61d50d60836", "optional", "7");
INSERT INTO `wp_icl_strings` VALUES("757", "en", "page-builder-shortcode-strings-2536", "3a60ede492b79a8e73a28be55fb9b602", "[vc_empty_space][ct_team_member image=\"2806\" social=\"%5B%7B%7D%5D\" title=\"Nicola Tremante\" el_class=\"single-team\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"42\"]", "36", "2", "", "VISUAL", "vc_column: content", "0", "", "599a4bf405bdfd223315f69b8ab15032", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("714", "en", "page-builder-shortcode-strings-2493", "f63bf44ceda3919d641b7c26950fd1f4", "[vc_empty_space][ct_team_member image=\"2744\" social=\"%5B%7B%7D%5D\" title=\"Francesco Bentivegna\" el_class=\"single-team\"][ct_space space_lg=\"0\" space_md=\"0\" space_sm=\"0\" space_xs=\"42\"]", "27", "2", "", "VISUAL", "vc_column: content", "0", "", "593ef400c6003c096ee3f3d23496f513", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("715", "en", "page-builder-shortcode-strings-2493", "cd4d1e847a2f7f1f1117676d2b8e19dd", "</p>\r\n<div align=\"justify\">\r\n<p><strong>Francesco Bentivegna</strong> is a lawyer and Italian negotiator skilled in international transactions, particularly in the business areas of oil and gas, as well as in the field of agreements related to extraction process and infrastructure. He has over 40 years of professional work experience around the world and more than 20 years of working experience in the Republic of Kazakhstan, as a legal counsel and strategic advisor in negotiations with the Republic of Kazakhstan, including the negotiation of all major agreements and settlements.</p>\r\n<p>Over the past 20 years he has established and developed a network of relationships with senior representatives of the government, and with the diplomatic and business community as well in Kazakhstan.</p>\r\n<p>Academic:</p>\r\n<p>University of Palermo: 1973. Law degree. Thesis about “Succession to Multilateral Treaties”. Summa cum Laude.</p>\r\n<p>University of Texas in Dallas, USA: 1981. Diploma of the Academy of American and international law.</p>\r\n<p>Member of the Bar of Milan.</p>\r\n<p>Languages: Italian, English, French, Russia.</p>\r\n<p>Career:</p>\r\n<p>1974 - Milan, Italy: he worked as a trainee lawyer and then qualified as a lawyer.</p>\r\n<p>1977 - Milan: ENI, the Italian National Oil Company (Italy) - Lawyer - Legal Office for International Affairs.</p>\r\n<p>1981 - University of Texas in Dallas, USA: Academy of International Law.</p>\r\n<p>1985 – Milan: Manager, Business and Legal negotiations Agip Spa.</p>\r\n<p>In this capacity he led the negotiations for several oil agreements worldwide, including Agip and various sovereign states (such as Norway, China, Nigeria and the Republic of Congo). In 1987 he was appointed representative of the Legal Committee on behalf of Agip for the North Sea in Norway.</p>\r\n<p>1993 - Reading, UK: Head office at Karachaganak Venture between Agip and British Gas, in the developing of one of the world’s most important oilfields.</p>\r\n<p>1993 - Almaty, Kazakhstan: he took part in negotiating and drafting of the Agreement on the principles of sharing production between the Republic of Kazakhstan and Agip / British Gas. 1994: Almaty, Kazakhstan: he was officially invited to attend sessions on the drafting of the Kazakhstan’s Constitution and to lecture on the Italian Constitution by the President of the Academy of Sciences of the Republic of Kazakhstan.</p>\r\n<p>1995 - Aksai, Kazakhstan: Resident legal manager of the Karachaganak Venture. In this capacity, he took part to all the important meetings and negotiations of the project which led to the signing of the Final Agreement on Production Sharing in Washington in 1997, between the Republic of Kazakhstan and foreign investors.</p>\r\n<p>1997 - London, UK: he was appointed General Counsel of the Karachaganak Venture, as to coordination and supervision of the legal area under the Karachaganak project, including legal departments in London, Aksai and Astana, with a total workteam of sixteen lawyers.</p>\r\n<p>1997: Director of the Board of KMSL Ltd, Karachaganak Marketing Services Limited.</p>\r\n<p>1998 - Almaty, Kazakhstan: he took part to the negotiation of Amendment no. 1 of the Final Production Sharing Agreement.</p>\r\n<p>1999: Director of the Board of KPDL Ltd, Karachaganak Petroleum Development Limited.</p>\r\n<p>2003: Astana, Kazakhstan: he took part to the negotiations for the signing of the first settlement agreement between the Republic of Kazakhstan and foreign investors.</p>\r\n<p>2006 - Astana, Kazakhstan: he took part to the negotiations for the signing of the settlement agreement no.2 between the Republic of Kazakhstan and foreign investors.</p>\r\n<p>2006: Director of Board of Eni BTC (Baku Tbilisi Ceyhan) Ltd.</p>\r\n<p>2007 - Moscow, Russia: he took part to the negotiations leading to the signing of the agreement between Gas Sales KazRosGas (a joint venture between Gazprom and KazMunaiGas) and foreign investors.</p>\r\n<p>2009 - Astana / London: he was given the task by the Seniors of the Contracting Companies ENI, British Gas, Chevron and LukOil to lead and coordinate on behalf of the Contracting Companies the working group on the side of the contractor in relation to a series of ongoing disputes and arbitrations in progress. The negotiations ended in December 2011 with the signing of a settlement agreement.</p>\r\n<p>2010-13: he moved to Astana to work as a Senior Advisor for the president’s Agip Caspian Sea.</p>\r\n<p>2014: he moved back to London, where he currently works as an independent consultant.</p>\r\n<p>&nbsp;</p>\r\n<p>Awards:</p>\r\n<p>2004: he was awarded a Pochetnaya Gramota (Certificate of Honour) and a medal from the President of KazMunaiGaz, the Kazakh state oil company, on the occasion of the 25th anniversary of the discovery of the Karachaganak field.</p>\r\n<p>2009: he was awarded a certificate of honor and a medal from the President of the Association of KazEnergy oil companies to celebrate the 110th year of the Kazakh oil sector.</p>\r\n<p>Memberships:</p>\r\n<p>Since 2002: Member of the British-Kazakh Society.</p>\r\n<p>2013: Member of the Russian and CIS Arbitration Network.</p>\r\n<p>2013: Member of the British-Azerbaijani Law Association.</p>\r\n<p>2015: Member of the London Court of International Arbitration (“LCIA”).</div>\r\n<p>", "27", "3", "", "VISUAL", "vc_column_text: content", "0", "", "c6a1b38dd859d518eba00b960b1377ac", "optional", NULL);
INSERT INTO `wp_icl_strings` VALUES("836", "en", "page-builder-shortcode-strings-232", "6a541a9ce6e16a0dc193304d68de753d", "\r\n<p style=\"text-align: justify;\">Studio Legale Lauro combine its sector expertise across fields such as shipping, energy market and green economy, with a wealth of experience in the full range of financing products offered to shipowners, traders and exporters.</p>\r\n", "12", "5", "", "VISUAL", "vc_column_text: content", "0", "", "57603fbac8628cc17defca2e6ea9641e", "optional", "35");
INSERT INTO `wp_icl_strings` VALUES("856", "en", "page-builder-shortcode-strings-229", "2a5193036c5def36a88b51dacddeb767", "[ct_heading text=\"Expertise\" align_lg=\"align-center\" align_md=\"align-center-md\" align_sm=\"align-center-sm\" align_xs=\"align-center-xs\" font_size_sm=\"24\" font_size_xs=\"24\" font_weight=\"800\" text_color=\"#870101\" show_gap=\"show\" description_font_weight=\"inherit\" margin_bottom=\"0\" el_class=\"sub-color-primary\"]", "1", "4", "", "VISUAL", "vc_column_inner: content", "0", "", "39b96973cfa4b781d038823dfd9e4926", "optional", "0");
INSERT INTO `wp_icl_strings` VALUES("857", "en", "page-builder-shortcode-strings-229", "1aa3dcfc155686bef8f1e121459d21cb", "[ct_heading text=\"Studio Legale Lauro hosts many of the world major shipping sector players at “Shipping &amp; the Law”, the yearly conference held in Naples, to discuss the current hottest shipping industry topics.\" align_lg=\"align-center\" align_md=\"align-center-md\" align_sm=\"align-center-sm\" align_xs=\"align-center-xs\" font_size_sm=\"24\" font_size_xs=\"24\" font_weight=\"\" text_color=\"#000000\" show_gap=\"show\" subtitle=\"Events\" subtitle_font_size=\"22\" description_font_weight=\"inherit\" margin_bottom=\"0\"][vc_empty_space height=\"62px\"]", "1", "18", "", "VISUAL", "vc_column: content", "0", "", "600b6804cd0118c8f3d8b19f5d269242", "optional", "0");

/* INSERT TABLE DATA: wp_icl_translation_status */
INSERT INTO `wp_icl_translation_status` VALUES("1", "334", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:46", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("2", "335", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:46", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("3", "336", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:46", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("4", "337", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:46", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("5", "338", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:46", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("6", "339", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:46", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("7", "340", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:46", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("8", "341", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:46", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("9", "342", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:46", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("10", "343", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:46", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("11", "344", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:47", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("12", "345", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:47", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("13", "346", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:47", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("14", "347", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:47", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("15", "348", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:47", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("16", "349", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:47", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("17", "350", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:47", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("18", "351", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:47", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("19", "352", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:47", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("20", "353", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:47", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("21", "354", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:48", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("22", "355", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:48", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("23", "356", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:48", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("24", "357", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:48", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("25", "358", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:48", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("26", "359", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:48", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("27", "360", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:48", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("28", "361", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:48", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("29", "362", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:48", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("30", "363", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:48", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("31", "364", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:49", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("32", "365", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:49", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("33", "366", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:49", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("34", "367", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:49", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("35", "368", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:49", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("36", "369", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:49", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("37", "370", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:49", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("38", "371", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:49", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("39", "372", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:49", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("40", "373", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:49", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("41", "374", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:51", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("42", "375", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:51", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("43", "376", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:51", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("44", "377", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:51", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("45", "378", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:51", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("46", "379", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:51", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("47", "380", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:51", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("48", "381", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:51", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("49", "382", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:51", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("50", "383", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:51", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("51", "384", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:52", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("52", "385", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:52", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("53", "386", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:52", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("54", "387", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:52", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("55", "388", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:52", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("56", "389", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:52", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("57", "390", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:52", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("58", "391", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:52", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("59", "392", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:52", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("60", "393", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:52", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("61", "394", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:53", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("62", "395", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:53", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("63", "396", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:53", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("64", "397", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:53", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("65", "398", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:53", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("66", "399", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:53", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("67", "400", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:53", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("68", "401", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:53", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("69", "402", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:53", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("70", "403", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:53", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("71", "404", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:54", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("72", "405", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:54", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("73", "406", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:54", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("74", "407", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:54", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("75", "408", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:54", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("76", "409", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:54", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("77", "410", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:54", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("78", "411", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:54", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("79", "412", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:54", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("80", "413", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:55", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("81", "414", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:56", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("82", "415", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:56", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("83", "416", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:56", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("84", "417", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:56", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("85", "418", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:56", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("86", "419", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:56", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("87", "420", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:56", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("88", "421", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:56", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("89", "422", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:56", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("90", "423", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:56", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("91", "424", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:57", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("92", "425", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:57", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("93", "426", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:57", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("94", "427", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:57", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("95", "428", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:57", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("96", "429", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:57", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("97", "430", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:57", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("98", "431", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:57", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("99", "432", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:57", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("100", "433", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:57", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("101", "434", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:58", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("102", "435", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:58", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("103", "436", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:58", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("104", "437", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:58", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("105", "438", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:58", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("106", "439", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:58", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("107", "440", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:58", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("108", "441", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:58", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("109", "442", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:58", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("110", "443", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:58", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("111", "444", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:59", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("112", "445", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:59", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("113", "446", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:59", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("114", "447", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:59", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("115", "448", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:59", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("116", "449", "9", "0", "0", "", "", "0", "", "2020-02-19 10:08:59", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("117", "453", "9", "0", "0", "", "", "0", "", "2020-02-19 10:26:56", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("118", "455", "9", "0", "0", "", "", "0", "", "2020-02-19 10:40:17", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("119", "457", "9", "0", "0", "", "", "0", "", "2020-02-19 10:57:07", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("120", "459", "9", "0", "0", "", "", "0", "", "2020-02-19 10:58:55", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("121", "461", "9", "0", "0", "", "", "0", "", "2020-02-19 11:03:42", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("122", "463", "9", "0", "0", "", "", "0", "", "2020-02-19 11:10:59", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("123", "475", "9", "0", "0", "", "", "0", "", "2020-02-19 11:47:00", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("124", "477", "9", "0", "0", "", "", "0", "", "2020-02-19 11:49:37", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("125", "479", "9", "0", "0", "", "", "0", "", "2020-02-19 11:50:01", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("126", "481", "9", "0", "0", "", "", "0", "", "2020-02-19 12:59:41", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("127", "483", "9", "0", "0", "", "", "0", "", "2020-02-19 13:02:47", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("128", "485", "9", "0", "0", "", "", "0", "", "2020-02-19 14:10:15", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("129", "487", "9", "0", "0", "", "", "0", "", "2020-02-19 16:33:11", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("130", "489", "9", "0", "0", "", "", "0", "", "2020-02-20 12:44:57", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("131", "491", "9", "0", "0", "", "", "0", "", "2020-02-20 12:48:01", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("132", "493", "9", "0", "0", "", "", "0", "", "2020-02-20 12:49:00", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("133", "495", "9", "0", "0", "", "", "0", "", "2020-02-20 12:49:24", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("134", "497", "9", "0", "0", "", "", "0", "", "2020-02-20 12:49:59", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("135", "499", "9", "0", "0", "", "", "0", "", "2020-02-21 09:30:56", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("136", "501", "9", "0", "0", "", "", "0", "", "2020-02-21 09:32:27", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("137", "503", "9", "0", "0", "", "", "0", "", "2020-02-21 09:33:26", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("138", "505", "9", "0", "0", "", "", "0", "", "2020-02-21 09:35:12", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("139", "507", "9", "0", "0", "", "", "0", "", "2020-02-21 09:36:41", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("140", "509", "9", "0", "0", "", "", "0", "", "2020-02-21 09:45:38", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("141", "511", "9", "0", "0", "", "", "0", "", "2020-02-21 10:46:47", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("142", "513", "9", "0", "0", "", "", "0", "", "2020-02-21 10:46:53", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("143", "515", "9", "0", "0", "", "", "0", "", "2020-02-21 10:50:07", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("144", "518", "9", "0", "0", "", "", "0", "", "2020-02-21 13:40:10", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("145", "531", "9", "0", "0", "", "", "0", "", "2020-02-21 14:08:44", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("146", "543", "9", "0", "0", "", "", "0", "", "2020-02-21 21:14:11", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("147", "550", "9", "0", "0", "", "", "0", "", "2020-02-21 22:01:12", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("148", "552", "9", "0", "0", "", "", "0", "", "2020-02-21 22:03:42", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("149", "557", "9", "0", "0", "", "", "0", "", "2020-02-22 08:27:41", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("150", "559", "9", "0", "0", "", "", "0", "", "2020-02-22 08:33:25", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("151", "561", "9", "0", "0", "", "", "0", "", "2020-02-22 08:46:24", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("152", "563", "9", "0", "0", "", "", "0", "", "2020-02-22 08:48:25", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("153", "570", "9", "0", "0", "", "", "0", "", "2020-02-22 09:14:26", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("154", "572", "9", "0", "0", "", "", "0", "", "2020-02-22 09:18:24", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("155", "574", "9", "0", "0", "", "", "0", "", "2020-02-22 09:22:31", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("156", "581", "9", "0", "0", "", "", "0", "", "2020-02-28 14:53:41", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("157", "583", "9", "0", "0", "", "", "0", "", "2020-02-28 15:25:58", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("158", "587", "9", "0", "0", "", "", "0", "", "2020-02-28 15:46:09", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("159", "589", "9", "0", "0", "", "", "0", "", "2020-02-28 15:50:31", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("160", "591", "9", "0", "0", "", "", "0", "", "2020-02-28 16:03:44", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("161", "598", "9", "0", "0", "", "", "0", "", "2020-02-28 16:40:24", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("162", "600", "9", "0", "0", "", "", "0", "", "2020-02-28 17:10:15", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("163", "602", "9", "0", "0", "", "", "0", "", "2020-02-28 17:14:20", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("164", "604", "9", "0", "0", "", "", "0", "", "2020-02-28 17:14:26", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("165", "606", "9", "0", "0", "", "", "0", "", "2020-02-28 17:14:35", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("166", "608", "9", "0", "0", "", "", "0", "", "2020-02-28 17:14:40", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("167", "610", "9", "0", "0", "", "", "0", "", "2020-02-28 17:14:51", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("168", "612", "9", "0", "0", "", "", "0", "", "2020-02-28 17:15:02", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("169", "614", "9", "0", "0", "", "", "0", "", "2020-02-28 17:15:12", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("170", "616", "9", "0", "0", "", "", "0", "", "2020-02-28 17:15:22", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("171", "618", "9", "0", "0", "", "", "0", "", "2020-03-09 11:28:29", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("172", "621", "9", "0", "0", "", "", "0", "", "2020-03-09 11:35:30", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("173", "625", "9", "0", "0", "", "", "0", "", "2020-03-09 11:40:58", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("174", "627", "9", "0", "0", "", "", "0", "", "2020-03-09 11:42:04", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("175", "629", "9", "0", "0", "", "", "0", "", "2020-03-09 11:49:40", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("176", "631", "9", "0", "0", "", "", "0", "", "2020-03-09 11:51:09", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("177", "634", "9", "0", "0", "", "", "0", "", "2020-03-09 12:00:33", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("178", "639", "9", "0", "0", "", "", "0", "", "2020-03-09 12:27:48", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("179", "641", "9", "0", "0", "", "", "0", "", "2020-03-09 12:31:56", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("180", "643", "9", "0", "0", "", "", "0", "", "2020-03-09 12:46:02", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("181", "645", "9", "0", "0", "", "", "0", "", "2020-03-09 15:43:56", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("182", "647", "9", "0", "0", "", "", "0", "", "2020-03-09 15:47:05", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("183", "649", "9", "0", "0", "", "", "0", "", "2020-03-09 15:51:24", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("184", "651", "9", "0", "0", "", "", "0", "", "2020-03-09 15:54:31", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("185", "653", "9", "0", "0", "", "", "0", "", "2020-03-09 15:55:00", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("186", "655", "9", "0", "0", "", "", "0", "", "2020-03-09 16:09:04", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("187", "657", "9", "0", "0", "", "", "0", "", "2020-03-09 16:10:11", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("188", "659", "9", "0", "0", "", "", "0", "", "2020-03-09 16:11:53", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("189", "661", "9", "0", "0", "", "", "0", "", "2020-03-09 16:13:22", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("190", "663", "9", "0", "0", "", "", "0", "", "2020-03-09 16:16:55", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("191", "666", "9", "0", "0", "", "", "0", "", "2020-03-09 16:33:31", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("192", "670", "9", "0", "0", "", "", "0", "", "2020-03-16 16:23:43", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("193", "672", "9", "0", "0", "", "", "0", "", "2020-03-16 16:23:57", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("194", "686", "9", "0", "0", "", "", "0", "", "2020-03-16 17:06:47", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("195", "730", "9", "0", "0", "", "", "0", "", "2020-04-27 18:32:18", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("196", "733", "9", "0", "0", "", "", "0", "", "2020-04-27 18:33:35", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("197", "735", "9", "0", "0", "", "", "0", "", "2020-04-27 18:38:37", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("198", "737", "9", "0", "0", "", "", "0", "", "2020-04-27 18:39:07", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("199", "739", "9", "0", "0", "", "", "0", "", "2020-04-27 18:41:34", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("200", "741", "9", "0", "0", "", "", "0", "", "2020-04-27 18:43:10", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("201", "743", "9", "0", "0", "", "", "0", "", "2020-04-27 18:44:55", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("202", "745", "9", "0", "0", "", "", "0", "", "2020-04-27 18:46:54", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("203", "748", "9", "0", "0", "", "", "0", "", "2020-04-27 18:48:34", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("204", "750", "9", "0", "0", "", "", "0", "", "2020-04-27 18:49:59", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("205", "752", "9", "0", "0", "", "", "0", "", "2020-05-11 18:03:52", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("206", "754", "9", "0", "0", "", "", "0", "", "2020-05-11 18:06:10", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("207", "759", "9", "0", "0", "", "", "0", "", "2020-06-25 10:34:45", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("208", "761", "9", "0", "0", "", "", "0", "", "2020-06-25 11:09:04", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("209", "763", "9", "0", "0", "", "", "0", "", "2020-06-25 11:09:50", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("210", "765", "9", "0", "0", "", "", "0", "", "2020-06-25 11:14:42", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("211", "767", "9", "0", "0", "", "", "0", "", "2020-06-25 11:16:15", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("212", "769", "9", "0", "0", "", "", "0", "", "2020-06-26 07:28:29", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("213", "771", "9", "0", "0", "", "", "0", "", "2020-06-26 07:28:54", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("214", "773", "9", "0", "0", "", "", "0", "", "2020-06-26 07:29:19", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("215", "775", "9", "0", "0", "", "", "0", "", "2020-06-26 07:29:44", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("216", "777", "9", "0", "0", "", "", "0", "", "2020-06-26 07:30:13", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("217", "779", "9", "0", "0", "", "", "0", "", "2020-06-26 07:30:45", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("218", "781", "9", "0", "0", "", "", "0", "", "2020-06-26 07:31:06", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("219", "783", "9", "0", "0", "", "", "0", "", "2020-06-26 07:31:31", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("220", "785", "9", "0", "0", "", "", "0", "", "2020-06-26 07:31:52", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("221", "787", "9", "0", "0", "", "", "0", "", "2020-06-26 07:32:14", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("222", "789", "9", "0", "0", "", "", "0", "", "2020-06-26 07:33:23", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("223", "791", "9", "0", "0", "", "", "0", "", "2020-06-26 07:33:53", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("224", "793", "9", "0", "0", "", "", "0", "", "2020-06-26 07:34:18", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("225", "795", "9", "0", "0", "", "", "0", "", "2020-06-26 07:34:43", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("226", "798", "9", "0", "0", "", "", "0", "", "2020-07-28 11:25:53", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("227", "800", "9", "0", "0", "", "", "0", "", "2020-07-28 11:31:59", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("228", "802", "9", "0", "0", "", "", "0", "", "2020-07-28 11:34:31", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("229", "804", "9", "0", "0", "", "", "0", "", "2020-07-28 11:36:33", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("230", "806", "9", "0", "0", "", "", "0", "", "2020-07-28 12:21:56", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("231", "808", "9", "0", "0", "", "", "0", "", "2020-07-28 12:24:52", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("232", "810", "9", "0", "0", "", "", "0", "", "2020-07-28 12:46:36", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("233", "812", "9", "0", "0", "", "", "0", "", "2020-07-28 12:47:38", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("234", "814", "9", "0", "0", "", "", "0", "", "2020-07-28 12:48:53", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("235", "816", "9", "0", "0", "", "", "0", "", "2020-07-28 12:50:47", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("236", "818", "9", "0", "0", "", "", "0", "", "2020-07-28 12:51:51", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("237", "820", "9", "0", "0", "", "", "0", "", "2020-07-28 12:54:01", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("238", "822", "9", "0", "0", "", "", "0", "", "2020-07-28 12:56:44", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("239", "824", "9", "0", "0", "", "", "0", "", "2020-07-28 13:02:01", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("240", "826", "9", "0", "0", "", "", "0", "", "2020-07-28 13:05:28", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("241", "828", "9", "0", "0", "", "", "0", "", "2020-07-28 13:09:48", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("242", "830", "9", "0", "0", "", "", "0", "", "2020-07-28 13:12:21", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("243", "832", "9", "0", "0", "", "", "0", "", "2020-07-28 13:21:00", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("244", "834", "9", "0", "0", "", "", "0", "", "2020-07-28 13:22:48", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("245", "839", "9", "0", "0", "", "", "0", "", "2020-07-28 13:34:57", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("246", "841", "9", "0", "0", "", "", "0", "", "2020-07-28 13:36:02", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("247", "843", "9", "0", "0", "", "", "0", "", "2020-07-28 13:37:20", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("248", "845", "9", "0", "0", "", "", "0", "", "2020-07-28 13:40:51", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("249", "847", "9", "0", "0", "", "", "0", "", "2020-07-28 13:56:31", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("250", "849", "9", "0", "0", "", "", "0", "", "2020-07-28 14:44:38", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("251", "851", "9", "0", "0", "", "", "0", "", "2020-07-28 14:49:07", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("252", "853", "9", "0", "0", "", "", "0", "", "2020-07-28 14:50:17", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("253", "855", "9", "0", "0", "", "", "0", "", "2020-07-28 14:54:45", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("254", "857", "9", "0", "0", "", "", "0", "", "2020-07-28 17:16:17", "0", NULL, NULL, NULL, "1", NULL);

/* INSERT TABLE DATA: wp_icl_translations */
INSERT INTO `wp_icl_translations` VALUES("573", "post_attachment", "2256", "4178", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("574", "post_attachment", "2257", "4178", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("576", "post_nav_menu_item", "2260", "4180", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("575", "post_nav_menu_item", "2259", "4179", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("566", "post_page", "2240", "4174", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("8", "post_nav_menu_item", "1849", "1849", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("9", "post_nav_menu_item", "1850", "1850", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("10", "post_nav_menu_item", "1851", "1851", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("11", "post_nav_menu_item", "1852", "1852", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("12", "post_nav_menu_item", "1853", "1853", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("13", "post_nav_menu_item", "1854", "1854", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("14", "post_nav_menu_item", "1855", "1855", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("563", "post_attachment", "2230", "4171", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("562", "post_attachment", "2229", "4171", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("561", "post_attachment", "2227", "4170", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("537", "package_page-builder-shortcode-strings", "13", "4156", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("758", "post_attachment", "2633", "4290", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("572", "post_attachment", "2253", "4177", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("571", "post_attachment", "2252", "4177", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("570", "post_attachment", "2245", "4176", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("569", "post_attachment", "2244", "4176", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("568", "package_page-builder-shortcode-strings", "18", "4175", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("26", "post_nav_menu_item", "1871", "1871", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("27", "post_nav_menu_item", "1872", "1872", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("28", "post_nav_menu_item", "1873", "1873", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("560", "post_attachment", "2226", "4170", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("559", "post_attachment", "2217", "4169", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("558", "post_attachment", "2216", "4169", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("557", "post_attachment", "2215", "4168", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("556", "post_attachment", "2214", "4168", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("555", "package_page-builder-shortcode-strings", "17", "4167", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("553", "post_page", "2209", "4166", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("552", "post_attachment", "2206", "4165", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("551", "post_attachment", "2205", "4165", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("550", "post_attachment", "2204", "4164", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("549", "post_attachment", "2203", "4164", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("548", "package_page-builder-shortcode-strings", "16", "4163", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("546", "post_page", "2198", "4162", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("44", "post_nav_menu_item", "1889", "1889", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("45", "post_nav_menu_item", "1890", "1890", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("46", "post_nav_menu_item", "1891", "1891", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("796", "post_nav_menu_item", "2691", "4309", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("48", "post_nav_menu_item", "1893", "1893", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("49", "post_nav_menu_item", "1894", "1894", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("797", "post_attachment", "2694", "4310", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("542", "post_attachment", "2189", "4160", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("52", "post_nav_menu_item", "1897", "1897", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("799", "post_attachment", "2696", "4311", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("54", "post_nav_menu_item", "1899", "1899", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("55", "post_nav_menu_item", "1900", "1900", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("800", "post_attachment", "2697", "4311", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("798", "post_attachment", "2695", "4310", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("545", "package_page-builder-shortcode-strings", "15", "4161", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("535", "package_page-builder-shortcode-strings", "12", "4155", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("543", "post_attachment", "2190", "4160", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("693", "post_page", "2493", "4250", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("64", "post_page", "1859", "1859", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("65", "post_page", "3", "3", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("66", "post_page", "1860", "1860", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("67", "post_page", "229", "229", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("68", "post_page", "232", "232", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("69", "post_page", "236", "236", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("70", "post_page", "238", "238", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("71", "post_page", "240", "240", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("72", "post_page", "242", "242", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("73", "post_page", "244", "244", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("74", "post_page", "246", "246", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("75", "post_page", "250", "250", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("76", "post_page", "252", "252", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("77", "post_page", "254", "254", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("78", "post_page", "274", "274", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("79", "post_page", "276", "276", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("80", "post_page", "278", "278", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("81", "post_page", "280", "280", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("82", "post_page", "282", "282", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("83", "post_page", "284", "284", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("84", "post_page", "286", "286", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("85", "post_page", "302", "302", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("86", "post_page", "303", "303", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("87", "post_page", "304", "304", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("88", "post_page", "305", "305", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("89", "post_page", "543", "543", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("90", "post_page", "1119", "1119", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("91", "post_page", "1357", "1357", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("92", "post_page", "1359", "1359", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("93", "post_page", "1862", "1862", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("94", "post_page", "2", "2", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("95", "post_portfolio", "1511", "1511", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("96", "post_portfolio", "582", "582", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("97", "post_portfolio", "584", "584", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("98", "post_portfolio", "586", "586", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("99", "post_portfolio", "588", "588", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("100", "post_portfolio", "590", "590", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("101", "post_portfolio", "592", "592", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("102", "post_portfolio", "594", "594", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("103", "post_portfolio", "596", "596", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("104", "post_portfolio", "598", "598", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("105", "post_post", "341", "341", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("106", "post_post", "346", "346", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("107", "post_post", "348", "348", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("108", "post_post", "196", "196", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("109", "post_post", "204", "204", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("110", "post_post", "206", "206", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("111", "post_post", "208", "208", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("112", "post_post", "211", "211", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("113", "post_post", "213", "213", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("114", "post_post", "1", "1", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("115", "post_product", "909", "909", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("116", "post_product", "910", "910", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("117", "post_product", "907", "907", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("118", "post_product", "407", "407", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("119", "post_product", "408", "408", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("120", "post_product", "409", "409", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("121", "post_product", "411", "411", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("122", "post_product", "412", "412", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("123", "post_product", "413", "413", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("124", "post_product", "414", "414", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("125", "post_product", "417", "417", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("126", "post_product", "418", "418", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("127", "post_product", "425", "425", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("128", "post_service", "645", "645", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("129", "post_service", "646", "646", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("130", "post_service", "647", "647", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("131", "post_service", "648", "648", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("132", "post_service", "649", "649", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("133", "post_service", "650", "650", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("134", "post_wpcf7_contact_form", "1863", "1863", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("135", "post_wpcf7_contact_form", "754", "754", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("136", "post_wpcf7_contact_form", "1639", "1639", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("137", "post_wpcf7_contact_form", "7", "7", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("138", "tax_category", "1", "1912", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("139", "tax_category", "16", "1927", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("672", "post_attachment", "2408", "4232", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("671", "post_attachment", "2407", "4232", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("669", "post_attachment", "2405", "4231", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("670", "post_attachment", "2406", "4231", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("146", "tax_post_tag", "23", "1957", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("147", "tax_post_tag", "24", "1958", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("148", "tax_post_tag", "25", "1959", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("149", "tax_post_tag", "26", "1960", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("150", "tax_post_tag", "27", "1961", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("151", "tax_post_tag", "28", "1962", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("152", "tax_post_tag", "29", "1963", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("153", "tax_nav_menu", "48", "2012", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("154", "tax_nav_menu", "49", "2013", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("155", "tax_nav_menu", "50", "2014", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("156", "tax_nav_menu", "51", "2015", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("157", "tax_portfolio-category", "31", "2047", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("158", "tax_portfolio-category", "33", "2049", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("159", "tax_portfolio-category", "35", "2051", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("160", "tax_portfolio-category", "36", "2052", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("161", "tax_portfolio-category", "39", "2055", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("162", "tax_product_type", "2", "2058", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("163", "tax_product_type", "3", "2059", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("164", "tax_product_type", "4", "2060", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("165", "tax_product_type", "5", "2061", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("166", "tax_product_visibility", "6", "2068", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("167", "tax_product_visibility", "7", "2069", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("168", "tax_product_visibility", "8", "2070", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("169", "tax_product_visibility", "9", "2071", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("170", "tax_product_visibility", "10", "2072", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("171", "tax_product_visibility", "11", "2073", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("172", "tax_product_visibility", "12", "2074", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("173", "tax_product_visibility", "13", "2075", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("174", "tax_product_visibility", "14", "2076", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("175", "tax_product_cat", "15", "2092", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("176", "tax_product_cat", "41", "2118", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("177", "tax_product_cat", "42", "2119", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("178", "tax_product_cat", "43", "2120", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("179", "tax_product_cat", "44", "2121", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("180", "tax_product_cat", "45", "2122", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("181", "tax_product_cat", "46", "2123", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("182", "tax_product_cat", "47", "2124", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("183", "tax_product_tag", "30", "2155", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("184", "tax_product_tag", "32", "2157", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("185", "tax_product_tag", "34", "2159", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("186", "tax_product_tag", "37", "2162", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("187", "tax_product_tag", "38", "2163", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("188", "tax_product_tag", "40", "2165", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("189", "comment", "1", "2167", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("190", "comment", "2", "2168", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("191", "comment", "3", "2169", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("192", "comment", "4", "2170", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("193", "comment", "5", "2171", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("194", "comment", "6", "2172", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("195", "comment", "7", "2173", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("196", "comment", "8", "2174", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("197", "comment", "9", "2175", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("198", "comment", "10", "2176", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("199", "comment", "11", "2177", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("200", "comment", "12", "2178", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("201", "comment", "13", "2179", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("202", "comment", "14", "2180", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("203", "comment", "15", "2181", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("204", "comment", "16", "2182", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("205", "comment", "17", "2183", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("206", "comment", "18", "2184", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("207", "comment", "19", "2185", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("208", "tax_category", "52", "1912", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("209", "post_attachment", "214", "2400", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("210", "post_attachment", "215", "2401", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("211", "post_attachment", "216", "2402", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("212", "post_attachment", "1376", "3562", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("213", "post_attachment", "1377", "3563", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("214", "post_attachment", "1385", "3571", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("215", "post_attachment", "1401", "3587", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("216", "post_attachment", "1413", "3599", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("217", "post_attachment", "1414", "3600", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("218", "post_attachment", "1415", "3601", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("219", "post_attachment", "1416", "3602", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("220", "post_attachment", "1417", "3603", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("221", "post_attachment", "1418", "3604", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("222", "post_attachment", "1419", "3605", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("223", "post_attachment", "1420", "3606", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("224", "post_attachment", "1421", "3607", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("225", "post_attachment", "1422", "3608", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("226", "post_attachment", "1423", "3609", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("227", "post_attachment", "1424", "3610", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("228", "post_attachment", "1425", "3611", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("229", "post_attachment", "1426", "3612", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("230", "post_attachment", "1429", "3615", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("231", "post_attachment", "1430", "3616", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("232", "post_attachment", "1431", "3617", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("233", "post_attachment", "1432", "3618", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("234", "post_attachment", "1433", "3619", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("235", "post_attachment", "1450", "3636", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("236", "post_attachment", "1458", "3644", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("237", "post_attachment", "1490", "3676", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("238", "post_attachment", "1495", "3681", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("239", "post_attachment", "1496", "3682", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("240", "post_attachment", "1497", "3683", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("241", "post_attachment", "1498", "3684", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("242", "post_attachment", "1499", "3685", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("243", "post_attachment", "1500", "3686", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("244", "post_attachment", "1501", "3687", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("245", "post_attachment", "1502", "3688", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("246", "post_attachment", "1503", "3689", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("247", "post_attachment", "1504", "3690", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("248", "post_attachment", "1505", "3691", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("249", "post_attachment", "1506", "3692", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("250", "post_attachment", "1507", "3693", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("251", "post_attachment", "1508", "3694", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("252", "post_attachment", "1509", "3695", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("253", "post_attachment", "1510", "3696", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("254", "post_attachment", "1544", "3730", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("255", "post_attachment", "1545", "3731", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("256", "post_attachment", "1546", "3732", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("257", "post_attachment", "1552", "3738", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("258", "post_attachment", "1553", "3739", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("259", "post_attachment", "1559", "3745", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("260", "post_attachment", "1584", "3770", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("261", "post_attachment", "1585", "3771", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("262", "post_attachment", "1586", "3772", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("263", "post_attachment", "1587", "3773", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("264", "post_attachment", "1598", "3784", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("265", "post_attachment", "1599", "3785", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("266", "post_attachment", "1624", "3810", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("267", "post_attachment", "1625", "3811", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("268", "post_attachment", "1626", "3812", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("269", "post_attachment", "1627", "3813", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("270", "post_attachment", "1648", "3834", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("271", "post_attachment", "1650", "3836", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("272", "post_attachment", "1656", "3842", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("273", "post_attachment", "1661", "3847", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("274", "post_attachment", "1663", "3849", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("275", "post_attachment", "1671", "3857", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("276", "post_attachment", "1679", "3865", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("277", "post_attachment", "1687", "3873", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("278", "post_attachment", "1696", "3882", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("279", "post_attachment", "1716", "3902", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("280", "post_attachment", "1721", "3907", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("281", "post_attachment", "1731", "3917", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("282", "post_attachment", "1732", "3918", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("283", "post_attachment", "1733", "3919", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("284", "post_attachment", "1742", "3928", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("285", "post_attachment", "1764", "3950", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("286", "post_attachment", "1767", "3953", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("287", "post_attachment", "1768", "3954", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("288", "post_attachment", "1775", "3961", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("289", "post_attachment", "1793", "3979", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("290", "post_attachment", "1794", "3980", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("291", "post_attachment", "1797", "3983", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("292", "post_attachment", "1798", "3984", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("293", "post_attachment", "1806", "3992", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("294", "post_attachment", "1807", "3993", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("295", "post_attachment", "1808", "3994", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("296", "post_attachment", "1809", "3995", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("297", "post_attachment", "1810", "3996", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("298", "post_attachment", "1811", "3997", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("299", "post_attachment", "1812", "3998", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("300", "post_attachment", "1816", "4002", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("301", "post_attachment", "1817", "4003", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("302", "post_attachment", "1823", "4009", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("303", "post_attachment", "1824", "4010", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("304", "post_attachment", "1825", "4011", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("305", "post_attachment", "1826", "4012", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("306", "post_attachment", "1827", "4013", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("307", "post_attachment", "1828", "4014", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("308", "post_attachment", "1829", "4015", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("309", "post_attachment", "1830", "4016", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("310", "post_attachment", "1836", "4022", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("311", "post_attachment", "1837", "4023", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("312", "post_attachment", "1840", "4026", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("313", "post_attachment", "1841", "4027", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("314", "post_attachment", "8", "2194", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("315", "post_attachment", "1911", "4097", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("316", "post_attachment", "1912", "4098", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("317", "post_attachment", "1913", "4099", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("318", "post_attachment", "1914", "4100", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("319", "post_attachment", "1915", "4101", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("320", "post_attachment", "1916", "4102", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("321", "post_attachment", "1917", "4103", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("322", "post_attachment", "1918", "4104", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("323", "post_attachment", "1920", "4106", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("324", "post_attachment", "1921", "4107", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("326", "tax_translation_priority", "53", "4108", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("327", "tax_translation_priority", "54", "4108", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("329", "tax_translation_priority", "55", "4109", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("330", "tax_translation_priority", "56", "4109", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("332", "tax_translation_priority", "57", "4110", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("333", "tax_translation_priority", "58", "4110", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("334", "post_attachment", "1930", "2194", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("335", "post_attachment", "1931", "2400", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("336", "post_attachment", "1932", "2401", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("337", "post_attachment", "1933", "2402", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("338", "post_attachment", "1934", "3562", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("339", "post_attachment", "1935", "3563", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("340", "post_attachment", "1936", "3571", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("341", "post_attachment", "1937", "3587", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("342", "post_attachment", "1938", "3599", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("343", "post_attachment", "1939", "3600", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("344", "post_attachment", "1940", "3601", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("345", "post_attachment", "1941", "3602", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("346", "post_attachment", "1942", "3603", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("347", "post_attachment", "1943", "3604", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("348", "post_attachment", "1944", "3605", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("349", "post_attachment", "1945", "3606", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("350", "post_attachment", "1946", "3607", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("351", "post_attachment", "1947", "3608", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("352", "post_attachment", "1948", "3609", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("353", "post_attachment", "1949", "3610", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("354", "post_attachment", "1950", "3611", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("355", "post_attachment", "1951", "3612", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("356", "post_attachment", "1952", "3615", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("357", "post_attachment", "1953", "3616", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("358", "post_attachment", "1954", "3617", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("359", "post_attachment", "1955", "3618", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("360", "post_attachment", "1956", "3619", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("361", "post_attachment", "1957", "3636", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("362", "post_attachment", "1958", "3644", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("363", "post_attachment", "1959", "3676", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("364", "post_attachment", "1960", "3681", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("365", "post_attachment", "1961", "3682", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("366", "post_attachment", "1962", "3683", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("367", "post_attachment", "1963", "3684", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("368", "post_attachment", "1964", "3685", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("369", "post_attachment", "1965", "3686", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("370", "post_attachment", "1966", "3687", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("371", "post_attachment", "1967", "3688", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("372", "post_attachment", "1968", "3689", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("373", "post_attachment", "1969", "3690", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("374", "post_attachment", "1970", "3691", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("375", "post_attachment", "1971", "3692", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("376", "post_attachment", "1972", "3693", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("377", "post_attachment", "1973", "3694", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("378", "post_attachment", "1974", "3695", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("379", "post_attachment", "1975", "3696", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("380", "post_attachment", "1976", "3730", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("381", "post_attachment", "1977", "3731", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("382", "post_attachment", "1978", "3732", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("383", "post_attachment", "1979", "3738", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("384", "post_attachment", "1980", "3739", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("385", "post_attachment", "1981", "3745", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("386", "post_attachment", "1982", "3770", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("387", "post_attachment", "1983", "3771", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("388", "post_attachment", "1984", "3772", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("389", "post_attachment", "1985", "3773", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("390", "post_attachment", "1986", "3784", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("391", "post_attachment", "1987", "3785", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("392", "post_attachment", "1988", "3810", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("393", "post_attachment", "1989", "3811", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("394", "post_attachment", "1990", "3812", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("395", "post_attachment", "1991", "3813", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("396", "post_attachment", "1992", "3834", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("397", "post_attachment", "1993", "3836", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("398", "post_attachment", "1994", "3842", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("399", "post_attachment", "1995", "3847", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("400", "post_attachment", "1996", "3849", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("401", "post_attachment", "1997", "3857", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("402", "post_attachment", "1998", "3865", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("403", "post_attachment", "1999", "3873", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("404", "post_attachment", "2000", "3882", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("405", "post_attachment", "2001", "3902", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("406", "post_attachment", "2002", "3907", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("407", "post_attachment", "2003", "3917", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("408", "post_attachment", "2004", "3918", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("409", "post_attachment", "2005", "3919", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("410", "post_attachment", "2006", "3928", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("411", "post_attachment", "2007", "3950", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("412", "post_attachment", "2008", "3953", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("413", "post_attachment", "2009", "3954", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("414", "post_attachment", "2010", "3961", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("415", "post_attachment", "2011", "3979", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("416", "post_attachment", "2012", "3980", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("417", "post_attachment", "2013", "3983", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("418", "post_attachment", "2014", "3984", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("419", "post_attachment", "2015", "3992", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("420", "post_attachment", "2016", "3993", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("421", "post_attachment", "2017", "3994", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("422", "post_attachment", "2018", "3995", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("423", "post_attachment", "2019", "3996", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("424", "post_attachment", "2020", "3997", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("425", "post_attachment", "2021", "3998", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("426", "post_attachment", "2022", "4002", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("427", "post_attachment", "2023", "4003", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("428", "post_attachment", "2024", "4009", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("429", "post_attachment", "2025", "4010", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("430", "post_attachment", "2026", "4011", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("431", "post_attachment", "2027", "4012", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("432", "post_attachment", "2028", "4013", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("433", "post_attachment", "2029", "4014", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("434", "post_attachment", "2030", "4015", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("435", "post_attachment", "2031", "4016", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("436", "post_attachment", "2032", "4022", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("437", "post_attachment", "2033", "4023", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("438", "post_attachment", "2034", "4026", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("439", "post_attachment", "2035", "4027", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("440", "post_attachment", "2036", "4097", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("441", "post_attachment", "2037", "4098", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("442", "post_attachment", "2038", "4099", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("443", "post_attachment", "2039", "4100", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("444", "post_attachment", "2040", "4101", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("445", "post_attachment", "2041", "4102", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("446", "post_attachment", "2042", "4103", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("447", "post_attachment", "2043", "4104", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("448", "post_attachment", "2044", "4106", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("449", "post_attachment", "2045", "4107", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("451", "package_page-builder-shortcode-strings", "1", "4111", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("452", "post_attachment", "2049", "4112", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("453", "post_attachment", "2050", "4112", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("454", "post_attachment", "2052", "4113", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("455", "post_attachment", "2053", "4113", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("456", "post_attachment", "2055", "4114", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("457", "post_attachment", "2056", "4114", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("458", "post_attachment", "2058", "4115", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("459", "post_attachment", "2059", "4115", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("460", "post_attachment", "2060", "4116", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("461", "post_attachment", "2061", "4116", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("462", "post_attachment", "2063", "4117", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("463", "post_attachment", "2064", "4117", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("465", "package_page-builder-shortcode-strings", "2", "4118", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("467", "package_page-builder-shortcode-strings", "3", "4119", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("469", "package_page-builder-shortcode-strings", "4", "4120", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("471", "package_page-builder-shortcode-strings", "5", "4121", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("473", "package_page-builder-shortcode-strings", "6", "4122", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("474", "post_attachment", "2067", "4123", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("475", "post_attachment", "2068", "4123", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("476", "post_attachment", "2070", "4124", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("477", "post_attachment", "2071", "4124", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("478", "post_attachment", "2072", "4125", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("479", "post_attachment", "2073", "4125", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("480", "post_attachment", "2075", "4126", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("481", "post_attachment", "2076", "4126", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("482", "post_attachment", "2078", "4127", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("483", "post_attachment", "2079", "4127", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("484", "post_attachment", "2081", "4128", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("485", "post_attachment", "2082", "4128", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("486", "post_attachment", "2086", "4129", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("487", "post_attachment", "2087", "4129", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("490", "post_attachment", "2092", "4131", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("489", "post_attachment", "2091", "4130", "it", NULL);
INSERT INTO `wp_icl_translations` VALUES("491", "post_attachment", "2093", "4131", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("492", "post_attachment", "2094", "4132", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("493", "post_attachment", "2095", "4132", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("494", "post_attachment", "2096", "4133", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("495", "post_attachment", "2097", "4133", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("496", "post_attachment", "2098", "4134", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("497", "post_attachment", "2099", "4134", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("498", "post_attachment", "2108", "4135", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("499", "post_attachment", "2109", "4135", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("500", "post_attachment", "2110", "4136", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("501", "post_attachment", "2111", "4136", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("502", "post_attachment", "2112", "4137", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("503", "post_attachment", "2113", "4137", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("504", "post_attachment", "2114", "4138", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("505", "post_attachment", "2115", "4138", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("506", "post_attachment", "2116", "4139", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("507", "post_attachment", "2117", "4139", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("508", "post_attachment", "2119", "4140", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("509", "post_attachment", "2120", "4140", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("510", "post_attachment", "2127", "4141", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("511", "post_attachment", "2128", "4141", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("512", "post_attachment", "2129", "4142", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("513", "post_attachment", "2130", "4142", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("514", "post_attachment", "2133", "4143", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("515", "post_attachment", "2134", "4143", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("516", "tax_category", "59", "4144", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("517", "post_attachment", "2150", "4145", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("518", "post_attachment", "2151", "4145", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("520", "package_page-builder-shortcode-strings", "7", "4146", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("521", "post_page", "2155", "4147", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("523", "package_page-builder-shortcode-strings", "8", "4148", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("524", "post_page", "2160", "4149", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("526", "package_page-builder-shortcode-strings", "9", "4150", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("527", "post_page", "2164", "4151", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("529", "package_page-builder-shortcode-strings", "10", "4152", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("530", "post_attachment", "2169", "4153", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("531", "post_attachment", "2170", "4153", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("533", "package_page-builder-shortcode-strings", "11", "4154", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("539", "package_page-builder-shortcode-strings", "14", "4157", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("540", "post_nav_menu_item", "2186", "4158", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("577", "post_nav_menu_item", "2261", "4181", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("579", "package_page-builder-shortcode-strings", "19", "4182", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("580", "post_attachment", "2269", "4183", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("581", "post_attachment", "2270", "4183", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("582", "post_attachment", "2271", "4184", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("583", "post_attachment", "2272", "4184", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("585", "package_page-builder-shortcode-strings", "20", "4185", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("586", "post_attachment", "2276", "4186", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("587", "post_attachment", "2277", "4186", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("588", "post_attachment", "2278", "4187", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("589", "post_attachment", "2279", "4187", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("590", "post_attachment", "2282", "4188", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("591", "post_attachment", "2283", "4188", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("592", "post_page", "2285", "4189", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("594", "package_page-builder-shortcode-strings", "21", "4190", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("595", "post_nav_menu_item", "2295", "4191", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("596", "post_nav_menu_item", "2296", "4192", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("597", "post_attachment", "2298", "4193", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("598", "post_attachment", "2299", "4193", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("599", "post_attachment", "2300", "4194", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("600", "post_attachment", "2301", "4194", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("601", "post_attachment", "2303", "4195", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("602", "post_attachment", "2304", "4195", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("603", "post_attachment", "2305", "4196", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("604", "post_attachment", "2306", "4196", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("605", "post_attachment", "2307", "4197", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("606", "post_attachment", "2308", "4197", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("607", "post_attachment", "2309", "4198", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("608", "post_attachment", "2310", "4198", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("609", "post_attachment", "2311", "4199", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("610", "post_attachment", "2312", "4199", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("611", "post_attachment", "2313", "4200", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("612", "post_attachment", "2314", "4200", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("613", "post_attachment", "2315", "4201", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("614", "post_attachment", "2316", "4201", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("615", "post_attachment", "2317", "4202", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("616", "post_attachment", "2318", "4202", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("617", "post_attachment", "2321", "4203", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("618", "post_attachment", "2322", "4203", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("619", "post_post", "2325", "4204", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("620", "post_attachment", "2326", "4205", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("621", "post_attachment", "2327", "4205", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("623", "package_page-builder-shortcode-strings", "22", "4206", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("624", "post_attachment", "2331", "4207", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("625", "post_attachment", "2332", "4207", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("626", "post_attachment", "2333", "4208", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("627", "post_attachment", "2334", "4208", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("628", "post_attachment", "2335", "4209", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("629", "post_attachment", "2336", "4209", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("630", "post_attachment", "2337", "4210", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("631", "post_attachment", "2338", "4210", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("632", "post_post", "2339", "4211", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("633", "post_attachment", "2340", "4212", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("634", "post_attachment", "2341", "4212", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("636", "package_page-builder-shortcode-strings", "23", "4213", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("637", "tax_category", "61", "4214", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("638", "post_attachment", "2343", "4215", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("639", "post_attachment", "2344", "4215", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("640", "post_attachment", "2347", "4216", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("641", "post_attachment", "2348", "4216", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("642", "post_attachment", "2353", "4217", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("643", "post_attachment", "2354", "4217", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("644", "post_attachment", "2355", "4218", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("645", "post_attachment", "2356", "4218", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("646", "post_attachment", "2357", "4219", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("647", "post_attachment", "2358", "4219", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("648", "post_attachment", "2359", "4220", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("649", "post_attachment", "2360", "4220", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("650", "post_attachment", "2361", "4221", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("651", "post_attachment", "2362", "4221", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("652", "post_attachment", "2363", "4222", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("653", "post_attachment", "2364", "4222", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("654", "post_attachment", "2366", "4223", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("655", "post_attachment", "2367", "4223", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("656", "post_attachment", "2368", "4224", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("657", "post_attachment", "2369", "4224", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("658", "post_attachment", "2370", "4225", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("659", "post_attachment", "2371", "4225", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("660", "post_attachment", "2372", "4226", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("661", "post_attachment", "2373", "4226", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("662", "post_attachment", "2374", "4227", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("663", "post_attachment", "2375", "4227", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("664", "post_post", "2376", "4228", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("665", "post_attachment", "2377", "4229", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("666", "post_attachment", "2378", "4229", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("668", "package_page-builder-shortcode-strings", "24", "4230", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("765", "post_attachment", "2652", "4293", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("764", "post_attachment", "2651", "4293", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("763", "post_attachment", "2650", "4292", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("762", "post_attachment", "2649", "4292", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("761", "post_attachment", "2648", "4291", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("760", "post_attachment", "2647", "4291", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("679", "post_nav_menu_item", "2433", "4239", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("759", "post_attachment", "2634", "4290", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("681", "post_nav_menu_item", "2435", "4241", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("682", "post_nav_menu_item", "2436", "4242", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("757", "post_nav_menu_item", "2629", "4289", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("756", "package_gutenberg", "39", "4288", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("685", "post_attachment", "2439", "4245", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("686", "post_attachment", "2440", "4245", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("687", "post_page", "2444", "4246", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("689", "package_page-builder-shortcode-strings", "25", "4247", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("690", "post_page", "2447", "4248", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("692", "package_page-builder-shortcode-strings", "26", "4249", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("695", "package_page-builder-shortcode-strings", "27", "4251", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("696", "post_page", "2509", "4252", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("698", "package_page-builder-shortcode-strings", "28", "4253", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("699", "post_page", "2513", "4254", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("701", "package_page-builder-shortcode-strings", "29", "4255", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("702", "post_page", "2516", "4256", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("704", "package_page-builder-shortcode-strings", "30", "4257", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("705", "post_page", "2520", "4258", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("707", "package_page-builder-shortcode-strings", "31", "4259", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("708", "post_page", "2523", "4260", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("710", "package_page-builder-shortcode-strings", "32", "4261", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("711", "post_page", "2526", "4262", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("713", "package_page-builder-shortcode-strings", "33", "4263", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("714", "post_page", "2530", "4264", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("716", "package_page-builder-shortcode-strings", "34", "4265", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("717", "post_page", "2533", "4266", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("719", "package_page-builder-shortcode-strings", "35", "4267", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("720", "post_page", "2536", "4268", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("722", "package_page-builder-shortcode-strings", "36", "4269", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("723", "post_page", "2539", "4270", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("725", "package_page-builder-shortcode-strings", "37", "4271", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("726", "post_page", "2544", "4272", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("728", "package_page-builder-shortcode-strings", "38", "4273", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("729", "post_attachment", "2554", "4274", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("730", "post_attachment", "2555", "4274", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("731", "post_post", "2553", "4275", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("732", "post_attachment", "2557", "4276", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("733", "post_attachment", "2558", "4276", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("734", "post_attachment", "2562", "4277", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("735", "post_attachment", "2563", "4277", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("736", "post_attachment", "2564", "4278", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("737", "post_attachment", "2565", "4278", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("738", "post_attachment", "2566", "4279", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("739", "post_attachment", "2567", "4279", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("740", "post_attachment", "2568", "4280", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("741", "post_attachment", "2569", "4280", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("742", "post_attachment", "2570", "4281", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("743", "post_attachment", "2571", "4281", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("744", "post_attachment", "2572", "4282", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("745", "post_attachment", "2573", "4282", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("746", "post_post", "2574", "4283", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("747", "post_attachment", "2576", "4284", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("748", "post_attachment", "2577", "4284", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("749", "post_attachment", "2578", "4285", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("750", "post_attachment", "2579", "4285", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("751", "post_attachment", "2597", "4286", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("752", "post_attachment", "2598", "4286", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("753", "post_attachment", "2599", "4287", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("754", "post_attachment", "2600", "4287", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("766", "post_attachment", "2653", "4294", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("767", "post_attachment", "2654", "4294", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("768", "post_attachment", "2655", "4295", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("769", "post_attachment", "2656", "4295", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("770", "post_attachment", "2657", "4296", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("771", "post_attachment", "2658", "4296", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("772", "post_attachment", "2659", "4297", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("773", "post_attachment", "2660", "4297", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("774", "post_attachment", "2661", "4298", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("775", "post_attachment", "2662", "4298", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("776", "post_attachment", "2663", "4299", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("777", "post_attachment", "2664", "4299", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("778", "post_attachment", "2665", "4300", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("779", "post_attachment", "2666", "4300", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("780", "post_attachment", "2667", "4301", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("781", "post_attachment", "2668", "4301", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("782", "post_attachment", "2669", "4302", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("783", "post_attachment", "2670", "4302", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("784", "post_attachment", "2671", "4303", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("785", "post_attachment", "2672", "4303", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("786", "post_attachment", "2673", "4304", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("787", "post_attachment", "2674", "4304", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("788", "post_attachment", "2675", "4305", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("789", "post_attachment", "2676", "4305", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("790", "post_attachment", "2677", "4306", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("791", "post_attachment", "2678", "4306", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("792", "post_attachment", "2679", "4307", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("793", "post_attachment", "2680", "4307", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("794", "post_attachment", "2681", "4308", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("795", "post_attachment", "2682", "4308", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("801", "post_attachment", "2698", "4312", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("802", "post_attachment", "2699", "4312", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("803", "post_attachment", "2701", "4313", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("804", "post_attachment", "2702", "4313", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("805", "post_attachment", "2744", "4314", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("806", "post_attachment", "2745", "4314", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("807", "post_attachment", "2748", "4315", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("808", "post_attachment", "2749", "4315", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("809", "post_attachment", "2754", "4316", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("810", "post_attachment", "2755", "4316", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("811", "post_attachment", "2757", "4317", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("812", "post_attachment", "2758", "4317", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("813", "post_attachment", "2760", "4318", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("814", "post_attachment", "2761", "4318", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("815", "post_attachment", "2762", "4319", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("816", "post_attachment", "2763", "4319", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("817", "post_attachment", "2764", "4320", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("818", "post_attachment", "2765", "4320", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("819", "post_attachment", "2767", "4321", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("820", "post_attachment", "2768", "4321", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("821", "post_attachment", "2771", "4322", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("822", "post_attachment", "2772", "4322", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("823", "post_attachment", "2777", "4323", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("824", "post_attachment", "2778", "4323", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("825", "post_attachment", "2781", "4324", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("826", "post_attachment", "2782", "4324", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("827", "post_attachment", "2785", "4325", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("828", "post_attachment", "2786", "4325", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("829", "post_attachment", "2787", "4326", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("830", "post_attachment", "2788", "4326", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("831", "post_attachment", "2790", "4327", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("832", "post_attachment", "2791", "4327", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("833", "post_attachment", "2792", "4328", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("834", "post_attachment", "2793", "4328", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("835", "post_page", "2795", "4329", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("837", "package_page-builder-shortcode-strings", "40", "4330", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("838", "post_attachment", "2798", "4331", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("839", "post_attachment", "2799", "4331", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("840", "post_attachment", "2800", "4332", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("841", "post_attachment", "2801", "4332", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("842", "post_attachment", "2802", "4333", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("843", "post_attachment", "2803", "4333", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("844", "post_attachment", "2806", "4334", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("845", "post_attachment", "2807", "4334", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("846", "post_attachment", "2811", "4335", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("847", "post_attachment", "2812", "4335", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("848", "post_attachment", "2814", "4336", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("849", "post_attachment", "2815", "4336", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("850", "post_attachment", "2818", "4337", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("851", "post_attachment", "2819", "4337", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("852", "post_attachment", "2820", "4338", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("853", "post_attachment", "2821", "4338", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("854", "post_attachment", "2824", "4339", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("855", "post_attachment", "2825", "4339", "it", "en");
INSERT INTO `wp_icl_translations` VALUES("856", "post_attachment", "2871", "4340", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("857", "post_attachment", "2872", "4340", "it", "en");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://sviluppo.studiolegalelauro.it", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://sviluppo.studiolegalelauro.it", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Studio Legale Lauro", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "International Law Firm", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "rosariadaniele@yahoo.it", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:263:{s:9:\"events/?$\";s:29:\"index.php?post_type=portfolio\";s:39:\"events/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:34:\"events/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:26:\"events/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:12:\"Expertise/?$\";s:27:\"index.php?post_type=service\";s:42:\"Expertise/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=service&feed=$matches[1]\";s:37:\"Expertise/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=service&feed=$matches[1]\";s:29:\"Expertise/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=service&paged=$matches[1]\";s:9:\"footer/?$\";s:26:\"index.php?post_type=footer\";s:39:\"footer/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=footer&feed=$matches[1]\";s:34:\"footer/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=footer&feed=$matches[1]\";s:26:\"footer/page/([0-9]{1,})/?$\";s:44:\"index.php?post_type=footer&paged=$matches[1]\";s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:34:\"events/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"events/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"events/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"events/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"events/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"events/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"events/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:27:\"events/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:47:\"events/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:42:\"events/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:35:\"events/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:42:\"events/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:32:\"events/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?portfolio=$matches[1]&wc-api=$matches[3]\";s:38:\"events/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:49:\"events/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:31:\"events/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:23:\"events/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"events/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"events/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"events/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"events/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"events/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"Expertise/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"Expertise/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"Expertise/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"Expertise/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"Expertise/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"Expertise/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"Expertise/([^/]+)/embed/?$\";s:40:\"index.php?service=$matches[1]&embed=true\";s:30:\"Expertise/([^/]+)/trackback/?$\";s:34:\"index.php?service=$matches[1]&tb=1\";s:50:\"Expertise/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?service=$matches[1]&feed=$matches[2]\";s:45:\"Expertise/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?service=$matches[1]&feed=$matches[2]\";s:38:\"Expertise/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?service=$matches[1]&paged=$matches[2]\";s:45:\"Expertise/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?service=$matches[1]&cpage=$matches[2]\";s:35:\"Expertise/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?service=$matches[1]&wc-api=$matches[3]\";s:41:\"Expertise/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"Expertise/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:34:\"Expertise/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?service=$matches[1]&page=$matches[2]\";s:26:\"Expertise/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"Expertise/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"Expertise/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"Expertise/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"Expertise/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"Expertise/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"footer/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"footer/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"footer/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"footer/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"footer/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"footer/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"footer/([^/]+)/embed/?$\";s:39:\"index.php?footer=$matches[1]&embed=true\";s:27:\"footer/([^/]+)/trackback/?$\";s:33:\"index.php?footer=$matches[1]&tb=1\";s:47:\"footer/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?footer=$matches[1]&feed=$matches[2]\";s:42:\"footer/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?footer=$matches[1]&feed=$matches[2]\";s:35:\"footer/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?footer=$matches[1]&paged=$matches[2]\";s:42:\"footer/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?footer=$matches[1]&cpage=$matches[2]\";s:32:\"footer/([^/]+)/wc-api(/(.*))?/?$\";s:47:\"index.php?footer=$matches[1]&wc-api=$matches[3]\";s:38:\"footer/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:49:\"footer/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:31:\"footer/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?footer=$matches[1]&page=$matches[2]\";s:23:\"footer/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"footer/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"footer/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"footer/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"footer/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"footer/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio-category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio-category=$matches[1]&feed=$matches[2]\";s:35:\"portfolio-category/([^/]+)/embed/?$\";s:51:\"index.php?portfolio-category=$matches[1]&embed=true\";s:47:\"portfolio-category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio-category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio-category/([^/]+)/?$\";s:40:\"index.php?portfolio-category=$matches[1]\";s:50:\"expertise/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?service-category=$matches[1]&feed=$matches[2]\";s:45:\"expertise/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?service-category=$matches[1]&feed=$matches[2]\";s:26:\"expertise/([^/]+)/embed/?$\";s:49:\"index.php?service-category=$matches[1]&embed=true\";s:38:\"expertise/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?service-category=$matches[1]&paged=$matches[2]\";s:20:\"expertise/([^/]+)/?$\";s:38:\"index.php?service-category=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"vc_grid_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"vc_grid_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"vc_grid_item/([^/]+)/embed/?$\";s:45:\"index.php?vc_grid_item=$matches[1]&embed=true\";s:33:\"vc_grid_item/([^/]+)/trackback/?$\";s:39:\"index.php?vc_grid_item=$matches[1]&tb=1\";s:41:\"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&paged=$matches[2]\";s:48:\"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]\";s:38:\"vc_grid_item/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?vc_grid_item=$matches[1]&wc-api=$matches[3]\";s:44:\"vc_grid_item/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"vc_grid_item/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"vc_grid_item/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?vc_grid_item=$matches[1]&page=$matches[2]\";s:29:\"vc_grid_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"vc_grid_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"vc_grid_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=229&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:21:{i:0;s:40:\"sitepress-multilingual-cms/sitepress.php\";i:1;s:35:\"redux-framework/redux-framework.php\";i:2;s:33:\"classic-editor/classic-editor.php\";i:3;s:36:\"contact-form-7/wp-contact-form-7.php\";i:4;s:31:\"cookie-notice/cookie-notice.php\";i:5;s:17:\"ctcore/ctcore.php\";i:6;s:21:\"ctimport/ctimport.php\";i:7;s:44:\"custom-twitter-feeds/custom-twitter-feed.php\";i:8;s:25:\"duplicator/duplicator.php\";i:9;s:29:\"hide-featured-image/index.php\";i:10;s:33:\"instagram-feed/instagram-feed.php\";i:11;s:27:\"js_composer/js_composer.php\";i:12;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";i:13;s:23:\"revslider/revslider.php\";i:14;s:81:\"update-theme-and-plugins-from-zip-file/update-theme-and-plugins-from-zip-file.php\";i:15;s:27:\"woocommerce/woocommerce.php\";i:16;s:41:\"wp-gdpr-compliance/wp-gdpr-compliance.php\";i:17;s:33:\"wp-user-avatar/wp-user-avatar.php\";i:18;s:33:\"wpml-media-translation/plugin.php\";i:19;s:34:\"wpml-string-translation/plugin.php\";i:20;s:38:\"wpml-translation-management/plugin.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:2:{i:0;s:95:\"/home/studiolegalelaur/sviluppo.studiolegalelauro.it/wp-content/themes/lawsight-child/style.css\";i:2;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "lawsight", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "lawsight-child", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO `wp_options` VALUES("43", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "45805", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:3:{i:3;a:5:{s:5:\"title\";s:10:\"Categories\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:8:\"dropdown\";i:0;s:8:\"el_class\";s:0:\"\";}i:4;a:5:{s:5:\"title\";s:10:\"Categories\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:8:\"dropdown\";i:0;s:8:\"el_class\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:6:{i:1;a:5:{s:5:\"title\";s:9:\"Brochures\";s:4:\"text\";s:101:\"View our 2018 financial prospectus\r\nbrochure for an easy to read guide on\r\nall of the services offer.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:8:\"el_class\";s:13:\"text-brochure\";}i:3;a:5:{s:5:\"title\";s:7:\"Gallery\";s:4:\"text\";s:82:\"[vc_gallery type=\"image_grid\" images=\"217,218,219,220,221,222\" img_size=\"580x580\"]\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:8:\"el_class\";s:0:\"\";}i:5;a:6:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:302:\"<div align=\"justify\"><span style=\"color: #999;\"><strong>Studio Legale Lauro</strong> is an Italian law firm, established in 1993 in Naples, providing a wide range of legal services in maritime, commercial and international law matters to the global maritime business sector and industries.</span></div>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:8:\"el_class\";s:0:\"\";s:13:\"wpml_language\";s:2:\"en\";}i:6;a:6:{s:5:\"title\";s:14:\"Instagram Feed\";s:4:\"text\";s:16:\"[instagram-feed]\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:8:\"el_class\";s:0:\"\";s:13:\"wpml_language\";s:3:\"all\";}i:7;a:6:{s:5:\"title\";s:12:\"TWITTER FEED\";s:4:\"text\";s:22:\"[custom-twitter-feeds]\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:8:\"el_class\";s:0:\"\";s:13:\"wpml_language\";s:3:\"all\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:2:{s:33:\"classic-editor/classic-editor.php\";a:2:{i:0;s:14:\"Classic_Editor\";i:1;s:9:\"uninstall\";}s:33:\"instagram-feed/instagram-feed.php\";s:22:\"sb_instagram_uninstall\";}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "229", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("92", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("93", "initial_db_version", "44719", "yes");
INSERT INTO `wp_options` VALUES("94", "wp_user_roles", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:149:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:24:\"edit_booked_appointments\";b:1;s:21:\"manage_booked_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:34:\"wpml_manage_translation_management\";b:1;s:21:\"wpml_manage_languages\";b:1;s:41:\"wpml_manage_theme_and_plugin_localization\";b:1;s:19:\"wpml_manage_support\";b:1;s:36:\"wpml_manage_woocommerce_multilingual\";b:1;s:37:\"wpml_operate_woocommerce_multilingual\";b:1;s:29:\"wpml_manage_media_translation\";b:1;s:22:\"wpml_manage_navigation\";b:1;s:24:\"wpml_manage_sticky_links\";b:1;s:30:\"wpml_manage_string_translation\";b:1;s:33:\"wpml_manage_translation_analytics\";b:1;s:25:\"wpml_manage_wp_menus_sync\";b:1;s:32:\"wpml_manage_taxonomy_translation\";b:1;s:27:\"wpml_manage_troubleshooting\";b:1;s:31:\"wpml_manage_translation_options\";b:1;s:29:\"manage_instagram_feed_options\";b:1;s:31:\"vc_access_rules_post_types/post\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:36:\"vc_access_rules_post_types/portfolio\";b:1;s:34:\"vc_access_rules_post_types/service\";b:1;s:33:\"vc_access_rules_post_types/footer\";b:1;s:34:\"vc_access_rules_post_types/product\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:24:\"vc_access_rules_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:35:\"manage_custom_twitter_feeds_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:43:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:19:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:14:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:20:\"booked_booking_agent\";a:2:{s:4:\"name\";s:13:\"Booking Agent\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:24:\"edit_booked_appointments\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:101:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("95", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("96", "widget_search", "a:3:{i:2;a:1:{s:5:\"title\";s:6:\"Search\";}i:3;a:2:{s:5:\"title\";s:6:\"Search\";s:8:\"el_class\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "sidebars_widgets", "a:10:{s:19:\"wp_inactive_widgets\";a:8:{i:0;s:10:\"nav_menu-1\";i:1;s:19:\"getintouch_widget-1\";i:2;s:6:\"text-1\";i:3;s:18:\"brochures_widget-1\";i:4;s:18:\"brochures_widget-2\";i:5;s:17:\"ct_recent_posts-3\";i:6;s:19:\"getintouch_widget-3\";i:7;s:18:\"cs_social_widget-1\";}s:12:\"sidebar-blog\";a:2:{i:0;s:8:\"search-2\";i:1;s:12:\"categories-3\";}s:12:\"sidebar-page\";a:5:{i:0;s:8:\"search-3\";i:1;s:12:\"categories-4\";i:2;s:17:\"ct_recent_posts-2\";i:3;s:6:\"text-3\";i:4;s:11:\"tag_cloud-2\";}s:15:\"sidebar-service\";a:2:{i:0;s:10:\"nav_menu-2\";i:1;s:19:\"getintouch_widget-2\";}s:12:\"sidebar-shop\";a:4:{i:0;s:32:\"woocommerce_product_categories-1\";i:1;s:26:\"woocommerce_price_filter-1\";i:2;s:31:\"woocommerce_product_tag_cloud-1\";i:3;s:22:\"woocommerce_products-1\";}s:16:\"sidebar-footer-1\";a:3:{i:0;s:13:\"media_image-1\";i:1;s:6:\"text-5\";i:2;s:19:\"getintouch_widget-4\";}s:16:\"sidebar-footer-2\";a:1:{i:0;s:6:\"text-7\";}s:16:\"sidebar-footer-3\";a:1:{i:0;s:6:\"text-6\";}s:16:\"sidebar-footer-4\";a:3:{i:0;s:13:\"media_image-2\";i:1;s:13:\"media_image-3\";i:2;s:13:\"media_image-4\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("102", "cron", "a:20:{i:1637944106;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1637944810;a:1:{s:24:\"update_wpml_config_index\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1637946387;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1637946806;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1637951157;a:1:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1637957187;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1637961957;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1637971200;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1637975467;a:1:{s:23:\"sb_instagram_twicedaily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1638000386;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638000455;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638000456;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638004094;a:1:{s:32:\"wpml-tm-check-overdue-jobs-event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638026757;a:1:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638026767;a:1:{s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638077341;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1638378437;a:1:{s:27:\"wpml_tm_send_summary_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1638977217;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}i:1640365637;a:1:{s:25:\"otgs_send_components_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_media_image", "a:5:{i:1;a:17:{s:13:\"attachment_id\";i:2169;s:3:\"url\";s:100:\"https://sviluppo.studiolegalelauro.it/wp-content/uploads/2020/02/LOGO-STUDIO-LEGALE-LAURO-FOOTER.png\";s:5:\"title\";b:0;s:4:\"size\";s:4:\"full\";s:5:\"width\";i:300;s:6:\"height\";i:62;s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:9:\"link_type\";s:6:\"custom\";s:8:\"link_url\";s:0:\"\";s:13:\"image_classes\";s:0:\"\";s:12:\"link_classes\";s:0:\"\";s:8:\"link_rel\";s:0:\"\";s:17:\"link_target_blank\";b:0;s:11:\"image_title\";s:0:\"\";s:8:\"el_class\";s:11:\"footer-logo\";s:13:\"wpml_language\";s:3:\"all\";}i:2;a:17:{s:4:\"size\";s:4:\"full\";s:5:\"width\";i:521;s:6:\"height\";i:209;s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:9:\"link_type\";s:6:\"custom\";s:8:\"link_url\";s:25:\"https://www.legal500.com/\";s:13:\"image_classes\";s:0:\"\";s:12:\"link_classes\";s:0:\"\";s:8:\"link_rel\";s:0:\"\";s:17:\"link_target_blank\";b:0;s:11:\"image_title\";s:0:\"\";s:13:\"attachment_id\";i:2282;s:3:\"url\";s:108:\"https://sviluppo.studiolegalelauro.it/wp-content/uploads/2020/02/ROSETTE-LEGAL-500-DA-INSERIRE-IN-FOOTER.png\";s:5:\"title\";b:0;s:8:\"el_class\";s:0:\"\";s:13:\"wpml_language\";s:3:\"all\";}i:3;a:17:{s:4:\"size\";s:4:\"full\";s:5:\"width\";i:300;s:6:\"height\";i:120;s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:9:\"link_type\";s:6:\"custom\";s:8:\"link_url\";s:25:\"https://www.legal500.com/\";s:13:\"image_classes\";s:0:\"\";s:12:\"link_classes\";s:0:\"\";s:8:\"link_rel\";s:0:\"\";s:17:\"link_target_blank\";b:0;s:11:\"image_title\";s:0:\"\";s:13:\"attachment_id\";i:2372;s:3:\"url\";s:77:\"https://sviluppo.studiolegalelauro.it/wp-content/uploads/2020/03/2020okok.png\";s:5:\"title\";b:0;s:8:\"el_class\";s:21:\"https://chambers.com/\";s:13:\"wpml_language\";s:3:\"all\";}i:4;a:17:{s:4:\"size\";s:4:\"full\";s:5:\"width\";i:300;s:6:\"height\";i:120;s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:9:\"link_type\";s:6:\"custom\";s:8:\"link_url\";s:21:\"https://chambers.com/\";s:13:\"image_classes\";s:0:\"\";s:12:\"link_classes\";s:0:\"\";s:8:\"link_rel\";s:0:\"\";s:17:\"link_target_blank\";b:0;s:11:\"image_title\";s:0:\"\";s:13:\"attachment_id\";i:2374;s:3:\"url\";s:85:\"https://sviluppo.studiolegalelauro.it/wp-content/uploads/2020/03/rosette-chambers.png\";s:5:\"title\";b:0;s:8:\"el_class\";s:0:\"\";s:13:\"wpml_language\";s:3:\"all\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_tag_cloud", "a:2:{i:2;a:4:{s:5:\"title\";s:4:\"Tags\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";s:8:\"el_class\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_nav_menu", "a:3:{i:1;a:2:{s:8:\"nav_menu\";i:50;s:8:\"el_class\";s:0:\"\";}i:2;a:3:{s:8:\"nav_menu\";i:50;s:8:\"el_class\";s:0:\"\";s:5:\"title\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "theme_mods_twentynineteen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1581953082;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("114", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("145", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("146", "rlrsssl_options", "a:16:{s:12:\"site_has_ssl\";b:1;s:25:\"ssl_success_message_shown\";b:1;s:22:\"htaccess_warning_shown\";b:0;s:19:\"review_notice_shown\";b:1;s:17:\"plugin_db_version\";s:5:\"3.2.9\";s:11:\"ssl_enabled\";b:1;s:9:\"debug_log\";N;s:4:\"hsts\";b:0;s:19:\"javascript_redirect\";b:0;s:11:\"wp_redirect\";b:1;s:26:\"autoreplace_insecure_links\";b:1;s:5:\"debug\";b:0;s:20:\"do_not_edit_htaccess\";b:0;s:31:\"switch_mixed_content_fixer_hook\";b:0;s:19:\"dismiss_all_notices\";b:0;s:17:\"htaccess_redirect\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("157", "rsssl_activation_timestamp", "1581495648", "yes");
INSERT INTO `wp_options` VALUES("176", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("27260", "_transient_rsssl_plusone_count", "0", "yes");
INSERT INTO `wp_options` VALUES("112363", "_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1637986588", "no");
INSERT INTO `wp_options` VALUES("112364", "_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1637943388", "no");
INSERT INTO `wp_options` VALUES("112365", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1637986589", "no");
INSERT INTO `wp_options` VALUES("112366", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Post Status: Post Status Excerpt (No. 34) — Developer Overload: Physical and Mental Health\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=89989\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://poststatus.com/excerpt/34/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3530:\"<h2>&#8220;I prioritized my mental health over my physical health until I realized it was all the same thing.&#8221;</h2>\n\n\n\n<p class=\"has-drop-cap\">In this episode of Post Status Excerpt, David chats with Cory about taking care of your physical and mental health and how these factor into &#8220;Developer Overload.&#8221; Far too often (especially younger) professionals do not prioritize their health so they can work or do more in a day — until it comes back to bite them.</p>\n\n\n\n<p><strong>Also: </strong>David shares that getting up early in the morning works for him and encourages people who have a hard time managing things in the morning to give it a shot — early mornings are usually quiet for many people, both in the place they live and the clients and employees they communicate with during the day.</p>\n\n\n\n\n\n\n\n<p class=\"has-background\">Every week <strong><a href=\"https://poststatus.com/podcast/the-excerpt/\">Post Status Excerpt</a></strong> will brief you on important WordPress news — in about 15 minutes or less! Learn what\'s new in WordPress in a flash. <img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/26a1.png\" alt=\"⚡\" class=\"wp-smiley\" /><br /><br />You can listen to <a href=\"https://poststatus.com/podcast/the-excerpt/\">past episodes</a> of <strong>The Excerpt</strong>, <a href=\"https://poststatus.com/category/post-status-podcasts/\">browse all our podcasts</a>, and don’t forget to subscribe on <a href=\"https://open.spotify.com/show/1m3xwXbe0MG5BzFVPtB0A7\">Spotify</a>, Amazon Music, <a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5zaW1wbGVjYXN0LmNvbS8ySkU5c2M4UA\">Google Podcasts</a>, <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">iTunes</a>, <a href=\"https://castro.fm/podcast/c53552c6-1ee0-4fc4-9de4-08ed6bf1ee4d\">Castro</a>, <a href=\"https://www.youtube.com/c/PostStatus\">YouTube</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, <a href=\"https://player.fm/series/wordpress-post-status-podcasts\">Player.fm</a>, <a href=\"https://pca.st/05rR\">Pocket Casts</a>, <a href=\"https://wordpress-post-status-draft-podcast.simplecast.com/\">Simplecast</a>, or by <a href=\"https://feeds.simplecast.com/2JE9sc8P\">RSS</a>. <img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /></p>\n\n\n\n<h3 id=\"h-mentioned-in-the-show\"><img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/1f517.png\" alt=\"🔗\" class=\"wp-smiley\" /> Mentioned in the show:</h3>\n\n\n\n<ul><li><a href=\"https://twitter.com/dimensionmedia\" target=\"_blank\" rel=\"noreferrer noopener\">David Bisset (Twitter)</a></li><li><a href=\"http://twitter.com/nathaningram\">Cory Miller</a><a href=\"http://twitter.com/corymiller303\"> (Twitter)</a></li><li><a href=\"https://twitter.com/post_status\" target=\"_blank\" rel=\"noreferrer noopener\">Post Status (Twitter)</a></li></ul>\n\n\n\n<h3><img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> Sponsor: <a href=\"https://poststat.us/sandhills\" target=\"_blank\" rel=\"noreferrer noopener sponsored nofollow\">Bluehost</a></h3>\n\n\n\n<p>Everything your website needs — from start-up to success story — is at Bluehost. Whether you\'re looking to create a website, blog, or online store, Bluehost will get you started with an all-in-one website platform tailored to your specific needs. Get a free domain name in your first year, free 24/7 lifetime support, and total design freedom with WordPress at Bluehost.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 25 Nov 2021 04:00:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"David Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WordPress.org blog: Watch State of the Word at a Watch Party with your WordPress Friends\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11641\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://wordpress.org/news/2021/11/watch-state-of-the-word-at-a-watch-party-with-your-wordpress-friends/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7241:\"<p><a href=\"https://wordpress.org/news/2021/11/state-of-the-word-2021/\">State of the Word 2021</a> is just around the corner!&nbsp;</p>\n\n\n\n<p>Although attending State of the Word in person would be ideal, not all WordPress community members get to enjoy the experience of attending the speech live with friends.&nbsp;</p>\n\n\n\n<p>This year, as State of the Word is streamed live for the second time, we want to restore that in person camaraderie through State of the Word watch parties for WordPress Community members around the world.</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p><strong>We encourage WordPress meetup organizers and community members worldwide to (safely) host State of the Word 2021 watch parties —</strong><a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/2021-state-of-the-word-watch-parties/\"><strong>read this handbook to learn more</strong></a><strong>.</strong></p></blockquote>\n\n\n\n<h2 id=\"why-organize-a-watch-party\">Why organize a watch party?&nbsp;</h2>\n\n\n\n<ul><li>If you are a <a href=\"https://meetup.com/pro/wordpress\">WordPress meetup</a> organizer, many folks in your meetup may be unaware of the State of the Word, and a watch party could be a great opportunity to introduce or remind them.</li><li>As meetup organizers slowly bid goodbye to a tough year, the watch party could be an excellent opportunity to revitalize your group, especially if you haven’t had many events this year.</li><li>Along with your Meetup group members, you get a platform to ask questions directly to Matt Mullenweg.</li><li>And last but not least, even if you are not a Meetup Organizer, a watch party can be the perfect opportunity to reconnect and have a blast with your WordPress friends!</li></ul>\n\n\n\n<h2 id=\"how-do-i-organize-a-state-of-the-word-watch-party\">How do I organize a State of the Word watch party?</h2>\n\n\n\n<p>You can choose to host a watch party online or in person. Check out <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/2021-state-of-the-word-watch-parties/#schedule-a-state-of-the-word-watch-party-for-your-meetup\">our handbook</a> for detailed instructions on how to schedule an event (including event templates).</p>\n\n\n\n<div class=\"wp-block-columns\">\n<div class=\"wp-block-column\">\n<h3 id=\"online\">Online</h3>\n\n\n\n<p>The simplest way to organize an online watch party is to schedule an online event for your WordPress group and add the State of the Word YouTube streaming link directly on Meetup.com. Alternatively, you can schedule an online meeting using tools like Zoom and broadcast the live stream over there by screen sharing––thereby facilitating better engagement. </p>\n\n\n\n<div class=\"wp-container-61a081661c3d5 wp-block-buttons\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/2021-state-of-the-word-watch-parties/#organizing-an-online-watch-party\" target=\"_blank\" rel=\"noreferrer noopener\">Organize an Online Watch Party</a></div>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-column\">\n<h3 id=\"in-person\">In Person</h3>\n\n\n\n<p>If your region meets <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/2021-returning-to-in-person-meetups/\">the guidelines for in person events</a> (if vaccines and testing are freely available), you can organize an in person watch party event (for fully vaccinated OR recently tested OR recently recovered folks) for your WordPress Meetup! Group members can hang out together (following local safety guidelines of course) and watch State of the Word live.</p>\n\n\n\n<div class=\"wp-container-61a081661c6b0 wp-block-buttons\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/2021-state-of-the-word-watch-parties/#organizing-an-in-person-watch-party\" target=\"_blank\" rel=\"noreferrer noopener\">Plan an In person Watch Party</a></div>\n</div>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<p><strong>NOTE:</strong> If State of the Word is happening at an odd hour in your timezone, you can still organize a watch party by organizing a replay of live stream, at a date/time that is convenient for your group.</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>If your Local WordPress Meetup is organizing an in person watch party, <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/2021-state-of-the-word-watch-parties/request-swag-for-in-person-watch-parties/\"><strong>fill out this form</strong></a><strong> so that we can ship some swag for your group to celebrate!</strong><br />Deadline: November 30, 2021</p></blockquote>\n\n\n\n<h2 id=\"what-else-do-i-need-to-know-about-organizing-a-state-of-the-word-watch-party\">What else do I need to know about organizing a State of the Word watch party?</h2>\n\n\n\n<p>Excited? To help you get started, we’ve put together a few resources:</p>\n\n\n\n<ul><li><strong>Check out this </strong><a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/2021-state-of-the-word-watch-parties/\"><strong>handbook</strong></a><strong> for detailed instructions on how to organize a watch party, </strong>be it online or in person.</li><li>Looking for a Zoom Pro account to host your online watch party?&nbsp;<a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/getting-started/special-virtual-events-zoom-request/\">Request a community zoom pro account</a>&nbsp;for your event right away!</li><li>We have prepared some <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/2021-state-of-the-word-watch-parties/email-templates-for-state-of-the-word/\">email templates</a> that Meetup Organizers can use to spread the word in their Meetup groups.</li><li>Don’t forget to share on social media about your watch party events using the hashtag <strong>#StateOfTheWord</strong> so we can join in on the fun!</li></ul>\n\n\n\n<blockquote class=\"wp-block-quote\"><p><strong>NOTE: </strong> The guidelines in this post are primarily aimed at WordPress Meetup organizers. <strong>However, you do not need to be a Meetup organizer to schedule a watch party!</strong> You can simply hang out together with your friends online or in person (while following local safety guidelines) and catch the event live!</p></blockquote>\n\n\n\n<p>If you are planning a watch party for State of the Word, and have questions, please drop us an email to: <a href=\"mailto:support@wordcamp.org\">support@wordcamp.org</a> if you have any questions. We are happy to help you in the best way possible.</p>\n\n\n\n<p><em>The following folks contributed to this post: <a href=\"https://profiles.wordpress.org/anjanavasan/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>anjanavasan</a> <a href=\"https://profiles.wordpress.org/eidolonnight/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>eidolonnight</a> <em><a href=\"https://profiles.wordpress.org/evarlese/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>evarlese</a></em></em> <em>and <a href=\"https://profiles.wordpress.org/rmartinezduque/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rmartinezduque</a></em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Nov 2021 18:30:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Hari Shanker R\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WordPress Foundation: Give Back to Open Source this Giving Tuesday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://wordpressfoundation.org/?p=202833\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://wordpressfoundation.org/news/2021/give-back-to-open-source-this-giving-tuesday/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3886:\"<p>Giving Tuesday is a global, non-profit movement that encourages people, organizations, and companies around the world to give, collaborate and celebrate generosity.</p>\n\n\n\n<p>Hosted on the first Tuesday following Thanksgiving, this year the charitable giving event will be taking place on <strong>November 30, 2021</strong>.</p>\n\n\n\n<p>With Giving Tuesday around the corner, many in the world are thinking about giving back. If you’re one of them, consider this opportunity to give back to open source.</p>\n\n\n\n<p>2021 and the pandemic brought a lot of changes to the world, including the open source community. And the year wasn’t without its challenges.</p>\n\n\n\n<p>Open source developers worldwide <a href=\"https://www.statista.com/statistics/912378/worldwide-open-source-professional-challenges-in-work/\" target=\"_blank\" rel=\"noreferrer noopener\">still face roadblocks</a>, from “lack of training opportunities” to “getting management buy-in for open source.”</p>\n\n\n\n<p>This is why the WordPress Foundation exists.</p>\n\n\n\n<h2 id=\"how-does-the-wordpress-foundation-support-open-source\">How does the WordPress Foundation support open source?</h2>\n\n\n\n<p>As a non-profit organization, our <a href=\"https://wordpressfoundation.org/\">work</a> is to ensure that open source software gets the support it needs. The funds we raise go toward ensuring free access to the projects we promote, protecting the WordPress trademark, and funding multiple programs aligned with our mission.</p>\n\n\n\n<p><strong>Some of the programs the WordPress Foundation supports include</strong>:</p>\n\n\n\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://wordpress.tv/\" target=\"_blank\">Video documentation</a> of WordCamp and WordPress meetup events.</li><li>“<a href=\"https://wordpressfoundation.org/tag/intro-to-open-source/\">Intro to Open Source</a>” workshops that increase awareness and understanding of the open web and open source in regions around the world that have relatively less participation.</li><li><a rel=\"noreferrer noopener\" href=\"https://doaction.org/\" target=\"_blank\">Charity hackathons</a> where developers come together and volunteer to build websites for nonprofit organizations around the world.</li><li><a rel=\"noreferrer noopener\" href=\"https://learn.wordpress.org/workshops/\" target=\"_blank\">Workshops</a>, both live and recorded, on how to use and develop for the WordPress platform.</li><li>School mentorship programs to encourage interest in WordPress and open source development from a young age.</li><li>Improving documentation about how to use and develop for, and contribute to the WordPress project.</li></ul>\n\n\n\n<p>But this is just the beginning. With your help, we can strengthen our support for these programs and fund many more exciting open source projects.</p>\n\n\n\n<a href=\"https://i0.wp.com/wordpressfoundation.org/content/uploads/2018/08/capetown.jpg?ssl=1\"><img /></a>Volunteers from do_action Cape Town 2018 working on charity websites\n\n\n\n<h2 id=\"how-can-you-help-this-giving-tuesday\">How can you help this Giving Tuesday?</h2>\n\n\n\n<p>The future is open source, and whether you’re a believer or part of the open source community, you can play a part in helping build this foundation for generations to come.</p>\n\n\n\n<p><strong>This Giving Tuesday, consider donating to the WordPress Foundation so we can work together toward a future that’s built on open source.</strong></p>\n\n\n\n<p>You can choose to donate annually or make a one-time donation. Every gift counts!</p>\n\n\n\n<div class=\"wp-container-61a10487a72fe wp-block-buttons\">\n<div class=\"wp-block-button is-style-fill\"><a class=\"wp-block-button__link has-white-color has-text-color has-background\" href=\"https://wordpressfoundation.org/donate/\"><strong>Donate to the WordPress Foundation</strong></a></div>\n</div>\n\n\n\n<p></p>\n\n\n\n<p class=\"has-text-align-left\">Thank you for supporting our mission!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Nov 2021 16:05:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Anjana Vasan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"HeroPress: Tales Of A Serial Contributor – Histórias de um colaborador em série\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=4283\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"https://heropress.com/essays/tales-of-a-serial-contributor/#utm_source=rss&utm_medium=rss&utm_campaign=tales-of-a-serial-contributor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:31833:\"<img width=\"1024\" height=\"512\" src=\"https://heropress.com/wp-content/uploads/2021/11/112321-min.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: I believe that the great advantage and differential of WordPress ... is its community.\" /><p><a href=\"https://heropress.com/feed/#portuguese\"><span class=\"css-901oao css-16my406 r-poiln3 r-bcqeeo r-qvutc0\">O texto também está disponível em português do Brasil.</span></a></p>\n<p>Hey! My name is Daniel Kossmann. I&#8217;ve been WordPress user since 2009, one of the organizers of the Curitiba community, creator of the weekly newsletter called PainelWP, and a regular writer about WP in my blog. This is my before and after story from joining the WordPress community in Brazil. Happy reading!</p>\n<h2>First contacts with the internet</h2>\n<p>Since I was a kid I was very fond of computers and video games, but the internet opened a whole new world for me. I was so fascinated that at eleven years, around 1998, reading tutorials and analyzing HTML codes I created my first website on James Bond, of whom I was a big fan. In those first years, even though my parents didn&#8217;t quite understand what I was doing and why I was spending so much time in front of the computer, they backed me up by purchasing books and computers.</p>\n<p>Little by little I learned more about programming and developing my systems in ASP and only then PHP. Since there weren&#8217;t so many websites teaching programming, I created a series of websites that taught others how to create websites and add small functionalities for them, like counters, login area, blinking text, &#8230;. At that time, I even created a content management system, that could receive contributions through a form and automatically published them every day at a given time, with a countdown timer in the website telling visitors when the next update would occur. This may be seen as trivial today, but at that time it was very uncommon. Those were really fun days, where I spent several nights learning new things and talking to other people who had the same interest in IRC on the deceased Brasnet network. If you are curious to learn more, check out <a href=\"https://belohorizonte.wordcamp.org/2016/daniel-kossmann-ferraz-automacao/\">my interview at WordCamp Belo Horizonte 2016</a> (content in Portuguese).</p>\n<h2>First contact with WordPress</h2>\n<p>When the time came to choose my undergraduate, there was no doubt that it would be something related to computers. So I chose a Computer Science degree from Federal University from Parana (UFPR). During college, I also wanted to dabble in other fields, so I decided to create a blog in which to write movie reviews. Looking for a platform in which to easily publish texts, so I wouldn&#8217;t have to worry about coding because I already was doing this every day at school, I discovered WordPress. It didn&#8217;t take long and, in 2009, I launched my first public blog about movies, which after one year became <a href=\"https://www.interrogacao.com.br/\"><i>interrogAção</i></a> (content in portuguese), a cultural hub on cinema, literature, and comics, with collaborators from several cities in Brazil. As in the case with my first tutorial websites and IRC conversations, many of these people I only knew virtually, but we had an intense contact while exchanging know-how.</p>\n<p>Even though my focus was more on content creation and editorializing, I began to learn more about how to create themes and features in WordPress to customize the website. In one of these researches, I found out that an event focused on WP was going to happen in my city. Even not knowing a lot about the platform, I decided to attend and learn more.</p>\n<h2>First contact with the community</h2>\n<p>The event was <a href=\"https://curitiba.wordcamp.org/2010/\">WordCamp Curitiba 2010</a> (content in portuguese) and I still remember how amazed I was at it being so cheap, I think it was R$60 or less, offering so many souvenirs and snacks. Other tech events I had attended had always charged more than double and hadn&#8217;t offered half of these things.</p>\n<p>The talks were amazing, and everyone was always very kind and available. I was so excited about everything that I promised myself that I would volunteer during the next edition and also try to be a speaker. As I didn&#8217;t know anyone at the event, I challenged myself to talk with at least three people — I was extremely shy back then. Since then two of them have become lifelong friends.</p>\n<p>At the end of the event, I found out that there was an after-party called WordCana (a joke with the word &#8220;cana&#8221;, from sugarcane, that is used to make distilled spirit). Even though I didn&#8217;t drink alcohol, I decided to go and it was awesome! There, I got to know the event&#8217;s speakers, organizers and attendees. Everyone talking as equals. And the fact that I didn&#8217;t drink alcohol didn&#8217;t change at all my interaction with them.</p>\n<h2>From attendee to WordCamp organizer</h2>\n<p>The promise I had made during that event came true! Less than two years later, I was helping to organize the next edition, <a href=\"https://curitiba.wordcamp.org/2012/\">WordCamp Curitiba 2012</a> (content in portuguese), which was where I also gave <a href=\"https://wordpress.tv/2012/10/11/daniel-kossmann-ferramentas-livres-para-desenvolvimento-wordpress/\">my first public talk</a> (content in portuguese). I was still very shy and, during the talk, I was so nervous that I couldn&#8217;t hold the microphone near my mouth. Because of that, even though it was a small room, people were having a hard time listening to my voice. Nevertheless, it was an important overcoming experience that has kept me desiring to improve my public speaking skills for future talks to this day.</p>\n<h2>From user to entrepreneur</h2>\n<p>Since I was a kid I had dreamt about opening my own company. Therefore, when I graduated in 2011, as I have always liked creating websites, I had little doubts about my next step: creating a web development company. I named it Spirallab, because of my passion for spirals and imagining turning it into a creative project lab. In the beginning, I didn&#8217;t define a direction and I worked with various systems and programming languages. Soon I realized that giving maintenance to these different solutions was a lot of work. So I opted to use a single platform, WordPress, due to its ease of use for my clients and the possibility to create various types of websites.</p>\n<p>This decision allowed me to dive even deeper into the system, making better and faster-to-deliver solutions for my clients. As time went by, I also increased my services within the platform, adding support, maintenance, courses, consulting and optimized hosting for WordPress, which at that time was extremely hard to find. This allowed for a broader client range. It also enabled us to specialize in the platform, getting to better know all of its facets.</p>\n<p>Even being a small company, never going beyond four people, I made sure to find ways to contribute to the WordPress community. After all, I managed to support my business without paying a single cent to use the platform. That is why I sponsored several WordCamps and meetups. This created a curious situation: Spirallab&#8217;s name was side by side with other sponsors that had 10 to 50 times its size. I wondered why there weren&#8217;t more companies doing the same. The sponsorship quotas started with a very low price tag, sometimes R$250. Considering the annual revenue of a company that uses WP as its main solution, I believe that this cost or investment could be easily included in its annual budget. I wish more companies, regardless of their size, would do that.</p>\n<p>Besides that, I&#8217;ve talked at several meetups and WordCamps, where I shared what I learned in my day-to-day life. It was always and still is a big pleasure to be able to make these contributions. During the events, I gave away some stickers from my company that had an illustration of a digital alchemist (a kind of modern wizard). Because of that, and my looks (long hair and beard), I ended up being nicknamed the WordPress Wizard.</p>\n<p>Eight years after Spirallab&#8217;s foundation, I decided to close the company&#8217;s activities and start a new chapter at <a href=\"https://www.pipefy.com/\">Pipefy</a> in 2019, where I currently work as a WordPress Development Coordinator.</p>\n<h2>The return of Curitiba&#8217;s WordPress Community</h2>\n<p>After WordCamp 2012, Curitiba&#8217;s community became inactive. But the urge to continue with the events stayed with me. It took me three years to take the first step. So I got in touch with other people from the Brazilian community that I had met at WordCamp, to find out what was needed to restart the meetings, which are called meetups, in Curitiba. Coincidentally, I found out three people who wanted to do the same and we started planning the event through Slack, a text chat software. In less than a month, we organized the <a href=\"https://www.meetup.com/pt-BR/wpcuritiba/events/224130389/\">first event</a>, on August 5, 2015. The most curious thing was that we were able to do all of the planning virtually, and only met for the first time in person on the day of the event.</p>\n<p>Due to the speed in which we were able to organize this event, it may seem that we already had experience with this type of organization, but in fact, we didn&#8217;t have much, if any. So the first thing we asked ourselves was, &#8220;What would be nice to have included in the event if we were attendees?&#8221;. And two things stood out: having food and fun. So we ordered food (pizza, for convenience) and we tried to make something funner and without many formalities. We didn&#8217;t want to have those events where hardly anyone talks to anyone and after the talk, everyone leaves like they&#8217;re running away from something.</p>\n<p>Keeping anyone from feeling lost, we made a brief presentation with slides at the beginning of the meetup, explaining what the event was and how it was organized, asking everyone to introduce themselves. This structure was maintained during all future events. Little by little, we carried out several experiments, such as a section where everyone could share news, themes, or plugin tips, or a classified section, where people could say if they were looking for or offering a particular service. Among the organizers, we always pre-arranged tips to be shared, in order to encourage others to participate. At first, few people engaged, but over time, they ended up becoming an important part of the event.</p>\n<p>As I was extremely shy, getting in front of people to introduce the meetup was not easy.</p>\n<blockquote><p>I was very nervous and ended up speaking very low, even stuttering a little. I wanted to change that and knew that the only way was to practice. I believe the meetup is a great place for this, as it is a small group of people with a common interest: learning.</p></blockquote>\n<p>This makes everyone more receptive, creating a safe environment to participate in a variety of ways.</p>\n<p>By the way, this is something very important to me: making the events an environment where everyone feels welcome and safe to ask questions and share experiences. Therefore, I always welcome new participants and encourage them to participate and talk to other people. Sometimes I retell the story of my first WordCamp, where I challenged myself to talk to three strangers.</p>\n<p>Nowadays, although I&#8217;m still a reserved person, I&#8217;m not so shy anymore and can speak in public without as much difficulty. Because of this personal achievement, whenever possible, I encourage others to give their first talk and also share all the tips I used, and still use, to make better presentations. I get very happy when I see people overcoming these challenges and growing personally and professionally. Despite having changed a lot, I still set a personal challenge to always do something to take me out of my comfort zone in each and every talk. Sometimes it doesn&#8217;t have the expected effect, but at least I have one more funny story to tell.</p>\n<p>It&#8217;s been more than six years since the first meetup (there was even a <a href=\"https://www.youtube.com/watch?v=vhYqoPaRsPo\">commemorative video</a>) and throughout this time the WordPress community in Curitiba has held monthly events. I confess that it is not easy to maintain this consistency, but it is very rewarding!</p>\n<h2>From developer to WordPress content creator</h2>\n<p>I&#8217;ve always enjoyed reading technology newsletters, but there weren&#8217;t any specific to WordPress in Brazil. After much contemplation (and procrastination) I decided to create a newsletter that prioritized the spreading of content in Portuguese. And, on June 22, 2019, I published the Zero edition of <a href=\"https://www.painelwp.com.br/\">PainelWP</a> (content in portuguese). Since then, I&#8217;ve searched and published the main news, tutorials, tips, events, and WordPress jobs weekly. My main goal with the newsletter is to inspire more people to create content about WP in Portuguese.</p>\n<p>As I learn a lot from reading tutorials and articles, this year (2021), I also started writing content regularly about WordPress on <a href=\"https://www.danielkossmann.com/category/wordpress/\">my blog</a> (content in portuguese). One of the publications I&#8217;m doing on behalf of PainelWP is to write about <a href=\"https://developer.wordpress.org/reference/functions/\">how to use WordPress&#8217;s native PHP functions</a> (content in portuguese), with code examples. Writing regularly is quite challenging, but it&#8217;s very rewarding and I learn a lot. I recommend creating a blog and posting on it regularly to all professionals who want to improve their knowledge. One idea is to keep a record of what you are learning on the blog.</p>\n<p>In addition, all of this is published under the <a href=\"https://creativecommons.org/licenses/by-sa/4.0/deed.en\">Creative Commons BY-SA license</a>, almost an equivalent of free software license for content. I chose this license because it makes it easy for content to be shared and used, like the WordPress source code.</p>\n<h2>The Importance of the WordPress Community</h2>\n<p>I believe that the great advantage and differential of WordPress, in addition to the numerous plugins and themes available, is its community. Because it&#8217;s an open platform and makes it easy to create websites, it attracts people with very different technical levels and backgrounds. This diversity helps create an open space for exchange, where everyone has something different to teach.</p>\n<p>This creates a connection both online and in person. It&#8217;s very satisfying to meet people in person at community events. From these encounters, I&#8217;ve made several lasting friendships. These contacts also have helped me a lot professionally. I&#8217;ve received several job referrals from them and I&#8217;ve also referred several people.</p>\n<p>An important tip I&#8217;ve learned in the WordPress community is: every time you&#8217;re in a conversation circle during events, leave a free space for a new person to join the circle. This format is also called <a href=\"https://ericholscher.com/blog/2017/aug/2/pacman-rule-conferences/\">the Pac-Man Rule</a>.</p>\n<p>If you&#8217;re not yet part of the WordPress community, I recommend looking for a meetup in your city, or nearby, to join. There are also several community meetings online now, which is a great opportunity to exchange knowledge with people from other cities. Hope you&#8217;ve enjoyed my story and see you at the next meetup or WordCamp!</p>\n<h1 id=\"portuguese\">Histórias de um colaborador em série</h1>\n<p>Oi! Meu nome é Daniel Kossmann. Utilizo WordPress desde 2009, sou um dos organizadores da Comunidade de WordPress de Curitiba, criador da newsletter semanal PainelWP e escrevo regularmente sobre WP em meu blog pessoal. Esta é a minha história antes e depois de começar a participar da comunidade do WordPress do Brasil. Boa leitura!</p>\n<h2>Primeiros contatos com a internet</h2>\n<p>Desde criança já gostava bastante de computadores e videogames, mas a internet abriu um mundo totalmente novo para mim. Fiquei tão fascinado que aos 11 anos, por volta de 1998, lendo tutoriais e analisando códigos HTML criei o meu primeiro site (sobre James Bond, eu era um grande fã). Nesses primeiros anos, apesar de meus pais não entenderem direito o que eu fazia e porque passava tantas horas em frente ao computador, eles me apoiaram comprando livros e computadores.</p>\n<p>Aos poucos fui aprendendo mais sobre programação e criando meus próprios sistemas em ASP e depois em PHP. Como existiam poucos sites em português que ensinavam programação, criei vários sites que ensinavam outras pessoas a criarem sites e adicionar pequenas funcionalidades neles (como contadores, áreas de login, textos piscando, …). Nesta época, também cheguei a criar meu próprio gerenciador de conteúdo, que aceitava o envio de conteúdo por colaboradores através de um formulário e fazia a publicação automaticamente todos os dias em um determinado horário (com um contador no site avisando quando seria a próxima atualização). Isto pode parecer bem trivial hoje em dia, mas naquele tempo ainda não era nada comum. Esta foi uma época bem divertida, onde passei várias madrugadas aprendendo coisas novas e conversando com outras pessoas que tinham o mesmo interesse no IRC, na falecida rede Brasnet. Se você ficou curioso para saber sobre essa época, veja a <a href=\"https://belohorizonte.wordcamp.org/2016/daniel-kossmann-ferraz-automacao/\">entrevista que o WordCamp Belo Horizonte 2016 fez comigo</a>.</p>\n<h2>Primeiros contatos com o WordPress</h2>\n<p>Quando chegou a hora de escolher um curso superior, não tinha dúvidas que seria algo relacionado à computação. Então entrei no curso de Ciência da Computação na Universidade Federal do Paraná (UFPR). Durante a faculdade, também queria experimentar outras áreas e decidi criar um blog para escrever críticas de filmes. Procurando por uma plataforma que fosse fácil de publicar textos para que eu não tivesse que me preocupar com códigos (já via isso todo dia no meu curso), descobri o WordPress. Não demorou muito e em 2009 criei meu primeiro blog público sobre cinema, que depois de um ano se transformou no <a href=\"https://www.interrogacao.com.br/\">interrogAção</a>, um portal cultural sobre cinema, literatura e quadrinhos, com colaboradores de várias cidades do Brasil. Assim como nos meus primeiros sites de tutoriais, e conversas do IRC, muitas dessas pessoas eu só conhecia virtualmente, mas tínhamos um contato intenso de troca de conhecimento.</p>\n<p>Apesar do meu foco estar mais voltado para criação e editoração de conteúdo, comecei a aprender mais sobre como funcionava a criação de temas e funcionalidades no WordPress para poder personalizar o site. Em uma dessas pesquisas, descobri que iria acontecer um evento só sobre o WP na minha cidade. Mesmo não sabendo ainda muito sobre o sistema, decidi me inscrever para poder aprender mais.</p>\n<h2>Primeiro contato com a comunidade</h2>\n<p>O evento era o <a href=\"https://curitiba.wordcamp.org/2010/\">WordCamp Curitiba 2010</a> e ainda lembro do quanto fiquei impressionado por ele ser tão barato (acho que foi R$60 ou menos), oferecer tantos brindes e ter lanches. Os outros eventos de tecnologia que havia participado sempre custaram mais que o dobro e não ofereciam nem metade dessas coisas.</p>\n<p>As palestras foram ótimas e todo mundo era sempre muito gentil e disponível. Fiquei tão empolgado com tudo, que prometi para mim mesmo que iria ajudar na próxima edição e também tentar palestrar nela. Como não conhecia ninguém no evento, defini como desafio pessoal falar com pelo menos três pessoas (eu era extremamente tímido). Duas delas acabaram se tornando amizades de longa data.</p>\n<p>No final do evento, descobri que haveria uma continuação chamada WordCana. Mesmo não gostando de beber, decidi ir e foi sensacional! Lá, conheci mais de perto os palestrantes, organizadores e participantes do evento. Todos falando de igual para igual. E o fato de não beber, não influenciou em nada minha interação com as outras pessoas.</p>\n<h2>De participante para organizador do WordCamp</h2>\n<p>A promessa que fiz durante o evento deu certo! Menos de dois anos depois, estava ajudando a organizar a próxima edição, o <a href=\"https://curitiba.wordcamp.org/2012/\">WordCamp Curitiba 2012</a>. Nele também fiz <a href=\"https://wordpress.tv/2012/10/11/daniel-kossmann-ferramentas-livres-para-desenvolvimento-wordpress/\">minha primeira palestra pública</a>. Eu continuava sendo muito tímido e durante a palestra, fiquei tão nervoso que não conseguia deixar o microfone perto da boca. Por conta disso, mesmo em uma sala pequena, as pessoas tiveram dificuldades para me escutar. Mesmo assim, foi uma importante experiência de superação, que me ajudou a continuar querendo melhorar minhas habilidades de falar em público em futuras palestras.</p>\n<h2>De usuário para empreendedor</h2>\n<p>Desde criança sonhava em abrir minha própria empresa e como gostava de criar sites, quando me formei em 2011, não tive muitas dúvidas sobre qual seria meu próximo passo: abrir uma empresa que desenvolve soluções para a internet. Chamei ela de Spirallab, por conta da minha paixão por espirais e pensando em torná-la um laboratório para projetos criativos. No início não defini muito um foco e trabalhei com vários sistemas e linguagens de programação diferentes. Aos poucos percebi que a manutenção dessas diferentes soluções estava ficando muito trabalhosa. Decidi que deveria utilizar apenas uma única plataforma e escolhi o WordPress, porque era fácil de ser utilizado pelo cliente e permitia a criação de diversos tipos de sites.</p>\n<p>Esta decisão me permitiu aprofundar muito mais no sistema, fazendo com que criasse soluções melhores e mais rápidas de entregar para meus clientes. Conforme o tempo foi passando, também aumentei as opções de serviços oferecidos em volta da plataforma: suporte, manutenção, hospedagem otimizada para WordPress (na época era extremamente difícil achar algo assim), cursos e consultorias. Isto permitiu uma diversificação maior de clientes. Também possibilitou uma especialização na plataforma, conhecendo todos os aspectos que a envolviam.</p>\n<p>Mesmo sendo uma empresa pequena (nunca passou de 4 pessoas), fiz questão de encontrar maneiras de contribuir com a comunidade do WordPress. Afinal, eu estava conseguindo sustentar o negócio sem precisar pagar nenhum centavo para utilizar a plataforma. Por isso ajudei a patrocinar vários WordCamps e meetups. Isso criava uma situação curiosa: o nome da Spirallab ficava ao lado de outros patrocinadores que tinham 10 ou 50 vezes o tamanho dela. Ficava então me perguntando porque não haviam mais empresas fazendo o mesmo. As cotas desses patrocínios iniciavam com um valor bem baixo (muitas vezes em R$250). Se formos considerar o faturamento de uma empresa que utiliza o WP como solução principal, acredito que este custo (ou investimento) poderia ser facilmente adicionado ao planejamento anual. Gostaria muito que mais empresas, independente do tamanho, fizessem isso.</p>\n<p>Além disso, palestrei em vários meetups e WordCamps, onde compartilhei o que havia aprendido no meu dia a dia. Sempre foi (e ainda é) uma satisfação muito grande poder fazer estas contribuições. Durante os eventos eu distribuía um adesivo da minha empresa que tinha a ilustração de um alquimista digital (uma espécie de mago moderno). Por conta disto, e do meu visual (cabelo comprido e barba), acabei ganhando o apelido de o Mago do WordPress.</p>\n<p>Oito anos depois da fundação da Spirallab, decidi encerrar as atividades da empresa e iniciei um novo capítulo na <a href=\"https://www.pipefy.com/\">Pipefy</a> em 2019, onde trabalho atualmente como coordenador de desenvolvimento WordPress.</p>\n<h2>O retorno da Comunidade de WordPress de Curitiba</h2>\n<p>Depois do WordCamp 2012, a Comunidade de Curitiba ficou inativa. Mas a vontade de continuar com os eventos continuou na minha cabeça. Demorei três anos para dar o primeiro passo. Então entrei em contato com outras pessoas da comunidade brasileira que tinha conhecido no WordCamp, para saber o que era necessário para voltar a fazer os encontros (também chamados de <i>meetups</i>) em Curitiba. Por coincidência, descobri que mais três pessoas estavam querendo fazer o mesmo e começamos a planejar o evento através do Slack (software de bate papo em texto). Em menos de um mês, organizamos o <a href=\"https://www.meetup.com/pt-BR/wpcuritiba/events/224130389/\">primeiro evento, no dia 5 de agosto de 2015</a>. O mais interessante foi que conseguimos fazer tudo isso virtualmente. Só no dia do evento que nós nos encontramos pessoalmente pela primeira vez.</p>\n<p>Pela velocidade que conseguimos organizar este evento, pode parecer que já tínhamos experiência neste tipo de organização, mas na verdade não tínhamos muita (ou nenhuma) experiência como organizadores. Por isso, a primeira coisa que nos perguntamos foi: o que seria legal ter, caso fossemos participantes? E duas coisas se destacaram: ter comida e ser divertido. Então pedimos comida (pizza, pela praticidade) e tentamos fazer algo mais divertido e sem formalidades. Não queríamos aqueles eventos onde quase ninguém fala com ninguém e depois da palestra todos vão embora como se estivessem fugindo de algo.</p>\n<p>Para que ninguém se sentisse perdido, no início do meetup fizemos uma breve apresentação com slides, explicando o que é o evento e como ele é organizado, pedindo para cada um se apresentar. Essa estrutura se manteve durante todos os próximos eventos. Aos poucos fomos fazendo vários experimentos. Desde uma seção onde todos podiam compartilhar uma notícia, dica de tema ou plugin, até um espaço para classificados, onde as pessoas poderiam dizer se procuravam ou ofereciam determinado serviço. Entre os organizadores, sempre combinamos previamente dicas para serem compartilhadas, de forma a estimular outras pessoas a participarem. No começo poucas pessoas participavam, mas com o tempo, estes momentos acabaram se tornando uma parte importante do evento.</p>\n<p>Como eu era extremamente tímido, ficar em frente a várias pessoas para apresentar o meetup não era nada fácil. Ficava muito nervoso e acabava falando bem baixo, até gaguejando um pouco. Queria mudar isso e sabia que o único jeito era praticar. Acredito que o meetup é uma ótima oportunidade para isto, por ser um grupo pequeno de pessoas com um interesse em comum: aprender. Isso faz com que todos sejam mais receptivos, criando um ambiente seguro para participar de várias formas.</p>\n<p>Aliás, isto é algo muito importante para mim: tornar os eventos um ambiente onde todas as pessoas se sintam bem vindas e seguras para fazerem perguntas e compartilharem experiências. Por isso, sempre dou boas vindas para os novos participantes e os incentivo a participarem e conversarem com outras pessoas do evento. Às vezes, conto a história do meu primeiro WordCamp, onde me desafiei a conversar com três pessoas desconhecidas.</p>\n<p>Hoje em dia, apesar de continuar sendo uma pessoa mais quieta, não sou mais tão tímido e consigo falar em público sem tanta dificuldade. Por conta desta superação pessoal, sempre que possível, incentivo outras pessoas a darem sua primeira palestra e também compartilho todas as dicas que utilizei (e ainda utilizo) para fazer melhores apresentações. Fico muito feliz quando vejo pessoas superando essas dificuldades e crescendo pessoalmente e profissionalmente. Apesar de ter mudado muita coisa, ainda utilizo como desafio pessoal fazer sempre algo para me tirar da zona de conforto em cada palestra (às vezes não tem o efeito esperado, mas pelo menos tenho mais uma história engraçada para contar).</p>\n<p>Já se passaram mais de seis anos desde o primeiro meetup (teve até um <a href=\"https://www.youtube.com/watch?v=vhYqoPaRsPo\">vídeo comemorativo</a>) e desde lá a comunidade de WordPress de Curitiba faz eventos mensalmente. Confesso que não é nada fácil manter essa consistência, mas é muito gratificante!</p>\n<h2>De desenvolvedor para criador de conteúdo sobre WordPress</h2>\n<p>Sempre gostei muito de ler newsletters sobre tecnologia, mas não havia nenhuma específica de WordPress no Brasil. Depois de muito contemplar (e procrastinar), decidi criar uma newsletter que priorizasse a divulgação de conteúdo em português. E, em 22 de junho de 2019, publiquei a edição zero do <a href=\"https://www.painelwp.com.br/\">PainelWP</a>. Desde lá, semanalmente procuro e divulgo as principais notícias, tutoriais, dicas, eventos e vagas de WordPress. Meu principal objetivo com a newsletter é inspirar mais pessoas a criarem conteúdo sobre WP em português.</p>\n<p>Como aprendo muito lendo tutoriais e artigos, também comecei a escrever regularmente este ano (2021) no <a href=\"https://www.danielkossmann.com/category/wordpress/\">meu blog conteúdo sobre WordPress</a>. Uma das publicações que estou fazendo por conta do PainelWP é escrever semanalmente sobre como utilizar <a href=\"https://developer.wordpress.org/reference/functions/\">funções nativas em PHP do WordPress</a>, com exemplos de códigos. Escrever regularmente é bem desafiador, mas é muito gratificante e aprendo bastante. Recomendo a todos os profissionais que querem aprimorar seus conhecimentos, criar um blog e postar regularmente. Uma ideia é manter um registro do que você está aprendendo no blog.</p>\n<p>Além disso, tudo isso é publicado sob a <a href=\"https://creativecommons.org/licenses/by-sa/4.0/deed.pt_BR\">licença Creative Commons BY-SA</a>, quase um equivalente do software livre para conteúdo. Escolhi esta licença pois facilita que o conteúdo seja compartilhado e utilizado, assim como o código fonte do WordPress.</p>\n<h2>A importância da comunidade de WordPress</h2>\n<p>Acredito que a grande vantagem e diferencial do WordPress, além dos inúmeros plugins e temas disponíveis, é a sua comunidade. Por ser uma plataforma aberta e facilitar a criação de sites, ele atrai pessoas com vários níveis técnicos e históricos muito diferentes. Esta diversificação ajuda a criar um espaço aberto para trocas, onde cada um tem algo diferente para ensinar.</p>\n<p>Isto cria uma conexão que se dá tanto online quanto presencialmente. É muito gratificante encontrar pessoas pessoalmente em eventos da comunidade. A partir desses encontros, fiz várias amizades duradouras. Estes contatos também me ajudaram bastante profissionalmente. Já recebi várias indicações para serviços a partir deles e também já indiquei várias pessoas.</p>\n<p>Uma dica importante que aprendi na comunidade de WordPress é: toda vez que estiver em uma roda de conversa durante os eventos, deixe um espaço livre para que uma nova pessoa possa se juntar à roda. Este formato também é chamado de <a href=\"https://ericholscher.com/blog/2017/aug/2/pacman-rule-conferences/\">regra do Pac-Man</a>.</p>\n<p>Se você ainda não faz parte da comunidade de WordPress, recomendo procurar um meetup na sua cidade (ou próximo dela) para participar. Também há várias comunidades fazendo encontros online agora, que são uma ótima oportunidade de trocar conhecimento com pessoas de outras cidades. Espero que você tenha gostado da minha história e nos vemos no próximo meetup ou WordCamp!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Nov 2021 11:00:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Daniel Kossmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: WordPress, Blogging, and the Things We Are Thankful For\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=126085\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:171:\"https://wptavern.com/wordpress-blogging-and-the-things-we-are-thankful-for?utm_source=rss&utm_medium=rss&utm_campaign=wordpress-blogging-and-the-things-we-are-thankful-for\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4246:\"<p class=\"has-drop-cap\">On Saturday, one side of my family held our pre-Thanksgiving reunion. It had been two years since we were able to do it. I offered to host this year when our previous venue&rsquo;s loss threatened to sideline the event for yet another year. Needless to say, I was exhausted by the time my last cousin and his wife got in the car and drove off toward their home in south Alabama.</p>\n\n\n\n<p>Sunday, the day after, was the first relaxing day I had taken in weeks. But, I am not one for spending the entire day dedicated to watching TV &mdash; except when <em>Squid Game</em> was released.</p>\n\n\n\n<p>Dusting off my rarely-used personal blog, I began to pen an update post on my National Novel Writing Month progress. Instead of actually doing that, at least until later in the night, I looked over years of published blog posts.</p>\n\n\n\n<p>There is a rich history there, at least to me. My blog is a journal of my personal memories going back to 2003. For 18 years, I have been writing something, spitting out words into what can sometimes feel like an endless void. That na&iuml;ve 19-year-old kid who was just setting foot into the online world was not thinking he would still be doing the same thing all these years later. He was just blogging. It was one part an extension of the angst-ridden notebooks he had filled as a teen. It was another part of a new and exciting journey.</p>\n\n\n\n<p>For around an hour or so, I simply clicked and read and clicked and read. It is an extraordinary time to be alive, to take part in this moment in history where anyone from all over the world could live those same memories with me. And I can read their blogs. I can read about their hopes and dreams, view galleries of their pets, or catch up on their goals for the new year.</p>\n\n\n\n<p>This is one of the reasons I subscribe to people&rsquo;s personal blog feeds more so than news or development sites. At the end of the day, everything we do here is about people.</p>\n\n\n\n<p>I took a deep dive through my archives, caught up with some fun moments I had shared with the world, and read over some of my old WordPress development tutorials. I even scanned through my obsession with Marie Kond&#333;s tidying rules.</p>\n\n\n\n<p>I was only disappointed that there were many moments that I decided not to share. I perused some of the notes from unpublished drafts of various instances of #WPDrama, discussions where I decided to keep my thoughts to myself rather than rock the boat. I skipped over headlines for books I had read but never reviewed. I remembered some life-changing moments that I never bothered to even write a draft about.</p>\n\n\n\n<p>Aside from reminiscing over the past half of my life, I realized that my blog is older than many people who are just starting their own blogging journeys. WordPress, which also <a href=\"https://wptavern.com/happy-18th-birthday-wordpress\">turned 18 this year</a>, is older than its next generation of users.</p>\n\n\n\n<p>I also realized that I simply enjoy blogging. I had never given it much thought before &mdash; the <em>why</em> behind my continued participation in this artform. Perhaps it is because I have something I want to say from time to time. Maybe it is simply therapeutic. In the end, it might not matter. However, I am grateful that we have platforms like WordPress that allow us all to do it, regardless of our reasons.</p>\n\n\n\n<p>As we close shop for the week for some much-needed rest, I am making a note to read through the bookmarked blog posts I have not gotten around to (thank you to everyone who has shared). I want to dive into the backlog of personal blogs I have yet to catch up on. I always check out every Tavern commenter&rsquo;s website when they leave a URL in the form. I do not always get around to them immediately, but I have found many blogs that I genuinely enjoy reading this way.</p>\n\n\n\n<p>Heading into this year&rsquo;s U.S. Thanksgiving holiday, I am reminded of how fortunate I am to be a part of the WordPress community. It is a living, breathing ecosystem that has always remained true to its blogging roots. The platform allows millions of people to share their voices while owning their content.  That alone is something worth being thankful for.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Nov 2021 00:05:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: WordPress 5.9 Revised Release Date Confirmed for January 25, 2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=126003\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:193:\"https://wptavern.com/wordpress-5-9-revised-release-date-confirmed-for-january-25-2022?utm_source=rss&utm_medium=rss&utm_campaign=wordpress-5-9-revised-release-date-confirmed-for-january-25-2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4210:\"<p>Last week WordPress 5.9&rsquo;s release leads found a consensus for <a href=\"https://wptavern.com/wordpress-5-9-delayed-until-january-2022\">delaying the release</a> after missing the deadlines for Beta 1 due to significant blockers. At that time they proposed a schedule for moving forward, and that is now <a href=\"https://make.wordpress.org/core/5-9/\">confirmed</a>. Beta 1 is planned for November 30, 2021, with subsequent betas in December. RC 1 is scheduled for January 4, 2022, and the official release is anticipated on January 25.</p>\n\n\n\n<p>For the past decade, Matt Mullenweg&rsquo;s <a href=\"https://make.wordpress.org/core/2010/04/20/deadlines-are-not-arbritrary-theyre-a/\">deadlines are not arbitrary</a> philosophy has guided core development, preventing  releases from being delayed by the desire to squeeze in one more feature:</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>Deadlines are not arbitrary, they&rsquo;re a promise we make to ourselves and our users that helps us rein in the endless possibilities of things that could be a part of every release. </p></blockquote>\n\n\n\n<p>Deadlines make it possible for agencies, product developers, and hosting companies with millions of WordPress customers, to prepare for upcoming releases in a predictable way that ultimately enables more sites to update regularly. The situation with WordPress 5.9 is unique, because the effort involves shipping a set of interdependent features that also provide the foundation for a new way of theming.</p>\n\n\n\n<p>&ldquo;As the FSE features are very closely intertwined, removing some of its pieces would risk making the release unstable,&rdquo; 5.9 Core Tech Lead Tonya Mork said in a <a href=\"https://make.wordpress.org/core/2021/11/22/wordpress-5-9-revised-release-schedule/\">post</a> announcing the new schedule. &ldquo;To avoid delivering a sub-optimal experience, moving fixes to a 5.9 minor or 6.0 was ruled out.&rdquo;</p>\n\n\n\n<p>Mork said the team considered punting full-site editing (FSE) and the Twenty Twenty-Two theme that depends on it to 6.0 but saw more benefit in shipping the collection of features sooner.</p>\n\n\n\n<p>&ldquo;The 6.0 release isn&rsquo;t due until April 2022&mdash;too long for the community to wait for them,&rdquo; Mork said. &ldquo;After processing this<a href=\"http://github.com/WordPress/gutenberg/issues/36556\">&nbsp;list of issues</a>,&nbsp;Core&nbsp;Editor team saw the features could ship in 5.9 with the revised schedule.&rdquo;&nbsp;</p>\n\n\n\n<p>Anne McCarthy, who is co-leading testing for the release, is in the trenches with FSE and wrote a <a href=\"https://nomad.blog/2021/11/23/why-i-voted-to-delay-wordpress-5-9/\">summary</a> of why she was proponent of delaying in this instance. She cited improved sustainability for contributors, and the value of users getting access to the whole suite of FSE features rather than smaller pieces, as factors in the decision.</p>\n\n\n\n<p>&ldquo;More specifically, if we were to push everything to 6.0, this would delay the Twenty Twenty-Two theme, hold back the launch of block themes in general, and delay a ton of user value in exploring ways to edit all parts of a site,&rdquo; McCarthy said.</p>\n\n\n\n<p>The decision to delay 5.9 to January 2022 has been met with positive feedback from all sides, and many following the progress have expressed their appreciation of the team&rsquo;s transparency throughout the decision-making process. It&rsquo;s reassuring to see the release leads acting in the interest of users and contributors, instead of forcing something half-baked forward. </p>\n\n\n\n<p>In the meantime, if you want a sneak peak of some newer features coming in 5.9, check out the video the release team <a href=\"https://wordpress.org/news/2021/11/a-look-at-wordpress-5-9/\">published</a> today. It showcases the amazing flexibility of the upcoming Twenty Twenty-Two theme and how much more you can do with WordPress without having to change to a different theme. If you want to be part of the team making FSE better for everyone, jump in and <a href=\"https://make.wordpress.org/test/tag/fse-testing-call/\">start testing</a> the new features ahead of the beta release.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 23 Nov 2021 23:20:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"WordPress.org blog: A Look at WordPress 5.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11625\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/news/2021/11/a-look-at-wordpress-5-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2465:\"<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>WordPress 5.9 is expected to be a ground-breaking release. It will introduce the next generation of themes with <a href=\"https://make.wordpress.org/core/2021/10/06/introducing-twenty-twenty-two/\">Twenty Twenty-Two</a> joining the fun and over 30 theme blocks to build all parts of your site. <a href=\"https://make.wordpress.org/core/5-9/\">In anticipation of the January 25th release</a>, we hope you enjoy this sneak peek of 5.9.</p>\n\n\n\n<p>New design tools will allow you to create exactly what you want, from adding filters to all your images to fine-tuning the border radius on all your buttons. With WordPress 5.9 providing more design control along with streamlined access to patterns, you can easily change the entire look and feel of your site without switching themes<strong>.</strong></p>\n\n\n\n<p>No matter what you’re editing, whether it&#8217;s crafting a new post or working on a header, improvements to List View make it simple to navigate content regardless of complexity. More improvements and features for everyone are to come in this release and we can&#8217;t wait to see what you create with WordPress 5.9! </p>\n\n\n\n<h2 id=\"stay-tuned\">Stay Tuned</h2>\n\n\n\n<p>Stay tuned for more updates as the date draws near. If you want to help, the best thing you can do is <a href=\"https://make.wordpress.org/core/handbook/testing/beta-testing/\">test everything</a>! For all the details, <a href=\"https://make.wordpress.org/core/2021/11/22/wordpress-5-9-revised-release-schedule/\">check out this Make Core post</a>.</p>\n\n\n\n<p><em>Video props: <a href=\"https://profiles.wordpress.org/annezazu/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>annezazu</a> (also co-wrote the post) <a href=\"https://profiles.wordpress.org/michaelpick/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>michaelpick</a> <a href=\"https://profiles.wordpress.org/matveb/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>matveb</a> <a href=\"https://profiles.wordpress.org/beafialho/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>beafialho</a> <a href=\"https://profiles.wordpress.org/javiarce/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>javiarce</a> <a href=\"https://profiles.wordpress.org/critterverse/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>critterverse</a> <a href=\"https://profiles.wordpress.org/joen/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>joen</a>.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 23 Nov 2021 21:02:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Kelly Hoffman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"WPTavern: GoDaddy Data Breach Exposes 1.2 Million Active and Inactive Managed WordPress Hosting Accounts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=125998\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:253:\"https://wptavern.com/godaddy-data-breach-exposes-1-2-million-active-and-inactive-managed-wordpress-hosting-accounts?utm_source=rss&utm_medium=rss&utm_campaign=godaddy-data-breach-exposes-1-2-million-active-and-inactive-managed-wordpress-hosting-accounts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3389:\"<p>In a disclosure to the U.S. Securities and Exchange Commission (SEC) that was <a href=\"https://www.sec.gov/Archives/edgar/data/1609711/000160971121000122/gddyblogpostnov222021.htm\">published today</a>, GoDaddy announced a data security breach impacting its WordPress managed hosting customers. The company discovered unauthorized third-party access to its hosting environment on November 17, 2021, through an exploited vulnerability.</p>\n\n\n\n<p>GoDaddy&rsquo;s initial investigations show the attacker gained access using a compromised password beginning on September 6, 2021. Nearly every sensitive data point associated with hosting a WordPress website was compromised, including customer email addresses, admin passwords, sFTP and database credentials, and SSL private keys. GoDaddy published the following summary of data the attacker had access to for more than two months:</p>\n\n\n\n<ul><li>Up to 1.2 million active and inactive Managed WordPress customers had their email address and customer number exposed. The exposure of email addresses presents risk of phishing attacks.</li><li>The original WordPress Admin password that was set at the time of provisioning was exposed. If those credentials were still in use, we reset those passwords.</li><li>For active customers, sFTP and database usernames and passwords were exposed. We reset both passwords.</li><li>For a subset of active customers, the SSL private key was exposed. We are in the process of issuing and installing new certificates for those customers.</li></ul>\n\n\n\n<p>GoDaddy has more than 20 million customers but only the managed WordPress hosting accounts were affected by this breach. Looking further into the incident, <a href=\"https://www.wordfence.com/blog/2021/11/godaddy-breach-plaintext-passwords/\">Wordfence claims that GoDaddy was storing sFTP credentials as plaintext</a>, although GoDaddy has not officially confirmed it:</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>GoDaddy stored sFTP passwords in such a way that the plaintext versions of the passwords could be retrieved, rather than storing salted hashes of these passwords, or providing public key authentication, which are both industry best practices.</p><p>We confirmed this by accessing the user interface for GoDaddy Managed Hosting and were able to view our own password&hellip;When using public-key authentication or salted hashes, it is not possible to view your own password like this because the hosting provider simply does not have it.</p></blockquote>\n\n\n\n<p>GoDaddy&rsquo;s stock tumbled after the SEC disclosure got picked up by major news organizations, finishing down&nbsp;5.25%. The company <a href=\"http://previous%20incidents:%20https://twitter.com/lenraleigh/status/1462974068588789769\">emailed its customers</a> to notify them that their accounts may have been compromised during the two months when the attacker had unauthorized access.</p>\n\n\n\n<img />\n\n\n\n<p>The incident has damaged customers&rsquo; trust and puts developers and agencies in an uncomfortable position if they are required to notify their customers about the breach. Impacted site owners will need to watch for malware, suspicious activity, and potential phishing attacks.</p>\n\n\n\n<p>Godaddy says it has already taken steps to further secure its provisioning system and is continuing its investigation with the help of an IT forensics firm and law enforcement.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 23 Nov 2021 04:55:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"WPTavern: How Do Post Formats Fit Into a Block Theme World?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=125982\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:161:\"https://wptavern.com/how-do-post-formats-fit-into-a-block-theme-world?utm_source=rss&utm_medium=rss&utm_campaign=how-do-post-formats-fit-into-a-block-theme-world\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5899:\"<p class=\"has-drop-cap\">Over the weekend, Nick Bohle asked Ellen Bauer of Elma Studio <a href=\"https://twitter.com/nickbohle/status/1462231308697018373\">how post formats fit into the block-theming world</a>. The question was a proposal for her a WordPress theme and FSE <a href=\"https://twitter.com/i/spaces/1ZkJzbaDPVgJv/peek\">chat she held yesterday</a> via Twitter Spaces. I could not attend and see if Bauer touched on the subject, but the question is something I have given a lot of thought to not that long ago.</p>\n\n\n\n<p>Over the summer, I <a href=\"https://twitter.com/justintadlock/status/1407208677795373056\">tweeted out a screenshot</a> of an experiment around post formats. A part of me was trying to figure out if we could revive a dying feature, one I continue to use today.</p>\n\n\n\n<img />Aside post format archive.\n\n\n\n<p>I have been using post formats since before they were a thing. &ldquo;Asides&rdquo; were one of the precursors to the feature landing in WordPress. I wrote my first on my personal blog back in 2006. I had borrowed some code that WordPress cofounder Matt Mullenweg had <a href=\"https://ma.tt/2004/05/asides/\">posted two years earlier</a>. It was a concept he had borrowed from others.</p>\n\n\n\n<p>For me, it was a way to give a unique layout to quick posts and links without all the beefiness of a long-form article.</p>\n\n\n\n<p>In 2011, WordPress 3.1 launched with a new taxonomy. Users could choose between nine different formats for their posts, assuming their theme supported one or more of them. The goal was to allow theme authors to design custom layouts around each one.</p>\n\n\n\n<p>For much of the community, it felt like WordPress was chasing Tumblr&rsquo;s post content feature. The allure quickly wore off after it seemed to have hit a standstill beyond its initial release. Besides a few fixes and trivial enhancements under the hood, post formats never amounted to much.</p>\n\n\n\n<p>They have remained a niche feature over the years. A few theme authors still add in support. Some of us old-school bloggers who have been using them in some form or fashion are still hanging on. But, post formats have been dead for a long time.</p>\n\n\n\n<p>Therefore, I decided to try to make them work for block themes.</p>\n\n\n\n<p>One of the most frustrating things I encountered with post formats in this block-based theme project was how powerless I felt over making them work &ldquo;the old way.&rdquo; The dynamic nature of classic theming meant that I could switch post content templates out on pages that listed multiple posts. Query Loop and its inner Post Template block do not allow me to show a different template for a quote or gallery-formatted post, for example.</p>\n\n\n\n<p>This was frustrating because that part of the design process was out of my hands. If I wanted to do something as simple as show an entirely different design for an aside post within a mix of normal posts, I could not do so as the theme designer, at least not without doing some hacky workarounds.</p>\n\n\n\n<p>My &ldquo;light bulb&rdquo; moment was when I realized that it was OK to not have that control. I needed to get outside of the mindset that the design was mine and mine alone. That is viewing creation through a classic theming lens. My approach was wrong. Instead, I had to start thinking about how to hand over these design tools to the user.</p>\n\n\n\n<p>The question became: Can I create something that utilizes that original post format concept while giving users the freedom to do what they want?</p>\n\n\n\n<p>Then, it dawned on me. The following is the response I tweeted to Jeff Chandler, who had <a href=\"https://twitter.com/jeffr0/status/1407211205685661700\">asked if I thought post formats</a> would work as patterns:</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>I think of blocks themselves as an evolution of post formats. Video, audio, embeds (basically cool links), quotes, etc. Most of the elements are already there. Patterns just give users an easy way to insert various designs, which could build off those blocks.</p></blockquote>\n\n\n\n<p>Maybe post formats as they currently exist are dead. However, the idea of designing a layout around specific types of posts is very much alive.</p>\n\n\n\n<p>If users want to embed a single video into a post, it is just a matter of copying and pasting a link. To share a quote they found from their favorite author, they merely need to drop it into a Quote block. Other than chat posts (let&rsquo;s just gloss over those entirely), the concept of post formats has simply been replaced with blocks.</p>\n\n\n\n<p>However, theme authors still have a role to play. If all the elements for post formats have been essentially replaced by blocks themselves, that means designers can have a field day building patterns around them.</p>\n\n\n\n<img />Patterns built for post formats.\n\n\n\n<p>That led me to build off my original idea for asides, my favorite post format. Instead of offering a single design, I built three different patterns for users to choose from. End-users could mix and match how they appeared on the front end.</p>\n\n\n\n<p>I also built a custom <code>taxonomy-post_format-aside.html</code> template to showcase them on their archive page. It merely displayed the published date and the post content, which the user controls.</p>\n\n\n\n<p>I went back to the drawing board and built a quote pattern that I liked. Again, it would be up to the user whether they wanted that particular design. They could always go in a different direction.</p>\n\n\n\n<img />Quote block pattern and custom style.\n\n\n\n<p>In some ways, post formats were always limiting. The feature was never fleshed out, and there were only nine allowed formats. At the end of the day, each was merely a term within a taxonomy. There were never any rules about how it all was supposed to work. Maybe that is not such a bad thing. Now, posts can be anything users want them to be.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 22 Nov 2021 23:57:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WordPress.org blog: Join us for State of the Word 2021, in person or online!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11611\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://wordpress.org/news/2021/11/join-us-for-state-of-the-word-2021-in-person-or-online/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1704:\"<p>As <a href=\"https://wordpress.org/news/2021/11/state-of-the-word-2021/\">previously announced</a>, State of the Word will be livestreamed from New York City. That means that you can join the fun either online or in person, on <a href=\"https://www.worldtimebuddy.com/?qm=1&lid=5128581,100&h=5128581&date=2021-12-14&sln=17-19&hf=0\">December 14, 2021, between 5 and 7 pm EST</a>!</p>\n\n\n\n<p>To join State of the Word 2021 online, check your Meetup chapter for a local watch party, or simply visit <a href=\"https://wordpress.org/news/\">wordpress.org/news</a>, where the livestream will be embedded.&nbsp;</p>\n\n\n\n<p>If you would like to participate in person in New York City, please request a seat by filling out the registration form by Sunday, November 28. Not all requests will receive a seat due to venue capacity, but everyone who requests one will receive further notification on Tuesday, November 30.&nbsp;</p>\n\n\n\n<p>In person attendees will be asked to show their COVID vaccination card at the venue entrance, and are expected to follow the safety measures in place. Because of these safety measures, there is a maximum of 50 attendees.&nbsp;</p>\n\n\n\n<div class=\"wp-container-61a081661ea97 wp-block-buttons\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://wordcampcentral.survey.fm/request-a-seat-sotw-2021\">Request a seat</a></div>\n</div>\n\n\n\n<p>Whether you participate in person or online, we are so excited to see you on December 14! Don’t forget, State of the Word will be followed by a Question &amp; Answer session. If you have a question for Matt, you can send your question ahead of time to ask-matt@wordcamp.org, or ask during the event in the YouTube chat.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 22 Nov 2021 21:08:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"Gutenberg Times: Creating a Poll Block for Gutenberg, Skins Are Back in Style, WordPress 5.9 in 2022 – Weekend Edition 193\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=19604\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"https://gutenbergtimes.com/creating-a-poll-block-for-gutenberg-skins-are-back-in-style-wordpress-5-9-in-2022-weekend-edition-193/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:20455:\"<p>Howdy!</p>\n\n\n\n<p>I am back from our trip to Chicago. It is a fun city even when it&#8217;s cold. I took it as a  training run for our Christmas travels to Canada in about four weeks. One afternoon, we walked Michigan Avenue, The Bean and the sculpture and botanical garden in Millennium Park. Another afternoon, we visited the Shedd Aquarium. It is definitely worth a visit should you ever get to Chicago. Their exhibition space is vast and wonderful.  My favorite section was the <a href=\"https://www.instagram.com/p/CWJxgUnAS7j/\">Caribbean Reef </a>with the most colorful corals, algae and fish. The greatest joy was however to spend some quality time with my coworkers at Automattic, Tara King and Ryan Welcher. Turns out we all like beer and scuba diving. </p>\n\n\n\n<p>Now back to Gutenberg News, WordPress release and State of the Word. I had fun catching up on all the good vibe from the community. </p>\n\n\n\n<p>Stay warm, stay calm, be brave and wait for the signs.<sup>1</sup></p>\n\n\n\n<p>Yours, 💕<br />Birgit</p>\n\n\n\n<p class=\"has-small-font-size\"><sup>1</sup> <em>Canadian Cree</em></p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>Monday, November 22nd, 2021 at 7pm ET / 00:00 UTC </strong> join us for WordPress Meetup organized by the group in Montclair, NJ. I will talk about <a href=\"https://www.meetup.com/WordPress-Montclair-Meetup/events/281915481/\"><strong>What is Full-Site Editing?</strong></a> and answer questions from participants. I am looking forward to seeing friends there and make new ones. </p>\n\n\n\n<a href=\"https://www.meetup.com/WordPress-Montclair-Meetup/events/281915481/\"><img /></a><a href=\"https://www.meetup.com/WordPress-Montclair-Meetup/events/281915481/\"><em>RSVP and get the Zoom Link</em></a>\n\n\n\n\n<p><strong>Table of Contents</strong></p>\n\n\n\n<div class=\"wp-block-sortabrilliant-guidepost\"><ul><li><a href=\"https://gutenbergtimes.com/feed/#the-gutenberg-minute\">The Gutenberg Minute</a></li><li><a href=\"https://gutenbergtimes.com/feed/#gutenberg-team-and-core-wordpress-updates\">Gutenberg Team and Core WordPress updates</a><ul><li><a href=\"https://gutenbergtimes.com/feed/#gutenberg-11-9-and-11-9-1-has-been-released\">Gutenberg 11.9 and 11.9.1 has been released. </a></li></ul></li><li><a href=\"https://gutenbergtimes.com/feed/#theme-builders-and-block-themes\">Theme Builders and Block Themes</a></li><li><a href=\"https://gutenbergtimes.com/feed/#developing-for-gutenberg-and-building-custom-blocks\">Developing for Gutenberg and Building Custom Blocks </a></li><li><a href=\"https://gutenbergtimes.com/feed/#gutenberg-for-site-builders-and-content-creators\">Gutenberg for Site Builders and Content Creators</a></li><li><a href=\"https://gutenbergtimes.com/feed/#wordpress-events\">WordPress Events</a></li></ul></div>\n\n\n\n\n<h2 id=\"the-gutenberg-minute\">The Gutenberg Minute</h2>\n\n\n\n<p>As part of the WP Minute podcast, we record a minute of Gutenberg updates to be added to the show. Here is this week&#8217;s content. </p>\n\n\n\nGutenberg Minute November 2021  for this week&#8217;s <a href=\"https://thewpminute.com/pagedaddy/\">WPMinute </a>episode\n\n\n\n<ul><li><a href=\"https://wordpress.org/themes/tags/full-site-editing/\">WordPress Theme Repository &#8211; List of Block Themes </a></li><li><a href=\"https://github.com/WordPress/gutenberg/pull/36332\">Update theme.json schema to refer to wp.org URL </a></li><li><a href=\"https://github.com/WordPress/gutenberg/pull/34843\">Add API to access global settings, styles and stylesheet </a></li><li><a href=\"https://make.wordpress.org/test/2021/11/08/fse-program-testing-call-11-site-editing-safari/\">Call for Testing: Site Editing Safari</a></li></ul>\n\n\n\n<p>Big Thank You to Matt Medeiros for including the segment every month. </p>\n\n\n\n<p><em>Updates: The Full-Site Editing will come to WordPress 5.9, however not on December 14th. There are now 28 block themes in the WordPress repository. </em></p>\n\n\n\n<h2 id=\"gutenberg-team-and-core-wordpress-updates\">Gutenberg Team and Core WordPress updates</h2>\n\n\n\n<p>The Beta 1 for WordPress 5.9 release has been moved to November 30th, 2021, due to not enough time to fix FSE interface issues for users. This also moves the date for the final release to January 2021. The new proposed schedule has January 25th, 2021 as release date. </p>\n\n\n\n<ul><li><strong>Tonya Mork</strong>, Core Tech Release lead posted <a href=\"https://make.wordpress.org/core/2021/11/17/wordpress-5-9-beta-1-delayed/\">more details on the Make Core blog.</a></li><li><strong>Robert Anderson</strong>, Editor Tech Release lead, posted <a href=\"https://github.com/WordPress/gutenberg/issues/36556\">the list of pending issues and blockers</a>. </li><li><strong>Sarah Gooding</strong> posted <a href=\"https://wptavern.com/wordpress-5-9-delayed-until-january-2022\"><strong>WordPress 5.9 Delayed Until January 2022</strong></a></li></ul>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>If you want to assist in testing Beta and release candidate versions, <strong><a href=\"https://twitter.com/courtneyr_dev\">Courtney Robertson</a></strong>, held a panel discussion  with Core Contributors George Mamadashvili, Andy Fragen and yours truly on the various options to test upcoming versions. The recording is available now <a href=\"https://www.godaddy.com/garage/gutenberg-how-to-test-the-latest-updates/\"><strong>Testing the latest features in WordPress</strong></a> with resources and links. </p>\n\n\n\n<p>After the Beta 1 release, you only need to install the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester plugin</a> and set it to c<em>hannel</em> <strong>Bleeding Edge</strong> and <em>stream </em><strong>Beta/RC Only</strong>. </p>\n\n\n\n<img />Setting <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester Plugin</a> for testing Beta and Release Candidates during the release cycle of an new WordPress version. \n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s main (trunk) branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total\" /></p>\n\n\n\n\n<h3 id=\"gutenberg-11-9-and-11-9-1-has-been-released\">Gutenberg 11.9 and 11.9.1 has been released. </h3>\n\n\n\n<p>Just before the <em>Feature Freeze</em> of the WordPress 5.9 release cycle, Gutenberg 11.9 was released. <a href=\"https://twitter.com/andrewserong\"><strong>Andrew Serong</strong></a> published the release notes in <strong><a href=\"https://make.wordpress.org/core/2021/11/12/whats-new-in-gutenberg-11-9-0-10-november/\">What’s new in Gutenberg 11.9.0 (10 November)</a></strong>.</p>\n\n\n\n<p><strong><a href=\"https://twitter.com/justintadlock\">Justin Tadlock</a></strong> posted the details as well: <a href=\"https://wptavern.com/gutenberg-11-9-focuses-on-navigation-menus-and-block-theming\"><strong>Gutenberg 11.9 Focuses on Navigation Menus and Block Theming</strong></a></p>\n\n\n\n<p>In&nbsp;<strong><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-55-gutenberg-11-9-wordpress-5-9-navigation-block/\">Gutenberg Changelog newest episode (#55)</a></strong>,&nbsp;<strong><a href=\"https://twitter.com/gziolo\">Grzegorz (Greg) Ziolkowski</a> </strong>and I discuss Gutenberg 11.9, WordPress 5.9 and Navigation Block. Surprise guest: <strong><a href=\"https://twitter.com/riadbenguella\">Riad Benguella.</a></strong> Listen in and <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><em><strong>write us a review.</strong></em></a></p>\n\n\n\n\n<p><strong>Subscribe to the&nbsp;<a href=\"https://gutenbergtimes.com/podcast/\">Gutenberg Changelog</a>&nbsp;podcast </strong><br />🎙️&nbsp;<a href=\"https://open.spotify.com/show/620NwVKQJGdTupy36zYxvg?mc_cid=4b6c9f88fe\">Spotify</a>&nbsp;|&nbsp;<a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9ndXRlbmJlcmd0aW1lcy5jb20vZmVlZC9wb2RjYXN0\">Google</a>&nbsp;|&nbsp;<a href=\"https://podcasts.apple.com/us/podcast/gutenberg-changelog/id1469294475\">iTunes</a>&nbsp;|&nbsp;<a href=\"https://pca.st/podcast/f8445ec0-7508-0137-f267-1d245fc5f9cf\">PocketCasts</a>&nbsp;|&nbsp;<a href=\"https://www.stitcher.com/show/gutenberg-changelog\">Stitcher</a>&nbsp;|<br />🎙️&nbsp;<a href=\"https://www.podbean.com/podcast-detail/chi7j-9904a/Gutenberg-Changelog-Podcast\">Pod Bean</a>&nbsp;|&nbsp;<a href=\"https://castbox.fm/channel/Gutenberg-Changelog-id2173375\">CastBox</a>&nbsp;|&nbsp;<a href=\"https://www.podchaser.com/podcasts/gutenberg-changelog-878239/\">Podchaser</a>&nbsp;|&nbsp;<a href=\"https://gutenbergtimes.com/feed/podcast\">RSS Feed</a>&nbsp;</p>\n\n\n\n<img />\n\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2021&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test and Meta team from Jan. 2021 on. Updated by yours truly.  </p>\n\n\n\n\n<h2 id=\"theme-builders-and-block-themes\">Theme Builders and Block Themes</h2>\n\n\n\n<p><strong><a href=\"https://twitter.com/ellenbauer\">Ellen Bauer</a> </strong>wrote an <strong><a href=\"https://www.elmastudio.de/en/theme-json-for-wordpress-block-themes-explained/\">Introduction to Theme.json</a></strong> and explained how the  configuration choices work together to manage a build a block theme, like Aino and can be used in Classic themes as well. Bauer also invites you to a Twitter Spaces conversation on November 21, 2021 at 2pm to the <strong><a href=\"https://twitter.com/i/spaces/1ZkJzbaDPVgJv?s=20\">WordPress FSE &amp; block theme chat</a></strong></p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>In his article <a href=\"https://wptavern.com/skins-are-back-in-style-proposal-for-themes-to-bundle-user-selectable-design-variations\"><strong>“Skins” Are Back in Style, Proposal for Themes To Bundle User-Selectable Design Variations</strong></a>, Justin Tadlock commented on a Proof of Concept by Riad Benguella, who explored &#8220;a way for extenders to offer multiple global styles variations and the user would be able to pick up one of the variation for its site.&#8221; (<a href=\"https://github.com/WordPress/gutenberg/pull/35619\"><em>on Github</em></a>). </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/critterverse\">Channing Ritter</a></strong> also experimented and explored the possibility of <a href=\"https://critterverse.blog/2021/11/10/a-global-styles-switcher/\">switching out different style settings within the Global Styles panel</a>. In the comments, Ritter mentioned that a feature like that could make it fairly quickly into the Gutenberg plugin for users to test. </p>\n\n\n\n<h2 id=\"developing-for-gutenberg-and-building-custom-blocks\">Developing for Gutenberg and Building Custom Blocks </h2>\n\n\n\n<p>The latest Decode Podcast episode is titled <strong><a href=\"https://developers.wpengine.com/podcast/9511712\">Gutenberg with Jason Bahl</a>.</strong>  <strong>Kellen Mace</strong> and <strong>Will Johnston</strong>, talked to <strong><a href=\"https://twitter.com/jasonbahl\">Jason Bahl</a></strong>, creator and maintainer of <a href=\"https://www.wpgraphql.com/\">WPGraphQL</a> plugin and ecosystem,  about the benefits of Gutenberg, what&#8217;s lacking in Gutenberg&#8217;s current implementation, and what implementations exist for rendering Gutenberg in headless WordPress.</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/mattwatsoncodes\">Matt Watson</a></strong> shared his experience in <a href=\"https://wpowls.co/articles/creating-a-custom-block-for-wp-owls/\"><strong>Creating a Custom Block for WPOwl</strong></a>. The task was a Link block displaying and image a text blurb and a URL. Watson then described his implementation journey and covers these steps: </p>\n\n\n\n<ul><li>Building a Reusable Block, </li><li>Convert it to a Block Pattern</li><li>Why use a Block instead of a Pattern</li><li>Create a Block WordPress Script</li><li>Write the edit.js and save.js functions </li><li>Create Block Styles and Variations. </li></ul>\n\n\n\n<p>The final block is now used on the <a href=\"https://wpowls.co/wpowls-60/\"><em>WPOwls newsletter.</em></a> You can study the <a href=\"https://github.com/wholesomecode/wp-owls-owl-link\">code via the public GitHub repository</a></p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>Editor <strong><a href=\"https://twitter.com/palmiak_fp\">Maciek Palmowski</a></strong> announced the <a href=\"https://wpowls.co/the-owl-link-challenge/\"><strong>WPOwls Challenge </strong></a>for the WordPress community to build a similar block with different tools. Besides the version built as Block Patterns and Native Custom Blocks (ReactJS) they already have versions built with ACF Blocks, and via Block Builder plugin. There are other tools available, for instance you could us <a href=\"https://wordpress.org/plugins/genesis-custom-blocks/\">Genesis Custom Blocks</a> or <a href=\"https://wordpress.org/plugins/lazy-blocks/\">Lazy Blocks</a> or a <a href=\"https://developer.wordpress.org/block-editor/how-to-guides/block-tutorial/creating-dynamic-blocks/\">Dynamic Block</a>. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/ryanwelcher\">Ryan Welcher</a></strong> live-coded again this week. He walked us through the first part of <a href=\"https://www.youtube.com/watch?v=G6sxo9tpRvA\">Creating a Poll Block for Gutenberg</a> using <a href=\"https://react-google-charts.com/\"><em>React Google Charts</em></a> and the native <em><a href=\"https://developer.wordpress.org/block-editor/getting-started/create-block/\">WordPress Create Block</a></em> script. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/joe_hoyle\">Joe Hoyle</a></strong>, co-founder and CTO of HumanMade, published an experimental library to render custom Gutenberg blocks built in React (front-end) on the server (using PHP V8JS).  Hoyle wrote in the Readme file of the <a href=\"https://github.com/humanmade/block-editor-ssr\"><strong>repository Block Editor SSR</strong></a> &#8220;Building blocks that will render as a React-app on the front end has many possible architectures and solutions. Block Editor SSR expects blocks to be built in a&nbsp;<em>certain</em>&nbsp;way (the way that made most sense to me). Before detailing how Block Editor SSR will server-render and hydrate your custom React block, first let&#8217;s go over how building custom blocks in React (front end) is expected to go.&#8221;</p>\n\n\n\n<h2 id=\"gutenberg-for-site-builders-and-content-creators\">Gutenberg for Site Builders and Content Creators</h2>\n\n\n\n<p><a href=\"https://twitter.com/kathyzant\"><strong>Kathy Zant,</strong></a> new product marketing manager for KadenceWP, <a href=\"https://www.kadencewp.com/blog/introducing-kadence-conversions/\"><strong>introduced the new premium plugin, Kadence Conversation</strong></a>, as a no-code interface to create lightweight and performant popups, modals, slide-ins, and banners for your site. At the time of this post, the plugin is available via Black Friday sale at 40% off. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p>In his tutorial, <strong><a href=\"https://twitter.com/scruffian\">Ben Dwyer</a></strong> explains how to use the plugin <strong><a href=\"https://themeshaper.com/2021/11/17/create-a-blockbase-child-theme/\">Create A Blockbase Child&nbsp;Theme</a></strong>  and employ the existing tools to modify a Blockbase theme, and then export a bundle of templates and theme.json as a new child theme. <a href=\"https://wptavern.com/automattic-theme-team-releases-a-plugin-to-build-blockbase-child-themes\"><em>Justin Tadlock wrote about it, too.</em></a> </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><em>Block Theme No 28 </em>was added to the WordPress Theme repository. <strong><a href=\"https://twitter.com/justintadlock\">Justin Tadlock</a></strong> took it out for a spin and shared his findings: <a href=\"https://wptavern.com/wowmall-a-free-experimental-woocommerce-block-theme\"><strong>Wowmall: A Free Experimental WooCommerce Block Theme</strong></a>. Tadlock wrote: &#8220;For an eCommerce theme, it is much cleaner than others I have seen, and it leverages almost every piece of the block system. It ships over 30 block patterns.&#8221;</p>\n\n\n\n<h2 id=\"wordpress-events\">WordPress Events</h2>\n\n\n\n<p><strong>November 22, 2021 &#8211; 7pm ET / 22:00 UTC</strong><br /><strong><a href=\"https://www.meetup.com/WordPress-Montclair-Meetup/events/\" rel=\"nofollow\">Meetup Montclair, New Jersey</a></strong><br /><strong>What is Full-Site Editing?</strong> w/ Birgit Pauli-Haack</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>November 23, 2021 &#8211; 10:00 am EST / 15:00 UTC</strong><br /><strong><a href=\"https://www.meetup.com/wordpress-social-learning/events/282149151/\">WordPress Social Learning</a></strong><br /><strong>Discussion: Discovering theme.json for WordPress themes</strong> with Daisy Olson</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>November 27th, 2021</strong><br /><strong><a href=\"https://saopaulo.wordcamp.org/2021/\">WordCamp São Paulo</a></strong></p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>December 11 + 12, 2021</strong><br /><a href=\"https://taiwan.wordcamp.org/2021/\"><strong>WordCamp Taiwan</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>December 14th, 2021 &#8211; 5:00 pm ET / 22:00 UTC</strong><br /><strong><a href=\"https://wordpress.org/news/2021/11/state-of-the-word-2021/\">WordPress News</a></strong><br /><strong>State of The Word w/ Matt Mullenweg</strong> + Q &amp; A</p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>February 4+5, 2022<br /><a href=\"https://birmingham.wordcamp.org/2022/\">WordCamp Birmingham, AL</a></strong><br />Call for Sponsors and Speakers are open now. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p><strong>March 4th, 2022 all day<br /><a href=\"https://www.wordfest.live/2022/march/\">WordFest 2022</a></strong><br />a 24-hour festival of WordPress. <a href=\"https://www.wordfest.live/2022/march/call-for-speakers/\">Call for Speakers is open</a>. Deadline Dec 6th, 2021. </p>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p class=\"has-drop-cap\">On the<a href=\"https://wpcalendar.io/online/\">&nbsp;<strong>Calendar for WordPress Online Events</strong>&nbsp;</a>site, you can browse a list of the upcoming WordPress Events, around the world, including WordCamps,  WooCommerce, Elementor, Divi Builder and Beaver Builder meetups.</p>\n\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n<p class=\"has-text-align-center\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\">Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator is-style-wide\" />\n\n\n\n\n\n<p><a href=\"https://www.flickr.com/photos/13998657@N02/18526571462\" target=\"_blank\" rel=\"noreferrer noopener\"></a><a href=\"https://www.flickr.com/photos/51035555243@N01/38744499\" target=\"_blank\" rel=\"noreferrer noopener\"></a>Featured image: <a href=\"https://americanart.si.edu/artwork/baby-blocks-112064\">&#8220;Baby Blocks&#8221;&nbsp;by&nbsp;Bessie Ely&nbsp;is licensed under&nbsp;CC0 1.0</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 20 Nov 2021 06:42:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: Automattic Theme Team Releases a Plugin To Build Blockbase Child Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=125905\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:207:\"https://wptavern.com/automattic-theme-team-releases-a-plugin-to-build-blockbase-child-themes?utm_source=rss&utm_medium=rss&utm_campaign=automattic-theme-team-releases-a-plugin-to-build-blockbase-child-themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4388:\"<p class=\"has-drop-cap\">On Wednesday, Ben Dwyer <a href=\"https://themeshaper.com/2021/11/17/create-a-blockbase-child-theme/\">announced a new block-based plugin</a> on the Theme Shaper blog. The Automattic Theme Team had built a <a href=\"https://github.com/Automattic/create-blockbase-theme\">child theme creator</a> for its Blockbase WordPress parent theme.</p>\n\n\n\n<p><a href=\"https://wordpress.org/themes/blockbase/\">Blockbase</a> has quickly started filling the role of Underscores, a starter that many developers used to create custom themes in the classic era. For block templating and global styles, something fresh was needed. It is both a launchpad and educational tool for theme authors who want to test the block theme waters.</p>\n\n\n\n<p>The approach is different now than in the past. Instead of using Blockbase as a customizable starting point, which is still a valid use case, the Automattic Theme Team is leaning far more heavily into child theming. It is a single parent to raise a legion of children, and the family has grown at a rapid pace. Since releasing Blockbase on WordPress.org, the team has already launched five child themes for it. Their <a href=\"https://github.com/Automattic/themes\">themes repo on GitHub</a> shows several others in progress.</p>\n\n\n\n<p>With the talent in the team&rsquo;s arsenal and the Create Blockbase Theme plugin at hand, they could spit out design after design after design. Of course, the child themes might begin to lose some of their flavor if the team moved too fast.</p>\n\n\n\n<p>Dwyer created a custom theme called Typewriter, which is downloadable via the announcement post. For my test, I did not go quite as far with customization and relied on one of the pre-existing color schemes from Blockbase.</p>\n\n\n\n<img />\n\n\n\n<p>I primarily wanted to get a feel for how the tool worked. After a bit of tinkering, I had something that still felt much like its parent with some simple changes.</p>\n\n\n\n<p>To use the plugin, users must install and activate the Blockbase theme. Until WordPress 5.9 is released, the Gutenberg plugin is necessary too. Currently, there are two places to make stylistic changes. The first is in the site editor. I made some adjustments to the header template part and index template. I also changed a few global styles.</p>\n\n\n\n<img />Customizing the index template and global styles.\n\n\n\n<p>The second place to modify the theme&rsquo;s design is via the customizer, which Blockbase enables (it is not accessible by default with block themes). The long-term goal should move all of these extra customizations to the site editor when it handles all the necessary use cases, such as a <a href=\"https://wptavern.com/proposed-web-fonts-api-not-coming-to-wordpress-5-9-possibly-landing-in-gutenberg-first\">web fonts API</a>.</p>\n\n\n\n<p>After switching the color scheme and selecting a couple of custom fonts, I had everything in place.</p>\n\n\n\n<img />Selecting a custom font.\n\n\n\n<p>After I had all the customizations I wanted, I headed over to Appearance &gt; Create Blockbase Theme in the admin. The page has a handful of fields to fill in &mdash; just basic theme info. Once I was finished, clicking the &ldquo;Create Blockbase Theme&rdquo; created a downloadable ZIP file.</p>\n\n\n\n<img />Generating a Blockbase child theme.\n\n\n\n<p>Everything worked. The only issue I ran into was with the theme folder slug when using a multi-word theme name. <code>Tavern Test</code> became <code>tavern_test.zip</code>. It is standard practice to hyphenate theme folders instead of using an underscore to separate multiple words.</p>\n\n\n\n<p>The plugin does add a blank <code>screenshot.png</code> file. Creators will want to change that if they intend to publicly release their custom child theme.</p>\n\n\n\n<p>This is the sort of future I have long imagined for the WordPress theme space, one that can empower anyone to create designs of their own. It is a future where an end-user, even a non-coder, can tinker around for a while, export whatever they have built, and share it with others.</p>\n\n\n\n<p>We are not at that point with WordPress itself. The site editor currently allows users to export their templates. However, I hope that this same functionality is extended to exporting a fully-installable parent or child theme in the future. The basis of democratizing design means that everyone can give it a go without learning to code.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 19 Nov 2021 23:42:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"WPTavern: WordPress 5.9 Delayed Until January 2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=125857\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:145:\"https://wptavern.com/wordpress-5-9-delayed-until-january-2022?utm_source=rss&utm_medium=rss&utm_campaign=wordpress-5-9-delayed-until-january-2022\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6511:\"<img />photo credit: <a href=\"https://flickr.com/photos/bionicteaching/5948497535/in/photolist-a4DB5k-ddR7m6-2hY62pS-2j1SNKo-2gVgBDF-2iQKbJz-2mpRzg5-o5uNv-2kZXTrc-2kaA4cG-2ipXyyx-2i1FMBL-2hczLX3-2gVikgB-2kHAzjL-2gNm6zQ-4FqcGi-7GRAo8-2gNkmv2-2gNkms1-2m7Fjzj-2hy98BL-2iABt8S-2jcVFsu-R46BYR-atjfJF-cJjJXb-2jNysNx-2kRrhRt-RaqGFB-2hzjuNi-2hxXktV-2hzoRjj-2hy7SMX-2hYCngf-2g5DqMg-2eq7vbd-Fi1aN3-Q9DhTa-2hzp4eS-2hxJzsN-j1RYuM-RNKgg5-2kNMrwW-TAdgqb-rPgJLf-2cw8mMR-2gNm6Dc-2j4c5D2-2hdmx5p\">Tom Woodward</a>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2021/11/17/wordpress-5-9-beta-1-delayed/\">WordPress 5.9 has been delayed</a> due to significant blockers that could not be resolved in time for Beta 1, which was previously <a href=\"https://make.wordpress.org/core/2021/09/03/wordpress-5-9-planning-roundup/\">scheduled</a> to be released November 16. The 5.9 release team came to the decision after a lengthy deliberation on the impact a delay will have on users and contributors. </p>\n\n\n\n<p>Robert Anderson, Editor Tech Lead for 5.9, published <a href=\"https://github.com/WordPress/gutenberg/issues/36556\">a summary of the blockers</a> that were found while testing full-site editing in&nbsp;core&nbsp;this week. They are identified as either blockers for beta 1 or blockers for 5.9.</p>\n\n\n\n<p>&ldquo;Historically (and even in the linked post), &lsquo;<a href=\"https://make.wordpress.org/core/2010/04/20/deadlines-are-not-arbritrary-theyre-a/\">deadlines are not arbitrary</a>&lsquo; has referred to the ability to cut features that aren&rsquo;t quite ready yet, and include them in a future release,&rdquo; Gary Pendergast commented on the post announcing 5.9 beta 1 as delayed. &ldquo;Are there particular reasons for why this philosophy has been re-interpreted?&rdquo;</p>\n\n\n\n<p>Tonya Mork, Core Tech Lead for the 5.9 release, responded with an explanation that FSE is going to have to be a package deal. </p>\n\n\n\n<p>&ldquo;Removing those areas that need fixing were ruled out as they are too intertwined into FSE and would make it unstable,&rdquo; Mork said. &ldquo;Punting fixes was ruled out as these meant delivering a &lsquo;half-baked&rsquo; experience.</p>\n\n\n\n<p>&ldquo;The choice is between shipping these major features in 5.9 with a delay or moving these major features to 6.0 to ship in the spring.</p>\n\n\n\n<p>&ldquo;Impacts were assessed. Shipping these major features sooner than later were determined to be more beneficial with less impact.&rdquo;</p>\n\n\n\n<p>Others commenting on the post shared concerns about the features possibly being rushed after seeing the list of blockers.</p>\n\n\n\n<p>&ldquo;My initial reaction when reading the&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues/36556\">Overview of WP 5.9 pending issues and blockers</a>&nbsp;-issue on&nbsp;Gutenberg&nbsp;repository was &lsquo;holy smokes, there are so many open issues and blockers,\'&rdquo; Timi Wahalahti said.</p>\n\n\n\n<p>&ldquo;Nevertheless, from the viewpoint of a developer working in an agency and having 150+ client sites to look after, I do have similar concerns that Gary and Addison (in the Gutenberg repo issue) have already shared about rushing features out. After seeing the&nbsp;blocker&nbsp;list and reading how new major features are still under works, I&rsquo;d be very uncomfortable on updating to 5.9 after releasing it, knowing that some features were probably finished in a hurry.&rdquo;</p>\n\n\n\n<p>Contributors on GitHub cautioned that the new flows for FSE features have not been adequately tested and should not be shipped just days after landing major changes. </p>\n\n\n\n<p>&ldquo;I think there are some large red flags here that some things are not ready for 5.9,&rdquo; Gutenberg contributor Addison Stavlo said. &ldquo;Overall, it seems like right now we are rushing things in a dangerous way. We targeted 5.9 as the release for these items in core but too many things are just not ready, hence the rushing to change so many things at the last minute. Wouldn&rsquo;t it be better to miss the expected target date than to rush potentially regrettable decisions and brand new flows into core WP at the last minute?&rdquo;</p>\n\n\n\n<p>The new proposed schedule, which has not yet been officially confirmed, is as follows:</p>\n\n\n\n<ul><li>Nov 30 &ndash; Beta 1 (2 weeks from now)</li><li>Dec 7 &ndash; Beta 2</li><li>Dec 14 &ndash; Beta 3</li><li>Dec 21 &ndash; Beta 4 (optional)</li><li>Jan 4 &ndash; RC 1 (5 weeks from Beta)</li><li>Jan 11 &ndash; RC2</li><li>Jan 18 &ndash; RC 3</li><li>Jan 25 &ndash; Release date</li></ul>\n\n\n\n<p>At the time of publishing, all 18 contributors who weighed in on <a href=\"https://wordpress.slack.com/archives/C02JUSF02TT/p1637262875087500\">a poll in the 5.9 release leads slack channel</a> are in favor of the proposed new schedule. More blockers are being resolved and should continue throughout the weekend, but the delay to Beta 1 makes it inevitable that the stable release will be pushed back to January.</p>\n\n\n\n<p>The remaining consideration is whether or not FSE will be on track for inclusion in 5.9 or if it will need to be shipped in 6.0.</p>\n\n\n\n<p>&ldquo;If for some reason progress does not advance on track or something unknown / unexpected happens to cause further delays, then FSE features and TT2 theme are at risk to be punted to 6.0,&rdquo; Mork told the Tavern. The team is working to put safeguards in place to protect the release from further delays.</p>\n\n\n\n<p>&ldquo;FSE is a collection of features with some that are interconnected,&rdquo; WordPress 5.9 Testing Co-Lead Anne McCarthy said. &ldquo;This release includes a selection that are interconnected including Styles, Block theme flows, Navigation Block, etc. In order for them to really shine, it makes the most sense for them to be released together, making it hard to just delay shipping one. They need more time to be refined in order to be shipped&nbsp;<em>together</em>.&rdquo;</p>\n\n\n\n<p>The release team plans to publish an update on Monday with confirmation of the schedule moving forward. McCarthy noted that contributions have been lower this year, which has contributed to the delay.</p>\n\n\n\n<p>&ldquo;We need to recognize the very Human situation we&rsquo;re in right now both in terms of larger cultural moments coming up with various holidays/celebrations and the reality of still being in the midst of a pandemic,&rdquo; McCarthy said. &ldquo;Delaying provides sustainability to get this release right without potentially burning out the remaining contributor base.&rdquo;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 19 Nov 2021 23:07:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: BuddyPress 10.0.0 Beta 1 Delayed, Stable Release Rescheduled for December 24\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=125869\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:215:\"https://wptavern.com/buddypress-10-0-0-beta-1-delayed-stable-release-rescheduled-for-december-24?utm_source=rss&utm_medium=rss&utm_campaign=buddypress-10-0-0-beta-1-delayed-stable-release-rescheduled-for-december-24\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2662:\"<p>The upcoming BuddyPress 10.0.0 beta 1 release was scheduled for November 20, but contributors have decided to <a href=\"https://bpdevel.wordpress.com/2021/11/18/bp-dev-chat-summary-november-17-2021/\">postpone the beta</a> by two weeks, due to lack of time for adequately testing recent improvements to the planned features. The stable release has been rescheduled for December 24. This version will <a href=\"https://buddypress.trac.wordpress.org/ticket/8318\">require WordPress &gt;=&nbsp;5.4</a>. </p>\n\n\n\n<p>The delayed beta gives BuddyPress plugin developers more time to update the way they add custom tabs in admin screens, as version 10 will make changes to&nbsp;the layout of the Settings and Tools Administration screens. A short tutorial for <a href=\"https://bpdevel.wordpress.com/2021/11/17/buddypress-admin-tabs-will-look-different-in-10-0-0/\">how to update custom tabs</a> was published in a recent BP dev note.</p>\n\n\n\n<p>Version 10 will add a new <a href=\"https://buddypress.trac.wordpress.org/ticket/8582\">site membership requests</a> feature, which changes the registration process so that a site admin must manually approve requests. Approval sends an email to the user with a link to activate their account. Administrators can turn the feature on by disabling &ldquo;Anyone can register&rdquo; and enabling membership requests. Improvements to site membership requests are still under review and need more testing, which was one factor in the decision to postpone beta 1.</p>\n\n\n\n<p>Contributors are also still working on <a href=\"https://buddypress.trac.wordpress.org/ticket/8581\">extending no content activities with images and call of actions</a>, a feature that needs some refinement to the initial approach.</p>\n\n\n\n<p>Unrelated to the postponed beta schedule, BuddyPress contributors are now discussing a proposal regarding the core BP blocks.</p>\n\n\n\n<p>&ldquo;I was thinking we should probably stop adding blocks to BP Core and instead create standalone blocks into the WordPress plugins directory,&rdquo; BuddyPress core developer Mathieu Viet said during the most recent dev chat. </p>\n\n\n\n<p>One advantage of not packaging them with BuddyPress is that they can be updated independently of core updates, which happen less frequently. One contributor, Varun Dubey, noted that this will increase the number of active plugins on sites and suggested the team consider bundling them in a block collection plugin instead. Anyone with a strong opinion on the matter is encouraged to share it as a comment on the most recent <a href=\"https://bpdevel.wordpress.com/2021/11/18/bp-dev-chat-summary-november-17-2021/\">BP Dev Chat summary post</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 19 Nov 2021 05:03:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Post Status: The Open Web Manifesto\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://poststatus.com/?post_type=mn_rocks_news&p=89816\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://poststatus.com/news/the-open-web-manifesto/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:693:\"<p>Accessibility, Creatibility, and Connectibility — these are the three things that define the Open Web in its ideal state. It can be accessed by everyone, anyone can freely create on it, and the communities that form there can sustain themselves and grow. WordPress is critical to the Open Web as an indicator of its health, an ecosystem for business growth, and a path for people to contribute to the health, growth, and future of the Open Web. We want to guide, connect, and elevate our members — WordPress businesses and professionals — as they grow. And we want to make sure we share, nurture, and replenish the common resource we have in the Open Web. <strong><br />\n</strong></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 19 Nov 2021 00:44:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jonathan Wold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"WPTavern: Donate to Big Orange Heart, Become a Self-Proclaimed Winner in the WP Builds WordPress Awards 2021\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=125645\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:259:\"https://wptavern.com/donate-to-big-orange-heart-become-a-self-proclaimed-winner-in-the-wp-builds-wordpress-awards-2021?utm_source=rss&utm_medium=rss&utm_campaign=donate-to-big-orange-heart-become-a-self-proclaimed-winner-in-the-wp-builds-wordpress-awards-2021\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5730:\"<p class=\"has-drop-cap\">Flipping the usual <del>popularity contests</del> <em>WordPress-related award systems</em> on their heads, Nathan Wrigley has created something where we can all be a winner. What started as a joke to crown his WP Builds podcast as the best quickly took a positive turn that has seen several charitable donations in the past week or so.</p>\n\n\n\n<p>The awards &ldquo;contest&rdquo; is simple. Anyone can donate the minimum amount of $10 to <a href=\"https://www.bigorangeheart.org/\">Big Orange Heart</a> and show their receipt via the submission form.  They can then create a new award category for the <a href=\"https://wpbuilds.com/wp-builds-wordpress-awards-2021/\">WP Builds awards page</a> and claim themselves as the sole winner. There are 27 days remaining to enter.</p>\n\n\n\n<img />Awards page and submission form.\n\n\n\n<p>While I certainly want to be charitable, I saw this as an opportunity to crown myself as the Best WordPress Halo Player in 2021. I have already won, so no one can dispute it.</p>\n\n\n\n<p>In all seriousness, Big Orange Heart is a worthy cause in which to donate, regardless of whether you claim your award. The charity organization focuses on mental and physical health for remote workers. It offers coaching, mentoring, workshops, and other resources to over 14,500 members.</p>\n\n\n\n<p>&ldquo;So I really did not come up with this,&rdquo; said Wrigley. &ldquo;It was an accident. I saw a few posts about a variety of awards polls (both inside WordPress and outside too), and I thought that it would be funny to create an Awards poll of my own. It had only one question, which was &lsquo;Best Podcast called WP Builds&rsquo; and there was only one option to choose from, which was, <em>erm</em>&hellip;WP Builds. I thought that this was enormously funny because somewhat humorless dad jokes are the level that I&rsquo;m on.&rdquo;</p>\n\n\n\n<p>He then <a href=\"https://twitter.com/wpbuilds/status/1458387183283458056\">posted on Twitter</a> and got 30 votes for the joke award poll in which his podcast could be the only winner.</p>\n\n\n\n<p>&ldquo;A day later, I got a <a href=\"https://twitter.com/pootlepress/status/1458431706243997702\">tweet from Jamie Marsland</a> of PootlePress who said (jokingly, I expect) that he&rsquo;d give me &pound;10 if I would add a new question of &lsquo;Best WordPress Tennis Player&rsquo; and him as the only possible winner. Now, I know nothing about tennis (or WordPress, if the truth be known), and so I thought about this for a moment. I imagined all of the things that I would do with Jamie&rsquo;s &pound;10. The new Bond film at the cinema, some new tennis balls, a billionth of a Bitcoin&hellip;Then I remembered Big Orange Heart.&rdquo;</p>\n\n\n\n<p>Thus, a new fundraiser and faux awards contest had been born. Wrigley described Big Orange Heart as a charity that&rsquo;s really close to his heart. He told Marsland <a href=\"https://twitter.com/wpbuilds/status/1458432722955902977\">to donate to the organization</a> to earn his spot. A $25 contribution and a <a href=\"https://twitter.com/pootlepress/status/1458433464559091713\">screenshot of a receipt</a> later, and he had become the unofficial best WordPress tennis player.</p>\n\n\n\n<p>Not to be outdone, Nigel M Rodgers later won the &ldquo;Bestest Best WordPress Tennis Player&rdquo; award. It is all in good fun.</p>\n\n\n\n<p>&ldquo;So this silliness had taken a new turn,&rdquo; said Wrigley. &rdquo; A silly idea had generated $25 for Big Orange Heart. My heart was racing; this could be huge. I went to bed. In the morning, I woke up and sent out a new tweet.&rdquo;</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">If you donate $10 to <a href=\"https://twitter.com/aBigOrangeHeart?ref_src=twsrc%5Etfw\">@aBigOrangeHeart</a> I will make you a 100% certain winner of a category of your choosing in \"The WP Builds WordPress Awards 2021\". It\'s money well spent. You\'ll feel like a winner! <a href=\"https://t.co/L8i8O4Ayog\">https://t.co/L8i8O4Ayog</a></p>&mdash; Nathan Wrigley (@wpbuilds) <a href=\"https://twitter.com/wpbuilds/status/1458433750027718658?ref_src=twsrc%5Etfw\">November 10, 2021</a></blockquote>\n</div>\n\n\n\n<p>&ldquo;I had set a new low for Awards,&rdquo; he said. &ldquo;I will allow you to donate/buy your way into winning whatever category you choose for yourself in exchange for a guarantee that you&rsquo;ll win!&rdquo;</p>\n\n\n\n<p>The WP Builds WordPress Awards 2021 is, without a doubt, unique. Now that we are just ahead of the holidays, it is always a welcome time to donate.</p>\n\n\n\n<p>Michelle Frechette &ldquo;is actually triplets masquerading as one person&rdquo; reads one award. Leanne Mitton is the &ldquo;Best Gnome Collector in the WordPress community.&rdquo; Isaac Coleman is &ldquo;The Most Awesome 13 Year Old in the World&rdquo; &mdash; <em>there could be a proud parent involved in that one</em>. And, there are many others to read through just for laughs.</p>\n\n\n\n<p>Wrigley does not yet know if he will run it in 2022. He is waiting to see how this one turns out. With enough support from the WordPress community, it could be fun to keep up with every year.</p>\n\n\n\n<p>For now, Big Orange Heart is the only accepted charitable organization. However, I asked if Wrigley would be open to others in our space in the future, assuming he keeps it up next year.</p>\n\n\n\n<p>&ldquo;I&rsquo;m sure that there would be ways to allow the person making the donation to choose alternative charities,&rdquo; he said. &ldquo;This seems like a great idea! I&rsquo;m open to suggestions about which charities we could include.&rdquo;</p>\n\n\n\n<p><strong>Note: </strong><em>Nathan Wrigley runs the WP Jukebox podcast for WP Tavern.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Nov 2021 19:12:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"Post Status: Post Status Excerpt (No. 33) — The Next Chapter For In-Person WordCamps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=89029\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://poststatus.com/excerpt/33/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3940:\"<h2>&#8220;I expect the hallway track to be pretty busy during this event.&#8221; —Nathan Ingram</h2>\n\n\n\n<p class=\"has-drop-cap\">In this episode of Post Status Excerpt, David talks with special guests <strong>Nathan Ingram</strong> and <strong>Ryan Marks</strong> about <strong>WordCamp Birmingham 2022</strong> — one of the first in-person WordCamps after almost two years of no live events anywhere in the world. With 200+ people expected to attend, Nathan and Ryan talk about the safeguards that will be in place, how they are managing expectations, how their sponsorships are being handled, the role of hybrid events, and how WordCamp Birmingham\'s reboot is being received in the WordPress community.</p>\n\n\n\n<p><strong>Also don\'t forget: </strong>We\'re encouraging listeners to check out the &#8220;<a href=\"https://poststatus.com/make-wordpress/\">Week at WordPress.org</a>&#8221; — get the feed <a href=\"https://poststatus.com/make-wordpress/feed/\">here</a> — and <a href=\"https://poststatus.com/submit-2021-black-friday-cyber-monday-deals/\">submit your Black Friday / Cyber Monday deals</a> to us at Post Status for us to share.</p>\n\n\n\n\n\n\n\n<p class=\"has-background\">Every week <strong><a href=\"https://poststatus.com/podcast/the-excerpt/\">Post Status Excerpt</a></strong> will brief you on important WordPress news — in about 15 minutes or less! Learn what\'s new in WordPress in a flash. <img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/26a1.png\" alt=\"⚡\" class=\"wp-smiley\" /><br /><br />You can listen to <a href=\"https://poststatus.com/podcast/the-excerpt/\">past episodes</a> of <strong>The Excerpt</strong>, <a href=\"https://poststatus.com/category/post-status-podcasts/\">browse all our podcasts</a>, and don’t forget to subscribe on <a href=\"https://open.spotify.com/show/1m3xwXbe0MG5BzFVPtB0A7\">Spotify</a>, Amazon Music, <a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5zaW1wbGVjYXN0LmNvbS8ySkU5c2M4UA\">Google Podcasts</a>, <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">iTunes</a>, <a href=\"https://castro.fm/podcast/c53552c6-1ee0-4fc4-9de4-08ed6bf1ee4d\">Castro</a>, <a href=\"https://www.youtube.com/c/PostStatus\">YouTube</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, <a href=\"https://player.fm/series/wordpress-post-status-podcasts\">Player.fm</a>, <a href=\"https://pca.st/05rR\">Pocket Casts</a>, <a href=\"https://wordpress-post-status-draft-podcast.simplecast.com/\">Simplecast</a>, or by <a href=\"https://feeds.simplecast.com/2JE9sc8P\">RSS</a>. <img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /></p>\n\n\n\n<h3 id=\"h-mentioned-in-the-show\"><img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/1f517.png\" alt=\"🔗\" class=\"wp-smiley\" /> Mentioned in the show:</h3>\n\n\n\n<ul><li><a href=\"https://birmingham.wordcamp.org/2022/\">WordCamp Birmingham / WP\'Yall</a></li><li><a href=\"https://twitter.com/dimensionmedia\" target=\"_blank\" rel=\"noreferrer noopener\">David Bisset (Twitter)</a></li><li><a href=\"http://twitter.com/nathaningram\">Nathan Ingram (Twitter)</a></li><li><a href=\"http://twitter.com/cdrmarks\">Ryan Marks (Twitter)</a></li><li><a href=\"https://twitter.com/post_status\" target=\"_blank\" rel=\"noreferrer noopener\">Post Status (Twitter)</a></li></ul>\n\n\n\n<h3><img src=\"https://s.w.org/images/core/emoji/13.0.1/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> Sponsor: <a href=\"https://poststat.us/sandhills\" target=\"_blank\" rel=\"noreferrer noopener sponsored nofollow\">SpinupWP</a></h3>\n\n\n\n<p>Spin up your own extremely fast WordPress server in minutes with <strong>SpinupWP</strong>. Use any cloud hosting provider you want, and manage your servers remotely with a simple but powerful control panel. Get the security and performance of managed hosting without losing the independence of hosting your projects and your clients yourself.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Nov 2021 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"David Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"WPTavern: New Core Web Vitals Technology Report Shows Overall Pass Rate for WordPress Sites Decreases with Newer Versions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=125594\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:287:\"https://wptavern.com/new-core-web-vitals-technology-report-shows-overall-pass-rate-for-wordpress-sites-decreases-with-newer-versions?utm_source=rss&utm_medium=rss&utm_campaign=new-core-web-vitals-technology-report-shows-overall-pass-rate-for-wordpress-sites-decreases-with-newer-versions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5696:\"<p>Some new data from a recent <a href=\"https://discuss.httparchive.org/t/new-dashboard-the-core-web-vitals-technology-report/2178\">Core Web Vitals (CWV) technology report</a> produced by the HTTP Archive shows WordPress sites running newer versions have lower CWV pass rates. </p>\n\n\n\n<p>The original report was published in July by Rick Viscomi, one of the maintainers of the HTTP Archive. The site provides a permanent repository of web performance information, giving researchers a common set of data for researching and understanding trends. Contributors&rsquo; efforts are sponsored by Google, Mozilla, New Relic, Etsy, and other companies.</p>\n\n\n\n<p>One of the most notable findings in Viscomi&rsquo;s report showed that just 22% of WordPress-powered origins pass the Core Web Vitals &ldquo;Good&rdquo; threshold.</p>\n\n\n\n<div class=\"wp-block-image\"><img /></div>\n\n\n\n<p>WordPress core committer Adam Silverstein wanted to dig a little deeper into this data set to see if he could extract more information about WordPress sites&rsquo; CWV performance that wasn&rsquo;t represented in the initial published graphs. He proposed an analysis that would <a href=\"https://discuss.httparchive.org/t/comparing-core-web-vital-performance-across-wordpress-versions/2256\">compare Core Web Vital performance across WordPress versions</a>:</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>How have CWV scores changed over WordPress versions? Are there measurable improvements in the wild after recent changes like adding native&nbsp;<a href=\"https://make.wordpress.org/core/2020/07/14/lazy-loading-images-in-5-5/\">image</a>&nbsp;(version 5.5) and&nbsp;<a href=\"https://make.wordpress.org/core/2021/02/19/lazy-loading-iframes-in-5-7/\">iframe</a>&nbsp;(version 5.7) lazy loading and&nbsp;<a href=\"https://make.wordpress.org/core/2021/06/07/wordpress-5-8-adds-webp-support/\">WebP image support</a>&nbsp;(version 5.8)?</p></blockquote>\n\n\n\n<p>Silverstein worked with Viscomi to create a query that would extract performance data grouped by WordPress version. He found that core additions like native image and iframe lazy loading, and WebP image support have had no measurable improvement on CWV scores in the wild. </p>\n\n\n\n<div class=\"wp-block-image\"><img /><a href=\"https://datastudio.google.com/u/0/reporting/ab251873-b787-4a8e-b4c8-efccf4b9a911/page/HUaeC?s=vvFHFeV3n_Q\">WordPress Versions Core Web Vitals report</a></div>\n\n\n\n<p>&ldquo;Lazy loading may be too aggressive as it is applied to all images,&rdquo; Silverstein said, noting that <a href=\"https://web.dev/lcp-lazy-loading/\">lazy loading can be detrimental</a> if over used. This should be remedied soon. Google-sponsored WordPress core committer Felix Arntz opened <a href=\"https://core.trac.wordpress.org/ticket/53675\">a ticket to improve lazy loading</a>, which will be included in WordPress 5.9. </p>\n\n\n\n<p>&ldquo;WebP adoption in WordPress has been growing since the 5.8 release, however users need to manually convert their images to WebP before uploading to take advantage of the format,&rdquo; Silverstein said. &ldquo;Landing WebP as the default format for sub-sized images which was started in&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/52867\">this ticket</a>&nbsp;will have a much bigger impact by automatically converting uploaded images to WebP.&#8203;&#8203;&rdquo;</p>\n\n\n\n<p>A few highlights of Silverstein&rsquo;s observations from the analysis include: </p>\n\n\n\n<ul><li>70% of origins are on the latest version of WordPress and 88% are on one of the last two versions, meaning changes we make to core reach the majority of sites relatively quickly.</li><li>The number of origins is quite low for older versions of WordPress, with fewer than 5k origins for most versions before 4.7</li><li>Overall CWV pass rates have generally decreased over WordPress versions. Although it might also be the case that &ldquo;leading-edge&rdquo; websites that update to the latest version are generally slower than those that linger on older versions.</li></ul>\n\n\n\n<p>Silverstein anticipates this analysis will provide the basis for tracking major improvements in the future. The Google-sponsored WordPress contributors on his team are active in certain core projects and are leading <a href=\"https://wptavern.com/yoast-and-google-sponsored-core-contributors-propose-new-wordpress-performance-team\">WordPress&rsquo; new performance team</a> with the goal of improving core performance as measured by&nbsp;<a href=\"https://web.dev/vitals/\">Google&rsquo;s Core Web Vitals</a>&nbsp;metrics.</p>\n\n\n\n<p>&ldquo;Basically I wanted to create a way to measure the impact of core WordPress improvements on WordPress sites (at scale),&rdquo; Silverstein told the Tavern. &ldquo;My team at Google is focused on helping improve the performance of the web at scale, and WordPress is a huge part of that! You may have noticed us working on features like lazy loaded images and iframes, WebP image support and now helping start the performance group. I wanted to find a way to see if our work is having a measurable impact &ndash; and not just on a vanilla WordPress site you might set up for testing, but in the wild, or real world websites that upgrade to the latest version of WordPress. That is the goal of the dashboard.&rdquo;</p>\n\n\n\n<p>The new <a href=\"https://datastudio.google.com/u/0/reporting/ab251873-b787-4a8e-b4c8-efccf4b9a911/page/HUaeC?s=vvFHFeV3n_Q\">dashboard</a>, which tracks WordPress CWV performance by version, is available to the performance team for monitoring their progress with each new WordPress release. Google-sponsored contributors are using it to measure the impact of their efforts across various performance initiatives.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Nov 2021 03:15:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: Rank Math SEO Launches a Content AI Feature\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=125464\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:151:\"https://wptavern.com/rank-math-seo-launches-a-content-ai-feature?utm_source=rss&utm_medium=rss&utm_campaign=rank-math-seo-launches-a-content-ai-feature\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8496:\"<p class=\"has-drop-cap\">Last week, the popular <a href=\"https://wordpress.org/plugins/seo-by-rank-math/\">Rank Math SEO</a> plugin received a major update that includes a new artificial intelligence system. The Content AI feature is a SaaS product that behaves like a personal writing assistant to boost search rankings.</p>\n\n\n\n<p>&ldquo;We built Rank Math&rsquo;s Content AI feature to revolutionize the content production and optimization process with proprietary AI that gives SEOs and content marketers a competitive edge,&rdquo; said Bhanu Ahluwalia, Rank Math&rsquo;s CMO.</p>\n\n\n\n<p>The system allows users to research what their content should look like based on a keyword. Each keyword analysis costs one credit. This data is stored on the user&rsquo;s server, so the same keyword used on multiple posts does not cost extra. Users get five free credits after signing up for a user account with Rank Math. However, they must upgrade to one of the three commercial plans, ranging from $59 to $499 per year, for more.</p>\n\n\n\n<p>Each of the <a href=\"https://rankmath.com/offer/\">commercial plans</a> comes with a specific number of credits. They are marketed as free extras, but they are not &ldquo;free&rdquo; for users who want to upgrade for credits alone. The team says they are working on a pricing solution to address this.</p>\n\n\n\n<p>Users should see a new Content AI module that they can enable from the plugin&rsquo;s Dashboard screen. Turning this on creates a new tab under the plugin&rsquo;s General Settings page for further configuration.</p>\n\n\n\n<img />Content AI general settings.\n\n\n\n<p>The Content AI feature works with the WordPress editor, the classic editor, Elementor, and Divi. However, the team plans to extend this support to other page builders in the future</p>\n\n\n\n<p>Users can then enter a focus keyword from the post-editing screen and click the Content AI button. From there, they can research their chosen keyword, and Rank Math pulls up suggestions from their system.</p>\n\n\n\n<img />Example post with Content AI score.\n\n\n\n<p>The scoring system is easy to understand. Above 80 (in the green) is considered &ldquo;good.&rdquo; Anything below might need some work based on the plugin&rsquo;s recommendations.</p>\n\n\n\n<p>The primary suggestions from the Content AI center on total words, links, headings, and media. When asked how the numbers were figured, Ahluwalia said, &ldquo;This is a computation performed based on the top-ranking content in search engine results pages (i.e., characteristics of content that ranks).&rdquo; It is a proprietary system, so maybe the team is not ready to give away the exact details.</p>\n\n\n\n<p>The feature also lets users copy related keywords to use in their posts, offers questions that the content should answer, and lists potential links to use.</p>\n\n\n\n<p>The following video explains how Content AI works:</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<h2 id=\"are-content-scores-a-good-thing\">Are Content Scores a Good Thing?</h2>\n\n\n\n<p class=\"has-drop-cap\">I am admittedly skeptical of any claims from SEO tools. There is value in most of the plugins in the space, and Rank Math is no different. However, I also want end-users to take SEO or content scores with a grain of salt. Hitting a specific word, link, heading, or media count is not going to make or break you. These should be guidelines, not goalposts.</p>\n\n\n\n<p>When asked how the score was calculated, I was pointed to a <a href=\"https://rankmath.com/kb/seo-score-vs-content-ai-score/\">knowledgebase article</a> on the Rank Math website. Nothing in the Content AI section explicitly explains the &ldquo;math&rdquo; behind the score. Essentially, the documentation references how the AI analyzes search results for various factors and describes how the tool works. There is some generally solid advice throughout, but it does not answer how those scores are calculated.</p>\n\n\n\n<p>One particular area of concern was the recommended media count for each post. I had access to a full demo of the feature with a few dozen posts to check. Nearly all that I ran 